/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.decoration.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.WordUtils;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.facet.infra.browser.uicore.internal.model.LinkItem;
import org.eclipse.papyrus.infra.services.decoration.DecorationService;
import org.eclipse.papyrus.infra.services.decoration.IDecorationSpecificFunctions;
import org.eclipse.papyrus.infra.services.decoration.util.Decoration;
import org.eclipse.papyrus.infra.services.decoration.util.DecorationSpecificFunctions;
import org.eclipse.papyrus.infra.services.decoration.util.IPapyrusDecoration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecorationUtils {
    private Object element;
    private EObject eObject;

    public DecorationUtils(Object element) {
        if (element == null) {
            throw new IllegalArgumentException("The decorated element shall not be null");
        }
        EObject eObject = (EObject)Platform.getAdapterManager().getAdapter(element, EObject.class);
        this.element = element;
        this.setEObject(eObject);
    }

    public DecorationUtils(EObject eObject) {
        if (eObject == null) {
            throw new IllegalArgumentException("The decorated EObject shall not be null");
        }
        this.setEObject(eObject);
    }

    public void tryChildIfEmpty() {
        List items;
        if (this.getEObject() == null && this.element instanceof LinkItem && (items = ((LinkItem)this.element).getChildrenElements()).size() > 0 && items.get(0) instanceof EObject) {
            this.setEObject((EObject)items.get(0));
        }
    }

    public EObject getEObject() {
        return this.eObject;
    }

    public void setEObject(EObject eObject) {
        this.eObject = eObject;
    }

    public Map<String, Decoration> getDecorations(DecorationService decorationService) {
        return decorationService.getDecorations();
    }

    public EList<IPapyrusDecoration> getDecorations(DecorationService decorationService, boolean navigateToParents) {
        IDecorationSpecificFunctions decoUtil;
        Map<String, Decoration> decorations = this.getDecorations(decorationService);
        BasicEList foundDecorations = new BasicEList();
        HashMap<String, EList> childDecorationMap = new HashMap<String, EList>();
        if (decorations != null) {
            block0: for (Decoration decoration : decorations.values()) {
                EObject eObjectOfDecorator = decoration.getElement();
                if (eObjectOfDecorator == this.getEObject()) {
                    if (decoration.getMessage() == null) {
                        decoration.setMessage("");
                    }
                    foundDecorations.add((Object)decoration);
                }
                decoUtil = DecorationSpecificFunctions.getDecorationInterface(decoration.getType());
                if (!navigateToParents || decoUtil == null || decoUtil.supportsMarkerPropagation() == IDecorationSpecificFunctions.MarkChildren.NO) continue;
                IDecorationSpecificFunctions.MarkChildren markChildren = decoUtil.supportsMarkerPropagation();
                boolean first = true;
                eObjectOfDecorator = eObjectOfDecorator.eContainer();
                while (eObjectOfDecorator != null) {
                    if (eObjectOfDecorator == this.getEObject()) {
                        String type = decoration.getType();
                        EList childDecorations = (EList)childDecorationMap.get(type);
                        if (childDecorations == null) {
                            childDecorations = new BasicEList();
                            childDecorationMap.put(type, childDecorations);
                        }
                        childDecorations.add((Object)decoration);
                    }
                    eObjectOfDecorator = eObjectOfDecorator.eContainer();
                    if (markChildren != IDecorationSpecificFunctions.MarkChildren.ALL && !first) continue block0;
                    first = false;
                }
            }
        }
        for (String type : childDecorationMap.keySet()) {
            IPapyrusDecoration propagatedDecoration;
            EList childDecorations = (EList)childDecorationMap.get(type);
            if (childDecorations == null || (propagatedDecoration = (decoUtil = DecorationSpecificFunctions.getDecorationInterface(type)).markerPropagation((EList<IPapyrusDecoration>)childDecorations)) == null) continue;
            foundDecorations.add((Object)propagatedDecoration);
        }
        return foundDecorations;
    }

    public String getDecorationMessage(DecorationService decorationService) {
        Map<String, Decoration> decorations = this.getDecorations(decorationService);
        if (decorations != null) {
            String message = "";
            for (Decoration decoration : decorations.values()) {
                EObject eObjectOfDecorator = decoration.getElement();
                if (eObjectOfDecorator != this.getEObject()) continue;
                if (message.length() > 0) {
                    message = String.valueOf(message) + "\n";
                }
                message = String.valueOf(message) + "- " + WordUtils.wrap((String)decoration.getMessage(), (int)100, (String)"\n  ", (boolean)true);
            }
            return message.length() > 0 ? message : null;
        }
        return null;
    }
}

