/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.validation;

import java.util.Map;
import java.util.MissingResourceException;
import org.eclipse.core.resources.IMarker;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.action.ValidateAction;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;

public class ValidationUtils {
    public static ValidateAction.EclipseResourcesUtil eclipseResourcesUtil = EMFPlugin.IS_RESOURCES_BUNDLE_AVAILABLE ? new ValidateAction.EclipseResourcesUtil() : null;

    public static EObject eObjectFromMarkerOrMap(IMarker marker, Map attributes, EditingDomain domain) {
        if (domain == null) {
            return null;
        }
        String uriAttribute = marker != null ? marker.getAttribute("uri", null) : (String)attributes.get("uri");
        if (uriAttribute != null) {
            URI uriOfMarker = URI.createURI((String)uriAttribute);
            try {
                return domain.getResourceSet().getEObject(uriOfMarker, true);
            }
            catch (MissingResourceException e) {
                return ValidationUtils.eObjectOfFragment(uriOfMarker, domain);
            }
            catch (WrappedException e) {
                return ValidationUtils.eObjectOfFragment(uriOfMarker, domain);
            }
        }
        return null;
    }

    public static EObject eObjectOfFragment(URI uri, EditingDomain domain) {
        try {
            for (Resource resource : domain.getResourceSet().getResources()) {
                EObject eObjectOfMarker = resource.getEObject(uri.fragment());
                if (eObjectOfMarker == null) continue;
                return eObjectOfMarker;
            }
        }
        catch (WrappedException wrappedException) {
            // empty catch block
        }
        return null;
    }

    public static Resource getValidationResource(EObject eObject) {
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)eObject);
        return ValidationUtils.getValidationResourceViaDomain(domain);
    }

    public static Resource getValidationResourceViaDomain(TransactionalEditingDomain domain) {
        if (domain != null) {
            Resource resource = eclipseResourcesUtil != null ? (Resource)domain.getResourceSet().getResources().get(0) : null;
            return resource;
        }
        return null;
    }
}

