/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.editors;

import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.papyrus.infra.widgets.databinding.TextObservableValue;
import org.eclipse.papyrus.infra.widgets.editors.AbstractValueEditor;
import org.eclipse.papyrus.infra.widgets.selectors.StringSelector;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Text;

public class StringEditor
extends AbstractValueEditor
implements KeyListener,
ModifyListener {
    protected final Text text;
    private int delay = 600;
    private boolean validateOnDelay = false;
    private Timer timer;
    private TimerTask currentValidateTask;
    private static final int DEFAULT_HEIGHT_HINT = 55;
    private static final int DEFAULT_WIDTH_HINT = 100;

    public StringEditor(Composite parent, int style) {
        this(parent, style, null, 55, 100);
    }

    public StringEditor(Composite parent, int style, String label) {
        this(parent, style, label, 55, 100);
    }

    public StringEditor(Composite parent, int style, int heighHint, int widthHint) {
        this(parent, style, null, heighHint, widthHint);
    }

    public StringEditor(Composite parent, int style, String label, int heighHint, int widthHint) {
        super(parent, label);
        GridData data = this.getDefaultLayoutData();
        if ((style & 2) != 0) {
            data.heightHint = heighHint;
            data.widthHint = widthHint;
            style |= 0x200;
        }
        this.text = factory.createText((Composite)this, null, style);
        this.text.setLayoutData((Object)data);
        if (label != null) {
            this.label.setLayoutData((Object)this.getLabelLayoutData());
        }
        this.text.addKeyListener((KeyListener)this);
        this.setCommitOnFocusLost((Control)this.text);
    }

    protected GridData getLabelLayoutData() {
        GridData result = super.getLabelLayoutData();
        if (this.text != null && (this.text.getStyle() & 2) != 0) {
            result.verticalAlignment = 1;
        }
        return result;
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (e.keyCode == 13 || e.keyCode == 0x1000050) {
            if ((this.text.getStyle() & 2) == 0) {
                if (e.stateMask == 0) {
                    this.notifyChange();
                }
            } else if (e.stateMask == 262144) {
                String str = this.text.getText();
                if (str.endsWith(StringSelector.LINE_SEPARATOR)) {
                    int newLength = str.length() - StringSelector.LINE_SEPARATOR.length();
                    this.text.setText(str.substring(0, newLength));
                    this.text.setSelection(newLength);
                }
                this.notifyChange();
            }
        }
    }

    public void setModelObservable(IObservableValue observable) {
        this.setWidgetObservable((IObservableValue)new TextObservableValue(this.text, observable, 16), true);
        super.setModelObservable(observable);
    }

    public Object getEditableType() {
        return String.class;
    }

    public Object getValue() {
        return this.text.getText();
    }

    public void setReadOnly(boolean readOnly) {
        this.text.setEnabled(!readOnly);
    }

    public boolean isReadOnly() {
        return !this.text.isEnabled();
    }

    protected void notifyChange() {
        this.text.notifyListeners(16, new Event());
        this.commit();
    }

    public void setToolTipText(String tooltip) {
        this.text.setToolTipText(tooltip);
        super.setLabelToolTipText(tooltip);
    }

    public void setValue(Object value) {
        if (value instanceof String) {
            this.text.setText((String)value);
        } else {
            this.text.setText("");
        }
    }

    public void setValidateOnDelay(boolean validateOnDelay) {
        this.validateOnDelay = validateOnDelay;
        if (validateOnDelay) {
            this.text.addModifyListener((ModifyListener)this);
        } else {
            this.text.removeModifyListener((ModifyListener)this);
            this.cancelCurrentTask();
        }
    }

    public void setValidateOnDelay(int millis) {
        this.delay = millis;
        this.setValidateOnDelay(true);
        if (this.delay == 0) {
            this.cancelCurrentTask();
        }
    }

    private void cancelCurrentTask() {
        if (this.currentValidateTask != null) {
            this.currentValidateTask.cancel();
            this.currentValidateTask = null;
        }
    }

    public void modifyText(ModifyEvent e) {
        if (this.validateOnDelay) {
            if (this.delay == 0) {
                this.commit();
                return;
            }
            this.cancelCurrentTask();
            if (this.timer == null) {
                this.timer = new Timer(true);
            }
            this.currentValidateTask = new TimerTask(){

                public void run() {
                    StringEditor.this.getDisplay().syncExec(new Runnable(){

                        public void run() {
                            StringEditor.this.commit();
                        }
                    });
                }
            };
            this.timer.schedule(this.currentValidateTask, this.delay);
        }
    }

    public void dispose() {
        this.cancelCurrentTask();
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        super.dispose();
    }
}

