/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.selectors;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.papyrus.infra.widgets.editors.IElementSelectionListener;
import org.eclipse.papyrus.infra.widgets.editors.IElementSelector;
import org.eclipse.papyrus.infra.widgets.providers.EncapsulatedContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceSelector
implements IElementSelector {
    protected FilteredTree fTree;
    protected EncapsulatedContentProvider contentProvider;
    protected ILabelProvider labelProvider;
    protected boolean unique;
    protected boolean multiSelection;
    private Set<IElementSelectionListener> elementSelectionListeners = new HashSet<IElementSelectionListener>();
    protected Set<Object> selectedElements = new HashSet<Object>();

    public ReferenceSelector(boolean unique) {
        this.unique = unique;
        this.multiSelection = true;
    }

    public ReferenceSelector() {
        this.unique = false;
        this.multiSelection = false;
    }

    @Override
    public Object[] getSelectedElements() {
        ISelection selection = this.fTree.getViewer().getSelection();
        if (selection instanceof IStructuredSelection) {
            Object[] containerElementsToMove = this.getElementsToMove(((IStructuredSelection)selection).toArray());
            Object[] semanticElementsToMove = this.getSemanticElements(containerElementsToMove);
            this.addSelectedElements(semanticElementsToMove);
            return semanticElementsToMove;
        }
        return new Object[0];
    }

    private Object[] getSemanticElements(Object[] containerElements) {
        Object[] semanticElements = new Object[containerElements.length];
        int i = 0;
        Object[] objectArray = containerElements;
        int n = containerElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object containerElement = objectArray[n2];
            semanticElements[i++] = this.contentProvider.getAdaptedValue(containerElement);
            ++n2;
        }
        return semanticElements;
    }

    protected Object[] getElementsToMove(Object[] selection) {
        LinkedList<Object> elementsToMove = new LinkedList<Object>();
        Object[] objectArray = selection;
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (this.contentProvider.isValidValue(element)) {
                elementsToMove.add(element);
            }
            ++n2;
        }
        return elementsToMove.toArray();
    }

    private void addSelectedElements(Object[] semanticElements) {
        if (semanticElements.length > 0) {
            this.selectedElements.addAll(Arrays.asList(semanticElements));
            this.fTree.getViewer().refresh();
        }
    }

    @Override
    public Object[] getAllElements() {
        if (this.contentProvider == null) {
            return new Object[0];
        }
        LinkedList<Object> visibleElements = new LinkedList<Object>();
        TreeItem[] treeItemArray = this.fTree.getViewer().getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem rootItem = treeItemArray[n2];
            visibleElements.add(this.getElement(rootItem));
            if (rootItem.getExpanded()) {
                this.fillVisibleElements(rootItem, visibleElements);
            }
            ++n2;
        }
        Object[] containerElementsToMove = this.getElementsToMove(visibleElements.toArray());
        Object[] semanticElementsToMove = this.getSemanticElements(containerElementsToMove);
        this.addSelectedElements(semanticElementsToMove);
        return semanticElementsToMove;
    }

    private void fillVisibleElements(TreeItem item, Collection<Object> visibleElements) {
        TreeItem[] treeItemArray = item.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem childItem = treeItemArray[n2];
            visibleElements.add(this.getElement(childItem));
            if (childItem.getExpanded()) {
                this.fillVisibleElements(childItem, visibleElements);
            }
            ++n2;
        }
    }

    private Object getElement(TreeItem item) {
        return item.getData();
    }

    @Override
    public void setSelectedElements(Object[] semanticElements) {
        this.selectedElements.clear();
        this.selectedElements.addAll(Arrays.asList(semanticElements));
        this.fTree.getViewer().refresh();
    }

    @Override
    public void newObjectCreated(Object newObject) {
        this.contentProvider.addTemporaryElement(newObject);
        this.refresh();
    }

    @Override
    public void clearTemporaryElements() {
        this.contentProvider.clearTemporaryElements();
    }

    public void refresh() {
        this.fTree.getViewer().refresh();
    }

    public void setLabelProvider(ILabelProvider labelProvider) {
        this.labelProvider = labelProvider;
        if (this.fTree != null) {
            this.fTree.getViewer().setLabelProvider((IBaseLabelProvider)labelProvider);
        }
    }

    public void setContentProvider(IStaticContentProvider staticContentProvider) {
        this.contentProvider = new EncapsulatedContentProvider(staticContentProvider);
        if (this.fTree != null) {
            this.fTree.getViewer().setContentProvider((IContentProvider)this.contentProvider);
            this.fTree.getViewer().setInput((Object)"");
        }
    }

    @Override
    public void createControls(Composite parent) {
        Composite content = new Composite(parent, 2048);
        content.setLayout((Layout)new GridLayout(1, true));
        PatternFilter filter = new PatternFilter();
        filter.setPattern("*");
        this.fTree = new FilteredTree(content, 2050, new PatternFilter(), true);
        this.fTree.getViewer().getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        if (this.contentProvider != null) {
            this.fTree.getViewer().setContentProvider((IContentProvider)this.contentProvider);
            this.fTree.getViewer().setInput((Object)"");
        }
        if (this.labelProvider != null) {
            this.fTree.getViewer().setLabelProvider((IBaseLabelProvider)this.labelProvider);
        }
        this.fTree.getViewer().addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object containerElement) {
                if (ReferenceSelector.this.unique) {
                    return !ReferenceSelector.this.selectedElements.contains(ReferenceSelector.this.contentProvider.getAdaptedValue(containerElement));
                }
                return true;
            }
        });
        this.fTree.getViewer().getTree().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                if (!ReferenceSelector.this.elementSelectionListeners.isEmpty()) {
                    Object[] selectedElements = ReferenceSelector.this.getSelectedElements();
                    for (IElementSelectionListener listener : ReferenceSelector.this.elementSelectionListeners) {
                        listener.addElements(selectedElements);
                    }
                }
            }
        });
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
    }

    @Override
    public void addElementSelectionListener(IElementSelectionListener listener) {
        this.elementSelectionListeners.add(listener);
    }
}

