/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.service.types.helper;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.commands.DuplicateEObjectsCommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.DuplicateElementsRequest;
import org.eclipse.papyrus.sysml.service.types.Activator;
import org.eclipse.papyrus.uml.service.types.utils.NamedElementHelper;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;

public abstract class AbstractPropertyEditHelperAdvice
extends AbstractEditHelperAdvice {
    protected ICommand getBeforeDuplicateCommand(DuplicateElementsRequest request) {
        Object targetContainer = request.getParameter("Target_Owner");
        if (!(targetContainer instanceof EObject)) {
            return super.getBeforeDuplicateCommand(request);
        }
        Property propertyToBeDuplicated = this.getDuplicatedProperty(request);
        if (propertyToBeDuplicated == null) {
            return super.getBeforeDuplicateCommand(request);
        }
        Property newPart = (Property)request.getAllDuplicatedElementsMap().get(propertyToBeDuplicated);
        if (newPart == null) {
            Activator.log.debug("Trying to create a command for a new sysml property which has not been created yet");
            return super.getBeforeDuplicateCommand(request);
        }
        Association originalAssociation = propertyToBeDuplicated.getAssociation();
        if (originalAssociation == null) {
            return super.getBeforeDuplicateCommand(request);
        }
        Association newAssociation = (Association)request.getAllDuplicatedElementsMap().get(originalAssociation);
        if (newAssociation != null && newAssociation.equals(newPart.getAssociation())) {
            return super.getBeforeDuplicateCommand(request);
        }
        TransactionalEditingDomain editingDomain = this.getEditingDomain((EObject)propertyToBeDuplicated);
        if (editingDomain == null) {
            return super.getBeforeDuplicateCommand(request);
        }
        Package targetPackage = this.getTargetContainer((EObject)targetContainer, propertyToBeDuplicated, newPart, request.getAllDuplicatedElementsMap());
        return new DuplicatePapyrusAssociationCommand(editingDomain, "Duplicate Association", originalAssociation, request.getAllDuplicatedElementsMap(), targetPackage);
    }

    protected abstract Property getDuplicatedProperty(DuplicateElementsRequest var1);

    protected Package getTargetContainer(EObject targetContainer, Property partToBeDuplicated, Property newPart, Map allDuplicatedElementsMap) {
        Package result = newPart.getNearestPackage();
        if (result != null) {
            return result;
        }
        Package originalPackage = partToBeDuplicated.getNearestPackage();
        Object o = allDuplicatedElementsMap.get(originalPackage);
        if (o instanceof Package) {
            return (Package)o;
        }
        if (targetContainer instanceof Package) {
            return (Package)targetContainer;
        }
        if (targetContainer instanceof Element) {
            return ((Element)targetContainer).getNearestPackage();
        }
        return null;
    }

    protected TransactionalEditingDomain getEditingDomain(EObject eObject) {
        EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)eObject);
        if (editingDomain instanceof TransactionalEditingDomain) {
            return (TransactionalEditingDomain)editingDomain;
        }
        return null;
    }

    public class DuplicatePapyrusAssociationCommand
    extends DuplicateEObjectsCommand {
        private final Association associationToDuplicate;
        private final Package targetContainer;

        public DuplicatePapyrusAssociationCommand(TransactionalEditingDomain editingDomain, String label, Association originalAssociation, Map allDuplicatedObjectsMap, Package targetContainer) {
            super(editingDomain, label, Collections.singletonList(originalAssociation), allDuplicatedObjectsMap, (EObject)targetContainer);
            this.associationToDuplicate = originalAssociation;
            this.targetContainer = targetContainer;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            EcoreUtil.Copier copier = new EcoreUtil.Copier();
            copier.putAll(this.getAllDuplicatedObjectsMap());
            copier.copy((EObject)this.associationToDuplicate);
            copier.copyReferences();
            Association newAssociation = (Association)copier.get((Object)this.associationToDuplicate);
            if (newAssociation == null) {
                return CommandResult.newErrorCommandResult((String)"Impossible to find the copied association");
            }
            newAssociation.setPackage(this.targetContainer);
            String associationName = NamedElementHelper.getDefaultNameWithIncrementFromBase((String)"Association", (Collection)this.targetContainer.eContents());
            newAssociation.setName(associationName);
            return CommandResult.newOKCommandResult((Object)this.getAllDuplicatedObjectsMap());
        }

        public boolean canExecute() {
            return this.targetContainer instanceof Package;
        }
    }
}

