/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.service.types.helper.advice;

import java.util.Collections;
import java.util.List;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationType;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.sysml.service.types.command.SetNestedPathCommand;
import org.eclipse.papyrus.sysml.service.types.element.SysMLElementTypes;
import org.eclipse.papyrus.sysml.service.types.utils.ConnectorUtils;
import org.eclipse.papyrus.uml.service.types.utils.RequestParameterUtils;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.Property;

public class ConnectorEditHelperAdvice
extends AbstractEditHelperAdvice {
    private ConnectorUtils utils = new ConnectorUtils();

    protected ICommand getAfterReorientRelationshipCommand(ReorientRelationshipRequest request) {
        ICommand defaultCommand = super.getAfterReorientRelationshipCommand(request);
        int reorientDirection = request.getDirection();
        Edge reorientedEdgeView = RequestParameterUtils.getReconnectedEdge((IEditCommandRequest)request);
        View newEndView = RequestParameterUtils.getReconnectedEndView((IEditCommandRequest)request);
        View oppositeEndView = reorientDirection == 1 ? reorientedEdgeView.getTarget() : reorientedEdgeView.getSource();
        Connector connector = (Connector)request.getRelationship();
        if (((ISpecializationType)SysMLElementTypes.BLOCK).getMatcher().matches(connector.eContainer())) {
            if (this.utils.isCrossingEncapsulation(newEndView, oppositeEndView) || this.utils.isCrossingEncapsulation(oppositeEndView, newEndView)) {
                return UnexecutableCommand.INSTANCE;
            }
            int tmpNestedPathDirection = -1;
            List<Property> tmpNestedPath = Collections.emptyList();
            tmpNestedPathDirection = reorientDirection == 1 ? 1 : 2;
            tmpNestedPath = this.utils.getNestedPropertyPath(newEndView, oppositeEndView);
            defaultCommand = CompositeCommand.compose((ICommand)defaultCommand, (ICommand)new SetNestedPathCommand("Set connector nested source path", request.getRelationship(), (IEditCommandRequest)request, tmpNestedPath, tmpNestedPathDirection));
            tmpNestedPathDirection = reorientDirection == 1 ? 2 : 1;
            tmpNestedPath = this.utils.getNestedPropertyPath(oppositeEndView, newEndView);
            defaultCommand = CompositeCommand.compose((ICommand)defaultCommand, (ICommand)new SetNestedPathCommand("Set connector nested target path", request.getRelationship(), (IEditCommandRequest)request, tmpNestedPath, tmpNestedPathDirection));
        }
        return defaultCommand;
    }
}

