/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.service.types.stereotype.helper.advice;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyDependentsRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.sysml.blocks.Block;
import org.eclipse.papyrus.sysml.blocks.BlocksPackage;
import org.eclipse.papyrus.sysml.blocks.NestedConnectorEnd;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.UMLPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockEditHelperAdvice
extends AbstractEditHelperAdvice {
    protected ICommand getBeforeSetCommand(SetRequest request) {
        DestroyDependentsRequest req;
        ICommand connectorDestroyCommand;
        ICommand setCommand = super.getBeforeSetCommand(request);
        HashSet<Connector> connectorToDelete = new HashSet<Connector>();
        EObject elementToEdit = request.getElementToEdit();
        if (elementToEdit instanceof Block && request.getFeature() == BlocksPackage.eINSTANCE.getBlock_IsEncapsulated()) {
            Block blockApp = (Block)elementToEdit;
            Boolean setAsEncapsulated = request.getValue() instanceof Boolean ? (Boolean)request.getValue() : false;
            if (!blockApp.isEncapsulated() && setAsEncapsulated.booleanValue()) {
                for (Property property : this.getPropertyTypedByBlock(blockApp)) {
                    for (NestedConnectorEnd nestedEnd : this.getRelatedNestedConnectorEnd(property)) {
                        Connector connector;
                        ConnectorEnd end = nestedEnd.getBase_ConnectorEnd();
                        Connector connector2 = connector = end != null ? (Connector)end.eContainer() : null;
                        if (connector == null) continue;
                        connectorToDelete.add(connector);
                    }
                }
            }
        }
        if (!connectorToDelete.isEmpty() && (connectorDestroyCommand = (req = new DestroyDependentsRequest(request.getEditingDomain(), elementToEdit, false)).getDestroyDependentsCommand(connectorToDelete)) != null) {
            setCommand = CompositeCommand.compose((ICommand)connectorDestroyCommand, (ICommand)setCommand);
        }
        return setCommand;
    }

    private Collection<Property> getPropertyTypedByBlock(Block block) {
        EReference[] eRefs = new EReference[]{UMLPackage.eINSTANCE.getTypedElement_Type()};
        List references = EMFCoreUtil.getReferencers((EObject)block.getBase_Class(), (EReference[])eRefs);
        return references != null ? references : Collections.unmodifiableList(new ArrayList());
    }

    private Collection<NestedConnectorEnd> getRelatedNestedConnectorEnd(Property property) {
        EReference[] eRefs = new EReference[]{BlocksPackage.eINSTANCE.getNestedConnectorEnd_PropertyPath()};
        List references = EMFCoreUtil.getReferencers((EObject)property, (EReference[])eRefs);
        return references != null ? references : Collections.unmodifiableList(new ArrayList());
    }
}

