/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.alf.ui.contributions;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Element;
import org.eclipse.xtext.gmf.glue.edit.part.IXtextEMFReconciler;

public abstract class AbstractAlfReconciler
implements IXtextEMFReconciler {
    protected IGraphicalEditPart graphicalEditPart = null;
    protected String textualRepresentationWithErrors = "";

    public void reconcileWithError(IGraphicalEditPart graphicalEditPart, EObject modelObject, String newTextualRepresentation) {
        this.graphicalEditPart = graphicalEditPart;
        Element umlElement = null;
        if (!(modelObject instanceof Element)) {
            return;
        }
        umlElement = (Element)modelObject;
        this.textualRepresentationWithErrors = String.valueOf(this.textualRepresentationWithErrors) + newTextualRepresentation;
        UpdateElementCommand updateCommand = new UpdateElementCommand(umlElement);
        TransactionalEditingDomain domain = graphicalEditPart.getEditingDomain();
        domain.getCommandStack().execute((Command)updateCommand);
    }

    public abstract void reconcile(EObject var1, EObject var2);

    protected class UpdateElementCommand
    extends RecordingCommand {
        private Element element;

        protected void doExecute() {
            Comment textualRepresentation = null;
            for (Comment comment : this.element.getOwnedComments()) {
                if (comment.getBody() == null || !comment.getBody().startsWith("<<TextualRepresentation>>")) continue;
                textualRepresentation = comment;
                break;
            }
            if (textualRepresentation == null) {
                textualRepresentation = this.element.createOwnedComment();
            }
            String commentBody = "<<TextualRepresentation>>";
            commentBody = String.valueOf(commentBody) + AbstractAlfReconciler.this.textualRepresentationWithErrors;
            textualRepresentation.setBody(commentBody);
        }

        public UpdateElementCommand(Element element) {
            super(AbstractAlfReconciler.this.graphicalEditPart.getEditingDomain());
            this.element = element;
        }
    }
}

