/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.alf.alf;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum LinkOperationKind implements Enumerator
{
    CREATE(0, "CREATE", "createLink"),
    DESTROY(1, "DESTROY", "destroyLink");

    public static final int CREATE_VALUE = 0;
    public static final int DESTROY_VALUE = 1;
    private static final LinkOperationKind[] VALUES_ARRAY;
    public static final List<LinkOperationKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new LinkOperationKind[]{CREATE, DESTROY};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static LinkOperationKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LinkOperationKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LinkOperationKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LinkOperationKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LinkOperationKind get(int value) {
        switch (value) {
            case 0: {
                return CREATE;
            }
            case 1: {
                return DESTROY;
            }
        }
        return null;
    }

    private LinkOperationKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

