/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.alf.validation.typing;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.uml.alf.validation.typing.SignatureFacade;
import org.eclipse.papyrus.uml.alf.validation.typing.TypeExpression;
import org.eclipse.papyrus.uml.alf.validation.typing.TypeExpressionFactory;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Property;

public class DefaultConstructorFacade
extends SignatureFacade {
    private Class classToBeConstructed;
    private DataType datatypeToBeConstructed;

    public DefaultConstructorFacade(Class c) {
        super((EObject)c);
        this.classToBeConstructed = c;
        this.setReturnType(TypeExpressionFactory.eInstance.createTypeExpression((EObject)c));
    }

    public DefaultConstructorFacade(DataType d) {
        super((EObject)d);
        this.datatypeToBeConstructed = d;
        for (Property p : d.getAllAttributes()) {
            TypeExpression typeOfArgument = TypeExpressionFactory.eInstance.createTypeExpression((EObject)p);
            this.parameters.add(TypeExpressionFactory.eInstance.createTypeExpression((EObject)p));
            this.parametersMap.put(p.getName(), typeOfArgument);
        }
        this.setReturnType(TypeExpressionFactory.eInstance.createTypeExpression((EObject)d));
    }

    public DefaultConstructorFacade(TypeExpression t) {
        this.setName(t.getTypeFacade().getLabel());
        this.setReturnType(t);
    }

    public String getName() {
        return super.getName();
    }

    public boolean hasReturnType() {
        return true;
    }

    public String getLabel() {
        return super.getLabel();
    }

    public boolean isAConstructor() {
        return true;
    }

    public boolean isADestructor() {
        return false;
    }
}

