/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.common.ui.util.IWorkbenchPartDescriptor;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.providers.DiagramValidationMarkerNavigationProvider;
import org.eclipse.papyrus.uml.diagram.common.providers.DiagramValidationProvider;
import org.eclipse.papyrus.uml.diagram.common.util.DiagramEditPartsUtil;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;

public class ValidationAction
extends Action {
    public static final String VALIDATE_ACTION_KEY = "validateDiagramAction";
    private IWorkbenchPartDescriptor workbenchPartDescriptor;

    public ValidationAction(IWorkbenchPartDescriptor workbenchPartDescriptor) {
        this.setId(VALIDATE_ACTION_KEY);
        this.setText("Diagram Validation");
        this.workbenchPartDescriptor = workbenchPartDescriptor;
    }

    public void run() {
        IWorkbenchPart workbenchPart = this.workbenchPartDescriptor.getPartPage().getActivePart();
        if (workbenchPart instanceof IDiagramWorkbenchPart) {
            final IDiagramWorkbenchPart part = (IDiagramWorkbenchPart)workbenchPart;
            try {
                new WorkspaceModifyDelegatingOperation(new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
                        ValidationAction.runValidation(part.getDiagramEditPart(), (View)part.getDiagram());
                    }
                }).run((IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                Activator.getDefault().logError("Diagram Validation action failed", e);
            }
        }
    }

    public static void runValidation(DiagramEditPart diagramEditPart, View view) {
        final DiagramEditPart fpart = diagramEditPart;
        final View fview = view;
        TransactionalEditingDomain txDomain = TransactionUtil.getEditingDomain((EObject)view);
        DiagramValidationProvider.runWithConstraints(txDomain, new Runnable(){

            public void run() {
                ValidationAction.validate(fpart, fview);
            }
        });
    }

    private static void validate(DiagramEditPart diagramEditPart, View view) {
        IFile target;
        IFile iFile = target = view.eResource() != null ? WorkspaceSynchronizer.getFile((Resource)view.eResource()) : null;
        if (target != null) {
            DiagramValidationMarkerNavigationProvider.deleteMarkers((IResource)target);
        }
        Diagnostic diagnostic = ValidationAction.runEMFValidator(view);
        ValidationAction.createMarkers(target, diagnostic, diagramEditPart);
    }

    private static Diagnostic runEMFValidator(View target) {
        if (target.isSetElement() && target.getElement() != null) {
            EObject eo = target.getElement();
            while (eo.eContainer() != null) {
                eo = eo.eContainer();
            }
            return new Diagnostician(){

                public String getObjectLabel(EObject eObject) {
                    return EMFCoreUtil.getQualifiedName((EObject)eObject, (boolean)true);
                }
            }.validate(eo);
        }
        return Diagnostic.OK_INSTANCE;
    }

    private static void createMarkers(IFile target, Diagnostic emfValidationStatus, DiagramEditPart diagramEditPart) {
        if (emfValidationStatus.getSeverity() == 0) {
            return;
        }
        for (Diagnostic nextDiagnostic : emfValidationStatus.getChildren()) {
            List data = nextDiagnostic.getData();
            if (data == null || data.isEmpty() || !(data.get(0) instanceof EObject)) continue;
            EObject element = (EObject)data.get(0);
            List list = DiagramEditPartsUtil.getEObjectViews(element);
            if (list.size() == 0) {
                ValidationAction.addMarker(target, element.eResource().getURI().toString(), EMFCoreUtil.getQualifiedName((EObject)element, (boolean)true), nextDiagnostic.getMessage(), ValidationAction.diagnosticToStatusSeverity(nextDiagnostic.getSeverity()));
            }
            for (Object o : list) {
                if (!(o instanceof View)) continue;
                View v = (View)o;
                ValidationAction.addMarker(target, v.eResource().getURIFragment((EObject)v), EMFCoreUtil.getQualifiedName((EObject)element, (boolean)true), nextDiagnostic.getMessage(), ValidationAction.diagnosticToStatusSeverity(nextDiagnostic.getSeverity()));
            }
        }
    }

    private static void addMarker(IFile target, String elementId, String location, String message, int statusSeverity) {
        if (target == null) {
            return;
        }
        DiagramValidationMarkerNavigationProvider.addMarker(target, elementId, location, message, statusSeverity);
    }

    private static int diagnosticToStatusSeverity(int diagnosticSeverity) {
        if (diagnosticSeverity == 0) {
            return 0;
        }
        if (diagnosticSeverity == 1) {
            return 1;
        }
        if (diagnosticSeverity == 2) {
            return 2;
        }
        if (diagnosticSeverity == 4 || diagnosticSeverity == 8) {
            return 4;
        }
        return 1;
    }
}

