/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.editparts;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.AbstractBorderedShapeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditDomain;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramEditDomain;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.core.editorsfactory.IPageIconsRegistry;
import org.eclipse.papyrus.infra.core.editorsfactory.PageIconsRegistry;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.EditorUtils;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.figure.node.DiagramNodeFigure;
import org.eclipse.papyrus.uml.diagram.common.part.UmlGmfDiagramEditor;
import org.eclipse.ui.IWorkbenchPart;

public abstract class AbstractShortCutDiagramEditPart
extends AbstractBorderedShapeEditPart
implements Adapter {
    protected static final String DELETE_ICON = "icons/delete.gif";
    private IPageIconsRegistry editorRegistry;
    private Notifier target;
    protected Resource resourceToListen;

    public AbstractShortCutDiagramEditPart(View view) {
        super(view);
    }

    public ServicesRegistry getServicesRegistry() {
        IWorkbenchPart part;
        IDiagramEditDomain domain = this.getDiagramEditDomain();
        if (domain instanceof DiagramEditDomain && (part = ((DiagramEditDomain)domain).getEditorPart().getEditorSite().getPart()) instanceof UmlGmfDiagramEditor) {
            return ((UmlGmfDiagramEditor)part).getServicesRegistry();
        }
        return null;
    }

    protected IPageIconsRegistry createEditorRegistry() {
        try {
            ServicesRegistry servicesRegistry = this.getServicesRegistry();
            if (servicesRegistry != null) {
                return (IPageIconsRegistry)servicesRegistry.getService(IPageIconsRegistry.class);
            }
            return (IPageIconsRegistry)EditorUtils.getServiceRegistry().getService(IPageIconsRegistry.class);
        }
        catch (ServiceException e) {
            return new PageIconsRegistry();
        }
        catch (NullPointerException e) {
            return new PageIconsRegistry();
        }
    }

    public void activate() {
        super.activate();
        EObject eObject = this.resolveSemanticElement();
        this.resourceToListen = eObject.eResource();
        this.resourceToListen.eAdapters().add((Object)this);
    }

    protected IPageIconsRegistry getEditorRegistry() {
        if (this.editorRegistry == null) {
            this.editorRegistry = this.createEditorRegistry();
        }
        return this.editorRegistry;
    }

    public abstract DiagramNodeFigure getPrimaryShape();

    public void refresh() {
        this.refreshIcons();
        super.refresh();
    }

    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        this.refreshIcons();
    }

    protected void refreshBounds() {
        int width = 34;
        int height = 20;
        Dimension size = new Dimension(width, height);
        int x = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X());
        int y = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y());
        Point loc = new Point(x, y);
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)new Rectangle(loc, size));
    }

    private void refreshIcons() {
        if (this.resolveSemanticElement() instanceof Diagram && this.resolveSemanticElement().eResource() != null) {
            this.getPrimaryShape().setIcon(this.getEditorRegistry().getEditorIcon((Object)this.resolveSemanticElement()));
        } else {
            this.getPrimaryShape().setIcon(Activator.getPluginIconImage("org.eclipse.papyrus.uml.diagram.common", DELETE_ICON));
        }
    }

    public void deactivate() {
        super.deactivate();
        this.resourceToListen.eAdapters().remove((Object)this);
    }

    public void setTarget(Notifier target) {
        this.target = target;
    }

    public Notifier getTarget() {
        return this.target;
    }

    public boolean isAdapterForType(Object type) {
        return this.getModel().getClass() == type;
    }
}

