/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.editpolicies;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.DynamicEObjectImpl;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.core.listenerservice.IPapyrusListener;
import org.eclipse.papyrus.uml.appearance.helper.AppliedStereotypeHelper;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAppliedStereotypeDisplayEditPolicy
extends GraphicalEditPolicy
implements NotificationListener,
IPapyrusListener {
    public static final String STEREOTYPE_LABEL_POLICY = "AppliedStereotypeDisplayEditPolicy";
    protected Element hostSemanticElement;

    protected void cleanStereotypeDisplayInEAnnotation() {
        String stereotypesToDisplay = AppliedStereotypeHelper.getStereotypesToDisplay((EModelElement)((View)this.getHost().getModel()));
        StringTokenizer strQualifiedName = new StringTokenizer(stereotypesToDisplay, ",");
        while (strQualifiedName.hasMoreElements()) {
            String currentStereotype = strQualifiedName.nextToken();
            Element umlElement = this.getUMLElement();
            Stereotype stereotype = umlElement.getAppliedStereotype(currentStereotype);
            if (stereotype != null) continue;
            this.removeEAnnotationAboutStereotype(currentStereotype);
        }
    }

    public void activate() {
        View view = this.getView();
        if (view == null) {
            return;
        }
        this.hostSemanticElement = this.getUMLElement();
        this.getDiagramEventBroker().addNotificationListener((EObject)view, (NotificationListener)this);
        if (this.hostSemanticElement == null) {
            return;
        }
        this.getDiagramEventBroker().addNotificationListener((EObject)this.hostSemanticElement, (NotificationListener)this);
        for (EObject stereotypeApplication : this.hostSemanticElement.getStereotypeApplications()) {
            this.getDiagramEventBroker().addNotificationListener(stereotypeApplication, (NotificationListener)this);
        }
        this.refreshDisplay();
        this.cleanStereotypeDisplayInEAnnotation();
    }

    public void deactivate() {
        View view = this.getView();
        if (view == null) {
            return;
        }
        this.getDiagramEventBroker().removeNotificationListener((EObject)view, (NotificationListener)this);
        if (this.hostSemanticElement == null) {
            return;
        }
        for (EObject stereotypeApplication : this.hostSemanticElement.getStereotypeApplications()) {
            this.getDiagramEventBroker().removeNotificationListener(stereotypeApplication, (NotificationListener)this);
        }
        this.getDiagramEventBroker().removeNotificationListener((EObject)this.hostSemanticElement, (NotificationListener)this);
        this.hostSemanticElement = null;
    }

    protected DiagramEventBroker getDiagramEventBroker() {
        TransactionalEditingDomain theEditingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        if (theEditingDomain != null) {
            return DiagramEventBroker.getInstance((TransactionalEditingDomain)theEditingDomain);
        }
        return null;
    }

    protected Element getUMLElement() {
        return (Element)this.getView().getElement();
    }

    protected View getView() {
        return (View)this.getHost().getModel();
    }

    protected void removeEAnnotationAboutStereotype(final String stereotypeQN) {
        try {
            TransactionalEditingDomain editingDomain;
            if (this.getView() != null && (editingDomain = TransactionUtil.getEditingDomain((EObject)this.getView())) != null) {
                editingDomain.runExclusive(new Runnable(){

                    public void run() {
                        Display.getCurrent().asyncExec(new Runnable(){

                            public void run() {
                                if (AbstractAppliedStereotypeDisplayEditPolicy.this.getView() != null && editingDomain != null) {
                                    String presentationKind = AppliedStereotypeHelper.getAppliedStereotypePresentationKind((EModelElement)AbstractAppliedStereotypeDisplayEditPolicy.this.getView());
                                    RecordingCommand command = AppliedStereotypeHelper.getRemoveAppliedStereotypeCommand((TransactionalEditingDomain)editingDomain, (EModelElement)AbstractAppliedStereotypeDisplayEditPolicy.this.getView(), (String)stereotypeQN, (String)presentationKind);
                                    editingDomain.getCommandStack().execute((Command)command);
                                }
                            }
                        });
                    }
                });
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void notifyChanged(Notification notification) {
        int eventType = notification.getEventType();
        if (eventType == 20) {
            this.getDiagramEventBroker().addNotificationListener((EObject)notification.getNewValue(), (NotificationListener)this);
        } else if (eventType == 21) {
            this.getDiagramEventBroker().removeNotificationListener((EObject)notification.getOldValue(), (NotificationListener)this);
            this.cleanStereotypeDisplayInEAnnotation();
        }
        if (notification.getNotifier() instanceof EAnnotation && "Stereotype_Annotation" == ((EAnnotation)notification.getNotifier()).getSource()) {
            this.refreshDisplay();
        }
        if (eventType == 22) {
            this.refreshDisplay();
        }
        if (notification.getNotifier() instanceof DynamicEObjectImpl && this.hostSemanticElement != null && this.hostSemanticElement.getStereotypeApplications().contains(notification.getNotifier())) {
            this.refreshDisplay();
        }
    }

    public abstract void refreshDisplay();

    protected Map<String, List<String>> parseStereotypeProperties(String stereotypesToDisplay, String stereotypesPropertiesToDisplay) {
        HashMap<String, List<String>> propertiesMap = new HashMap<String, List<String>>();
        StringTokenizer stringTokenizer = new StringTokenizer(stereotypesPropertiesToDisplay, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String propertyName = stringTokenizer.nextToken();
            String stereotypeName = propertyName.substring(0, propertyName.lastIndexOf("."));
            if (!propertiesMap.containsKey(stereotypeName)) {
                ArrayList propertiesForStereotype = new ArrayList();
                propertiesMap.put(stereotypeName, propertiesForStereotype);
            }
            ((List)propertiesMap.get(stereotypeName)).add(propertyName.substring(propertyName.lastIndexOf(".") + 1, propertyName.length()));
        }
        return propertiesMap;
    }

    public Image stereotypeIconToDisplay() {
        String stereotypesToDisplay;
        StringTokenizer tokenizer;
        String stereotypespresentationKind = AppliedStereotypeHelper.getAppliedStereotypePresentationKind((EModelElement)((View)this.getHost().getModel()));
        if (stereotypespresentationKind == null) {
            return null;
        }
        if ((stereotypespresentationKind.equals("IconStereotype") || stereotypespresentationKind.equals("TextIconStereotype")) && (tokenizer = new StringTokenizer(stereotypesToDisplay = AppliedStereotypeHelper.getStereotypesToDisplay((EModelElement)((View)this.getHost().getModel())), ",")).hasMoreTokens()) {
            String firstStereotypeName = tokenizer.nextToken();
            Stereotype stereotype = this.getUMLElement().getAppliedStereotype(firstStereotypeName);
            return Activator.getIconElement(this.getUMLElement(), stereotype, false);
        }
        return null;
    }
}

