/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.figure.node;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.papyrus.uml.diagram.common.figure.node.CompartmentFigure;

public class ClassifierFigure
extends CompartmentFigure {
    protected static final int SPACE_FOR_ACTIVE_CLASS = 4;
    private boolean active = false;
    private static final String ATTRIBUTE_COMPARTMENT = "attributeCompartment";
    private static final String OPERATION_COMPARTMENT = "operationCompartment";
    private static final String NESTEDCLASSIFIER_COMPARTMENT = "nestedClassifierCompartment";
    private static final List<String> COMPARTMENT = new ArrayList<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add(ClassifierFigure.ATTRIBUTE_COMPARTMENT);
            this.add(ClassifierFigure.OPERATION_COMPARTMENT);
            this.add(ClassifierFigure.NESTEDCLASSIFIER_COMPARTMENT);
        }
    };

    public ClassifierFigure() {
        this((String)null);
    }

    public ClassifierFigure(String tagLabel) {
        super(COMPARTMENT, tagLabel);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.active) {
            Rectangle rect = this.getBounds();
            graphics.pushState();
            graphics.setForegroundColor(this.getForegroundColor());
            graphics.setLineWidth(1);
            graphics.drawLine(new Point(rect.x + 4, rect.y), new Point(rect.x + 4, rect.y + rect.height - 1));
            graphics.drawLine(new Point(rect.x - 4 - 1 + rect.width, rect.y), new Point(rect.x - 4 - 1 + rect.width, rect.y + rect.height - 1));
            graphics.setBackgroundColor(this.getBackgroundColor());
            graphics.setForegroundColor(this.getBackgroundColor());
            graphics.setLineWidth(3);
            graphics.drawLine(new Point(rect.x + 2, rect.y + 1), new Point(rect.x + 2, rect.y + rect.height - 2));
            graphics.drawLine(new Point(rect.x - 3 + rect.width, rect.y + 1), new Point(rect.x - 3 + rect.width, rect.y + rect.height - 2));
            graphics.popState();
        }
    }

    public IFigure getAttributeCompartmentFigure() {
        return this.getCompartment(ATTRIBUTE_COMPARTMENT);
    }

    public IFigure getOperationCompartmentFigure() {
        return this.getCompartment(OPERATION_COMPARTMENT);
    }

    public IFigure getNestedClassifierFigure() {
        return this.getCompartment(NESTEDCLASSIFIER_COMPARTMENT);
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }
}

