/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.ui.helper;

import java.util.Collection;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CustomPopupDialog
extends PopupDialog {
    private Point fAnchor;
    protected Composite composite;
    protected FormToolkit toolkit;
    private String title;
    protected ScrolledForm formHead;

    public CustomPopupDialog(Shell parent, Point point, String title) {
        super(parent, 0, true, true, false, false, false, null, null);
        this.fAnchor = point;
        this.toolkit = new FormToolkit(Display.getDefault());
        this.title = title;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
    }

    protected Control createContents(Composite parent) {
        this.getShell().setBackground(this.getShell().getDisplay().getSystemColor(16));
        this.initializeBounds();
        return this.createDialogArea(parent);
    }

    protected Control createDialogArea(Composite parent) {
        this.composite = (Composite)super.createDialogArea(parent);
        this.composite.setLayout((Layout)new FillLayout());
        this.formHead = this.toolkit.createScrolledForm(this.composite);
        this.toolkit.decorateFormHeading(this.formHead.getForm());
        this.formHead.setText(this.title);
        Collection<Action> actions = this.getActions();
        for (Action action : actions) {
            this.formHead.getToolBarManager().add((IAction)action);
        }
        this.formHead.getToolBarManager().add((IAction)new CloseAction());
        this.formHead.getToolBarManager().update(true);
        FillLayout layout = new FillLayout(512);
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        this.formHead.getBody().setLayout((Layout)layout);
        this.createSubsection();
        parent.pack();
        return this.composite;
    }

    protected abstract Collection<Action> getActions();

    protected abstract void createSubsection();

    protected Point getInitialLocation(Point size) {
        if (this.fAnchor == null) {
            return super.getInitialLocation(size);
        }
        Point point = this.fAnchor;
        Rectangle monitor = this.getShell().getMonitor().getClientArea();
        if (monitor.width < point.x + size.x) {
            point.x = Math.max(0, point.x - size.x);
        }
        if (monitor.height < point.y + size.y) {
            point.y = Math.max(0, point.y - size.y);
        }
        return point;
    }

    public boolean close() {
        if (this.toolkit != null) {
            this.toolkit.dispose();
        }
        this.toolkit = null;
        return super.close();
    }

    protected Control getFocusControl() {
        return this.composite;
    }

    private class CloseAction
    extends Action {
        private CloseAction() {
        }

        public ImageDescriptor getImageDescriptor() {
            return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE");
        }

        public void run() {
            CustomPopupDialog.this.close();
        }
    }
}

