/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.composite.custom.preferences;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.papyrus.infra.gmfdiag.preferences.pages.AbstractPapyrusElementPreferencePage;
import org.eclipse.papyrus.infra.gmfdiag.preferences.utils.GradientPreferenceConverter;
import org.eclipse.papyrus.infra.gmfdiag.preferences.utils.PreferenceConstantHelper;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class PropertyPreferencePage
extends AbstractPapyrusElementPreferencePage {
    public static final String ID = "org.eclipse.papyrus.uml.diagram.composite.custom.preferences.PropertyPreferencePage";
    protected Button displVisibility;
    protected Button displDerive;
    protected Button displName;
    protected Button displType;
    protected Button displMutliplicity;
    protected Button displDfltValue;
    protected Button displModifiers;
    private int propertyValue = this.getPreferenceStore().getInt("Property.label.display");

    public static void initDefaults(IPreferenceStore store) {
        String elementName = "Property";
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)PreferenceConstantHelper.getElementConstant((String)elementName, (int)0), (RGB)new RGB(255, 255, 255));
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)PreferenceConstantHelper.getElementConstant((String)elementName, (int)3), (RGB)new RGB(177, 207, 229));
        store.setDefault(PreferenceConstantHelper.getElementConstant((String)elementName, (int)5), false);
        GradientPreferenceConverter gradientPreferenceConverter = new GradientPreferenceConverter(new RGB(255, 255, 255), new RGB(177, 207, 229), 0, 0);
        store.setDefault(PreferenceConstantHelper.getElementConstant((String)elementName, (int)4), gradientPreferenceConverter.getPreferenceValue());
        store.setDefault("Property.label.display", 62);
    }

    protected Button createCheckButton(Composite parent, String label, int mask) {
        Button button = new Button(parent, 32);
        button.setText(label);
        button.addSelectionListener((SelectionListener)new AppearenceSelectionListener(mask));
        return button;
    }

    protected void createLabelPreferencesButtons(Composite parent) {
        Group group = new Group(parent, 32);
        group.setText("Label Display");
        group.setLayout((Layout)new FormLayout());
        this.displVisibility = this.createCheckButton((Composite)group, "Visibility", 2);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(0, 0);
        this.displVisibility.setLayoutData((Object)data);
        this.displDerive = this.createCheckButton((Composite)group, "Derived", 4);
        data = new FormData();
        data.left = new FormAttachment((Control)this.displVisibility, 85);
        data.top = new FormAttachment(0, 0);
        this.displDerive.setLayoutData((Object)data);
        this.displName = this.createCheckButton((Composite)group, "Name", 8);
        data = new FormData();
        data.left = new FormAttachment((Control)this.displDerive, 85);
        data.top = new FormAttachment(0, 0);
        this.displName.setLayoutData((Object)data);
        this.displType = this.createCheckButton((Composite)group, "Type", 16);
        data = new FormData();
        data.left = new FormAttachment((Control)this.displName, 85);
        data.top = new FormAttachment(0, 0);
        this.displType.setLayoutData((Object)data);
        this.displMutliplicity = this.createCheckButton((Composite)group, "Multiplicity", 32);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment((Control)this.displVisibility, 5);
        this.displMutliplicity.setLayoutData((Object)data);
        this.displDfltValue = this.createCheckButton((Composite)group, "Default Value", 64);
        data = new FormData();
        data.left = new FormAttachment((Control)this.displVisibility, 85);
        data.top = new FormAttachment((Control)this.displVisibility, 5);
        this.displDfltValue.setLayoutData((Object)data);
        this.displModifiers = this.createCheckButton((Composite)group, "Modifiers", 128);
        data = new FormData();
        data.left = new FormAttachment((Control)this.displDerive, 85);
        data.top = new FormAttachment((Control)this.displVisibility, 5);
        this.displModifiers.setLayoutData((Object)data);
    }

    protected void createPageContents(Composite parent) {
        super.createPageContents(parent);
        this.createLabelPreferencesButtons(parent);
        this.refreshButtons();
    }

    protected String getBundleId() {
        return "org.eclipse.papyrus.uml.diagram.composite";
    }

    protected void loadDefaultPreferences() {
        this.propertyValue = this.getPreferenceStore().getInt("Property.label.display");
        this.refreshButtons();
    }

    protected void performDefaults() {
        this.loadDefaultPreferences();
        super.performDefaults();
    }

    public boolean performOk() {
        this.storePreferences();
        return super.performOk();
    }

    protected void refreshButtons() {
        this.displVisibility.setSelection((this.propertyValue & 2) == 2);
        this.displDerive.setSelection((this.propertyValue & 4) == 4);
        this.displName.setSelection((this.propertyValue & 8) == 8);
        this.displType.setSelection((this.propertyValue & 0x10) == 16);
        this.displMutliplicity.setSelection((this.propertyValue & 0x20) == 32);
        this.displDfltValue.setSelection((this.propertyValue & 0x40) == 64);
        this.displModifiers.setSelection((this.propertyValue & 0x80) == 128);
    }

    protected void storePreferences() {
        IPreferenceStore store = this.getPreferenceStore();
        if (this.propertyValue != store.getInt("Property.label.display")) {
            store.setValue("Property.label.display", this.propertyValue);
        }
    }

    private class AppearenceSelectionListener
    implements SelectionListener {
        private final int style;

        public AppearenceSelectionListener(int style) {
            this.style = style;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            PropertyPreferencePage propertyPreferencePage = PropertyPreferencePage.this;
            propertyPreferencePage.propertyValue = propertyPreferencePage.propertyValue ^ this.style;
            PropertyPreferencePage.this.refreshButtons();
        }
    }
}

