/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.composite.part;

import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.providers.BaseViewInfo;
import org.eclipse.papyrus.uml.diagram.common.providers.ViewInfo;
import org.eclipse.papyrus.uml.diagram.composite.part.UMLDiagramEditorPlugin;
import org.eclipse.uml2.uml.Collaboration;
import org.eclipse.uml2.uml.CollaborationUse;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.UMLPackage;

public class UMLVisualIDRegistry {
    private static final String DEBUG_KEY = "org.eclipse.papyrus.uml.diagram.composite/debug/visualID";
    private static ViewInfo diagramViewInfo = null;

    public static int getVisualID(View view) {
        if (view instanceof Diagram) {
            if ("CompositeStructure".equals(view.getType())) {
                return 1000;
            }
            return -1;
        }
        return UMLVisualIDRegistry.getVisualID(view.getType());
    }

    public static String getModelID(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram) {
            EAnnotation annotation = view.getEAnnotation("Shortcut");
            if (annotation != null) {
                return (String)annotation.getDetails().get((Object)"modelID");
            }
            view = (View)view.eContainer();
        }
        return diagram != null ? diagram.getType() : null;
    }

    public static int getVisualID(String type) {
        try {
            return Integer.parseInt(type);
        }
        catch (NumberFormatException e) {
            if (Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)DEBUG_KEY))) {
                UMLDiagramEditorPlugin.getInstance().logError("Unable to parse view type as a visualID number: " + type);
            }
            return -1;
        }
    }

    public static String getType(int visualID) {
        return Integer.toString(visualID);
    }

    public static int getDiagramVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDiagram((Package)domainElement)) {
            return 1000;
        }
        return -1;
    }

    public static int getNodeVisualID(View containerView, EObject domainElement) {
        int containerVisualID;
        if (domainElement == null) {
            return -1;
        }
        String containerModelID = UMLVisualIDRegistry.getModelID(containerView);
        if (!"CompositeStructure".equals(containerModelID)) {
            return -1;
        }
        if ("CompositeStructure".equals(containerModelID)) {
            containerVisualID = UMLVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return -1;
        }
        switch (containerVisualID) {
            case 1000: {
                if (UMLPackage.eINSTANCE.getActivity().isSuperTypeOf(domainElement.eClass())) {
                    return 2060;
                }
                if (UMLPackage.eINSTANCE.getInteraction().isSuperTypeOf(domainElement.eClass())) {
                    return 2061;
                }
                if (UMLPackage.eINSTANCE.getProtocolStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 2062;
                }
                if (UMLPackage.eINSTANCE.getStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 2063;
                }
                if (UMLPackage.eINSTANCE.getFunctionBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 2064;
                }
                if (UMLPackage.eINSTANCE.getOpaqueBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 2065;
                }
                if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                    return 2069;
                }
                if (UMLPackage.eINSTANCE.getDevice().isSuperTypeOf(domainElement.eClass())) {
                    return 2070;
                }
                if (UMLPackage.eINSTANCE.getExecutionEnvironment().isSuperTypeOf(domainElement.eClass())) {
                    return 2071;
                }
                if (UMLPackage.eINSTANCE.getNode().isSuperTypeOf(domainElement.eClass())) {
                    return 2072;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) {
                    return 2073;
                }
                if (UMLPackage.eINSTANCE.getCollaboration().isSuperTypeOf(domainElement.eClass())) {
                    return 2075;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 2076;
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return 2066;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 2067;
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass())) {
                    return 2068;
                }
                if (UMLPackage.eINSTANCE.getActor().isSuperTypeOf(domainElement.eClass())) {
                    return 2077;
                }
                if (UMLPackage.eINSTANCE.getDeploymentSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 2078;
                }
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) {
                    return 2079;
                }
                if (UMLPackage.eINSTANCE.getInformationItem().isSuperTypeOf(domainElement.eClass())) {
                    return 2080;
                }
                if (UMLPackage.eINSTANCE.getSignal().isSuperTypeOf(domainElement.eClass())) {
                    return 2081;
                }
                if (UMLPackage.eINSTANCE.getUseCase().isSuperTypeOf(domainElement.eClass())) {
                    return 2082;
                }
                if (UMLPackage.eINSTANCE.getSignalEvent().isSuperTypeOf(domainElement.eClass())) {
                    return 2083;
                }
                if (UMLPackage.eINSTANCE.getCallEvent().isSuperTypeOf(domainElement.eClass())) {
                    return 2084;
                }
                if (UMLPackage.eINSTANCE.getAnyReceiveEvent().isSuperTypeOf(domainElement.eClass())) {
                    return 2085;
                }
                if (UMLPackage.eINSTANCE.getChangeEvent().isSuperTypeOf(domainElement.eClass())) {
                    return 2088;
                }
                if (UMLPackage.eINSTANCE.getTimeEvent().isSuperTypeOf(domainElement.eClass())) {
                    return 2089;
                }
                if (UMLPackage.eINSTANCE.getDurationObservation().isSuperTypeOf(domainElement.eClass())) {
                    return 2093;
                }
                if (UMLPackage.eINSTANCE.getTimeObservation().isSuperTypeOf(domainElement.eClass())) {
                    return 2094;
                }
                if (UMLPackage.eINSTANCE.getLiteralBoolean().isSuperTypeOf(domainElement.eClass())) {
                    return 2095;
                }
                if (UMLPackage.eINSTANCE.getLiteralInteger().isSuperTypeOf(domainElement.eClass())) {
                    return 2096;
                }
                if (UMLPackage.eINSTANCE.getLiteralNull().isSuperTypeOf(domainElement.eClass())) {
                    return 2097;
                }
                if (UMLPackage.eINSTANCE.getLiteralString().isSuperTypeOf(domainElement.eClass())) {
                    return 2098;
                }
                if (UMLPackage.eINSTANCE.getLiteralUnlimitedNatural().isSuperTypeOf(domainElement.eClass())) {
                    return 2099;
                }
                if (UMLPackage.eINSTANCE.getStringExpression().isSuperTypeOf(domainElement.eClass())) {
                    return 2100;
                }
                if (UMLPackage.eINSTANCE.getOpaqueExpression().isSuperTypeOf(domainElement.eClass())) {
                    return 2101;
                }
                if (UMLPackage.eINSTANCE.getTimeExpression().isSuperTypeOf(domainElement.eClass())) {
                    return 2102;
                }
                if (UMLPackage.eINSTANCE.getExpression().isSuperTypeOf(domainElement.eClass())) {
                    return 2103;
                }
                if (UMLPackage.eINSTANCE.getDuration().isSuperTypeOf(domainElement.eClass())) {
                    return 2104;
                }
                if (UMLPackage.eINSTANCE.getTimeInterval().isSuperTypeOf(domainElement.eClass())) {
                    return 2105;
                }
                if (UMLPackage.eINSTANCE.getDurationInterval().isSuperTypeOf(domainElement.eClass())) {
                    return 2106;
                }
                if (UMLPackage.eINSTANCE.getInterval().isSuperTypeOf(domainElement.eClass())) {
                    return 2107;
                }
                if (UMLPackage.eINSTANCE.getInstanceValue().isSuperTypeOf(domainElement.eClass())) {
                    return 2108;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 2109;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 2110;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 2111;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 2112;
                }
                if (UMLPackage.eINSTANCE.getInteractionConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 2113;
                }
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 2114;
            }
            case 2060: {
                if (UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) {
                    return 3069;
                }
                if (!UMLPackage.eINSTANCE.getParameter().isSuperTypeOf(domainElement.eClass())) break;
                return 3088;
            }
            case 2061: {
                if (UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) {
                    return 3069;
                }
                if (!UMLPackage.eINSTANCE.getParameter().isSuperTypeOf(domainElement.eClass())) break;
                return 3088;
            }
            case 2062: {
                if (UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) {
                    return 3069;
                }
                if (!UMLPackage.eINSTANCE.getParameter().isSuperTypeOf(domainElement.eClass())) break;
                return 3088;
            }
            case 2063: {
                if (UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) {
                    return 3069;
                }
                if (!UMLPackage.eINSTANCE.getParameter().isSuperTypeOf(domainElement.eClass())) break;
                return 3088;
            }
            case 2064: {
                if (UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) {
                    return 3069;
                }
                if (!UMLPackage.eINSTANCE.getParameter().isSuperTypeOf(domainElement.eClass())) break;
                return 3088;
            }
            case 2065: {
                if (UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) {
                    return 3069;
                }
                if (!UMLPackage.eINSTANCE.getParameter().isSuperTypeOf(domainElement.eClass())) break;
                return 3088;
            }
            case 2069: {
                if (!UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) break;
                return 3069;
            }
            case 2070: {
                if (!UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) break;
                return 3069;
            }
            case 2071: {
                if (!UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) break;
                return 3069;
            }
            case 2072: {
                if (!UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) break;
                return 3069;
            }
            case 2073: {
                if (!UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) break;
                return 3069;
            }
            case 2067: {
                if (!UMLPackage.eINSTANCE.getEnumerationLiteral().isSuperTypeOf(domainElement.eClass())) break;
                return 3066;
            }
            case 3070: {
                if (!UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) break;
                return 3069;
            }
            case 3072: {
                if (UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) {
                    return 3069;
                }
                if (!UMLPackage.eINSTANCE.getParameter().isSuperTypeOf(domainElement.eClass())) break;
                return 3088;
            }
            case 3073: {
                if (UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) {
                    return 3069;
                }
                if (!UMLPackage.eINSTANCE.getParameter().isSuperTypeOf(domainElement.eClass())) break;
                return 3088;
            }
            case 3074: {
                if (UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) {
                    return 3069;
                }
                if (!UMLPackage.eINSTANCE.getParameter().isSuperTypeOf(domainElement.eClass())) break;
                return 3088;
            }
            case 3075: {
                if (UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) {
                    return 3069;
                }
                if (!UMLPackage.eINSTANCE.getParameter().isSuperTypeOf(domainElement.eClass())) break;
                return 3088;
            }
            case 3076: {
                if (UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) {
                    return 3069;
                }
                if (!UMLPackage.eINSTANCE.getParameter().isSuperTypeOf(domainElement.eClass())) break;
                return 3088;
            }
            case 3077: {
                if (UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) {
                    return 3069;
                }
                if (!UMLPackage.eINSTANCE.getParameter().isSuperTypeOf(domainElement.eClass())) break;
                return 3088;
            }
            case 3081: {
                if (!UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) break;
                return 3069;
            }
            case 3082: {
                if (!UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) break;
                return 3069;
            }
            case 3083: {
                if (!UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) break;
                return 3069;
            }
            case 3084: {
                if (!UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) break;
                return 3069;
            }
            case 3085: {
                if (!UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) break;
                return 3069;
            }
            case 3079: {
                if (!UMLPackage.eINSTANCE.getEnumerationLiteral().isSuperTypeOf(domainElement.eClass())) break;
                return 3066;
            }
            case 7033: {
                if (!UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass())) break;
                return 3101;
            }
            case 7034: {
                if (!UMLPackage.eINSTANCE.getOperation().isSuperTypeOf(domainElement.eClass())) break;
                return 3102;
            }
            case 7036: {
                if (!UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass())) break;
                return 3101;
            }
            case 7037: {
                if (!UMLPackage.eINSTANCE.getOperation().isSuperTypeOf(domainElement.eClass())) break;
                return 3102;
            }
            case 7048: {
                if (!UMLPackage.eINSTANCE.getEnumerationLiteral().isSuperTypeOf(domainElement.eClass())) break;
                return 3066;
            }
            case 7049: {
                if (!UMLPackage.eINSTANCE.getEnumerationLiteral().isSuperTypeOf(domainElement.eClass())) break;
                return 3066;
            }
            case 7050: {
                if (UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) {
                    return 3069;
                }
                if (UMLPackage.eINSTANCE.getParameter().isSuperTypeOf(domainElement.eClass())) {
                    return 3088;
                }
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isProperty_3070(containerView, (Property)domainElement)) {
                    return 3070;
                }
                if (UMLPackage.eINSTANCE.getCollaborationUse().isSuperTypeOf(domainElement.eClass())) {
                    return 3071;
                }
                if (UMLPackage.eINSTANCE.getActivity().isSuperTypeOf(domainElement.eClass())) {
                    return 3072;
                }
                if (UMLPackage.eINSTANCE.getInteraction().isSuperTypeOf(domainElement.eClass())) {
                    return 3073;
                }
                if (UMLPackage.eINSTANCE.getProtocolStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3074;
                }
                if (UMLPackage.eINSTANCE.getStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3075;
                }
                if (UMLPackage.eINSTANCE.getFunctionBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3076;
                }
                if (UMLPackage.eINSTANCE.getOpaqueBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3077;
                }
                if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                    return 3081;
                }
                if (UMLPackage.eINSTANCE.getDevice().isSuperTypeOf(domainElement.eClass())) {
                    return 3082;
                }
                if (UMLPackage.eINSTANCE.getExecutionEnvironment().isSuperTypeOf(domainElement.eClass())) {
                    return 3083;
                }
                if (UMLPackage.eINSTANCE.getNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3084;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) {
                    return 3085;
                }
                if (UMLPackage.eINSTANCE.getCollaboration().isSuperTypeOf(domainElement.eClass())) {
                    return 3086;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3087;
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return 3078;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 3079;
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass())) {
                    return 3080;
                }
                if (UMLPackage.eINSTANCE.getActor().isSuperTypeOf(domainElement.eClass())) {
                    return 3091;
                }
                if (UMLPackage.eINSTANCE.getDeploymentSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 3092;
                }
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) {
                    return 3093;
                }
                if (UMLPackage.eINSTANCE.getInformationItem().isSuperTypeOf(domainElement.eClass())) {
                    return 3094;
                }
                if (UMLPackage.eINSTANCE.getSignal().isSuperTypeOf(domainElement.eClass())) {
                    return 3095;
                }
                if (UMLPackage.eINSTANCE.getUseCase().isSuperTypeOf(domainElement.eClass())) {
                    return 3096;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3097;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3116;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3117;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3118;
                }
                if (UMLPackage.eINSTANCE.getInteractionConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3119;
                }
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3120;
            }
            case 7051: {
                if (UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) {
                    return 3069;
                }
                if (UMLPackage.eINSTANCE.getParameter().isSuperTypeOf(domainElement.eClass())) {
                    return 3088;
                }
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isProperty_3070(containerView, (Property)domainElement)) {
                    return 3070;
                }
                if (UMLPackage.eINSTANCE.getCollaborationUse().isSuperTypeOf(domainElement.eClass())) {
                    return 3071;
                }
                if (UMLPackage.eINSTANCE.getActivity().isSuperTypeOf(domainElement.eClass())) {
                    return 3072;
                }
                if (UMLPackage.eINSTANCE.getInteraction().isSuperTypeOf(domainElement.eClass())) {
                    return 3073;
                }
                if (UMLPackage.eINSTANCE.getProtocolStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3074;
                }
                if (UMLPackage.eINSTANCE.getStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3075;
                }
                if (UMLPackage.eINSTANCE.getFunctionBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3076;
                }
                if (UMLPackage.eINSTANCE.getOpaqueBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3077;
                }
                if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                    return 3081;
                }
                if (UMLPackage.eINSTANCE.getDevice().isSuperTypeOf(domainElement.eClass())) {
                    return 3082;
                }
                if (UMLPackage.eINSTANCE.getExecutionEnvironment().isSuperTypeOf(domainElement.eClass())) {
                    return 3083;
                }
                if (UMLPackage.eINSTANCE.getNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3084;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) {
                    return 3085;
                }
                if (UMLPackage.eINSTANCE.getCollaboration().isSuperTypeOf(domainElement.eClass())) {
                    return 3086;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3087;
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return 3078;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 3079;
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass())) {
                    return 3080;
                }
                if (UMLPackage.eINSTANCE.getActor().isSuperTypeOf(domainElement.eClass())) {
                    return 3091;
                }
                if (UMLPackage.eINSTANCE.getDeploymentSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 3092;
                }
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) {
                    return 3093;
                }
                if (UMLPackage.eINSTANCE.getInformationItem().isSuperTypeOf(domainElement.eClass())) {
                    return 3094;
                }
                if (UMLPackage.eINSTANCE.getSignal().isSuperTypeOf(domainElement.eClass())) {
                    return 3095;
                }
                if (UMLPackage.eINSTANCE.getUseCase().isSuperTypeOf(domainElement.eClass())) {
                    return 3096;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3097;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3116;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3117;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3118;
                }
                if (UMLPackage.eINSTANCE.getInteractionConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3119;
                }
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3120;
            }
            case 7052: {
                if (UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) {
                    return 3069;
                }
                if (UMLPackage.eINSTANCE.getParameter().isSuperTypeOf(domainElement.eClass())) {
                    return 3088;
                }
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isProperty_3070(containerView, (Property)domainElement)) {
                    return 3070;
                }
                if (UMLPackage.eINSTANCE.getCollaborationUse().isSuperTypeOf(domainElement.eClass())) {
                    return 3071;
                }
                if (UMLPackage.eINSTANCE.getActivity().isSuperTypeOf(domainElement.eClass())) {
                    return 3072;
                }
                if (UMLPackage.eINSTANCE.getInteraction().isSuperTypeOf(domainElement.eClass())) {
                    return 3073;
                }
                if (UMLPackage.eINSTANCE.getProtocolStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3074;
                }
                if (UMLPackage.eINSTANCE.getStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3075;
                }
                if (UMLPackage.eINSTANCE.getFunctionBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3076;
                }
                if (UMLPackage.eINSTANCE.getOpaqueBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3077;
                }
                if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                    return 3081;
                }
                if (UMLPackage.eINSTANCE.getDevice().isSuperTypeOf(domainElement.eClass())) {
                    return 3082;
                }
                if (UMLPackage.eINSTANCE.getExecutionEnvironment().isSuperTypeOf(domainElement.eClass())) {
                    return 3083;
                }
                if (UMLPackage.eINSTANCE.getNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3084;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) {
                    return 3085;
                }
                if (UMLPackage.eINSTANCE.getCollaboration().isSuperTypeOf(domainElement.eClass())) {
                    return 3086;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3087;
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return 3078;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 3079;
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass())) {
                    return 3080;
                }
                if (UMLPackage.eINSTANCE.getActor().isSuperTypeOf(domainElement.eClass())) {
                    return 3091;
                }
                if (UMLPackage.eINSTANCE.getDeploymentSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 3092;
                }
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) {
                    return 3093;
                }
                if (UMLPackage.eINSTANCE.getInformationItem().isSuperTypeOf(domainElement.eClass())) {
                    return 3094;
                }
                if (UMLPackage.eINSTANCE.getSignal().isSuperTypeOf(domainElement.eClass())) {
                    return 3095;
                }
                if (UMLPackage.eINSTANCE.getUseCase().isSuperTypeOf(domainElement.eClass())) {
                    return 3096;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3097;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3116;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3117;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3118;
                }
                if (UMLPackage.eINSTANCE.getInteractionConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3119;
                }
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3120;
            }
            case 7053: {
                if (UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) {
                    return 3069;
                }
                if (UMLPackage.eINSTANCE.getParameter().isSuperTypeOf(domainElement.eClass())) {
                    return 3088;
                }
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isProperty_3070(containerView, (Property)domainElement)) {
                    return 3070;
                }
                if (UMLPackage.eINSTANCE.getCollaborationUse().isSuperTypeOf(domainElement.eClass())) {
                    return 3071;
                }
                if (UMLPackage.eINSTANCE.getActivity().isSuperTypeOf(domainElement.eClass())) {
                    return 3072;
                }
                if (UMLPackage.eINSTANCE.getInteraction().isSuperTypeOf(domainElement.eClass())) {
                    return 3073;
                }
                if (UMLPackage.eINSTANCE.getProtocolStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3074;
                }
                if (UMLPackage.eINSTANCE.getStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3075;
                }
                if (UMLPackage.eINSTANCE.getFunctionBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3076;
                }
                if (UMLPackage.eINSTANCE.getOpaqueBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3077;
                }
                if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                    return 3081;
                }
                if (UMLPackage.eINSTANCE.getDevice().isSuperTypeOf(domainElement.eClass())) {
                    return 3082;
                }
                if (UMLPackage.eINSTANCE.getExecutionEnvironment().isSuperTypeOf(domainElement.eClass())) {
                    return 3083;
                }
                if (UMLPackage.eINSTANCE.getNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3084;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) {
                    return 3085;
                }
                if (UMLPackage.eINSTANCE.getCollaboration().isSuperTypeOf(domainElement.eClass())) {
                    return 3086;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3087;
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return 3078;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 3079;
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass())) {
                    return 3080;
                }
                if (UMLPackage.eINSTANCE.getActor().isSuperTypeOf(domainElement.eClass())) {
                    return 3091;
                }
                if (UMLPackage.eINSTANCE.getDeploymentSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 3092;
                }
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) {
                    return 3093;
                }
                if (UMLPackage.eINSTANCE.getInformationItem().isSuperTypeOf(domainElement.eClass())) {
                    return 3094;
                }
                if (UMLPackage.eINSTANCE.getSignal().isSuperTypeOf(domainElement.eClass())) {
                    return 3095;
                }
                if (UMLPackage.eINSTANCE.getUseCase().isSuperTypeOf(domainElement.eClass())) {
                    return 3096;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3097;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3116;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3117;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3118;
                }
                if (UMLPackage.eINSTANCE.getInteractionConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3119;
                }
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3120;
            }
            case 7054: {
                if (UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) {
                    return 3069;
                }
                if (UMLPackage.eINSTANCE.getParameter().isSuperTypeOf(domainElement.eClass())) {
                    return 3088;
                }
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isProperty_3070(containerView, (Property)domainElement)) {
                    return 3070;
                }
                if (UMLPackage.eINSTANCE.getCollaborationUse().isSuperTypeOf(domainElement.eClass())) {
                    return 3071;
                }
                if (UMLPackage.eINSTANCE.getActivity().isSuperTypeOf(domainElement.eClass())) {
                    return 3072;
                }
                if (UMLPackage.eINSTANCE.getInteraction().isSuperTypeOf(domainElement.eClass())) {
                    return 3073;
                }
                if (UMLPackage.eINSTANCE.getProtocolStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3074;
                }
                if (UMLPackage.eINSTANCE.getStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3075;
                }
                if (UMLPackage.eINSTANCE.getFunctionBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3076;
                }
                if (UMLPackage.eINSTANCE.getOpaqueBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3077;
                }
                if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                    return 3081;
                }
                if (UMLPackage.eINSTANCE.getDevice().isSuperTypeOf(domainElement.eClass())) {
                    return 3082;
                }
                if (UMLPackage.eINSTANCE.getExecutionEnvironment().isSuperTypeOf(domainElement.eClass())) {
                    return 3083;
                }
                if (UMLPackage.eINSTANCE.getNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3084;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) {
                    return 3085;
                }
                if (UMLPackage.eINSTANCE.getCollaboration().isSuperTypeOf(domainElement.eClass())) {
                    return 3086;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3087;
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return 3078;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 3079;
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass())) {
                    return 3080;
                }
                if (UMLPackage.eINSTANCE.getActor().isSuperTypeOf(domainElement.eClass())) {
                    return 3091;
                }
                if (UMLPackage.eINSTANCE.getDeploymentSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 3092;
                }
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) {
                    return 3093;
                }
                if (UMLPackage.eINSTANCE.getInformationItem().isSuperTypeOf(domainElement.eClass())) {
                    return 3094;
                }
                if (UMLPackage.eINSTANCE.getSignal().isSuperTypeOf(domainElement.eClass())) {
                    return 3095;
                }
                if (UMLPackage.eINSTANCE.getUseCase().isSuperTypeOf(domainElement.eClass())) {
                    return 3096;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3097;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3116;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3117;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3118;
                }
                if (UMLPackage.eINSTANCE.getInteractionConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3119;
                }
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3120;
            }
            case 7055: {
                if (UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) {
                    return 3069;
                }
                if (UMLPackage.eINSTANCE.getParameter().isSuperTypeOf(domainElement.eClass())) {
                    return 3088;
                }
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isProperty_3070(containerView, (Property)domainElement)) {
                    return 3070;
                }
                if (UMLPackage.eINSTANCE.getCollaborationUse().isSuperTypeOf(domainElement.eClass())) {
                    return 3071;
                }
                if (UMLPackage.eINSTANCE.getActivity().isSuperTypeOf(domainElement.eClass())) {
                    return 3072;
                }
                if (UMLPackage.eINSTANCE.getInteraction().isSuperTypeOf(domainElement.eClass())) {
                    return 3073;
                }
                if (UMLPackage.eINSTANCE.getProtocolStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3074;
                }
                if (UMLPackage.eINSTANCE.getStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3075;
                }
                if (UMLPackage.eINSTANCE.getFunctionBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3076;
                }
                if (UMLPackage.eINSTANCE.getOpaqueBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3077;
                }
                if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                    return 3081;
                }
                if (UMLPackage.eINSTANCE.getDevice().isSuperTypeOf(domainElement.eClass())) {
                    return 3082;
                }
                if (UMLPackage.eINSTANCE.getExecutionEnvironment().isSuperTypeOf(domainElement.eClass())) {
                    return 3083;
                }
                if (UMLPackage.eINSTANCE.getNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3084;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) {
                    return 3085;
                }
                if (UMLPackage.eINSTANCE.getCollaboration().isSuperTypeOf(domainElement.eClass())) {
                    return 3086;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3087;
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return 3078;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 3079;
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass())) {
                    return 3080;
                }
                if (UMLPackage.eINSTANCE.getActor().isSuperTypeOf(domainElement.eClass())) {
                    return 3091;
                }
                if (UMLPackage.eINSTANCE.getDeploymentSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 3092;
                }
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) {
                    return 3093;
                }
                if (UMLPackage.eINSTANCE.getInformationItem().isSuperTypeOf(domainElement.eClass())) {
                    return 3094;
                }
                if (UMLPackage.eINSTANCE.getSignal().isSuperTypeOf(domainElement.eClass())) {
                    return 3095;
                }
                if (UMLPackage.eINSTANCE.getUseCase().isSuperTypeOf(domainElement.eClass())) {
                    return 3096;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3097;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3116;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3117;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3118;
                }
                if (UMLPackage.eINSTANCE.getInteractionConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3119;
                }
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3120;
            }
            case 7056: {
                if (UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) {
                    return 3069;
                }
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isProperty_3070(containerView, (Property)domainElement)) {
                    return 3070;
                }
                if (UMLPackage.eINSTANCE.getCollaborationUse().isSuperTypeOf(domainElement.eClass())) {
                    return 3071;
                }
                if (UMLPackage.eINSTANCE.getActivity().isSuperTypeOf(domainElement.eClass())) {
                    return 3072;
                }
                if (UMLPackage.eINSTANCE.getInteraction().isSuperTypeOf(domainElement.eClass())) {
                    return 3073;
                }
                if (UMLPackage.eINSTANCE.getProtocolStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3074;
                }
                if (UMLPackage.eINSTANCE.getStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3075;
                }
                if (UMLPackage.eINSTANCE.getFunctionBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3076;
                }
                if (UMLPackage.eINSTANCE.getOpaqueBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3077;
                }
                if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                    return 3081;
                }
                if (UMLPackage.eINSTANCE.getDevice().isSuperTypeOf(domainElement.eClass())) {
                    return 3082;
                }
                if (UMLPackage.eINSTANCE.getExecutionEnvironment().isSuperTypeOf(domainElement.eClass())) {
                    return 3083;
                }
                if (UMLPackage.eINSTANCE.getNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3084;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) {
                    return 3085;
                }
                if (UMLPackage.eINSTANCE.getCollaboration().isSuperTypeOf(domainElement.eClass())) {
                    return 3086;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3087;
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return 3078;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 3079;
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass())) {
                    return 3080;
                }
                if (UMLPackage.eINSTANCE.getActor().isSuperTypeOf(domainElement.eClass())) {
                    return 3091;
                }
                if (UMLPackage.eINSTANCE.getDeploymentSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 3092;
                }
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) {
                    return 3093;
                }
                if (UMLPackage.eINSTANCE.getInformationItem().isSuperTypeOf(domainElement.eClass())) {
                    return 3094;
                }
                if (UMLPackage.eINSTANCE.getSignal().isSuperTypeOf(domainElement.eClass())) {
                    return 3095;
                }
                if (UMLPackage.eINSTANCE.getUseCase().isSuperTypeOf(domainElement.eClass())) {
                    return 3096;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3097;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3116;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3117;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3118;
                }
                if (UMLPackage.eINSTANCE.getInteractionConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3119;
                }
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3120;
            }
            case 7057: {
                if (UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) {
                    return 3069;
                }
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isProperty_3070(containerView, (Property)domainElement)) {
                    return 3070;
                }
                if (UMLPackage.eINSTANCE.getCollaborationUse().isSuperTypeOf(domainElement.eClass())) {
                    return 3071;
                }
                if (UMLPackage.eINSTANCE.getActivity().isSuperTypeOf(domainElement.eClass())) {
                    return 3072;
                }
                if (UMLPackage.eINSTANCE.getInteraction().isSuperTypeOf(domainElement.eClass())) {
                    return 3073;
                }
                if (UMLPackage.eINSTANCE.getProtocolStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3074;
                }
                if (UMLPackage.eINSTANCE.getStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3075;
                }
                if (UMLPackage.eINSTANCE.getFunctionBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3076;
                }
                if (UMLPackage.eINSTANCE.getOpaqueBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3077;
                }
                if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                    return 3081;
                }
                if (UMLPackage.eINSTANCE.getDevice().isSuperTypeOf(domainElement.eClass())) {
                    return 3082;
                }
                if (UMLPackage.eINSTANCE.getExecutionEnvironment().isSuperTypeOf(domainElement.eClass())) {
                    return 3083;
                }
                if (UMLPackage.eINSTANCE.getNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3084;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) {
                    return 3085;
                }
                if (UMLPackage.eINSTANCE.getCollaboration().isSuperTypeOf(domainElement.eClass())) {
                    return 3086;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3087;
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return 3078;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 3079;
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass())) {
                    return 3080;
                }
                if (UMLPackage.eINSTANCE.getActor().isSuperTypeOf(domainElement.eClass())) {
                    return 3091;
                }
                if (UMLPackage.eINSTANCE.getDeploymentSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 3092;
                }
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) {
                    return 3093;
                }
                if (UMLPackage.eINSTANCE.getInformationItem().isSuperTypeOf(domainElement.eClass())) {
                    return 3094;
                }
                if (UMLPackage.eINSTANCE.getSignal().isSuperTypeOf(domainElement.eClass())) {
                    return 3095;
                }
                if (UMLPackage.eINSTANCE.getUseCase().isSuperTypeOf(domainElement.eClass())) {
                    return 3096;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3097;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3116;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3117;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3118;
                }
                if (UMLPackage.eINSTANCE.getInteractionConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3119;
                }
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3120;
            }
            case 7058: {
                if (UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) {
                    return 3069;
                }
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isProperty_3070(containerView, (Property)domainElement)) {
                    return 3070;
                }
                if (UMLPackage.eINSTANCE.getCollaborationUse().isSuperTypeOf(domainElement.eClass())) {
                    return 3071;
                }
                if (UMLPackage.eINSTANCE.getActivity().isSuperTypeOf(domainElement.eClass())) {
                    return 3072;
                }
                if (UMLPackage.eINSTANCE.getInteraction().isSuperTypeOf(domainElement.eClass())) {
                    return 3073;
                }
                if (UMLPackage.eINSTANCE.getProtocolStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3074;
                }
                if (UMLPackage.eINSTANCE.getStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3075;
                }
                if (UMLPackage.eINSTANCE.getFunctionBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3076;
                }
                if (UMLPackage.eINSTANCE.getOpaqueBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3077;
                }
                if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                    return 3081;
                }
                if (UMLPackage.eINSTANCE.getDevice().isSuperTypeOf(domainElement.eClass())) {
                    return 3082;
                }
                if (UMLPackage.eINSTANCE.getExecutionEnvironment().isSuperTypeOf(domainElement.eClass())) {
                    return 3083;
                }
                if (UMLPackage.eINSTANCE.getNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3084;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) {
                    return 3085;
                }
                if (UMLPackage.eINSTANCE.getCollaboration().isSuperTypeOf(domainElement.eClass())) {
                    return 3086;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3087;
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return 3078;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 3079;
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass())) {
                    return 3080;
                }
                if (UMLPackage.eINSTANCE.getActor().isSuperTypeOf(domainElement.eClass())) {
                    return 3091;
                }
                if (UMLPackage.eINSTANCE.getDeploymentSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 3092;
                }
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) {
                    return 3093;
                }
                if (UMLPackage.eINSTANCE.getInformationItem().isSuperTypeOf(domainElement.eClass())) {
                    return 3094;
                }
                if (UMLPackage.eINSTANCE.getSignal().isSuperTypeOf(domainElement.eClass())) {
                    return 3095;
                }
                if (UMLPackage.eINSTANCE.getUseCase().isSuperTypeOf(domainElement.eClass())) {
                    return 3096;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3097;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3116;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3117;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3118;
                }
                if (UMLPackage.eINSTANCE.getInteractionConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3119;
                }
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3120;
            }
            case 7059: {
                if (UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) {
                    return 3069;
                }
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isProperty_3070(containerView, (Property)domainElement)) {
                    return 3070;
                }
                if (UMLPackage.eINSTANCE.getCollaborationUse().isSuperTypeOf(domainElement.eClass())) {
                    return 3071;
                }
                if (UMLPackage.eINSTANCE.getActivity().isSuperTypeOf(domainElement.eClass())) {
                    return 3072;
                }
                if (UMLPackage.eINSTANCE.getInteraction().isSuperTypeOf(domainElement.eClass())) {
                    return 3073;
                }
                if (UMLPackage.eINSTANCE.getProtocolStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3074;
                }
                if (UMLPackage.eINSTANCE.getStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3075;
                }
                if (UMLPackage.eINSTANCE.getFunctionBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3076;
                }
                if (UMLPackage.eINSTANCE.getOpaqueBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3077;
                }
                if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                    return 3081;
                }
                if (UMLPackage.eINSTANCE.getDevice().isSuperTypeOf(domainElement.eClass())) {
                    return 3082;
                }
                if (UMLPackage.eINSTANCE.getExecutionEnvironment().isSuperTypeOf(domainElement.eClass())) {
                    return 3083;
                }
                if (UMLPackage.eINSTANCE.getNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3084;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) {
                    return 3085;
                }
                if (UMLPackage.eINSTANCE.getCollaboration().isSuperTypeOf(domainElement.eClass())) {
                    return 3086;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3087;
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return 3078;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 3079;
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass())) {
                    return 3080;
                }
                if (UMLPackage.eINSTANCE.getActor().isSuperTypeOf(domainElement.eClass())) {
                    return 3091;
                }
                if (UMLPackage.eINSTANCE.getDeploymentSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 3092;
                }
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) {
                    return 3093;
                }
                if (UMLPackage.eINSTANCE.getInformationItem().isSuperTypeOf(domainElement.eClass())) {
                    return 3094;
                }
                if (UMLPackage.eINSTANCE.getSignal().isSuperTypeOf(domainElement.eClass())) {
                    return 3095;
                }
                if (UMLPackage.eINSTANCE.getUseCase().isSuperTypeOf(domainElement.eClass())) {
                    return 3096;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3097;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3116;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3117;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3118;
                }
                if (UMLPackage.eINSTANCE.getInteractionConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3119;
                }
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3120;
            }
            case 7060: {
                if (UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) {
                    return 3069;
                }
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isProperty_3070(containerView, (Property)domainElement)) {
                    return 3070;
                }
                if (UMLPackage.eINSTANCE.getCollaborationUse().isSuperTypeOf(domainElement.eClass())) {
                    return 3071;
                }
                if (UMLPackage.eINSTANCE.getActivity().isSuperTypeOf(domainElement.eClass())) {
                    return 3072;
                }
                if (UMLPackage.eINSTANCE.getInteraction().isSuperTypeOf(domainElement.eClass())) {
                    return 3073;
                }
                if (UMLPackage.eINSTANCE.getProtocolStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3074;
                }
                if (UMLPackage.eINSTANCE.getStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3075;
                }
                if (UMLPackage.eINSTANCE.getFunctionBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3076;
                }
                if (UMLPackage.eINSTANCE.getOpaqueBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3077;
                }
                if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                    return 3081;
                }
                if (UMLPackage.eINSTANCE.getDevice().isSuperTypeOf(domainElement.eClass())) {
                    return 3082;
                }
                if (UMLPackage.eINSTANCE.getExecutionEnvironment().isSuperTypeOf(domainElement.eClass())) {
                    return 3083;
                }
                if (UMLPackage.eINSTANCE.getNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3084;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) {
                    return 3085;
                }
                if (UMLPackage.eINSTANCE.getCollaboration().isSuperTypeOf(domainElement.eClass())) {
                    return 3086;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3087;
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return 3078;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 3079;
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass())) {
                    return 3080;
                }
                if (UMLPackage.eINSTANCE.getActor().isSuperTypeOf(domainElement.eClass())) {
                    return 3091;
                }
                if (UMLPackage.eINSTANCE.getDeploymentSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 3092;
                }
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) {
                    return 3093;
                }
                if (UMLPackage.eINSTANCE.getInformationItem().isSuperTypeOf(domainElement.eClass())) {
                    return 3094;
                }
                if (UMLPackage.eINSTANCE.getSignal().isSuperTypeOf(domainElement.eClass())) {
                    return 3095;
                }
                if (UMLPackage.eINSTANCE.getUseCase().isSuperTypeOf(domainElement.eClass())) {
                    return 3096;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3097;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3116;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3117;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3118;
                }
                if (UMLPackage.eINSTANCE.getInteractionConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3119;
                }
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3120;
            }
            case 7061: {
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isProperty_3070(containerView, (Property)domainElement)) {
                    return 3070;
                }
                if (UMLPackage.eINSTANCE.getCollaborationUse().isSuperTypeOf(domainElement.eClass())) {
                    return 3071;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3097;
                }
                if (UMLPackage.eINSTANCE.getConnectableElement().isSuperTypeOf(domainElement.eClass())) {
                    return 3115;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3116;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3117;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3118;
                }
                if (UMLPackage.eINSTANCE.getInteractionConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3119;
                }
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3120;
            }
            case 7063: {
                if (UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) {
                    return 3069;
                }
                if (UMLPackage.eINSTANCE.getParameter().isSuperTypeOf(domainElement.eClass())) {
                    return 3088;
                }
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isProperty_3070(containerView, (Property)domainElement)) {
                    return 3070;
                }
                if (UMLPackage.eINSTANCE.getCollaborationUse().isSuperTypeOf(domainElement.eClass())) {
                    return 3071;
                }
                if (UMLPackage.eINSTANCE.getActivity().isSuperTypeOf(domainElement.eClass())) {
                    return 3072;
                }
                if (UMLPackage.eINSTANCE.getInteraction().isSuperTypeOf(domainElement.eClass())) {
                    return 3073;
                }
                if (UMLPackage.eINSTANCE.getProtocolStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3074;
                }
                if (UMLPackage.eINSTANCE.getStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3075;
                }
                if (UMLPackage.eINSTANCE.getFunctionBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3076;
                }
                if (UMLPackage.eINSTANCE.getOpaqueBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3077;
                }
                if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                    return 3081;
                }
                if (UMLPackage.eINSTANCE.getDevice().isSuperTypeOf(domainElement.eClass())) {
                    return 3082;
                }
                if (UMLPackage.eINSTANCE.getExecutionEnvironment().isSuperTypeOf(domainElement.eClass())) {
                    return 3083;
                }
                if (UMLPackage.eINSTANCE.getNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3084;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) {
                    return 3085;
                }
                if (UMLPackage.eINSTANCE.getCollaboration().isSuperTypeOf(domainElement.eClass())) {
                    return 3086;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3087;
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return 3078;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 3079;
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass())) {
                    return 3080;
                }
                if (UMLPackage.eINSTANCE.getActor().isSuperTypeOf(domainElement.eClass())) {
                    return 3091;
                }
                if (UMLPackage.eINSTANCE.getDeploymentSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 3092;
                }
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) {
                    return 3093;
                }
                if (UMLPackage.eINSTANCE.getInformationItem().isSuperTypeOf(domainElement.eClass())) {
                    return 3094;
                }
                if (UMLPackage.eINSTANCE.getSignal().isSuperTypeOf(domainElement.eClass())) {
                    return 3095;
                }
                if (UMLPackage.eINSTANCE.getUseCase().isSuperTypeOf(domainElement.eClass())) {
                    return 3096;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3097;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3116;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3117;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3118;
                }
                if (UMLPackage.eINSTANCE.getInteractionConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3119;
                }
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3120;
            }
            case 7064: {
                if (UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) {
                    return 3069;
                }
                if (UMLPackage.eINSTANCE.getParameter().isSuperTypeOf(domainElement.eClass())) {
                    return 3088;
                }
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isProperty_3070(containerView, (Property)domainElement)) {
                    return 3070;
                }
                if (UMLPackage.eINSTANCE.getCollaborationUse().isSuperTypeOf(domainElement.eClass())) {
                    return 3071;
                }
                if (UMLPackage.eINSTANCE.getActivity().isSuperTypeOf(domainElement.eClass())) {
                    return 3072;
                }
                if (UMLPackage.eINSTANCE.getInteraction().isSuperTypeOf(domainElement.eClass())) {
                    return 3073;
                }
                if (UMLPackage.eINSTANCE.getProtocolStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3074;
                }
                if (UMLPackage.eINSTANCE.getStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3075;
                }
                if (UMLPackage.eINSTANCE.getFunctionBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3076;
                }
                if (UMLPackage.eINSTANCE.getOpaqueBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3077;
                }
                if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                    return 3081;
                }
                if (UMLPackage.eINSTANCE.getDevice().isSuperTypeOf(domainElement.eClass())) {
                    return 3082;
                }
                if (UMLPackage.eINSTANCE.getExecutionEnvironment().isSuperTypeOf(domainElement.eClass())) {
                    return 3083;
                }
                if (UMLPackage.eINSTANCE.getNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3084;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) {
                    return 3085;
                }
                if (UMLPackage.eINSTANCE.getCollaboration().isSuperTypeOf(domainElement.eClass())) {
                    return 3086;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3087;
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return 3078;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 3079;
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass())) {
                    return 3080;
                }
                if (UMLPackage.eINSTANCE.getActor().isSuperTypeOf(domainElement.eClass())) {
                    return 3091;
                }
                if (UMLPackage.eINSTANCE.getDeploymentSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 3092;
                }
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) {
                    return 3093;
                }
                if (UMLPackage.eINSTANCE.getInformationItem().isSuperTypeOf(domainElement.eClass())) {
                    return 3094;
                }
                if (UMLPackage.eINSTANCE.getSignal().isSuperTypeOf(domainElement.eClass())) {
                    return 3095;
                }
                if (UMLPackage.eINSTANCE.getUseCase().isSuperTypeOf(domainElement.eClass())) {
                    return 3096;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3097;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3116;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3117;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3118;
                }
                if (UMLPackage.eINSTANCE.getInteractionConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3119;
                }
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3120;
            }
            case 7065: {
                if (UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) {
                    return 3069;
                }
                if (UMLPackage.eINSTANCE.getParameter().isSuperTypeOf(domainElement.eClass())) {
                    return 3088;
                }
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isProperty_3070(containerView, (Property)domainElement)) {
                    return 3070;
                }
                if (UMLPackage.eINSTANCE.getCollaborationUse().isSuperTypeOf(domainElement.eClass())) {
                    return 3071;
                }
                if (UMLPackage.eINSTANCE.getActivity().isSuperTypeOf(domainElement.eClass())) {
                    return 3072;
                }
                if (UMLPackage.eINSTANCE.getInteraction().isSuperTypeOf(domainElement.eClass())) {
                    return 3073;
                }
                if (UMLPackage.eINSTANCE.getProtocolStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3074;
                }
                if (UMLPackage.eINSTANCE.getStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3075;
                }
                if (UMLPackage.eINSTANCE.getFunctionBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3076;
                }
                if (UMLPackage.eINSTANCE.getOpaqueBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3077;
                }
                if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                    return 3081;
                }
                if (UMLPackage.eINSTANCE.getDevice().isSuperTypeOf(domainElement.eClass())) {
                    return 3082;
                }
                if (UMLPackage.eINSTANCE.getExecutionEnvironment().isSuperTypeOf(domainElement.eClass())) {
                    return 3083;
                }
                if (UMLPackage.eINSTANCE.getNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3084;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) {
                    return 3085;
                }
                if (UMLPackage.eINSTANCE.getCollaboration().isSuperTypeOf(domainElement.eClass())) {
                    return 3086;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3087;
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return 3078;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 3079;
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass())) {
                    return 3080;
                }
                if (UMLPackage.eINSTANCE.getActor().isSuperTypeOf(domainElement.eClass())) {
                    return 3091;
                }
                if (UMLPackage.eINSTANCE.getDeploymentSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 3092;
                }
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) {
                    return 3093;
                }
                if (UMLPackage.eINSTANCE.getInformationItem().isSuperTypeOf(domainElement.eClass())) {
                    return 3094;
                }
                if (UMLPackage.eINSTANCE.getSignal().isSuperTypeOf(domainElement.eClass())) {
                    return 3095;
                }
                if (UMLPackage.eINSTANCE.getUseCase().isSuperTypeOf(domainElement.eClass())) {
                    return 3096;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3097;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3116;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3117;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3118;
                }
                if (UMLPackage.eINSTANCE.getInteractionConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3119;
                }
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3120;
            }
            case 7066: {
                if (UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) {
                    return 3069;
                }
                if (UMLPackage.eINSTANCE.getParameter().isSuperTypeOf(domainElement.eClass())) {
                    return 3088;
                }
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isProperty_3070(containerView, (Property)domainElement)) {
                    return 3070;
                }
                if (UMLPackage.eINSTANCE.getCollaborationUse().isSuperTypeOf(domainElement.eClass())) {
                    return 3071;
                }
                if (UMLPackage.eINSTANCE.getActivity().isSuperTypeOf(domainElement.eClass())) {
                    return 3072;
                }
                if (UMLPackage.eINSTANCE.getInteraction().isSuperTypeOf(domainElement.eClass())) {
                    return 3073;
                }
                if (UMLPackage.eINSTANCE.getProtocolStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3074;
                }
                if (UMLPackage.eINSTANCE.getStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3075;
                }
                if (UMLPackage.eINSTANCE.getFunctionBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3076;
                }
                if (UMLPackage.eINSTANCE.getOpaqueBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3077;
                }
                if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                    return 3081;
                }
                if (UMLPackage.eINSTANCE.getDevice().isSuperTypeOf(domainElement.eClass())) {
                    return 3082;
                }
                if (UMLPackage.eINSTANCE.getExecutionEnvironment().isSuperTypeOf(domainElement.eClass())) {
                    return 3083;
                }
                if (UMLPackage.eINSTANCE.getNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3084;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) {
                    return 3085;
                }
                if (UMLPackage.eINSTANCE.getCollaboration().isSuperTypeOf(domainElement.eClass())) {
                    return 3086;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3087;
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return 3078;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 3079;
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass())) {
                    return 3080;
                }
                if (UMLPackage.eINSTANCE.getActor().isSuperTypeOf(domainElement.eClass())) {
                    return 3091;
                }
                if (UMLPackage.eINSTANCE.getDeploymentSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 3092;
                }
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) {
                    return 3093;
                }
                if (UMLPackage.eINSTANCE.getInformationItem().isSuperTypeOf(domainElement.eClass())) {
                    return 3094;
                }
                if (UMLPackage.eINSTANCE.getSignal().isSuperTypeOf(domainElement.eClass())) {
                    return 3095;
                }
                if (UMLPackage.eINSTANCE.getUseCase().isSuperTypeOf(domainElement.eClass())) {
                    return 3096;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3097;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3116;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3117;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3118;
                }
                if (UMLPackage.eINSTANCE.getInteractionConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3119;
                }
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3120;
            }
            case 7067: {
                if (UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) {
                    return 3069;
                }
                if (UMLPackage.eINSTANCE.getParameter().isSuperTypeOf(domainElement.eClass())) {
                    return 3088;
                }
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isProperty_3070(containerView, (Property)domainElement)) {
                    return 3070;
                }
                if (UMLPackage.eINSTANCE.getCollaborationUse().isSuperTypeOf(domainElement.eClass())) {
                    return 3071;
                }
                if (UMLPackage.eINSTANCE.getActivity().isSuperTypeOf(domainElement.eClass())) {
                    return 3072;
                }
                if (UMLPackage.eINSTANCE.getInteraction().isSuperTypeOf(domainElement.eClass())) {
                    return 3073;
                }
                if (UMLPackage.eINSTANCE.getProtocolStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3074;
                }
                if (UMLPackage.eINSTANCE.getStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3075;
                }
                if (UMLPackage.eINSTANCE.getFunctionBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3076;
                }
                if (UMLPackage.eINSTANCE.getOpaqueBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3077;
                }
                if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                    return 3081;
                }
                if (UMLPackage.eINSTANCE.getDevice().isSuperTypeOf(domainElement.eClass())) {
                    return 3082;
                }
                if (UMLPackage.eINSTANCE.getExecutionEnvironment().isSuperTypeOf(domainElement.eClass())) {
                    return 3083;
                }
                if (UMLPackage.eINSTANCE.getNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3084;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) {
                    return 3085;
                }
                if (UMLPackage.eINSTANCE.getCollaboration().isSuperTypeOf(domainElement.eClass())) {
                    return 3086;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3087;
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return 3078;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 3079;
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass())) {
                    return 3080;
                }
                if (UMLPackage.eINSTANCE.getActor().isSuperTypeOf(domainElement.eClass())) {
                    return 3091;
                }
                if (UMLPackage.eINSTANCE.getDeploymentSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 3092;
                }
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) {
                    return 3093;
                }
                if (UMLPackage.eINSTANCE.getInformationItem().isSuperTypeOf(domainElement.eClass())) {
                    return 3094;
                }
                if (UMLPackage.eINSTANCE.getSignal().isSuperTypeOf(domainElement.eClass())) {
                    return 3095;
                }
                if (UMLPackage.eINSTANCE.getUseCase().isSuperTypeOf(domainElement.eClass())) {
                    return 3096;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3097;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3116;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3117;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3118;
                }
                if (UMLPackage.eINSTANCE.getInteractionConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3119;
                }
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3120;
            }
            case 7068: {
                if (UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) {
                    return 3069;
                }
                if (UMLPackage.eINSTANCE.getParameter().isSuperTypeOf(domainElement.eClass())) {
                    return 3088;
                }
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isProperty_3070(containerView, (Property)domainElement)) {
                    return 3070;
                }
                if (UMLPackage.eINSTANCE.getCollaborationUse().isSuperTypeOf(domainElement.eClass())) {
                    return 3071;
                }
                if (UMLPackage.eINSTANCE.getActivity().isSuperTypeOf(domainElement.eClass())) {
                    return 3072;
                }
                if (UMLPackage.eINSTANCE.getInteraction().isSuperTypeOf(domainElement.eClass())) {
                    return 3073;
                }
                if (UMLPackage.eINSTANCE.getProtocolStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3074;
                }
                if (UMLPackage.eINSTANCE.getStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3075;
                }
                if (UMLPackage.eINSTANCE.getFunctionBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3076;
                }
                if (UMLPackage.eINSTANCE.getOpaqueBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3077;
                }
                if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                    return 3081;
                }
                if (UMLPackage.eINSTANCE.getDevice().isSuperTypeOf(domainElement.eClass())) {
                    return 3082;
                }
                if (UMLPackage.eINSTANCE.getExecutionEnvironment().isSuperTypeOf(domainElement.eClass())) {
                    return 3083;
                }
                if (UMLPackage.eINSTANCE.getNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3084;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) {
                    return 3085;
                }
                if (UMLPackage.eINSTANCE.getCollaboration().isSuperTypeOf(domainElement.eClass())) {
                    return 3086;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3087;
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return 3078;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 3079;
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass())) {
                    return 3080;
                }
                if (UMLPackage.eINSTANCE.getActor().isSuperTypeOf(domainElement.eClass())) {
                    return 3091;
                }
                if (UMLPackage.eINSTANCE.getDeploymentSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 3092;
                }
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) {
                    return 3093;
                }
                if (UMLPackage.eINSTANCE.getInformationItem().isSuperTypeOf(domainElement.eClass())) {
                    return 3094;
                }
                if (UMLPackage.eINSTANCE.getSignal().isSuperTypeOf(domainElement.eClass())) {
                    return 3095;
                }
                if (UMLPackage.eINSTANCE.getUseCase().isSuperTypeOf(domainElement.eClass())) {
                    return 3096;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3097;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3116;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3117;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3118;
                }
                if (UMLPackage.eINSTANCE.getInteractionConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3119;
                }
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3120;
            }
            case 7069: {
                if (UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) {
                    return 3069;
                }
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isProperty_3070(containerView, (Property)domainElement)) {
                    return 3070;
                }
                if (UMLPackage.eINSTANCE.getCollaborationUse().isSuperTypeOf(domainElement.eClass())) {
                    return 3071;
                }
                if (UMLPackage.eINSTANCE.getActivity().isSuperTypeOf(domainElement.eClass())) {
                    return 3072;
                }
                if (UMLPackage.eINSTANCE.getInteraction().isSuperTypeOf(domainElement.eClass())) {
                    return 3073;
                }
                if (UMLPackage.eINSTANCE.getProtocolStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3074;
                }
                if (UMLPackage.eINSTANCE.getStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3075;
                }
                if (UMLPackage.eINSTANCE.getFunctionBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3076;
                }
                if (UMLPackage.eINSTANCE.getOpaqueBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3077;
                }
                if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                    return 3081;
                }
                if (UMLPackage.eINSTANCE.getDevice().isSuperTypeOf(domainElement.eClass())) {
                    return 3082;
                }
                if (UMLPackage.eINSTANCE.getExecutionEnvironment().isSuperTypeOf(domainElement.eClass())) {
                    return 3083;
                }
                if (UMLPackage.eINSTANCE.getNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3084;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) {
                    return 3085;
                }
                if (UMLPackage.eINSTANCE.getCollaboration().isSuperTypeOf(domainElement.eClass())) {
                    return 3086;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3087;
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return 3078;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 3079;
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass())) {
                    return 3080;
                }
                if (UMLPackage.eINSTANCE.getActor().isSuperTypeOf(domainElement.eClass())) {
                    return 3091;
                }
                if (UMLPackage.eINSTANCE.getDeploymentSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 3092;
                }
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) {
                    return 3093;
                }
                if (UMLPackage.eINSTANCE.getInformationItem().isSuperTypeOf(domainElement.eClass())) {
                    return 3094;
                }
                if (UMLPackage.eINSTANCE.getSignal().isSuperTypeOf(domainElement.eClass())) {
                    return 3095;
                }
                if (UMLPackage.eINSTANCE.getUseCase().isSuperTypeOf(domainElement.eClass())) {
                    return 3096;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3097;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3116;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3117;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3118;
                }
                if (UMLPackage.eINSTANCE.getInteractionConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3119;
                }
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3120;
            }
            case 7070: {
                if (UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) {
                    return 3069;
                }
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isProperty_3070(containerView, (Property)domainElement)) {
                    return 3070;
                }
                if (UMLPackage.eINSTANCE.getCollaborationUse().isSuperTypeOf(domainElement.eClass())) {
                    return 3071;
                }
                if (UMLPackage.eINSTANCE.getActivity().isSuperTypeOf(domainElement.eClass())) {
                    return 3072;
                }
                if (UMLPackage.eINSTANCE.getInteraction().isSuperTypeOf(domainElement.eClass())) {
                    return 3073;
                }
                if (UMLPackage.eINSTANCE.getProtocolStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3074;
                }
                if (UMLPackage.eINSTANCE.getStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3075;
                }
                if (UMLPackage.eINSTANCE.getFunctionBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3076;
                }
                if (UMLPackage.eINSTANCE.getOpaqueBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3077;
                }
                if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                    return 3081;
                }
                if (UMLPackage.eINSTANCE.getDevice().isSuperTypeOf(domainElement.eClass())) {
                    return 3082;
                }
                if (UMLPackage.eINSTANCE.getExecutionEnvironment().isSuperTypeOf(domainElement.eClass())) {
                    return 3083;
                }
                if (UMLPackage.eINSTANCE.getNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3084;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) {
                    return 3085;
                }
                if (UMLPackage.eINSTANCE.getCollaboration().isSuperTypeOf(domainElement.eClass())) {
                    return 3086;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3087;
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return 3078;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 3079;
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass())) {
                    return 3080;
                }
                if (UMLPackage.eINSTANCE.getActor().isSuperTypeOf(domainElement.eClass())) {
                    return 3091;
                }
                if (UMLPackage.eINSTANCE.getDeploymentSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 3092;
                }
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) {
                    return 3093;
                }
                if (UMLPackage.eINSTANCE.getInformationItem().isSuperTypeOf(domainElement.eClass())) {
                    return 3094;
                }
                if (UMLPackage.eINSTANCE.getSignal().isSuperTypeOf(domainElement.eClass())) {
                    return 3095;
                }
                if (UMLPackage.eINSTANCE.getUseCase().isSuperTypeOf(domainElement.eClass())) {
                    return 3096;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3097;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3116;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3117;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3118;
                }
                if (UMLPackage.eINSTANCE.getInteractionConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3119;
                }
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3120;
            }
            case 7071: {
                if (UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) {
                    return 3069;
                }
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isProperty_3070(containerView, (Property)domainElement)) {
                    return 3070;
                }
                if (UMLPackage.eINSTANCE.getCollaborationUse().isSuperTypeOf(domainElement.eClass())) {
                    return 3071;
                }
                if (UMLPackage.eINSTANCE.getActivity().isSuperTypeOf(domainElement.eClass())) {
                    return 3072;
                }
                if (UMLPackage.eINSTANCE.getInteraction().isSuperTypeOf(domainElement.eClass())) {
                    return 3073;
                }
                if (UMLPackage.eINSTANCE.getProtocolStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3074;
                }
                if (UMLPackage.eINSTANCE.getStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3075;
                }
                if (UMLPackage.eINSTANCE.getFunctionBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3076;
                }
                if (UMLPackage.eINSTANCE.getOpaqueBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3077;
                }
                if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                    return 3081;
                }
                if (UMLPackage.eINSTANCE.getDevice().isSuperTypeOf(domainElement.eClass())) {
                    return 3082;
                }
                if (UMLPackage.eINSTANCE.getExecutionEnvironment().isSuperTypeOf(domainElement.eClass())) {
                    return 3083;
                }
                if (UMLPackage.eINSTANCE.getNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3084;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) {
                    return 3085;
                }
                if (UMLPackage.eINSTANCE.getCollaboration().isSuperTypeOf(domainElement.eClass())) {
                    return 3086;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3087;
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return 3078;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 3079;
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass())) {
                    return 3080;
                }
                if (UMLPackage.eINSTANCE.getActor().isSuperTypeOf(domainElement.eClass())) {
                    return 3091;
                }
                if (UMLPackage.eINSTANCE.getDeploymentSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 3092;
                }
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) {
                    return 3093;
                }
                if (UMLPackage.eINSTANCE.getInformationItem().isSuperTypeOf(domainElement.eClass())) {
                    return 3094;
                }
                if (UMLPackage.eINSTANCE.getSignal().isSuperTypeOf(domainElement.eClass())) {
                    return 3095;
                }
                if (UMLPackage.eINSTANCE.getUseCase().isSuperTypeOf(domainElement.eClass())) {
                    return 3096;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3097;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3116;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3117;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3118;
                }
                if (UMLPackage.eINSTANCE.getInteractionConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3119;
                }
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3120;
            }
            case 7072: {
                if (UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) {
                    return 3069;
                }
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isProperty_3070(containerView, (Property)domainElement)) {
                    return 3070;
                }
                if (UMLPackage.eINSTANCE.getCollaborationUse().isSuperTypeOf(domainElement.eClass())) {
                    return 3071;
                }
                if (UMLPackage.eINSTANCE.getActivity().isSuperTypeOf(domainElement.eClass())) {
                    return 3072;
                }
                if (UMLPackage.eINSTANCE.getInteraction().isSuperTypeOf(domainElement.eClass())) {
                    return 3073;
                }
                if (UMLPackage.eINSTANCE.getProtocolStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3074;
                }
                if (UMLPackage.eINSTANCE.getStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3075;
                }
                if (UMLPackage.eINSTANCE.getFunctionBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3076;
                }
                if (UMLPackage.eINSTANCE.getOpaqueBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3077;
                }
                if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                    return 3081;
                }
                if (UMLPackage.eINSTANCE.getDevice().isSuperTypeOf(domainElement.eClass())) {
                    return 3082;
                }
                if (UMLPackage.eINSTANCE.getExecutionEnvironment().isSuperTypeOf(domainElement.eClass())) {
                    return 3083;
                }
                if (UMLPackage.eINSTANCE.getNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3084;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) {
                    return 3085;
                }
                if (UMLPackage.eINSTANCE.getCollaboration().isSuperTypeOf(domainElement.eClass())) {
                    return 3086;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3087;
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return 3078;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 3079;
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass())) {
                    return 3080;
                }
                if (UMLPackage.eINSTANCE.getActor().isSuperTypeOf(domainElement.eClass())) {
                    return 3091;
                }
                if (UMLPackage.eINSTANCE.getDeploymentSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 3092;
                }
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) {
                    return 3093;
                }
                if (UMLPackage.eINSTANCE.getInformationItem().isSuperTypeOf(domainElement.eClass())) {
                    return 3094;
                }
                if (UMLPackage.eINSTANCE.getSignal().isSuperTypeOf(domainElement.eClass())) {
                    return 3095;
                }
                if (UMLPackage.eINSTANCE.getUseCase().isSuperTypeOf(domainElement.eClass())) {
                    return 3096;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3097;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3116;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3117;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3118;
                }
                if (UMLPackage.eINSTANCE.getInteractionConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3119;
                }
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3120;
            }
            case 7073: {
                if (UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) {
                    return 3069;
                }
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isProperty_3070(containerView, (Property)domainElement)) {
                    return 3070;
                }
                if (UMLPackage.eINSTANCE.getCollaborationUse().isSuperTypeOf(domainElement.eClass())) {
                    return 3071;
                }
                if (UMLPackage.eINSTANCE.getActivity().isSuperTypeOf(domainElement.eClass())) {
                    return 3072;
                }
                if (UMLPackage.eINSTANCE.getInteraction().isSuperTypeOf(domainElement.eClass())) {
                    return 3073;
                }
                if (UMLPackage.eINSTANCE.getProtocolStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3074;
                }
                if (UMLPackage.eINSTANCE.getStateMachine().isSuperTypeOf(domainElement.eClass())) {
                    return 3075;
                }
                if (UMLPackage.eINSTANCE.getFunctionBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3076;
                }
                if (UMLPackage.eINSTANCE.getOpaqueBehavior().isSuperTypeOf(domainElement.eClass())) {
                    return 3077;
                }
                if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                    return 3081;
                }
                if (UMLPackage.eINSTANCE.getDevice().isSuperTypeOf(domainElement.eClass())) {
                    return 3082;
                }
                if (UMLPackage.eINSTANCE.getExecutionEnvironment().isSuperTypeOf(domainElement.eClass())) {
                    return 3083;
                }
                if (UMLPackage.eINSTANCE.getNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3084;
                }
                if (UMLPackage.eINSTANCE.getClass_().isSuperTypeOf(domainElement.eClass())) {
                    return 3085;
                }
                if (UMLPackage.eINSTANCE.getCollaboration().isSuperTypeOf(domainElement.eClass())) {
                    return 3086;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3087;
                }
                if (UMLPackage.eINSTANCE.getPrimitiveType().isSuperTypeOf(domainElement.eClass())) {
                    return 3078;
                }
                if (UMLPackage.eINSTANCE.getEnumeration().isSuperTypeOf(domainElement.eClass())) {
                    return 3079;
                }
                if (UMLPackage.eINSTANCE.getDataType().isSuperTypeOf(domainElement.eClass())) {
                    return 3080;
                }
                if (UMLPackage.eINSTANCE.getActor().isSuperTypeOf(domainElement.eClass())) {
                    return 3091;
                }
                if (UMLPackage.eINSTANCE.getDeploymentSpecification().isSuperTypeOf(domainElement.eClass())) {
                    return 3092;
                }
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) {
                    return 3093;
                }
                if (UMLPackage.eINSTANCE.getInformationItem().isSuperTypeOf(domainElement.eClass())) {
                    return 3094;
                }
                if (UMLPackage.eINSTANCE.getSignal().isSuperTypeOf(domainElement.eClass())) {
                    return 3095;
                }
                if (UMLPackage.eINSTANCE.getUseCase().isSuperTypeOf(domainElement.eClass())) {
                    return 3096;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3097;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3120;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3116;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3117;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3118;
                }
                if (!UMLPackage.eINSTANCE.getInteractionConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3119;
            }
            case 7075: {
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isProperty_3070(containerView, (Property)domainElement)) {
                    return 3070;
                }
                if (UMLPackage.eINSTANCE.getCollaborationUse().isSuperTypeOf(domainElement.eClass())) {
                    return 3071;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3097;
                }
                if (UMLPackage.eINSTANCE.getConnectableElement().isSuperTypeOf(domainElement.eClass())) {
                    return 3115;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3116;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3117;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3118;
                }
                if (UMLPackage.eINSTANCE.getInteractionConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3119;
                }
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3120;
            }
            case 7077: {
                if (UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) {
                    return 3069;
                }
                if (UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isProperty_3070(containerView, (Property)domainElement)) {
                    return 3070;
                }
                if (!UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) break;
                return 3097;
            }
        }
        return -1;
    }

    public static boolean canCreateNode(View containerView, int nodeVisualID) {
        int containerVisualID;
        String containerModelID = UMLVisualIDRegistry.getModelID(containerView);
        if (!"CompositeStructure".equals(containerModelID)) {
            return false;
        }
        if ("CompositeStructure".equals(containerModelID)) {
            containerVisualID = UMLVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return false;
        }
        switch (containerVisualID) {
            case 1000: {
                if (2060 == nodeVisualID) {
                    return true;
                }
                if (2061 == nodeVisualID) {
                    return true;
                }
                if (2062 == nodeVisualID) {
                    return true;
                }
                if (2063 == nodeVisualID) {
                    return true;
                }
                if (2064 == nodeVisualID) {
                    return true;
                }
                if (2065 == nodeVisualID) {
                    return true;
                }
                if (2069 == nodeVisualID) {
                    return true;
                }
                if (2070 == nodeVisualID) {
                    return true;
                }
                if (2071 == nodeVisualID) {
                    return true;
                }
                if (2072 == nodeVisualID) {
                    return true;
                }
                if (2073 == nodeVisualID) {
                    return true;
                }
                if (2075 == nodeVisualID) {
                    return true;
                }
                if (2076 == nodeVisualID) {
                    return true;
                }
                if (2066 == nodeVisualID) {
                    return true;
                }
                if (2067 == nodeVisualID) {
                    return true;
                }
                if (2068 == nodeVisualID) {
                    return true;
                }
                if (2077 == nodeVisualID) {
                    return true;
                }
                if (2078 == nodeVisualID) {
                    return true;
                }
                if (2079 == nodeVisualID) {
                    return true;
                }
                if (2080 == nodeVisualID) {
                    return true;
                }
                if (2081 == nodeVisualID) {
                    return true;
                }
                if (2082 == nodeVisualID) {
                    return true;
                }
                if (2083 == nodeVisualID) {
                    return true;
                }
                if (2084 == nodeVisualID) {
                    return true;
                }
                if (2085 == nodeVisualID) {
                    return true;
                }
                if (2088 == nodeVisualID) {
                    return true;
                }
                if (2089 == nodeVisualID) {
                    return true;
                }
                if (2093 == nodeVisualID) {
                    return true;
                }
                if (2094 == nodeVisualID) {
                    return true;
                }
                if (2095 == nodeVisualID) {
                    return true;
                }
                if (2096 == nodeVisualID) {
                    return true;
                }
                if (2097 == nodeVisualID) {
                    return true;
                }
                if (2098 == nodeVisualID) {
                    return true;
                }
                if (2099 == nodeVisualID) {
                    return true;
                }
                if (2100 == nodeVisualID) {
                    return true;
                }
                if (2101 == nodeVisualID) {
                    return true;
                }
                if (2102 == nodeVisualID) {
                    return true;
                }
                if (2103 == nodeVisualID) {
                    return true;
                }
                if (2104 == nodeVisualID) {
                    return true;
                }
                if (2105 == nodeVisualID) {
                    return true;
                }
                if (2106 == nodeVisualID) {
                    return true;
                }
                if (2107 == nodeVisualID) {
                    return true;
                }
                if (2108 == nodeVisualID) {
                    return true;
                }
                if (2109 == nodeVisualID) {
                    return true;
                }
                if (2110 == nodeVisualID) {
                    return true;
                }
                if (2111 == nodeVisualID) {
                    return true;
                }
                if (2112 == nodeVisualID) {
                    return true;
                }
                if (2113 == nodeVisualID) {
                    return true;
                }
                if (2114 != nodeVisualID) break;
                return true;
            }
            case 2060: {
                if (5112 == nodeVisualID) {
                    return true;
                }
                if (7063 == nodeVisualID) {
                    return true;
                }
                if (3069 == nodeVisualID) {
                    return true;
                }
                if (3088 != nodeVisualID) break;
                return true;
            }
            case 2061: {
                if (5113 == nodeVisualID) {
                    return true;
                }
                if (7064 == nodeVisualID) {
                    return true;
                }
                if (3069 == nodeVisualID) {
                    return true;
                }
                if (3088 != nodeVisualID) break;
                return true;
            }
            case 2062: {
                if (5114 == nodeVisualID) {
                    return true;
                }
                if (7065 == nodeVisualID) {
                    return true;
                }
                if (3069 == nodeVisualID) {
                    return true;
                }
                if (3088 != nodeVisualID) break;
                return true;
            }
            case 2063: {
                if (5115 == nodeVisualID) {
                    return true;
                }
                if (7066 == nodeVisualID) {
                    return true;
                }
                if (3069 == nodeVisualID) {
                    return true;
                }
                if (3088 != nodeVisualID) break;
                return true;
            }
            case 2064: {
                if (5116 == nodeVisualID) {
                    return true;
                }
                if (7067 == nodeVisualID) {
                    return true;
                }
                if (3069 == nodeVisualID) {
                    return true;
                }
                if (3088 != nodeVisualID) break;
                return true;
            }
            case 2065: {
                if (5117 == nodeVisualID) {
                    return true;
                }
                if (7068 == nodeVisualID) {
                    return true;
                }
                if (3069 == nodeVisualID) {
                    return true;
                }
                if (3088 != nodeVisualID) break;
                return true;
            }
            case 2069: {
                if (5121 == nodeVisualID) {
                    return true;
                }
                if (7069 == nodeVisualID) {
                    return true;
                }
                if (3069 != nodeVisualID) break;
                return true;
            }
            case 2070: {
                if (5122 == nodeVisualID) {
                    return true;
                }
                if (7070 == nodeVisualID) {
                    return true;
                }
                if (3069 != nodeVisualID) break;
                return true;
            }
            case 2071: {
                if (5123 == nodeVisualID) {
                    return true;
                }
                if (7071 == nodeVisualID) {
                    return true;
                }
                if (3069 != nodeVisualID) break;
                return true;
            }
            case 2072: {
                if (5124 == nodeVisualID) {
                    return true;
                }
                if (7072 == nodeVisualID) {
                    return true;
                }
                if (3069 != nodeVisualID) break;
                return true;
            }
            case 2073: {
                if (5156 == nodeVisualID) {
                    return true;
                }
                if (7073 == nodeVisualID) {
                    return true;
                }
                if (3069 != nodeVisualID) break;
                return true;
            }
            case 2075: {
                if (5158 == nodeVisualID) {
                    return true;
                }
                if (7075 != nodeVisualID) break;
                return true;
            }
            case 2076: {
                if (5159 != nodeVisualID) break;
                return true;
            }
            case 2066: {
                if (5118 != nodeVisualID) break;
                return true;
            }
            case 2067: {
                if (5119 == nodeVisualID) {
                    return true;
                }
                if (7048 == nodeVisualID) {
                    return true;
                }
                if (3066 != nodeVisualID) break;
                return true;
            }
            case 2068: {
                if (5120 == nodeVisualID) {
                    return true;
                }
                if (7033 == nodeVisualID) {
                    return true;
                }
                if (7034 != nodeVisualID) break;
                return true;
            }
            case 2077: {
                if (5160 != nodeVisualID) break;
                return true;
            }
            case 2078: {
                if (5161 != nodeVisualID) break;
                return true;
            }
            case 2079: {
                if (5162 != nodeVisualID) break;
                return true;
            }
            case 2080: {
                if (5163 != nodeVisualID) break;
                return true;
            }
            case 2081: {
                if (5164 != nodeVisualID) break;
                return true;
            }
            case 2082: {
                if (5165 != nodeVisualID) break;
                return true;
            }
            case 2083: {
                if (5166 != nodeVisualID) break;
                return true;
            }
            case 2084: {
                if (5167 != nodeVisualID) break;
                return true;
            }
            case 2085: {
                if (5168 != nodeVisualID) break;
                return true;
            }
            case 2088: {
                if (5171 != nodeVisualID) break;
                return true;
            }
            case 2089: {
                if (5172 != nodeVisualID) break;
                return true;
            }
            case 2093: {
                if (5151 == nodeVisualID) {
                    return true;
                }
                if (5152 != nodeVisualID) break;
                return true;
            }
            case 2094: {
                if (5142 == nodeVisualID) {
                    return true;
                }
                if (5143 != nodeVisualID) break;
                return true;
            }
            case 2095: {
                if (5178 != nodeVisualID) break;
                return true;
            }
            case 2096: {
                if (5179 != nodeVisualID) break;
                return true;
            }
            case 2097: {
                if (5180 != nodeVisualID) break;
                return true;
            }
            case 2098: {
                if (5181 != nodeVisualID) break;
                return true;
            }
            case 2099: {
                if (5182 != nodeVisualID) break;
                return true;
            }
            case 2100: {
                if (5183 != nodeVisualID) break;
                return true;
            }
            case 2101: {
                if (5184 != nodeVisualID) break;
                return true;
            }
            case 2102: {
                if (5185 != nodeVisualID) break;
                return true;
            }
            case 2103: {
                if (5186 != nodeVisualID) break;
                return true;
            }
            case 2104: {
                if (5187 != nodeVisualID) break;
                return true;
            }
            case 2105: {
                if (5188 != nodeVisualID) break;
                return true;
            }
            case 2106: {
                if (5189 != nodeVisualID) break;
                return true;
            }
            case 2107: {
                if (5190 != nodeVisualID) break;
                return true;
            }
            case 2108: {
                if (5191 != nodeVisualID) break;
                return true;
            }
            case 2109: {
                if (5192 != nodeVisualID) break;
                return true;
            }
            case 2110: {
                if (5193 == nodeVisualID) {
                    return true;
                }
                if (6035 != nodeVisualID) break;
                return true;
            }
            case 2111: {
                if (5194 == nodeVisualID) {
                    return true;
                }
                if (6036 != nodeVisualID) break;
                return true;
            }
            case 2112: {
                if (5195 == nodeVisualID) {
                    return true;
                }
                if (6037 != nodeVisualID) break;
                return true;
            }
            case 2113: {
                if (5196 == nodeVisualID) {
                    return true;
                }
                if (6038 != nodeVisualID) break;
                return true;
            }
            case 2114: {
                if (5197 == nodeVisualID) {
                    return true;
                }
                if (6039 != nodeVisualID) break;
                return true;
            }
            case 3069: {
                if (5125 == nodeVisualID) {
                    return true;
                }
                if (6029 != nodeVisualID) break;
                return true;
            }
            case 3088: {
                if (6033 == nodeVisualID) {
                    return true;
                }
                if (6034 != nodeVisualID) break;
                return true;
            }
            case 3070: {
                if (5126 == nodeVisualID) {
                    return true;
                }
                if (7077 == nodeVisualID) {
                    return true;
                }
                if (3069 != nodeVisualID) break;
                return true;
            }
            case 3115: {
                if (5198 != nodeVisualID) break;
                return true;
            }
            case 3071: {
                if (5127 != nodeVisualID) break;
                return true;
            }
            case 3072: {
                if (5128 == nodeVisualID) {
                    return true;
                }
                if (7050 == nodeVisualID) {
                    return true;
                }
                if (3069 == nodeVisualID) {
                    return true;
                }
                if (3088 != nodeVisualID) break;
                return true;
            }
            case 3073: {
                if (5129 == nodeVisualID) {
                    return true;
                }
                if (7051 == nodeVisualID) {
                    return true;
                }
                if (3069 == nodeVisualID) {
                    return true;
                }
                if (3088 != nodeVisualID) break;
                return true;
            }
            case 3074: {
                if (5130 == nodeVisualID) {
                    return true;
                }
                if (7052 == nodeVisualID) {
                    return true;
                }
                if (3069 == nodeVisualID) {
                    return true;
                }
                if (3088 != nodeVisualID) break;
                return true;
            }
            case 3075: {
                if (5131 == nodeVisualID) {
                    return true;
                }
                if (7053 == nodeVisualID) {
                    return true;
                }
                if (3069 == nodeVisualID) {
                    return true;
                }
                if (3088 != nodeVisualID) break;
                return true;
            }
            case 3076: {
                if (5132 == nodeVisualID) {
                    return true;
                }
                if (7054 == nodeVisualID) {
                    return true;
                }
                if (3069 == nodeVisualID) {
                    return true;
                }
                if (3088 != nodeVisualID) break;
                return true;
            }
            case 3077: {
                if (5133 == nodeVisualID) {
                    return true;
                }
                if (7055 == nodeVisualID) {
                    return true;
                }
                if (3069 == nodeVisualID) {
                    return true;
                }
                if (3088 != nodeVisualID) break;
                return true;
            }
            case 3081: {
                if (5137 == nodeVisualID) {
                    return true;
                }
                if (7056 == nodeVisualID) {
                    return true;
                }
                if (3069 != nodeVisualID) break;
                return true;
            }
            case 3082: {
                if (5138 == nodeVisualID) {
                    return true;
                }
                if (7057 == nodeVisualID) {
                    return true;
                }
                if (3069 != nodeVisualID) break;
                return true;
            }
            case 3083: {
                if (5139 == nodeVisualID) {
                    return true;
                }
                if (7058 == nodeVisualID) {
                    return true;
                }
                if (3069 != nodeVisualID) break;
                return true;
            }
            case 3084: {
                if (5140 == nodeVisualID) {
                    return true;
                }
                if (7059 == nodeVisualID) {
                    return true;
                }
                if (3069 != nodeVisualID) break;
                return true;
            }
            case 3085: {
                if (5155 == nodeVisualID) {
                    return true;
                }
                if (7060 == nodeVisualID) {
                    return true;
                }
                if (3069 != nodeVisualID) break;
                return true;
            }
            case 3086: {
                if (5141 == nodeVisualID) {
                    return true;
                }
                if (7061 != nodeVisualID) break;
                return true;
            }
            case 3087: {
                if (5154 != nodeVisualID) break;
                return true;
            }
            case 3078: {
                if (5134 != nodeVisualID) break;
                return true;
            }
            case 3079: {
                if (5135 == nodeVisualID) {
                    return true;
                }
                if (7049 == nodeVisualID) {
                    return true;
                }
                if (3066 != nodeVisualID) break;
                return true;
            }
            case 3080: {
                if (5136 == nodeVisualID) {
                    return true;
                }
                if (7036 == nodeVisualID) {
                    return true;
                }
                if (7037 != nodeVisualID) break;
                return true;
            }
            case 3091: {
                if (5144 != nodeVisualID) break;
                return true;
            }
            case 3092: {
                if (5145 != nodeVisualID) break;
                return true;
            }
            case 3093: {
                if (5146 != nodeVisualID) break;
                return true;
            }
            case 3094: {
                if (5147 != nodeVisualID) break;
                return true;
            }
            case 3095: {
                if (5148 != nodeVisualID) break;
                return true;
            }
            case 3096: {
                if (5149 != nodeVisualID) break;
                return true;
            }
            case 3097: {
                if (5150 != nodeVisualID) break;
                return true;
            }
            case 3116: {
                if (6040 == nodeVisualID) {
                    return true;
                }
                if (6041 != nodeVisualID) break;
                return true;
            }
            case 3117: {
                if (6042 == nodeVisualID) {
                    return true;
                }
                if (6043 != nodeVisualID) break;
                return true;
            }
            case 3118: {
                if (6044 == nodeVisualID) {
                    return true;
                }
                if (6045 != nodeVisualID) break;
                return true;
            }
            case 3119: {
                if (6046 == nodeVisualID) {
                    return true;
                }
                if (6047 != nodeVisualID) break;
                return true;
            }
            case 3120: {
                if (6048 == nodeVisualID) {
                    return true;
                }
                if (6049 != nodeVisualID) break;
                return true;
            }
            case 7033: {
                if (3101 != nodeVisualID) break;
                return true;
            }
            case 7034: {
                if (3102 != nodeVisualID) break;
                return true;
            }
            case 7036: {
                if (3101 != nodeVisualID) break;
                return true;
            }
            case 7037: {
                if (3102 != nodeVisualID) break;
                return true;
            }
            case 7048: {
                if (3066 != nodeVisualID) break;
                return true;
            }
            case 7049: {
                if (3066 != nodeVisualID) break;
                return true;
            }
            case 7050: {
                if (3069 == nodeVisualID) {
                    return true;
                }
                if (3088 == nodeVisualID) {
                    return true;
                }
                if (3070 == nodeVisualID) {
                    return true;
                }
                if (3071 == nodeVisualID) {
                    return true;
                }
                if (3072 == nodeVisualID) {
                    return true;
                }
                if (3073 == nodeVisualID) {
                    return true;
                }
                if (3074 == nodeVisualID) {
                    return true;
                }
                if (3075 == nodeVisualID) {
                    return true;
                }
                if (3076 == nodeVisualID) {
                    return true;
                }
                if (3077 == nodeVisualID) {
                    return true;
                }
                if (3081 == nodeVisualID) {
                    return true;
                }
                if (3082 == nodeVisualID) {
                    return true;
                }
                if (3083 == nodeVisualID) {
                    return true;
                }
                if (3084 == nodeVisualID) {
                    return true;
                }
                if (3085 == nodeVisualID) {
                    return true;
                }
                if (3086 == nodeVisualID) {
                    return true;
                }
                if (3087 == nodeVisualID) {
                    return true;
                }
                if (3078 == nodeVisualID) {
                    return true;
                }
                if (3079 == nodeVisualID) {
                    return true;
                }
                if (3080 == nodeVisualID) {
                    return true;
                }
                if (3091 == nodeVisualID) {
                    return true;
                }
                if (3092 == nodeVisualID) {
                    return true;
                }
                if (3093 == nodeVisualID) {
                    return true;
                }
                if (3094 == nodeVisualID) {
                    return true;
                }
                if (3095 == nodeVisualID) {
                    return true;
                }
                if (3096 == nodeVisualID) {
                    return true;
                }
                if (3097 == nodeVisualID) {
                    return true;
                }
                if (3116 == nodeVisualID) {
                    return true;
                }
                if (3117 == nodeVisualID) {
                    return true;
                }
                if (3118 == nodeVisualID) {
                    return true;
                }
                if (3119 == nodeVisualID) {
                    return true;
                }
                if (3120 != nodeVisualID) break;
                return true;
            }
            case 7051: {
                if (3069 == nodeVisualID) {
                    return true;
                }
                if (3088 == nodeVisualID) {
                    return true;
                }
                if (3070 == nodeVisualID) {
                    return true;
                }
                if (3071 == nodeVisualID) {
                    return true;
                }
                if (3072 == nodeVisualID) {
                    return true;
                }
                if (3073 == nodeVisualID) {
                    return true;
                }
                if (3074 == nodeVisualID) {
                    return true;
                }
                if (3075 == nodeVisualID) {
                    return true;
                }
                if (3076 == nodeVisualID) {
                    return true;
                }
                if (3077 == nodeVisualID) {
                    return true;
                }
                if (3081 == nodeVisualID) {
                    return true;
                }
                if (3082 == nodeVisualID) {
                    return true;
                }
                if (3083 == nodeVisualID) {
                    return true;
                }
                if (3084 == nodeVisualID) {
                    return true;
                }
                if (3085 == nodeVisualID) {
                    return true;
                }
                if (3086 == nodeVisualID) {
                    return true;
                }
                if (3087 == nodeVisualID) {
                    return true;
                }
                if (3078 == nodeVisualID) {
                    return true;
                }
                if (3079 == nodeVisualID) {
                    return true;
                }
                if (3080 == nodeVisualID) {
                    return true;
                }
                if (3091 == nodeVisualID) {
                    return true;
                }
                if (3092 == nodeVisualID) {
                    return true;
                }
                if (3093 == nodeVisualID) {
                    return true;
                }
                if (3094 == nodeVisualID) {
                    return true;
                }
                if (3095 == nodeVisualID) {
                    return true;
                }
                if (3096 == nodeVisualID) {
                    return true;
                }
                if (3097 == nodeVisualID) {
                    return true;
                }
                if (3116 == nodeVisualID) {
                    return true;
                }
                if (3117 == nodeVisualID) {
                    return true;
                }
                if (3118 == nodeVisualID) {
                    return true;
                }
                if (3119 == nodeVisualID) {
                    return true;
                }
                if (3120 != nodeVisualID) break;
                return true;
            }
            case 7052: {
                if (3069 == nodeVisualID) {
                    return true;
                }
                if (3088 == nodeVisualID) {
                    return true;
                }
                if (3070 == nodeVisualID) {
                    return true;
                }
                if (3071 == nodeVisualID) {
                    return true;
                }
                if (3072 == nodeVisualID) {
                    return true;
                }
                if (3073 == nodeVisualID) {
                    return true;
                }
                if (3074 == nodeVisualID) {
                    return true;
                }
                if (3075 == nodeVisualID) {
                    return true;
                }
                if (3076 == nodeVisualID) {
                    return true;
                }
                if (3077 == nodeVisualID) {
                    return true;
                }
                if (3081 == nodeVisualID) {
                    return true;
                }
                if (3082 == nodeVisualID) {
                    return true;
                }
                if (3083 == nodeVisualID) {
                    return true;
                }
                if (3084 == nodeVisualID) {
                    return true;
                }
                if (3085 == nodeVisualID) {
                    return true;
                }
                if (3086 == nodeVisualID) {
                    return true;
                }
                if (3087 == nodeVisualID) {
                    return true;
                }
                if (3078 == nodeVisualID) {
                    return true;
                }
                if (3079 == nodeVisualID) {
                    return true;
                }
                if (3080 == nodeVisualID) {
                    return true;
                }
                if (3091 == nodeVisualID) {
                    return true;
                }
                if (3092 == nodeVisualID) {
                    return true;
                }
                if (3093 == nodeVisualID) {
                    return true;
                }
                if (3094 == nodeVisualID) {
                    return true;
                }
                if (3095 == nodeVisualID) {
                    return true;
                }
                if (3096 == nodeVisualID) {
                    return true;
                }
                if (3097 == nodeVisualID) {
                    return true;
                }
                if (3116 == nodeVisualID) {
                    return true;
                }
                if (3117 == nodeVisualID) {
                    return true;
                }
                if (3118 == nodeVisualID) {
                    return true;
                }
                if (3119 == nodeVisualID) {
                    return true;
                }
                if (3120 != nodeVisualID) break;
                return true;
            }
            case 7053: {
                if (3069 == nodeVisualID) {
                    return true;
                }
                if (3088 == nodeVisualID) {
                    return true;
                }
                if (3070 == nodeVisualID) {
                    return true;
                }
                if (3071 == nodeVisualID) {
                    return true;
                }
                if (3072 == nodeVisualID) {
                    return true;
                }
                if (3073 == nodeVisualID) {
                    return true;
                }
                if (3074 == nodeVisualID) {
                    return true;
                }
                if (3075 == nodeVisualID) {
                    return true;
                }
                if (3076 == nodeVisualID) {
                    return true;
                }
                if (3077 == nodeVisualID) {
                    return true;
                }
                if (3081 == nodeVisualID) {
                    return true;
                }
                if (3082 == nodeVisualID) {
                    return true;
                }
                if (3083 == nodeVisualID) {
                    return true;
                }
                if (3084 == nodeVisualID) {
                    return true;
                }
                if (3085 == nodeVisualID) {
                    return true;
                }
                if (3086 == nodeVisualID) {
                    return true;
                }
                if (3087 == nodeVisualID) {
                    return true;
                }
                if (3078 == nodeVisualID) {
                    return true;
                }
                if (3079 == nodeVisualID) {
                    return true;
                }
                if (3080 == nodeVisualID) {
                    return true;
                }
                if (3091 == nodeVisualID) {
                    return true;
                }
                if (3092 == nodeVisualID) {
                    return true;
                }
                if (3093 == nodeVisualID) {
                    return true;
                }
                if (3094 == nodeVisualID) {
                    return true;
                }
                if (3095 == nodeVisualID) {
                    return true;
                }
                if (3096 == nodeVisualID) {
                    return true;
                }
                if (3097 == nodeVisualID) {
                    return true;
                }
                if (3116 == nodeVisualID) {
                    return true;
                }
                if (3117 == nodeVisualID) {
                    return true;
                }
                if (3118 == nodeVisualID) {
                    return true;
                }
                if (3119 == nodeVisualID) {
                    return true;
                }
                if (3120 != nodeVisualID) break;
                return true;
            }
            case 7054: {
                if (3069 == nodeVisualID) {
                    return true;
                }
                if (3088 == nodeVisualID) {
                    return true;
                }
                if (3070 == nodeVisualID) {
                    return true;
                }
                if (3071 == nodeVisualID) {
                    return true;
                }
                if (3072 == nodeVisualID) {
                    return true;
                }
                if (3073 == nodeVisualID) {
                    return true;
                }
                if (3074 == nodeVisualID) {
                    return true;
                }
                if (3075 == nodeVisualID) {
                    return true;
                }
                if (3076 == nodeVisualID) {
                    return true;
                }
                if (3077 == nodeVisualID) {
                    return true;
                }
                if (3081 == nodeVisualID) {
                    return true;
                }
                if (3082 == nodeVisualID) {
                    return true;
                }
                if (3083 == nodeVisualID) {
                    return true;
                }
                if (3084 == nodeVisualID) {
                    return true;
                }
                if (3085 == nodeVisualID) {
                    return true;
                }
                if (3086 == nodeVisualID) {
                    return true;
                }
                if (3087 == nodeVisualID) {
                    return true;
                }
                if (3078 == nodeVisualID) {
                    return true;
                }
                if (3079 == nodeVisualID) {
                    return true;
                }
                if (3080 == nodeVisualID) {
                    return true;
                }
                if (3091 == nodeVisualID) {
                    return true;
                }
                if (3092 == nodeVisualID) {
                    return true;
                }
                if (3093 == nodeVisualID) {
                    return true;
                }
                if (3094 == nodeVisualID) {
                    return true;
                }
                if (3095 == nodeVisualID) {
                    return true;
                }
                if (3096 == nodeVisualID) {
                    return true;
                }
                if (3097 == nodeVisualID) {
                    return true;
                }
                if (3116 == nodeVisualID) {
                    return true;
                }
                if (3117 == nodeVisualID) {
                    return true;
                }
                if (3118 == nodeVisualID) {
                    return true;
                }
                if (3119 == nodeVisualID) {
                    return true;
                }
                if (3120 != nodeVisualID) break;
                return true;
            }
            case 7055: {
                if (3069 == nodeVisualID) {
                    return true;
                }
                if (3088 == nodeVisualID) {
                    return true;
                }
                if (3070 == nodeVisualID) {
                    return true;
                }
                if (3071 == nodeVisualID) {
                    return true;
                }
                if (3072 == nodeVisualID) {
                    return true;
                }
                if (3073 == nodeVisualID) {
                    return true;
                }
                if (3074 == nodeVisualID) {
                    return true;
                }
                if (3075 == nodeVisualID) {
                    return true;
                }
                if (3076 == nodeVisualID) {
                    return true;
                }
                if (3077 == nodeVisualID) {
                    return true;
                }
                if (3081 == nodeVisualID) {
                    return true;
                }
                if (3082 == nodeVisualID) {
                    return true;
                }
                if (3083 == nodeVisualID) {
                    return true;
                }
                if (3084 == nodeVisualID) {
                    return true;
                }
                if (3085 == nodeVisualID) {
                    return true;
                }
                if (3086 == nodeVisualID) {
                    return true;
                }
                if (3087 == nodeVisualID) {
                    return true;
                }
                if (3078 == nodeVisualID) {
                    return true;
                }
                if (3079 == nodeVisualID) {
                    return true;
                }
                if (3080 == nodeVisualID) {
                    return true;
                }
                if (3091 == nodeVisualID) {
                    return true;
                }
                if (3092 == nodeVisualID) {
                    return true;
                }
                if (3093 == nodeVisualID) {
                    return true;
                }
                if (3094 == nodeVisualID) {
                    return true;
                }
                if (3095 == nodeVisualID) {
                    return true;
                }
                if (3096 == nodeVisualID) {
                    return true;
                }
                if (3097 == nodeVisualID) {
                    return true;
                }
                if (3116 == nodeVisualID) {
                    return true;
                }
                if (3117 == nodeVisualID) {
                    return true;
                }
                if (3118 == nodeVisualID) {
                    return true;
                }
                if (3119 == nodeVisualID) {
                    return true;
                }
                if (3120 != nodeVisualID) break;
                return true;
            }
            case 7056: {
                if (3069 == nodeVisualID) {
                    return true;
                }
                if (3070 == nodeVisualID) {
                    return true;
                }
                if (3071 == nodeVisualID) {
                    return true;
                }
                if (3072 == nodeVisualID) {
                    return true;
                }
                if (3073 == nodeVisualID) {
                    return true;
                }
                if (3074 == nodeVisualID) {
                    return true;
                }
                if (3075 == nodeVisualID) {
                    return true;
                }
                if (3076 == nodeVisualID) {
                    return true;
                }
                if (3077 == nodeVisualID) {
                    return true;
                }
                if (3081 == nodeVisualID) {
                    return true;
                }
                if (3082 == nodeVisualID) {
                    return true;
                }
                if (3083 == nodeVisualID) {
                    return true;
                }
                if (3084 == nodeVisualID) {
                    return true;
                }
                if (3085 == nodeVisualID) {
                    return true;
                }
                if (3086 == nodeVisualID) {
                    return true;
                }
                if (3087 == nodeVisualID) {
                    return true;
                }
                if (3078 == nodeVisualID) {
                    return true;
                }
                if (3079 == nodeVisualID) {
                    return true;
                }
                if (3080 == nodeVisualID) {
                    return true;
                }
                if (3091 == nodeVisualID) {
                    return true;
                }
                if (3092 == nodeVisualID) {
                    return true;
                }
                if (3093 == nodeVisualID) {
                    return true;
                }
                if (3094 == nodeVisualID) {
                    return true;
                }
                if (3095 == nodeVisualID) {
                    return true;
                }
                if (3096 == nodeVisualID) {
                    return true;
                }
                if (3097 == nodeVisualID) {
                    return true;
                }
                if (3116 == nodeVisualID) {
                    return true;
                }
                if (3117 == nodeVisualID) {
                    return true;
                }
                if (3118 == nodeVisualID) {
                    return true;
                }
                if (3119 == nodeVisualID) {
                    return true;
                }
                if (3120 != nodeVisualID) break;
                return true;
            }
            case 7057: {
                if (3069 == nodeVisualID) {
                    return true;
                }
                if (3070 == nodeVisualID) {
                    return true;
                }
                if (3071 == nodeVisualID) {
                    return true;
                }
                if (3072 == nodeVisualID) {
                    return true;
                }
                if (3073 == nodeVisualID) {
                    return true;
                }
                if (3074 == nodeVisualID) {
                    return true;
                }
                if (3075 == nodeVisualID) {
                    return true;
                }
                if (3076 == nodeVisualID) {
                    return true;
                }
                if (3077 == nodeVisualID) {
                    return true;
                }
                if (3081 == nodeVisualID) {
                    return true;
                }
                if (3082 == nodeVisualID) {
                    return true;
                }
                if (3083 == nodeVisualID) {
                    return true;
                }
                if (3084 == nodeVisualID) {
                    return true;
                }
                if (3085 == nodeVisualID) {
                    return true;
                }
                if (3086 == nodeVisualID) {
                    return true;
                }
                if (3087 == nodeVisualID) {
                    return true;
                }
                if (3078 == nodeVisualID) {
                    return true;
                }
                if (3079 == nodeVisualID) {
                    return true;
                }
                if (3080 == nodeVisualID) {
                    return true;
                }
                if (3091 == nodeVisualID) {
                    return true;
                }
                if (3092 == nodeVisualID) {
                    return true;
                }
                if (3093 == nodeVisualID) {
                    return true;
                }
                if (3094 == nodeVisualID) {
                    return true;
                }
                if (3095 == nodeVisualID) {
                    return true;
                }
                if (3096 == nodeVisualID) {
                    return true;
                }
                if (3097 == nodeVisualID) {
                    return true;
                }
                if (3116 == nodeVisualID) {
                    return true;
                }
                if (3117 == nodeVisualID) {
                    return true;
                }
                if (3118 == nodeVisualID) {
                    return true;
                }
                if (3119 == nodeVisualID) {
                    return true;
                }
                if (3120 != nodeVisualID) break;
                return true;
            }
            case 7058: {
                if (3069 == nodeVisualID) {
                    return true;
                }
                if (3070 == nodeVisualID) {
                    return true;
                }
                if (3071 == nodeVisualID) {
                    return true;
                }
                if (3072 == nodeVisualID) {
                    return true;
                }
                if (3073 == nodeVisualID) {
                    return true;
                }
                if (3074 == nodeVisualID) {
                    return true;
                }
                if (3075 == nodeVisualID) {
                    return true;
                }
                if (3076 == nodeVisualID) {
                    return true;
                }
                if (3077 == nodeVisualID) {
                    return true;
                }
                if (3081 == nodeVisualID) {
                    return true;
                }
                if (3082 == nodeVisualID) {
                    return true;
                }
                if (3083 == nodeVisualID) {
                    return true;
                }
                if (3084 == nodeVisualID) {
                    return true;
                }
                if (3085 == nodeVisualID) {
                    return true;
                }
                if (3086 == nodeVisualID) {
                    return true;
                }
                if (3087 == nodeVisualID) {
                    return true;
                }
                if (3078 == nodeVisualID) {
                    return true;
                }
                if (3079 == nodeVisualID) {
                    return true;
                }
                if (3080 == nodeVisualID) {
                    return true;
                }
                if (3091 == nodeVisualID) {
                    return true;
                }
                if (3092 == nodeVisualID) {
                    return true;
                }
                if (3093 == nodeVisualID) {
                    return true;
                }
                if (3094 == nodeVisualID) {
                    return true;
                }
                if (3095 == nodeVisualID) {
                    return true;
                }
                if (3096 == nodeVisualID) {
                    return true;
                }
                if (3097 == nodeVisualID) {
                    return true;
                }
                if (3116 == nodeVisualID) {
                    return true;
                }
                if (3117 == nodeVisualID) {
                    return true;
                }
                if (3118 == nodeVisualID) {
                    return true;
                }
                if (3119 == nodeVisualID) {
                    return true;
                }
                if (3120 != nodeVisualID) break;
                return true;
            }
            case 7059: {
                if (3069 == nodeVisualID) {
                    return true;
                }
                if (3070 == nodeVisualID) {
                    return true;
                }
                if (3071 == nodeVisualID) {
                    return true;
                }
                if (3072 == nodeVisualID) {
                    return true;
                }
                if (3073 == nodeVisualID) {
                    return true;
                }
                if (3074 == nodeVisualID) {
                    return true;
                }
                if (3075 == nodeVisualID) {
                    return true;
                }
                if (3076 == nodeVisualID) {
                    return true;
                }
                if (3077 == nodeVisualID) {
                    return true;
                }
                if (3081 == nodeVisualID) {
                    return true;
                }
                if (3082 == nodeVisualID) {
                    return true;
                }
                if (3083 == nodeVisualID) {
                    return true;
                }
                if (3084 == nodeVisualID) {
                    return true;
                }
                if (3085 == nodeVisualID) {
                    return true;
                }
                if (3086 == nodeVisualID) {
                    return true;
                }
                if (3087 == nodeVisualID) {
                    return true;
                }
                if (3078 == nodeVisualID) {
                    return true;
                }
                if (3079 == nodeVisualID) {
                    return true;
                }
                if (3080 == nodeVisualID) {
                    return true;
                }
                if (3091 == nodeVisualID) {
                    return true;
                }
                if (3092 == nodeVisualID) {
                    return true;
                }
                if (3093 == nodeVisualID) {
                    return true;
                }
                if (3094 == nodeVisualID) {
                    return true;
                }
                if (3095 == nodeVisualID) {
                    return true;
                }
                if (3096 == nodeVisualID) {
                    return true;
                }
                if (3097 == nodeVisualID) {
                    return true;
                }
                if (3116 == nodeVisualID) {
                    return true;
                }
                if (3117 == nodeVisualID) {
                    return true;
                }
                if (3118 == nodeVisualID) {
                    return true;
                }
                if (3119 == nodeVisualID) {
                    return true;
                }
                if (3120 != nodeVisualID) break;
                return true;
            }
            case 7060: {
                if (3069 == nodeVisualID) {
                    return true;
                }
                if (3070 == nodeVisualID) {
                    return true;
                }
                if (3071 == nodeVisualID) {
                    return true;
                }
                if (3072 == nodeVisualID) {
                    return true;
                }
                if (3073 == nodeVisualID) {
                    return true;
                }
                if (3074 == nodeVisualID) {
                    return true;
                }
                if (3075 == nodeVisualID) {
                    return true;
                }
                if (3076 == nodeVisualID) {
                    return true;
                }
                if (3077 == nodeVisualID) {
                    return true;
                }
                if (3081 == nodeVisualID) {
                    return true;
                }
                if (3082 == nodeVisualID) {
                    return true;
                }
                if (3083 == nodeVisualID) {
                    return true;
                }
                if (3084 == nodeVisualID) {
                    return true;
                }
                if (3085 == nodeVisualID) {
                    return true;
                }
                if (3086 == nodeVisualID) {
                    return true;
                }
                if (3087 == nodeVisualID) {
                    return true;
                }
                if (3078 == nodeVisualID) {
                    return true;
                }
                if (3079 == nodeVisualID) {
                    return true;
                }
                if (3080 == nodeVisualID) {
                    return true;
                }
                if (3091 == nodeVisualID) {
                    return true;
                }
                if (3092 == nodeVisualID) {
                    return true;
                }
                if (3093 == nodeVisualID) {
                    return true;
                }
                if (3094 == nodeVisualID) {
                    return true;
                }
                if (3095 == nodeVisualID) {
                    return true;
                }
                if (3096 == nodeVisualID) {
                    return true;
                }
                if (3097 == nodeVisualID) {
                    return true;
                }
                if (3116 == nodeVisualID) {
                    return true;
                }
                if (3117 == nodeVisualID) {
                    return true;
                }
                if (3118 == nodeVisualID) {
                    return true;
                }
                if (3119 == nodeVisualID) {
                    return true;
                }
                if (3120 != nodeVisualID) break;
                return true;
            }
            case 7061: {
                if (3070 == nodeVisualID) {
                    return true;
                }
                if (3071 == nodeVisualID) {
                    return true;
                }
                if (3097 == nodeVisualID) {
                    return true;
                }
                if (3115 == nodeVisualID) {
                    return true;
                }
                if (3116 == nodeVisualID) {
                    return true;
                }
                if (3117 == nodeVisualID) {
                    return true;
                }
                if (3118 == nodeVisualID) {
                    return true;
                }
                if (3119 == nodeVisualID) {
                    return true;
                }
                if (3120 != nodeVisualID) break;
                return true;
            }
            case 7063: {
                if (3069 == nodeVisualID) {
                    return true;
                }
                if (3088 == nodeVisualID) {
                    return true;
                }
                if (3070 == nodeVisualID) {
                    return true;
                }
                if (3071 == nodeVisualID) {
                    return true;
                }
                if (3072 == nodeVisualID) {
                    return true;
                }
                if (3073 == nodeVisualID) {
                    return true;
                }
                if (3074 == nodeVisualID) {
                    return true;
                }
                if (3075 == nodeVisualID) {
                    return true;
                }
                if (3076 == nodeVisualID) {
                    return true;
                }
                if (3077 == nodeVisualID) {
                    return true;
                }
                if (3081 == nodeVisualID) {
                    return true;
                }
                if (3082 == nodeVisualID) {
                    return true;
                }
                if (3083 == nodeVisualID) {
                    return true;
                }
                if (3084 == nodeVisualID) {
                    return true;
                }
                if (3085 == nodeVisualID) {
                    return true;
                }
                if (3086 == nodeVisualID) {
                    return true;
                }
                if (3087 == nodeVisualID) {
                    return true;
                }
                if (3078 == nodeVisualID) {
                    return true;
                }
                if (3079 == nodeVisualID) {
                    return true;
                }
                if (3080 == nodeVisualID) {
                    return true;
                }
                if (3091 == nodeVisualID) {
                    return true;
                }
                if (3092 == nodeVisualID) {
                    return true;
                }
                if (3093 == nodeVisualID) {
                    return true;
                }
                if (3094 == nodeVisualID) {
                    return true;
                }
                if (3095 == nodeVisualID) {
                    return true;
                }
                if (3096 == nodeVisualID) {
                    return true;
                }
                if (3097 == nodeVisualID) {
                    return true;
                }
                if (3116 == nodeVisualID) {
                    return true;
                }
                if (3117 == nodeVisualID) {
                    return true;
                }
                if (3118 == nodeVisualID) {
                    return true;
                }
                if (3119 == nodeVisualID) {
                    return true;
                }
                if (3120 != nodeVisualID) break;
                return true;
            }
            case 7064: {
                if (3069 == nodeVisualID) {
                    return true;
                }
                if (3088 == nodeVisualID) {
                    return true;
                }
                if (3070 == nodeVisualID) {
                    return true;
                }
                if (3071 == nodeVisualID) {
                    return true;
                }
                if (3072 == nodeVisualID) {
                    return true;
                }
                if (3073 == nodeVisualID) {
                    return true;
                }
                if (3074 == nodeVisualID) {
                    return true;
                }
                if (3075 == nodeVisualID) {
                    return true;
                }
                if (3076 == nodeVisualID) {
                    return true;
                }
                if (3077 == nodeVisualID) {
                    return true;
                }
                if (3081 == nodeVisualID) {
                    return true;
                }
                if (3082 == nodeVisualID) {
                    return true;
                }
                if (3083 == nodeVisualID) {
                    return true;
                }
                if (3084 == nodeVisualID) {
                    return true;
                }
                if (3085 == nodeVisualID) {
                    return true;
                }
                if (3086 == nodeVisualID) {
                    return true;
                }
                if (3087 == nodeVisualID) {
                    return true;
                }
                if (3078 == nodeVisualID) {
                    return true;
                }
                if (3079 == nodeVisualID) {
                    return true;
                }
                if (3080 == nodeVisualID) {
                    return true;
                }
                if (3091 == nodeVisualID) {
                    return true;
                }
                if (3092 == nodeVisualID) {
                    return true;
                }
                if (3093 == nodeVisualID) {
                    return true;
                }
                if (3094 == nodeVisualID) {
                    return true;
                }
                if (3095 == nodeVisualID) {
                    return true;
                }
                if (3096 == nodeVisualID) {
                    return true;
                }
                if (3097 == nodeVisualID) {
                    return true;
                }
                if (3116 == nodeVisualID) {
                    return true;
                }
                if (3117 == nodeVisualID) {
                    return true;
                }
                if (3118 == nodeVisualID) {
                    return true;
                }
                if (3119 == nodeVisualID) {
                    return true;
                }
                if (3120 != nodeVisualID) break;
                return true;
            }
            case 7065: {
                if (3069 == nodeVisualID) {
                    return true;
                }
                if (3088 == nodeVisualID) {
                    return true;
                }
                if (3070 == nodeVisualID) {
                    return true;
                }
                if (3071 == nodeVisualID) {
                    return true;
                }
                if (3072 == nodeVisualID) {
                    return true;
                }
                if (3073 == nodeVisualID) {
                    return true;
                }
                if (3074 == nodeVisualID) {
                    return true;
                }
                if (3075 == nodeVisualID) {
                    return true;
                }
                if (3076 == nodeVisualID) {
                    return true;
                }
                if (3077 == nodeVisualID) {
                    return true;
                }
                if (3081 == nodeVisualID) {
                    return true;
                }
                if (3082 == nodeVisualID) {
                    return true;
                }
                if (3083 == nodeVisualID) {
                    return true;
                }
                if (3084 == nodeVisualID) {
                    return true;
                }
                if (3085 == nodeVisualID) {
                    return true;
                }
                if (3086 == nodeVisualID) {
                    return true;
                }
                if (3087 == nodeVisualID) {
                    return true;
                }
                if (3078 == nodeVisualID) {
                    return true;
                }
                if (3079 == nodeVisualID) {
                    return true;
                }
                if (3080 == nodeVisualID) {
                    return true;
                }
                if (3091 == nodeVisualID) {
                    return true;
                }
                if (3092 == nodeVisualID) {
                    return true;
                }
                if (3093 == nodeVisualID) {
                    return true;
                }
                if (3094 == nodeVisualID) {
                    return true;
                }
                if (3095 == nodeVisualID) {
                    return true;
                }
                if (3096 == nodeVisualID) {
                    return true;
                }
                if (3097 == nodeVisualID) {
                    return true;
                }
                if (3116 == nodeVisualID) {
                    return true;
                }
                if (3117 == nodeVisualID) {
                    return true;
                }
                if (3118 == nodeVisualID) {
                    return true;
                }
                if (3119 == nodeVisualID) {
                    return true;
                }
                if (3120 != nodeVisualID) break;
                return true;
            }
            case 7066: {
                if (3069 == nodeVisualID) {
                    return true;
                }
                if (3088 == nodeVisualID) {
                    return true;
                }
                if (3070 == nodeVisualID) {
                    return true;
                }
                if (3071 == nodeVisualID) {
                    return true;
                }
                if (3072 == nodeVisualID) {
                    return true;
                }
                if (3073 == nodeVisualID) {
                    return true;
                }
                if (3074 == nodeVisualID) {
                    return true;
                }
                if (3075 == nodeVisualID) {
                    return true;
                }
                if (3076 == nodeVisualID) {
                    return true;
                }
                if (3077 == nodeVisualID) {
                    return true;
                }
                if (3081 == nodeVisualID) {
                    return true;
                }
                if (3082 == nodeVisualID) {
                    return true;
                }
                if (3083 == nodeVisualID) {
                    return true;
                }
                if (3084 == nodeVisualID) {
                    return true;
                }
                if (3085 == nodeVisualID) {
                    return true;
                }
                if (3086 == nodeVisualID) {
                    return true;
                }
                if (3087 == nodeVisualID) {
                    return true;
                }
                if (3078 == nodeVisualID) {
                    return true;
                }
                if (3079 == nodeVisualID) {
                    return true;
                }
                if (3080 == nodeVisualID) {
                    return true;
                }
                if (3091 == nodeVisualID) {
                    return true;
                }
                if (3092 == nodeVisualID) {
                    return true;
                }
                if (3093 == nodeVisualID) {
                    return true;
                }
                if (3094 == nodeVisualID) {
                    return true;
                }
                if (3095 == nodeVisualID) {
                    return true;
                }
                if (3096 == nodeVisualID) {
                    return true;
                }
                if (3097 == nodeVisualID) {
                    return true;
                }
                if (3116 == nodeVisualID) {
                    return true;
                }
                if (3117 == nodeVisualID) {
                    return true;
                }
                if (3118 == nodeVisualID) {
                    return true;
                }
                if (3119 == nodeVisualID) {
                    return true;
                }
                if (3120 != nodeVisualID) break;
                return true;
            }
            case 7067: {
                if (3069 == nodeVisualID) {
                    return true;
                }
                if (3088 == nodeVisualID) {
                    return true;
                }
                if (3070 == nodeVisualID) {
                    return true;
                }
                if (3071 == nodeVisualID) {
                    return true;
                }
                if (3072 == nodeVisualID) {
                    return true;
                }
                if (3073 == nodeVisualID) {
                    return true;
                }
                if (3074 == nodeVisualID) {
                    return true;
                }
                if (3075 == nodeVisualID) {
                    return true;
                }
                if (3076 == nodeVisualID) {
                    return true;
                }
                if (3077 == nodeVisualID) {
                    return true;
                }
                if (3081 == nodeVisualID) {
                    return true;
                }
                if (3082 == nodeVisualID) {
                    return true;
                }
                if (3083 == nodeVisualID) {
                    return true;
                }
                if (3084 == nodeVisualID) {
                    return true;
                }
                if (3085 == nodeVisualID) {
                    return true;
                }
                if (3086 == nodeVisualID) {
                    return true;
                }
                if (3087 == nodeVisualID) {
                    return true;
                }
                if (3078 == nodeVisualID) {
                    return true;
                }
                if (3079 == nodeVisualID) {
                    return true;
                }
                if (3080 == nodeVisualID) {
                    return true;
                }
                if (3091 == nodeVisualID) {
                    return true;
                }
                if (3092 == nodeVisualID) {
                    return true;
                }
                if (3093 == nodeVisualID) {
                    return true;
                }
                if (3094 == nodeVisualID) {
                    return true;
                }
                if (3095 == nodeVisualID) {
                    return true;
                }
                if (3096 == nodeVisualID) {
                    return true;
                }
                if (3097 == nodeVisualID) {
                    return true;
                }
                if (3116 == nodeVisualID) {
                    return true;
                }
                if (3117 == nodeVisualID) {
                    return true;
                }
                if (3118 == nodeVisualID) {
                    return true;
                }
                if (3119 == nodeVisualID) {
                    return true;
                }
                if (3120 != nodeVisualID) break;
                return true;
            }
            case 7068: {
                if (3069 == nodeVisualID) {
                    return true;
                }
                if (3088 == nodeVisualID) {
                    return true;
                }
                if (3070 == nodeVisualID) {
                    return true;
                }
                if (3071 == nodeVisualID) {
                    return true;
                }
                if (3072 == nodeVisualID) {
                    return true;
                }
                if (3073 == nodeVisualID) {
                    return true;
                }
                if (3074 == nodeVisualID) {
                    return true;
                }
                if (3075 == nodeVisualID) {
                    return true;
                }
                if (3076 == nodeVisualID) {
                    return true;
                }
                if (3077 == nodeVisualID) {
                    return true;
                }
                if (3081 == nodeVisualID) {
                    return true;
                }
                if (3082 == nodeVisualID) {
                    return true;
                }
                if (3083 == nodeVisualID) {
                    return true;
                }
                if (3084 == nodeVisualID) {
                    return true;
                }
                if (3085 == nodeVisualID) {
                    return true;
                }
                if (3086 == nodeVisualID) {
                    return true;
                }
                if (3087 == nodeVisualID) {
                    return true;
                }
                if (3078 == nodeVisualID) {
                    return true;
                }
                if (3079 == nodeVisualID) {
                    return true;
                }
                if (3080 == nodeVisualID) {
                    return true;
                }
                if (3091 == nodeVisualID) {
                    return true;
                }
                if (3092 == nodeVisualID) {
                    return true;
                }
                if (3093 == nodeVisualID) {
                    return true;
                }
                if (3094 == nodeVisualID) {
                    return true;
                }
                if (3095 == nodeVisualID) {
                    return true;
                }
                if (3096 == nodeVisualID) {
                    return true;
                }
                if (3097 == nodeVisualID) {
                    return true;
                }
                if (3116 == nodeVisualID) {
                    return true;
                }
                if (3117 == nodeVisualID) {
                    return true;
                }
                if (3118 == nodeVisualID) {
                    return true;
                }
                if (3119 == nodeVisualID) {
                    return true;
                }
                if (3120 != nodeVisualID) break;
                return true;
            }
            case 7069: {
                if (3069 == nodeVisualID) {
                    return true;
                }
                if (3070 == nodeVisualID) {
                    return true;
                }
                if (3071 == nodeVisualID) {
                    return true;
                }
                if (3072 == nodeVisualID) {
                    return true;
                }
                if (3073 == nodeVisualID) {
                    return true;
                }
                if (3074 == nodeVisualID) {
                    return true;
                }
                if (3075 == nodeVisualID) {
                    return true;
                }
                if (3076 == nodeVisualID) {
                    return true;
                }
                if (3077 == nodeVisualID) {
                    return true;
                }
                if (3081 == nodeVisualID) {
                    return true;
                }
                if (3082 == nodeVisualID) {
                    return true;
                }
                if (3083 == nodeVisualID) {
                    return true;
                }
                if (3084 == nodeVisualID) {
                    return true;
                }
                if (3085 == nodeVisualID) {
                    return true;
                }
                if (3086 == nodeVisualID) {
                    return true;
                }
                if (3087 == nodeVisualID) {
                    return true;
                }
                if (3078 == nodeVisualID) {
                    return true;
                }
                if (3079 == nodeVisualID) {
                    return true;
                }
                if (3080 == nodeVisualID) {
                    return true;
                }
                if (3091 == nodeVisualID) {
                    return true;
                }
                if (3092 == nodeVisualID) {
                    return true;
                }
                if (3093 == nodeVisualID) {
                    return true;
                }
                if (3094 == nodeVisualID) {
                    return true;
                }
                if (3095 == nodeVisualID) {
                    return true;
                }
                if (3096 == nodeVisualID) {
                    return true;
                }
                if (3097 == nodeVisualID) {
                    return true;
                }
                if (3116 == nodeVisualID) {
                    return true;
                }
                if (3117 == nodeVisualID) {
                    return true;
                }
                if (3118 == nodeVisualID) {
                    return true;
                }
                if (3119 == nodeVisualID) {
                    return true;
                }
                if (3120 != nodeVisualID) break;
                return true;
            }
            case 7070: {
                if (3069 == nodeVisualID) {
                    return true;
                }
                if (3070 == nodeVisualID) {
                    return true;
                }
                if (3071 == nodeVisualID) {
                    return true;
                }
                if (3072 == nodeVisualID) {
                    return true;
                }
                if (3073 == nodeVisualID) {
                    return true;
                }
                if (3074 == nodeVisualID) {
                    return true;
                }
                if (3075 == nodeVisualID) {
                    return true;
                }
                if (3076 == nodeVisualID) {
                    return true;
                }
                if (3077 == nodeVisualID) {
                    return true;
                }
                if (3081 == nodeVisualID) {
                    return true;
                }
                if (3082 == nodeVisualID) {
                    return true;
                }
                if (3083 == nodeVisualID) {
                    return true;
                }
                if (3084 == nodeVisualID) {
                    return true;
                }
                if (3085 == nodeVisualID) {
                    return true;
                }
                if (3086 == nodeVisualID) {
                    return true;
                }
                if (3087 == nodeVisualID) {
                    return true;
                }
                if (3078 == nodeVisualID) {
                    return true;
                }
                if (3079 == nodeVisualID) {
                    return true;
                }
                if (3080 == nodeVisualID) {
                    return true;
                }
                if (3091 == nodeVisualID) {
                    return true;
                }
                if (3092 == nodeVisualID) {
                    return true;
                }
                if (3093 == nodeVisualID) {
                    return true;
                }
                if (3094 == nodeVisualID) {
                    return true;
                }
                if (3095 == nodeVisualID) {
                    return true;
                }
                if (3096 == nodeVisualID) {
                    return true;
                }
                if (3097 == nodeVisualID) {
                    return true;
                }
                if (3116 == nodeVisualID) {
                    return true;
                }
                if (3117 == nodeVisualID) {
                    return true;
                }
                if (3118 == nodeVisualID) {
                    return true;
                }
                if (3119 == nodeVisualID) {
                    return true;
                }
                if (3120 != nodeVisualID) break;
                return true;
            }
            case 7071: {
                if (3069 == nodeVisualID) {
                    return true;
                }
                if (3070 == nodeVisualID) {
                    return true;
                }
                if (3071 == nodeVisualID) {
                    return true;
                }
                if (3072 == nodeVisualID) {
                    return true;
                }
                if (3073 == nodeVisualID) {
                    return true;
                }
                if (3074 == nodeVisualID) {
                    return true;
                }
                if (3075 == nodeVisualID) {
                    return true;
                }
                if (3076 == nodeVisualID) {
                    return true;
                }
                if (3077 == nodeVisualID) {
                    return true;
                }
                if (3081 == nodeVisualID) {
                    return true;
                }
                if (3082 == nodeVisualID) {
                    return true;
                }
                if (3083 == nodeVisualID) {
                    return true;
                }
                if (3084 == nodeVisualID) {
                    return true;
                }
                if (3085 == nodeVisualID) {
                    return true;
                }
                if (3086 == nodeVisualID) {
                    return true;
                }
                if (3087 == nodeVisualID) {
                    return true;
                }
                if (3078 == nodeVisualID) {
                    return true;
                }
                if (3079 == nodeVisualID) {
                    return true;
                }
                if (3080 == nodeVisualID) {
                    return true;
                }
                if (3091 == nodeVisualID) {
                    return true;
                }
                if (3092 == nodeVisualID) {
                    return true;
                }
                if (3093 == nodeVisualID) {
                    return true;
                }
                if (3094 == nodeVisualID) {
                    return true;
                }
                if (3095 == nodeVisualID) {
                    return true;
                }
                if (3096 == nodeVisualID) {
                    return true;
                }
                if (3097 == nodeVisualID) {
                    return true;
                }
                if (3116 == nodeVisualID) {
                    return true;
                }
                if (3117 == nodeVisualID) {
                    return true;
                }
                if (3118 == nodeVisualID) {
                    return true;
                }
                if (3119 == nodeVisualID) {
                    return true;
                }
                if (3120 != nodeVisualID) break;
                return true;
            }
            case 7072: {
                if (3069 == nodeVisualID) {
                    return true;
                }
                if (3070 == nodeVisualID) {
                    return true;
                }
                if (3071 == nodeVisualID) {
                    return true;
                }
                if (3072 == nodeVisualID) {
                    return true;
                }
                if (3073 == nodeVisualID) {
                    return true;
                }
                if (3074 == nodeVisualID) {
                    return true;
                }
                if (3075 == nodeVisualID) {
                    return true;
                }
                if (3076 == nodeVisualID) {
                    return true;
                }
                if (3077 == nodeVisualID) {
                    return true;
                }
                if (3081 == nodeVisualID) {
                    return true;
                }
                if (3082 == nodeVisualID) {
                    return true;
                }
                if (3083 == nodeVisualID) {
                    return true;
                }
                if (3084 == nodeVisualID) {
                    return true;
                }
                if (3085 == nodeVisualID) {
                    return true;
                }
                if (3086 == nodeVisualID) {
                    return true;
                }
                if (3087 == nodeVisualID) {
                    return true;
                }
                if (3078 == nodeVisualID) {
                    return true;
                }
                if (3079 == nodeVisualID) {
                    return true;
                }
                if (3080 == nodeVisualID) {
                    return true;
                }
                if (3091 == nodeVisualID) {
                    return true;
                }
                if (3092 == nodeVisualID) {
                    return true;
                }
                if (3093 == nodeVisualID) {
                    return true;
                }
                if (3094 == nodeVisualID) {
                    return true;
                }
                if (3095 == nodeVisualID) {
                    return true;
                }
                if (3096 == nodeVisualID) {
                    return true;
                }
                if (3097 == nodeVisualID) {
                    return true;
                }
                if (3116 == nodeVisualID) {
                    return true;
                }
                if (3117 == nodeVisualID) {
                    return true;
                }
                if (3118 == nodeVisualID) {
                    return true;
                }
                if (3119 == nodeVisualID) {
                    return true;
                }
                if (3120 != nodeVisualID) break;
                return true;
            }
            case 7073: {
                if (3069 == nodeVisualID) {
                    return true;
                }
                if (3070 == nodeVisualID) {
                    return true;
                }
                if (3071 == nodeVisualID) {
                    return true;
                }
                if (3072 == nodeVisualID) {
                    return true;
                }
                if (3073 == nodeVisualID) {
                    return true;
                }
                if (3074 == nodeVisualID) {
                    return true;
                }
                if (3075 == nodeVisualID) {
                    return true;
                }
                if (3076 == nodeVisualID) {
                    return true;
                }
                if (3077 == nodeVisualID) {
                    return true;
                }
                if (3081 == nodeVisualID) {
                    return true;
                }
                if (3082 == nodeVisualID) {
                    return true;
                }
                if (3083 == nodeVisualID) {
                    return true;
                }
                if (3084 == nodeVisualID) {
                    return true;
                }
                if (3085 == nodeVisualID) {
                    return true;
                }
                if (3086 == nodeVisualID) {
                    return true;
                }
                if (3087 == nodeVisualID) {
                    return true;
                }
                if (3078 == nodeVisualID) {
                    return true;
                }
                if (3079 == nodeVisualID) {
                    return true;
                }
                if (3080 == nodeVisualID) {
                    return true;
                }
                if (3091 == nodeVisualID) {
                    return true;
                }
                if (3092 == nodeVisualID) {
                    return true;
                }
                if (3093 == nodeVisualID) {
                    return true;
                }
                if (3094 == nodeVisualID) {
                    return true;
                }
                if (3095 == nodeVisualID) {
                    return true;
                }
                if (3096 == nodeVisualID) {
                    return true;
                }
                if (3097 == nodeVisualID) {
                    return true;
                }
                if (3120 == nodeVisualID) {
                    return true;
                }
                if (3116 == nodeVisualID) {
                    return true;
                }
                if (3117 == nodeVisualID) {
                    return true;
                }
                if (3118 == nodeVisualID) {
                    return true;
                }
                if (3119 != nodeVisualID) break;
                return true;
            }
            case 7075: {
                if (3070 == nodeVisualID) {
                    return true;
                }
                if (3071 == nodeVisualID) {
                    return true;
                }
                if (3097 == nodeVisualID) {
                    return true;
                }
                if (3115 == nodeVisualID) {
                    return true;
                }
                if (3116 == nodeVisualID) {
                    return true;
                }
                if (3117 == nodeVisualID) {
                    return true;
                }
                if (3118 == nodeVisualID) {
                    return true;
                }
                if (3119 == nodeVisualID) {
                    return true;
                }
                if (3120 != nodeVisualID) break;
                return true;
            }
            case 7077: {
                if (3069 == nodeVisualID) {
                    return true;
                }
                if (3070 == nodeVisualID) {
                    return true;
                }
                if (3097 != nodeVisualID) break;
                return true;
            }
            case 4004: {
                if (6001 == nodeVisualID) {
                    return true;
                }
                if (6015 != nodeVisualID) break;
                return true;
            }
            case 4005: {
                if (6002 == nodeVisualID) {
                    return true;
                }
                if (6016 != nodeVisualID) break;
                return true;
            }
            case 4011: {
                if (6003 == nodeVisualID) {
                    return true;
                }
                if (6017 != nodeVisualID) break;
                return true;
            }
            case 4006: {
                if (6004 == nodeVisualID) {
                    return true;
                }
                if (6018 != nodeVisualID) break;
                return true;
            }
            case 4012: {
                if (6005 == nodeVisualID) {
                    return true;
                }
                if (6019 != nodeVisualID) break;
                return true;
            }
            case 4007: {
                if (6006 == nodeVisualID) {
                    return true;
                }
                if (6020 != nodeVisualID) break;
                return true;
            }
            case 4008: {
                if (6007 == nodeVisualID) {
                    return true;
                }
                if (6021 != nodeVisualID) break;
                return true;
            }
            case 4009: {
                if (6008 == nodeVisualID) {
                    return true;
                }
                if (6022 != nodeVisualID) break;
                return true;
            }
            case 4017: {
                if (6027 == nodeVisualID) {
                    return true;
                }
                if (6028 != nodeVisualID) break;
                return true;
            }
            case 4010: {
                if (6009 == nodeVisualID) {
                    return true;
                }
                if (6023 != nodeVisualID) break;
                return true;
            }
            case 4013: {
                if (6025 == nodeVisualID) {
                    return true;
                }
                if (6050 == nodeVisualID) {
                    return true;
                }
                if (6051 == nodeVisualID) {
                    return true;
                }
                if (6052 != nodeVisualID) break;
                return true;
            }
            case 4015: {
                if (6024 != nodeVisualID) break;
                return true;
            }
            case 4020: {
                if (6030 != nodeVisualID) break;
                return true;
            }
            case 4021: {
                if (6031 == nodeVisualID) {
                    return true;
                }
                if (6032 != nodeVisualID) break;
                return true;
            }
        }
        return false;
    }

    public static int getLinkWithClassVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (UMLPackage.eINSTANCE.getComponentRealization().isSuperTypeOf(domainElement.eClass())) {
            return 4004;
        }
        if (UMLPackage.eINSTANCE.getInterfaceRealization().isSuperTypeOf(domainElement.eClass())) {
            return 4005;
        }
        if (UMLPackage.eINSTANCE.getSubstitution().isSuperTypeOf(domainElement.eClass())) {
            return 4011;
        }
        if (UMLPackage.eINSTANCE.getRealization().isSuperTypeOf(domainElement.eClass())) {
            return 4006;
        }
        if (UMLPackage.eINSTANCE.getManifestation().isSuperTypeOf(domainElement.eClass())) {
            return 4012;
        }
        if (UMLPackage.eINSTANCE.getAbstraction().isSuperTypeOf(domainElement.eClass())) {
            return 4007;
        }
        if (UMLPackage.eINSTANCE.getUsage().isSuperTypeOf(domainElement.eClass())) {
            return 4008;
        }
        if (UMLPackage.eINSTANCE.getDeployment().isSuperTypeOf(domainElement.eClass())) {
            return 4009;
        }
        if (UMLPackage.eINSTANCE.getDependency().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDependency_4017((Dependency)domainElement)) {
            return 4017;
        }
        if (UMLPackage.eINSTANCE.getDependency().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDependency_4010((Dependency)domainElement)) {
            return 4010;
        }
        if (UMLPackage.eINSTANCE.getConnector().isSuperTypeOf(domainElement.eClass())) {
            return 4013;
        }
        if (UMLPackage.eINSTANCE.getGeneralization().isSuperTypeOf(domainElement.eClass())) {
            return 4015;
        }
        if (UMLPackage.eINSTANCE.getInformationFlow().isSuperTypeOf(domainElement.eClass())) {
            return 4021;
        }
        return -1;
    }

    private static boolean isDiagram(Package element) {
        return true;
    }

    private static boolean isProperty_3070(View containerView, Property domainElement) {
        Collaboration graphicalParent;
        return !(containerView.getElement() instanceof Collaboration) || !(graphicalParent = (Collaboration)containerView.getElement()).getCollaborationRoles().contains((Object)domainElement);
    }

    private static boolean isDependency_4017(Dependency domainElement) {
        CollaborationUse owner;
        return domainElement.getOwner() instanceof CollaborationUse && (owner = (CollaborationUse)domainElement.getOwner()).getRoleBindings().contains((Object)domainElement);
    }

    private static boolean isDependency_4010(Dependency domainElement) {
        CollaborationUse owner;
        return !(domainElement.getOwner() instanceof CollaborationUse) || !(owner = (CollaborationUse)domainElement.getOwner()).getRoleBindings().contains((Object)domainElement);
    }

    public static ViewInfo getDiagramViewInfo() {
        if (diagramViewInfo == null) {
            diagramViewInfo = UMLVisualIDRegistry.getPackage_1000ViewInfo();
        }
        return diagramViewInfo;
    }

    protected static ViewInfo getPackage_1000ViewInfo() {
        BaseViewInfo root = new BaseViewInfo(1000, 0, "", null, null);
        BaseViewInfo viewInfo = null;
        BaseViewInfo labelInfo = null;
        viewInfo = new BaseViewInfo(2060, 2, "Activity");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(2061, 2, "Interaction");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(2062, 2, "ProtocolStateMachine");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(2063, 2, "StateMachine");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(2064, 2, "FunctionBehavior");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(2065, 2, "OpaqueBehavior");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(2069, 2, "Component");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(2070, 2, "Device");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(2071, 2, "ExecutionEnvironment");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(2072, 2, "Node");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(2073, 2, "Class");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(2075, 2, "Collaboration");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(2076, 2, "Interface");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(2066, 2, "PrimitiveType");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(2067, 2, "Enumeration");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(2068, 2, "DataType");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(2077, 2, "Actor");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(2078, 2, "DeploymentSpecification");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(2079, 2, "Artifact");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(2080, 2, "InformationItem");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(2081, 2, "Signal");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(2082, 2, "UseCase");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(2083, 2, "SignalEvent");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(2084, 2, "CallEvent");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(2085, 2, "AnyReceiveEvent");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(2088, 2, "ChangeEvent");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(2089, 2, "TimeEvent");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(2093, 2, "DurationObservation");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(2094, 2, "TimeObservation");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(2095, 2, "LiteralBoolean");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(2096, 2, "LiteralInteger");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(2097, 2, "LiteralNull");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(2098, 2, "LiteralString");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(2099, 2, "LiteralUnlimitedNatural");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(2100, 2, "StringExpression");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(2101, 2, "OpaqueExpression");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(2102, 2, "TimeExpression");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(2103, 2, "Expression");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(2104, 2, "Duration");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(2105, 2, "TimeInterval");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(2106, 2, "DurationInterval");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(2107, 2, "Interval");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(2108, 2, "InstanceValue");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(2109, 2, "Comment");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(2110, 2, "DurationConstraint");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(2111, 2, "TimeConstraint");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(2112, 2, "IntervalConstraint");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(2113, 2, "InteractionConstraint");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(2114, 2, "Constraint");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(4001, 3, "");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(4002, 3, "");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(4003, 3, "");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(4004, 3, "");
        root.addNode(1000, (ViewInfo)viewInfo);
        labelInfo = new BaseViewInfo(6001, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        labelInfo = new BaseViewInfo(6015, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        viewInfo = new BaseViewInfo(4005, 3, "");
        root.addNode(1000, (ViewInfo)viewInfo);
        labelInfo = new BaseViewInfo(6002, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        labelInfo = new BaseViewInfo(6016, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        viewInfo = new BaseViewInfo(4011, 3, "");
        root.addNode(1000, (ViewInfo)viewInfo);
        labelInfo = new BaseViewInfo(6003, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        labelInfo = new BaseViewInfo(6017, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        viewInfo = new BaseViewInfo(4006, 3, "");
        root.addNode(1000, (ViewInfo)viewInfo);
        labelInfo = new BaseViewInfo(6004, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        labelInfo = new BaseViewInfo(6018, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        viewInfo = new BaseViewInfo(4012, 3, "");
        root.addNode(1000, (ViewInfo)viewInfo);
        labelInfo = new BaseViewInfo(6005, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        labelInfo = new BaseViewInfo(6019, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        viewInfo = new BaseViewInfo(4007, 3, "");
        root.addNode(1000, (ViewInfo)viewInfo);
        labelInfo = new BaseViewInfo(6006, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        labelInfo = new BaseViewInfo(6020, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        viewInfo = new BaseViewInfo(4008, 3, "");
        root.addNode(1000, (ViewInfo)viewInfo);
        labelInfo = new BaseViewInfo(6007, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        labelInfo = new BaseViewInfo(6021, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        viewInfo = new BaseViewInfo(4009, 3, "");
        root.addNode(1000, (ViewInfo)viewInfo);
        labelInfo = new BaseViewInfo(6008, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        labelInfo = new BaseViewInfo(6022, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        viewInfo = new BaseViewInfo(4017, 3, "");
        root.addNode(1000, (ViewInfo)viewInfo);
        labelInfo = new BaseViewInfo(6027, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        labelInfo = new BaseViewInfo(6028, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        viewInfo = new BaseViewInfo(4010, 3, "");
        root.addNode(1000, (ViewInfo)viewInfo);
        labelInfo = new BaseViewInfo(6009, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        labelInfo = new BaseViewInfo(6023, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        viewInfo = new BaseViewInfo(4013, 3, "");
        root.addNode(1000, (ViewInfo)viewInfo);
        labelInfo = new BaseViewInfo(6025, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        labelInfo = new BaseViewInfo(6050, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        labelInfo = new BaseViewInfo(6051, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        labelInfo = new BaseViewInfo(6052, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        viewInfo = new BaseViewInfo(4015, 3, "");
        root.addNode(1000, (ViewInfo)viewInfo);
        labelInfo = new BaseViewInfo(6024, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        viewInfo = new BaseViewInfo(4018, 3, "");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(4019, 3, "");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(4020, 3, "");
        root.addNode(1000, (ViewInfo)viewInfo);
        labelInfo = new BaseViewInfo(6030, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        viewInfo = new BaseViewInfo(4021, 3, "");
        root.addNode(1000, (ViewInfo)viewInfo);
        labelInfo = new BaseViewInfo(6031, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        labelInfo = new BaseViewInfo(6032, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        viewInfo = new BaseViewInfo(3069, 2, "Port");
        root.addNode(2073, (ViewInfo)viewInfo);
        root.addNode(3085, (ViewInfo)viewInfo);
        root.addNode(3070, (ViewInfo)viewInfo);
        root.addNode(3072, (ViewInfo)viewInfo);
        root.addNode(2060, (ViewInfo)viewInfo);
        root.addNode(3073, (ViewInfo)viewInfo);
        root.addNode(3074, (ViewInfo)viewInfo);
        root.addNode(3075, (ViewInfo)viewInfo);
        root.addNode(3076, (ViewInfo)viewInfo);
        root.addNode(3077, (ViewInfo)viewInfo);
        root.addNode(2061, (ViewInfo)viewInfo);
        root.addNode(2062, (ViewInfo)viewInfo);
        root.addNode(2063, (ViewInfo)viewInfo);
        root.addNode(2064, (ViewInfo)viewInfo);
        root.addNode(2065, (ViewInfo)viewInfo);
        root.addNode(3081, (ViewInfo)viewInfo);
        root.addNode(3082, (ViewInfo)viewInfo);
        root.addNode(3083, (ViewInfo)viewInfo);
        root.addNode(3084, (ViewInfo)viewInfo);
        root.addNode(2072, (ViewInfo)viewInfo);
        root.addNode(2071, (ViewInfo)viewInfo);
        root.addNode(2070, (ViewInfo)viewInfo);
        root.addNode(2069, (ViewInfo)viewInfo);
        root.addNode(7050, (ViewInfo)viewInfo);
        root.addNode(7051, (ViewInfo)viewInfo);
        root.addNode(7052, (ViewInfo)viewInfo);
        root.addNode(7053, (ViewInfo)viewInfo);
        root.addNode(7054, (ViewInfo)viewInfo);
        root.addNode(7055, (ViewInfo)viewInfo);
        root.addNode(7056, (ViewInfo)viewInfo);
        root.addNode(7057, (ViewInfo)viewInfo);
        root.addNode(7058, (ViewInfo)viewInfo);
        root.addNode(7059, (ViewInfo)viewInfo);
        root.addNode(7060, (ViewInfo)viewInfo);
        root.addNode(7063, (ViewInfo)viewInfo);
        root.addNode(7064, (ViewInfo)viewInfo);
        root.addNode(7065, (ViewInfo)viewInfo);
        root.addNode(7066, (ViewInfo)viewInfo);
        root.addNode(7067, (ViewInfo)viewInfo);
        root.addNode(7068, (ViewInfo)viewInfo);
        root.addNode(7069, (ViewInfo)viewInfo);
        root.addNode(7070, (ViewInfo)viewInfo);
        root.addNode(7071, (ViewInfo)viewInfo);
        root.addNode(7072, (ViewInfo)viewInfo);
        root.addNode(7073, (ViewInfo)viewInfo);
        root.addNode(7077, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(3088, 2, "Parameter");
        root.addNode(3072, (ViewInfo)viewInfo);
        root.addNode(3073, (ViewInfo)viewInfo);
        root.addNode(3074, (ViewInfo)viewInfo);
        root.addNode(3075, (ViewInfo)viewInfo);
        root.addNode(3076, (ViewInfo)viewInfo);
        root.addNode(3077, (ViewInfo)viewInfo);
        root.addNode(7050, (ViewInfo)viewInfo);
        root.addNode(7051, (ViewInfo)viewInfo);
        root.addNode(7052, (ViewInfo)viewInfo);
        root.addNode(7053, (ViewInfo)viewInfo);
        root.addNode(7054, (ViewInfo)viewInfo);
        root.addNode(7055, (ViewInfo)viewInfo);
        root.addNode(7063, (ViewInfo)viewInfo);
        root.addNode(7064, (ViewInfo)viewInfo);
        root.addNode(7065, (ViewInfo)viewInfo);
        root.addNode(7066, (ViewInfo)viewInfo);
        root.addNode(7067, (ViewInfo)viewInfo);
        root.addNode(7068, (ViewInfo)viewInfo);
        root.addNode(2060, (ViewInfo)viewInfo);
        root.addNode(2061, (ViewInfo)viewInfo);
        root.addNode(2062, (ViewInfo)viewInfo);
        root.addNode(2063, (ViewInfo)viewInfo);
        root.addNode(2064, (ViewInfo)viewInfo);
        root.addNode(2065, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(3070, 2, "Property");
        root.addNode(7050, (ViewInfo)viewInfo);
        root.addNode(7051, (ViewInfo)viewInfo);
        root.addNode(7052, (ViewInfo)viewInfo);
        root.addNode(7053, (ViewInfo)viewInfo);
        root.addNode(7054, (ViewInfo)viewInfo);
        root.addNode(7055, (ViewInfo)viewInfo);
        root.addNode(7056, (ViewInfo)viewInfo);
        root.addNode(7057, (ViewInfo)viewInfo);
        root.addNode(7058, (ViewInfo)viewInfo);
        root.addNode(7059, (ViewInfo)viewInfo);
        root.addNode(7060, (ViewInfo)viewInfo);
        root.addNode(7061, (ViewInfo)viewInfo);
        root.addNode(7063, (ViewInfo)viewInfo);
        root.addNode(7064, (ViewInfo)viewInfo);
        root.addNode(7065, (ViewInfo)viewInfo);
        root.addNode(7066, (ViewInfo)viewInfo);
        root.addNode(7067, (ViewInfo)viewInfo);
        root.addNode(7068, (ViewInfo)viewInfo);
        root.addNode(7069, (ViewInfo)viewInfo);
        root.addNode(7070, (ViewInfo)viewInfo);
        root.addNode(7071, (ViewInfo)viewInfo);
        root.addNode(7072, (ViewInfo)viewInfo);
        root.addNode(7073, (ViewInfo)viewInfo);
        root.addNode(7075, (ViewInfo)viewInfo);
        root.addNode(7077, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(3115, 2, "ConnectableElement");
        root.addNode(7061, (ViewInfo)viewInfo);
        root.addNode(7075, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(3071, 2, "CollaborationUse");
        root.addNode(7050, (ViewInfo)viewInfo);
        root.addNode(7051, (ViewInfo)viewInfo);
        root.addNode(7052, (ViewInfo)viewInfo);
        root.addNode(7053, (ViewInfo)viewInfo);
        root.addNode(7054, (ViewInfo)viewInfo);
        root.addNode(7055, (ViewInfo)viewInfo);
        root.addNode(7056, (ViewInfo)viewInfo);
        root.addNode(7057, (ViewInfo)viewInfo);
        root.addNode(7058, (ViewInfo)viewInfo);
        root.addNode(7059, (ViewInfo)viewInfo);
        root.addNode(7060, (ViewInfo)viewInfo);
        root.addNode(7061, (ViewInfo)viewInfo);
        root.addNode(7063, (ViewInfo)viewInfo);
        root.addNode(7064, (ViewInfo)viewInfo);
        root.addNode(7065, (ViewInfo)viewInfo);
        root.addNode(7066, (ViewInfo)viewInfo);
        root.addNode(7067, (ViewInfo)viewInfo);
        root.addNode(7068, (ViewInfo)viewInfo);
        root.addNode(7069, (ViewInfo)viewInfo);
        root.addNode(7070, (ViewInfo)viewInfo);
        root.addNode(7071, (ViewInfo)viewInfo);
        root.addNode(7072, (ViewInfo)viewInfo);
        root.addNode(7073, (ViewInfo)viewInfo);
        root.addNode(7075, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(3072, 2, "Activity");
        root.addNode(7050, (ViewInfo)viewInfo);
        root.addNode(7051, (ViewInfo)viewInfo);
        root.addNode(7052, (ViewInfo)viewInfo);
        root.addNode(7053, (ViewInfo)viewInfo);
        root.addNode(7054, (ViewInfo)viewInfo);
        root.addNode(7055, (ViewInfo)viewInfo);
        root.addNode(7056, (ViewInfo)viewInfo);
        root.addNode(7057, (ViewInfo)viewInfo);
        root.addNode(7058, (ViewInfo)viewInfo);
        root.addNode(7059, (ViewInfo)viewInfo);
        root.addNode(7060, (ViewInfo)viewInfo);
        root.addNode(7063, (ViewInfo)viewInfo);
        root.addNode(7064, (ViewInfo)viewInfo);
        root.addNode(7065, (ViewInfo)viewInfo);
        root.addNode(7066, (ViewInfo)viewInfo);
        root.addNode(7067, (ViewInfo)viewInfo);
        root.addNode(7068, (ViewInfo)viewInfo);
        root.addNode(7069, (ViewInfo)viewInfo);
        root.addNode(7070, (ViewInfo)viewInfo);
        root.addNode(7071, (ViewInfo)viewInfo);
        root.addNode(7072, (ViewInfo)viewInfo);
        root.addNode(7073, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(3073, 2, "Interaction");
        root.addNode(7050, (ViewInfo)viewInfo);
        root.addNode(7051, (ViewInfo)viewInfo);
        root.addNode(7052, (ViewInfo)viewInfo);
        root.addNode(7053, (ViewInfo)viewInfo);
        root.addNode(7054, (ViewInfo)viewInfo);
        root.addNode(7055, (ViewInfo)viewInfo);
        root.addNode(7056, (ViewInfo)viewInfo);
        root.addNode(7057, (ViewInfo)viewInfo);
        root.addNode(7058, (ViewInfo)viewInfo);
        root.addNode(7059, (ViewInfo)viewInfo);
        root.addNode(7060, (ViewInfo)viewInfo);
        root.addNode(7063, (ViewInfo)viewInfo);
        root.addNode(7064, (ViewInfo)viewInfo);
        root.addNode(7065, (ViewInfo)viewInfo);
        root.addNode(7066, (ViewInfo)viewInfo);
        root.addNode(7067, (ViewInfo)viewInfo);
        root.addNode(7068, (ViewInfo)viewInfo);
        root.addNode(7069, (ViewInfo)viewInfo);
        root.addNode(7070, (ViewInfo)viewInfo);
        root.addNode(7071, (ViewInfo)viewInfo);
        root.addNode(7072, (ViewInfo)viewInfo);
        root.addNode(7073, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(3074, 2, "ProtocolStateMachine");
        root.addNode(7050, (ViewInfo)viewInfo);
        root.addNode(7051, (ViewInfo)viewInfo);
        root.addNode(7052, (ViewInfo)viewInfo);
        root.addNode(7053, (ViewInfo)viewInfo);
        root.addNode(7054, (ViewInfo)viewInfo);
        root.addNode(7055, (ViewInfo)viewInfo);
        root.addNode(7056, (ViewInfo)viewInfo);
        root.addNode(7057, (ViewInfo)viewInfo);
        root.addNode(7058, (ViewInfo)viewInfo);
        root.addNode(7059, (ViewInfo)viewInfo);
        root.addNode(7060, (ViewInfo)viewInfo);
        root.addNode(7063, (ViewInfo)viewInfo);
        root.addNode(7064, (ViewInfo)viewInfo);
        root.addNode(7065, (ViewInfo)viewInfo);
        root.addNode(7066, (ViewInfo)viewInfo);
        root.addNode(7067, (ViewInfo)viewInfo);
        root.addNode(7068, (ViewInfo)viewInfo);
        root.addNode(7069, (ViewInfo)viewInfo);
        root.addNode(7070, (ViewInfo)viewInfo);
        root.addNode(7071, (ViewInfo)viewInfo);
        root.addNode(7072, (ViewInfo)viewInfo);
        root.addNode(7073, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(3075, 2, "StateMachine");
        root.addNode(7050, (ViewInfo)viewInfo);
        root.addNode(7051, (ViewInfo)viewInfo);
        root.addNode(7052, (ViewInfo)viewInfo);
        root.addNode(7053, (ViewInfo)viewInfo);
        root.addNode(7054, (ViewInfo)viewInfo);
        root.addNode(7055, (ViewInfo)viewInfo);
        root.addNode(7056, (ViewInfo)viewInfo);
        root.addNode(7057, (ViewInfo)viewInfo);
        root.addNode(7058, (ViewInfo)viewInfo);
        root.addNode(7059, (ViewInfo)viewInfo);
        root.addNode(7060, (ViewInfo)viewInfo);
        root.addNode(7063, (ViewInfo)viewInfo);
        root.addNode(7064, (ViewInfo)viewInfo);
        root.addNode(7065, (ViewInfo)viewInfo);
        root.addNode(7066, (ViewInfo)viewInfo);
        root.addNode(7067, (ViewInfo)viewInfo);
        root.addNode(7068, (ViewInfo)viewInfo);
        root.addNode(7069, (ViewInfo)viewInfo);
        root.addNode(7070, (ViewInfo)viewInfo);
        root.addNode(7071, (ViewInfo)viewInfo);
        root.addNode(7072, (ViewInfo)viewInfo);
        root.addNode(7073, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(3076, 2, "FunctionBehavior");
        root.addNode(7050, (ViewInfo)viewInfo);
        root.addNode(7051, (ViewInfo)viewInfo);
        root.addNode(7052, (ViewInfo)viewInfo);
        root.addNode(7053, (ViewInfo)viewInfo);
        root.addNode(7054, (ViewInfo)viewInfo);
        root.addNode(7055, (ViewInfo)viewInfo);
        root.addNode(7056, (ViewInfo)viewInfo);
        root.addNode(7057, (ViewInfo)viewInfo);
        root.addNode(7058, (ViewInfo)viewInfo);
        root.addNode(7059, (ViewInfo)viewInfo);
        root.addNode(7060, (ViewInfo)viewInfo);
        root.addNode(7063, (ViewInfo)viewInfo);
        root.addNode(7064, (ViewInfo)viewInfo);
        root.addNode(7065, (ViewInfo)viewInfo);
        root.addNode(7066, (ViewInfo)viewInfo);
        root.addNode(7067, (ViewInfo)viewInfo);
        root.addNode(7068, (ViewInfo)viewInfo);
        root.addNode(7069, (ViewInfo)viewInfo);
        root.addNode(7070, (ViewInfo)viewInfo);
        root.addNode(7071, (ViewInfo)viewInfo);
        root.addNode(7072, (ViewInfo)viewInfo);
        root.addNode(7073, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(3077, 2, "OpaqueBehavior");
        root.addNode(7050, (ViewInfo)viewInfo);
        root.addNode(7051, (ViewInfo)viewInfo);
        root.addNode(7052, (ViewInfo)viewInfo);
        root.addNode(7053, (ViewInfo)viewInfo);
        root.addNode(7054, (ViewInfo)viewInfo);
        root.addNode(7055, (ViewInfo)viewInfo);
        root.addNode(7056, (ViewInfo)viewInfo);
        root.addNode(7057, (ViewInfo)viewInfo);
        root.addNode(7058, (ViewInfo)viewInfo);
        root.addNode(7059, (ViewInfo)viewInfo);
        root.addNode(7060, (ViewInfo)viewInfo);
        root.addNode(7063, (ViewInfo)viewInfo);
        root.addNode(7064, (ViewInfo)viewInfo);
        root.addNode(7065, (ViewInfo)viewInfo);
        root.addNode(7066, (ViewInfo)viewInfo);
        root.addNode(7067, (ViewInfo)viewInfo);
        root.addNode(7068, (ViewInfo)viewInfo);
        root.addNode(7069, (ViewInfo)viewInfo);
        root.addNode(7070, (ViewInfo)viewInfo);
        root.addNode(7071, (ViewInfo)viewInfo);
        root.addNode(7072, (ViewInfo)viewInfo);
        root.addNode(7073, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(3081, 2, "Component");
        root.addNode(7050, (ViewInfo)viewInfo);
        root.addNode(7051, (ViewInfo)viewInfo);
        root.addNode(7052, (ViewInfo)viewInfo);
        root.addNode(7053, (ViewInfo)viewInfo);
        root.addNode(7054, (ViewInfo)viewInfo);
        root.addNode(7055, (ViewInfo)viewInfo);
        root.addNode(7056, (ViewInfo)viewInfo);
        root.addNode(7057, (ViewInfo)viewInfo);
        root.addNode(7058, (ViewInfo)viewInfo);
        root.addNode(7059, (ViewInfo)viewInfo);
        root.addNode(7060, (ViewInfo)viewInfo);
        root.addNode(7063, (ViewInfo)viewInfo);
        root.addNode(7064, (ViewInfo)viewInfo);
        root.addNode(7065, (ViewInfo)viewInfo);
        root.addNode(7066, (ViewInfo)viewInfo);
        root.addNode(7067, (ViewInfo)viewInfo);
        root.addNode(7068, (ViewInfo)viewInfo);
        root.addNode(7069, (ViewInfo)viewInfo);
        root.addNode(7070, (ViewInfo)viewInfo);
        root.addNode(7071, (ViewInfo)viewInfo);
        root.addNode(7072, (ViewInfo)viewInfo);
        root.addNode(7073, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(3082, 2, "Device");
        root.addNode(7050, (ViewInfo)viewInfo);
        root.addNode(7051, (ViewInfo)viewInfo);
        root.addNode(7052, (ViewInfo)viewInfo);
        root.addNode(7053, (ViewInfo)viewInfo);
        root.addNode(7054, (ViewInfo)viewInfo);
        root.addNode(7055, (ViewInfo)viewInfo);
        root.addNode(7056, (ViewInfo)viewInfo);
        root.addNode(7057, (ViewInfo)viewInfo);
        root.addNode(7058, (ViewInfo)viewInfo);
        root.addNode(7059, (ViewInfo)viewInfo);
        root.addNode(7060, (ViewInfo)viewInfo);
        root.addNode(7063, (ViewInfo)viewInfo);
        root.addNode(7064, (ViewInfo)viewInfo);
        root.addNode(7065, (ViewInfo)viewInfo);
        root.addNode(7066, (ViewInfo)viewInfo);
        root.addNode(7067, (ViewInfo)viewInfo);
        root.addNode(7068, (ViewInfo)viewInfo);
        root.addNode(7069, (ViewInfo)viewInfo);
        root.addNode(7070, (ViewInfo)viewInfo);
        root.addNode(7071, (ViewInfo)viewInfo);
        root.addNode(7072, (ViewInfo)viewInfo);
        root.addNode(7073, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(3083, 2, "ExecutionEnvironment");
        root.addNode(7050, (ViewInfo)viewInfo);
        root.addNode(7051, (ViewInfo)viewInfo);
        root.addNode(7052, (ViewInfo)viewInfo);
        root.addNode(7053, (ViewInfo)viewInfo);
        root.addNode(7054, (ViewInfo)viewInfo);
        root.addNode(7055, (ViewInfo)viewInfo);
        root.addNode(7056, (ViewInfo)viewInfo);
        root.addNode(7057, (ViewInfo)viewInfo);
        root.addNode(7058, (ViewInfo)viewInfo);
        root.addNode(7059, (ViewInfo)viewInfo);
        root.addNode(7060, (ViewInfo)viewInfo);
        root.addNode(7063, (ViewInfo)viewInfo);
        root.addNode(7064, (ViewInfo)viewInfo);
        root.addNode(7065, (ViewInfo)viewInfo);
        root.addNode(7066, (ViewInfo)viewInfo);
        root.addNode(7067, (ViewInfo)viewInfo);
        root.addNode(7068, (ViewInfo)viewInfo);
        root.addNode(7069, (ViewInfo)viewInfo);
        root.addNode(7070, (ViewInfo)viewInfo);
        root.addNode(7071, (ViewInfo)viewInfo);
        root.addNode(7072, (ViewInfo)viewInfo);
        root.addNode(7073, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(3084, 2, "Node");
        root.addNode(7050, (ViewInfo)viewInfo);
        root.addNode(7051, (ViewInfo)viewInfo);
        root.addNode(7052, (ViewInfo)viewInfo);
        root.addNode(7053, (ViewInfo)viewInfo);
        root.addNode(7054, (ViewInfo)viewInfo);
        root.addNode(7055, (ViewInfo)viewInfo);
        root.addNode(7056, (ViewInfo)viewInfo);
        root.addNode(7057, (ViewInfo)viewInfo);
        root.addNode(7058, (ViewInfo)viewInfo);
        root.addNode(7059, (ViewInfo)viewInfo);
        root.addNode(7060, (ViewInfo)viewInfo);
        root.addNode(7063, (ViewInfo)viewInfo);
        root.addNode(7064, (ViewInfo)viewInfo);
        root.addNode(7065, (ViewInfo)viewInfo);
        root.addNode(7066, (ViewInfo)viewInfo);
        root.addNode(7067, (ViewInfo)viewInfo);
        root.addNode(7068, (ViewInfo)viewInfo);
        root.addNode(7069, (ViewInfo)viewInfo);
        root.addNode(7070, (ViewInfo)viewInfo);
        root.addNode(7071, (ViewInfo)viewInfo);
        root.addNode(7072, (ViewInfo)viewInfo);
        root.addNode(7073, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(3085, 2, "Class");
        root.addNode(7050, (ViewInfo)viewInfo);
        root.addNode(7051, (ViewInfo)viewInfo);
        root.addNode(7052, (ViewInfo)viewInfo);
        root.addNode(7053, (ViewInfo)viewInfo);
        root.addNode(7054, (ViewInfo)viewInfo);
        root.addNode(7055, (ViewInfo)viewInfo);
        root.addNode(7056, (ViewInfo)viewInfo);
        root.addNode(7057, (ViewInfo)viewInfo);
        root.addNode(7058, (ViewInfo)viewInfo);
        root.addNode(7059, (ViewInfo)viewInfo);
        root.addNode(7060, (ViewInfo)viewInfo);
        root.addNode(7063, (ViewInfo)viewInfo);
        root.addNode(7064, (ViewInfo)viewInfo);
        root.addNode(7065, (ViewInfo)viewInfo);
        root.addNode(7066, (ViewInfo)viewInfo);
        root.addNode(7067, (ViewInfo)viewInfo);
        root.addNode(7068, (ViewInfo)viewInfo);
        root.addNode(7069, (ViewInfo)viewInfo);
        root.addNode(7070, (ViewInfo)viewInfo);
        root.addNode(7071, (ViewInfo)viewInfo);
        root.addNode(7072, (ViewInfo)viewInfo);
        root.addNode(7073, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(3086, 2, "Collaboration");
        root.addNode(7050, (ViewInfo)viewInfo);
        root.addNode(7051, (ViewInfo)viewInfo);
        root.addNode(7052, (ViewInfo)viewInfo);
        root.addNode(7053, (ViewInfo)viewInfo);
        root.addNode(7054, (ViewInfo)viewInfo);
        root.addNode(7055, (ViewInfo)viewInfo);
        root.addNode(7056, (ViewInfo)viewInfo);
        root.addNode(7057, (ViewInfo)viewInfo);
        root.addNode(7058, (ViewInfo)viewInfo);
        root.addNode(7059, (ViewInfo)viewInfo);
        root.addNode(7060, (ViewInfo)viewInfo);
        root.addNode(7063, (ViewInfo)viewInfo);
        root.addNode(7064, (ViewInfo)viewInfo);
        root.addNode(7065, (ViewInfo)viewInfo);
        root.addNode(7066, (ViewInfo)viewInfo);
        root.addNode(7067, (ViewInfo)viewInfo);
        root.addNode(7068, (ViewInfo)viewInfo);
        root.addNode(7069, (ViewInfo)viewInfo);
        root.addNode(7070, (ViewInfo)viewInfo);
        root.addNode(7071, (ViewInfo)viewInfo);
        root.addNode(7072, (ViewInfo)viewInfo);
        root.addNode(7073, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(3087, 2, "Interface");
        root.addNode(7050, (ViewInfo)viewInfo);
        root.addNode(7051, (ViewInfo)viewInfo);
        root.addNode(7052, (ViewInfo)viewInfo);
        root.addNode(7053, (ViewInfo)viewInfo);
        root.addNode(7054, (ViewInfo)viewInfo);
        root.addNode(7055, (ViewInfo)viewInfo);
        root.addNode(7056, (ViewInfo)viewInfo);
        root.addNode(7057, (ViewInfo)viewInfo);
        root.addNode(7058, (ViewInfo)viewInfo);
        root.addNode(7059, (ViewInfo)viewInfo);
        root.addNode(7060, (ViewInfo)viewInfo);
        root.addNode(7063, (ViewInfo)viewInfo);
        root.addNode(7064, (ViewInfo)viewInfo);
        root.addNode(7065, (ViewInfo)viewInfo);
        root.addNode(7066, (ViewInfo)viewInfo);
        root.addNode(7067, (ViewInfo)viewInfo);
        root.addNode(7068, (ViewInfo)viewInfo);
        root.addNode(7069, (ViewInfo)viewInfo);
        root.addNode(7070, (ViewInfo)viewInfo);
        root.addNode(7071, (ViewInfo)viewInfo);
        root.addNode(7072, (ViewInfo)viewInfo);
        root.addNode(7073, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(3078, 2, "PrimitiveType");
        root.addNode(7050, (ViewInfo)viewInfo);
        root.addNode(7051, (ViewInfo)viewInfo);
        root.addNode(7052, (ViewInfo)viewInfo);
        root.addNode(7053, (ViewInfo)viewInfo);
        root.addNode(7054, (ViewInfo)viewInfo);
        root.addNode(7055, (ViewInfo)viewInfo);
        root.addNode(7056, (ViewInfo)viewInfo);
        root.addNode(7057, (ViewInfo)viewInfo);
        root.addNode(7058, (ViewInfo)viewInfo);
        root.addNode(7059, (ViewInfo)viewInfo);
        root.addNode(7060, (ViewInfo)viewInfo);
        root.addNode(7063, (ViewInfo)viewInfo);
        root.addNode(7064, (ViewInfo)viewInfo);
        root.addNode(7065, (ViewInfo)viewInfo);
        root.addNode(7066, (ViewInfo)viewInfo);
        root.addNode(7067, (ViewInfo)viewInfo);
        root.addNode(7068, (ViewInfo)viewInfo);
        root.addNode(7069, (ViewInfo)viewInfo);
        root.addNode(7070, (ViewInfo)viewInfo);
        root.addNode(7071, (ViewInfo)viewInfo);
        root.addNode(7072, (ViewInfo)viewInfo);
        root.addNode(7073, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(3079, 2, "Enumeration");
        root.addNode(7050, (ViewInfo)viewInfo);
        root.addNode(7051, (ViewInfo)viewInfo);
        root.addNode(7052, (ViewInfo)viewInfo);
        root.addNode(7053, (ViewInfo)viewInfo);
        root.addNode(7054, (ViewInfo)viewInfo);
        root.addNode(7055, (ViewInfo)viewInfo);
        root.addNode(7056, (ViewInfo)viewInfo);
        root.addNode(7057, (ViewInfo)viewInfo);
        root.addNode(7058, (ViewInfo)viewInfo);
        root.addNode(7059, (ViewInfo)viewInfo);
        root.addNode(7060, (ViewInfo)viewInfo);
        root.addNode(7063, (ViewInfo)viewInfo);
        root.addNode(7064, (ViewInfo)viewInfo);
        root.addNode(7065, (ViewInfo)viewInfo);
        root.addNode(7066, (ViewInfo)viewInfo);
        root.addNode(7067, (ViewInfo)viewInfo);
        root.addNode(7068, (ViewInfo)viewInfo);
        root.addNode(7069, (ViewInfo)viewInfo);
        root.addNode(7070, (ViewInfo)viewInfo);
        root.addNode(7071, (ViewInfo)viewInfo);
        root.addNode(7072, (ViewInfo)viewInfo);
        root.addNode(7073, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(3080, 2, "DataType");
        root.addNode(7050, (ViewInfo)viewInfo);
        root.addNode(7051, (ViewInfo)viewInfo);
        root.addNode(7052, (ViewInfo)viewInfo);
        root.addNode(7053, (ViewInfo)viewInfo);
        root.addNode(7054, (ViewInfo)viewInfo);
        root.addNode(7055, (ViewInfo)viewInfo);
        root.addNode(7056, (ViewInfo)viewInfo);
        root.addNode(7057, (ViewInfo)viewInfo);
        root.addNode(7058, (ViewInfo)viewInfo);
        root.addNode(7059, (ViewInfo)viewInfo);
        root.addNode(7060, (ViewInfo)viewInfo);
        root.addNode(7063, (ViewInfo)viewInfo);
        root.addNode(7064, (ViewInfo)viewInfo);
        root.addNode(7065, (ViewInfo)viewInfo);
        root.addNode(7066, (ViewInfo)viewInfo);
        root.addNode(7067, (ViewInfo)viewInfo);
        root.addNode(7068, (ViewInfo)viewInfo);
        root.addNode(7069, (ViewInfo)viewInfo);
        root.addNode(7070, (ViewInfo)viewInfo);
        root.addNode(7071, (ViewInfo)viewInfo);
        root.addNode(7072, (ViewInfo)viewInfo);
        root.addNode(7073, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(3091, 2, "Actor");
        root.addNode(7050, (ViewInfo)viewInfo);
        root.addNode(7051, (ViewInfo)viewInfo);
        root.addNode(7052, (ViewInfo)viewInfo);
        root.addNode(7053, (ViewInfo)viewInfo);
        root.addNode(7054, (ViewInfo)viewInfo);
        root.addNode(7055, (ViewInfo)viewInfo);
        root.addNode(7056, (ViewInfo)viewInfo);
        root.addNode(7057, (ViewInfo)viewInfo);
        root.addNode(7058, (ViewInfo)viewInfo);
        root.addNode(7059, (ViewInfo)viewInfo);
        root.addNode(7060, (ViewInfo)viewInfo);
        root.addNode(7063, (ViewInfo)viewInfo);
        root.addNode(7064, (ViewInfo)viewInfo);
        root.addNode(7065, (ViewInfo)viewInfo);
        root.addNode(7066, (ViewInfo)viewInfo);
        root.addNode(7067, (ViewInfo)viewInfo);
        root.addNode(7068, (ViewInfo)viewInfo);
        root.addNode(7069, (ViewInfo)viewInfo);
        root.addNode(7070, (ViewInfo)viewInfo);
        root.addNode(7071, (ViewInfo)viewInfo);
        root.addNode(7072, (ViewInfo)viewInfo);
        root.addNode(7073, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(3092, 2, "DeploymentSpecification");
        root.addNode(7050, (ViewInfo)viewInfo);
        root.addNode(7051, (ViewInfo)viewInfo);
        root.addNode(7052, (ViewInfo)viewInfo);
        root.addNode(7053, (ViewInfo)viewInfo);
        root.addNode(7054, (ViewInfo)viewInfo);
        root.addNode(7055, (ViewInfo)viewInfo);
        root.addNode(7056, (ViewInfo)viewInfo);
        root.addNode(7057, (ViewInfo)viewInfo);
        root.addNode(7058, (ViewInfo)viewInfo);
        root.addNode(7059, (ViewInfo)viewInfo);
        root.addNode(7060, (ViewInfo)viewInfo);
        root.addNode(7063, (ViewInfo)viewInfo);
        root.addNode(7064, (ViewInfo)viewInfo);
        root.addNode(7065, (ViewInfo)viewInfo);
        root.addNode(7066, (ViewInfo)viewInfo);
        root.addNode(7067, (ViewInfo)viewInfo);
        root.addNode(7068, (ViewInfo)viewInfo);
        root.addNode(7069, (ViewInfo)viewInfo);
        root.addNode(7070, (ViewInfo)viewInfo);
        root.addNode(7071, (ViewInfo)viewInfo);
        root.addNode(7072, (ViewInfo)viewInfo);
        root.addNode(7073, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(3093, 2, "Artifact");
        root.addNode(7050, (ViewInfo)viewInfo);
        root.addNode(7051, (ViewInfo)viewInfo);
        root.addNode(7052, (ViewInfo)viewInfo);
        root.addNode(7053, (ViewInfo)viewInfo);
        root.addNode(7054, (ViewInfo)viewInfo);
        root.addNode(7055, (ViewInfo)viewInfo);
        root.addNode(7056, (ViewInfo)viewInfo);
        root.addNode(7057, (ViewInfo)viewInfo);
        root.addNode(7058, (ViewInfo)viewInfo);
        root.addNode(7059, (ViewInfo)viewInfo);
        root.addNode(7060, (ViewInfo)viewInfo);
        root.addNode(7063, (ViewInfo)viewInfo);
        root.addNode(7064, (ViewInfo)viewInfo);
        root.addNode(7065, (ViewInfo)viewInfo);
        root.addNode(7066, (ViewInfo)viewInfo);
        root.addNode(7067, (ViewInfo)viewInfo);
        root.addNode(7068, (ViewInfo)viewInfo);
        root.addNode(7069, (ViewInfo)viewInfo);
        root.addNode(7070, (ViewInfo)viewInfo);
        root.addNode(7071, (ViewInfo)viewInfo);
        root.addNode(7072, (ViewInfo)viewInfo);
        root.addNode(7073, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(3094, 2, "InformationItem");
        root.addNode(7050, (ViewInfo)viewInfo);
        root.addNode(7051, (ViewInfo)viewInfo);
        root.addNode(7052, (ViewInfo)viewInfo);
        root.addNode(7053, (ViewInfo)viewInfo);
        root.addNode(7054, (ViewInfo)viewInfo);
        root.addNode(7055, (ViewInfo)viewInfo);
        root.addNode(7056, (ViewInfo)viewInfo);
        root.addNode(7057, (ViewInfo)viewInfo);
        root.addNode(7058, (ViewInfo)viewInfo);
        root.addNode(7059, (ViewInfo)viewInfo);
        root.addNode(7060, (ViewInfo)viewInfo);
        root.addNode(7063, (ViewInfo)viewInfo);
        root.addNode(7064, (ViewInfo)viewInfo);
        root.addNode(7065, (ViewInfo)viewInfo);
        root.addNode(7066, (ViewInfo)viewInfo);
        root.addNode(7067, (ViewInfo)viewInfo);
        root.addNode(7068, (ViewInfo)viewInfo);
        root.addNode(7069, (ViewInfo)viewInfo);
        root.addNode(7070, (ViewInfo)viewInfo);
        root.addNode(7071, (ViewInfo)viewInfo);
        root.addNode(7072, (ViewInfo)viewInfo);
        root.addNode(7073, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(3095, 2, "Signal");
        root.addNode(7050, (ViewInfo)viewInfo);
        root.addNode(7051, (ViewInfo)viewInfo);
        root.addNode(7052, (ViewInfo)viewInfo);
        root.addNode(7053, (ViewInfo)viewInfo);
        root.addNode(7054, (ViewInfo)viewInfo);
        root.addNode(7055, (ViewInfo)viewInfo);
        root.addNode(7056, (ViewInfo)viewInfo);
        root.addNode(7057, (ViewInfo)viewInfo);
        root.addNode(7058, (ViewInfo)viewInfo);
        root.addNode(7059, (ViewInfo)viewInfo);
        root.addNode(7060, (ViewInfo)viewInfo);
        root.addNode(7063, (ViewInfo)viewInfo);
        root.addNode(7064, (ViewInfo)viewInfo);
        root.addNode(7065, (ViewInfo)viewInfo);
        root.addNode(7066, (ViewInfo)viewInfo);
        root.addNode(7067, (ViewInfo)viewInfo);
        root.addNode(7068, (ViewInfo)viewInfo);
        root.addNode(7069, (ViewInfo)viewInfo);
        root.addNode(7070, (ViewInfo)viewInfo);
        root.addNode(7071, (ViewInfo)viewInfo);
        root.addNode(7072, (ViewInfo)viewInfo);
        root.addNode(7073, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(3096, 2, "UseCase");
        root.addNode(7050, (ViewInfo)viewInfo);
        root.addNode(7051, (ViewInfo)viewInfo);
        root.addNode(7052, (ViewInfo)viewInfo);
        root.addNode(7053, (ViewInfo)viewInfo);
        root.addNode(7054, (ViewInfo)viewInfo);
        root.addNode(7055, (ViewInfo)viewInfo);
        root.addNode(7056, (ViewInfo)viewInfo);
        root.addNode(7057, (ViewInfo)viewInfo);
        root.addNode(7058, (ViewInfo)viewInfo);
        root.addNode(7059, (ViewInfo)viewInfo);
        root.addNode(7060, (ViewInfo)viewInfo);
        root.addNode(7063, (ViewInfo)viewInfo);
        root.addNode(7064, (ViewInfo)viewInfo);
        root.addNode(7065, (ViewInfo)viewInfo);
        root.addNode(7066, (ViewInfo)viewInfo);
        root.addNode(7067, (ViewInfo)viewInfo);
        root.addNode(7068, (ViewInfo)viewInfo);
        root.addNode(7069, (ViewInfo)viewInfo);
        root.addNode(7070, (ViewInfo)viewInfo);
        root.addNode(7071, (ViewInfo)viewInfo);
        root.addNode(7072, (ViewInfo)viewInfo);
        root.addNode(7073, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(3097, 2, "Comment");
        root.addNode(7050, (ViewInfo)viewInfo);
        root.addNode(7051, (ViewInfo)viewInfo);
        root.addNode(7052, (ViewInfo)viewInfo);
        root.addNode(7053, (ViewInfo)viewInfo);
        root.addNode(7054, (ViewInfo)viewInfo);
        root.addNode(7055, (ViewInfo)viewInfo);
        root.addNode(7056, (ViewInfo)viewInfo);
        root.addNode(7057, (ViewInfo)viewInfo);
        root.addNode(7058, (ViewInfo)viewInfo);
        root.addNode(7059, (ViewInfo)viewInfo);
        root.addNode(7060, (ViewInfo)viewInfo);
        root.addNode(7061, (ViewInfo)viewInfo);
        root.addNode(7063, (ViewInfo)viewInfo);
        root.addNode(7064, (ViewInfo)viewInfo);
        root.addNode(7065, (ViewInfo)viewInfo);
        root.addNode(7066, (ViewInfo)viewInfo);
        root.addNode(7067, (ViewInfo)viewInfo);
        root.addNode(7068, (ViewInfo)viewInfo);
        root.addNode(7069, (ViewInfo)viewInfo);
        root.addNode(7070, (ViewInfo)viewInfo);
        root.addNode(7071, (ViewInfo)viewInfo);
        root.addNode(7072, (ViewInfo)viewInfo);
        root.addNode(7073, (ViewInfo)viewInfo);
        root.addNode(7075, (ViewInfo)viewInfo);
        root.addNode(7077, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(3116, 2, "DurationConstraint");
        root.addNode(7050, (ViewInfo)viewInfo);
        root.addNode(7051, (ViewInfo)viewInfo);
        root.addNode(7052, (ViewInfo)viewInfo);
        root.addNode(7053, (ViewInfo)viewInfo);
        root.addNode(7054, (ViewInfo)viewInfo);
        root.addNode(7055, (ViewInfo)viewInfo);
        root.addNode(7056, (ViewInfo)viewInfo);
        root.addNode(7057, (ViewInfo)viewInfo);
        root.addNode(7058, (ViewInfo)viewInfo);
        root.addNode(7059, (ViewInfo)viewInfo);
        root.addNode(7060, (ViewInfo)viewInfo);
        root.addNode(7061, (ViewInfo)viewInfo);
        root.addNode(7063, (ViewInfo)viewInfo);
        root.addNode(7064, (ViewInfo)viewInfo);
        root.addNode(7065, (ViewInfo)viewInfo);
        root.addNode(7066, (ViewInfo)viewInfo);
        root.addNode(7067, (ViewInfo)viewInfo);
        root.addNode(7068, (ViewInfo)viewInfo);
        root.addNode(7069, (ViewInfo)viewInfo);
        root.addNode(7070, (ViewInfo)viewInfo);
        root.addNode(7071, (ViewInfo)viewInfo);
        root.addNode(7072, (ViewInfo)viewInfo);
        root.addNode(7073, (ViewInfo)viewInfo);
        root.addNode(7075, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(3117, 2, "TimeConstraint");
        root.addNode(7050, (ViewInfo)viewInfo);
        root.addNode(7051, (ViewInfo)viewInfo);
        root.addNode(7052, (ViewInfo)viewInfo);
        root.addNode(7053, (ViewInfo)viewInfo);
        root.addNode(7054, (ViewInfo)viewInfo);
        root.addNode(7055, (ViewInfo)viewInfo);
        root.addNode(7056, (ViewInfo)viewInfo);
        root.addNode(7057, (ViewInfo)viewInfo);
        root.addNode(7058, (ViewInfo)viewInfo);
        root.addNode(7059, (ViewInfo)viewInfo);
        root.addNode(7060, (ViewInfo)viewInfo);
        root.addNode(7061, (ViewInfo)viewInfo);
        root.addNode(7063, (ViewInfo)viewInfo);
        root.addNode(7064, (ViewInfo)viewInfo);
        root.addNode(7065, (ViewInfo)viewInfo);
        root.addNode(7066, (ViewInfo)viewInfo);
        root.addNode(7067, (ViewInfo)viewInfo);
        root.addNode(7068, (ViewInfo)viewInfo);
        root.addNode(7069, (ViewInfo)viewInfo);
        root.addNode(7070, (ViewInfo)viewInfo);
        root.addNode(7071, (ViewInfo)viewInfo);
        root.addNode(7072, (ViewInfo)viewInfo);
        root.addNode(7073, (ViewInfo)viewInfo);
        root.addNode(7075, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(3118, 2, "IntervalConstraint");
        root.addNode(7050, (ViewInfo)viewInfo);
        root.addNode(7051, (ViewInfo)viewInfo);
        root.addNode(7052, (ViewInfo)viewInfo);
        root.addNode(7053, (ViewInfo)viewInfo);
        root.addNode(7054, (ViewInfo)viewInfo);
        root.addNode(7055, (ViewInfo)viewInfo);
        root.addNode(7056, (ViewInfo)viewInfo);
        root.addNode(7057, (ViewInfo)viewInfo);
        root.addNode(7058, (ViewInfo)viewInfo);
        root.addNode(7059, (ViewInfo)viewInfo);
        root.addNode(7060, (ViewInfo)viewInfo);
        root.addNode(7061, (ViewInfo)viewInfo);
        root.addNode(7063, (ViewInfo)viewInfo);
        root.addNode(7064, (ViewInfo)viewInfo);
        root.addNode(7065, (ViewInfo)viewInfo);
        root.addNode(7066, (ViewInfo)viewInfo);
        root.addNode(7067, (ViewInfo)viewInfo);
        root.addNode(7068, (ViewInfo)viewInfo);
        root.addNode(7069, (ViewInfo)viewInfo);
        root.addNode(7070, (ViewInfo)viewInfo);
        root.addNode(7071, (ViewInfo)viewInfo);
        root.addNode(7072, (ViewInfo)viewInfo);
        root.addNode(7073, (ViewInfo)viewInfo);
        root.addNode(7075, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(3119, 2, "InteractionConstraint");
        root.addNode(7050, (ViewInfo)viewInfo);
        root.addNode(7051, (ViewInfo)viewInfo);
        root.addNode(7052, (ViewInfo)viewInfo);
        root.addNode(7053, (ViewInfo)viewInfo);
        root.addNode(7054, (ViewInfo)viewInfo);
        root.addNode(7055, (ViewInfo)viewInfo);
        root.addNode(7056, (ViewInfo)viewInfo);
        root.addNode(7057, (ViewInfo)viewInfo);
        root.addNode(7058, (ViewInfo)viewInfo);
        root.addNode(7059, (ViewInfo)viewInfo);
        root.addNode(7060, (ViewInfo)viewInfo);
        root.addNode(7061, (ViewInfo)viewInfo);
        root.addNode(7063, (ViewInfo)viewInfo);
        root.addNode(7064, (ViewInfo)viewInfo);
        root.addNode(7065, (ViewInfo)viewInfo);
        root.addNode(7066, (ViewInfo)viewInfo);
        root.addNode(7067, (ViewInfo)viewInfo);
        root.addNode(7068, (ViewInfo)viewInfo);
        root.addNode(7069, (ViewInfo)viewInfo);
        root.addNode(7070, (ViewInfo)viewInfo);
        root.addNode(7071, (ViewInfo)viewInfo);
        root.addNode(7072, (ViewInfo)viewInfo);
        root.addNode(7073, (ViewInfo)viewInfo);
        root.addNode(7075, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(3120, 2, "Constraint");
        root.addNode(7073, (ViewInfo)viewInfo);
        root.addNode(7050, (ViewInfo)viewInfo);
        root.addNode(7051, (ViewInfo)viewInfo);
        root.addNode(7052, (ViewInfo)viewInfo);
        root.addNode(7053, (ViewInfo)viewInfo);
        root.addNode(7054, (ViewInfo)viewInfo);
        root.addNode(7055, (ViewInfo)viewInfo);
        root.addNode(7056, (ViewInfo)viewInfo);
        root.addNode(7057, (ViewInfo)viewInfo);
        root.addNode(7058, (ViewInfo)viewInfo);
        root.addNode(7059, (ViewInfo)viewInfo);
        root.addNode(7060, (ViewInfo)viewInfo);
        root.addNode(7061, (ViewInfo)viewInfo);
        root.addNode(7063, (ViewInfo)viewInfo);
        root.addNode(7064, (ViewInfo)viewInfo);
        root.addNode(7065, (ViewInfo)viewInfo);
        root.addNode(7066, (ViewInfo)viewInfo);
        root.addNode(7067, (ViewInfo)viewInfo);
        root.addNode(7068, (ViewInfo)viewInfo);
        root.addNode(7069, (ViewInfo)viewInfo);
        root.addNode(7070, (ViewInfo)viewInfo);
        root.addNode(7071, (ViewInfo)viewInfo);
        root.addNode(7072, (ViewInfo)viewInfo);
        root.addNode(7075, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(3101, 2, "Property");
        root.addNode(7033, (ViewInfo)viewInfo);
        root.addNode(7036, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(3102, 2, "Operation");
        root.addNode(7034, (ViewInfo)viewInfo);
        root.addNode(7037, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(3100, 2, "Reception");
        viewInfo = new BaseViewInfo(3066, 2, "EnumerationLiteral");
        root.addNode(2067, (ViewInfo)viewInfo);
        root.addNode(3079, (ViewInfo)viewInfo);
        root.addNode(7049, (ViewInfo)viewInfo);
        root.addNode(7048, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(3103, 2, "Activity");
        viewInfo = new BaseViewInfo(3104, 2, "Interaction");
        viewInfo = new BaseViewInfo(3105, 2, "ProtocolStateMachine");
        viewInfo = new BaseViewInfo(3106, 2, "StateMachine");
        viewInfo = new BaseViewInfo(3107, 2, "FunctionBehavior");
        viewInfo = new BaseViewInfo(3108, 2, "OpaqueBehavior");
        viewInfo = new BaseViewInfo(3109, 2, "Collaboration");
        viewInfo = new BaseViewInfo(3110, 2, "Interface");
        viewInfo = new BaseViewInfo(3111, 2, "Enumeration");
        viewInfo = new BaseViewInfo(3112, 2, "PrimitiveType");
        viewInfo = new BaseViewInfo(3113, 2, "DataType");
        viewInfo = new BaseViewInfo(3114, 2, "Class");
        return root;
    }
}

