/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.UMLBaseItemSemanticEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.util.CommandHelper;
import org.eclipse.papyrus.uml.diagram.sequence.util.MessageConnectionHelper;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageSort;

public class Message6CreateCommand
extends EditElementCommand {
    protected final EObject source;
    protected final EObject target;
    protected Interaction container;

    public Message6CreateCommand(CreateRelationshipRequest request, EObject source, EObject target) {
        super(request.getLabel(), null, (IEditCommandRequest)request);
        this.source = source;
        this.target = target;
        this.container = this.deduceContainer(source, target);
    }

    public boolean canExecute() {
        if (this.source == null && this.target == null) {
            return false;
        }
        if (this.source != null && !(this.source instanceof Element)) {
            return false;
        }
        if (this.target != null && !(this.target instanceof Element)) {
            return false;
        }
        if (this.getSource() == null) {
            return true;
        }
        if (this.getContainer() == null) {
            return false;
        }
        if (this.getSource() != null && this.getTarget() != null && !CommandHelper.hasValidContainer(this.getRequest())) {
            return false;
        }
        if (!UMLBaseItemSemanticEditPolicy.getLinkConstraints().canCreateMessage_4008(this.getContainer(), this.getSource(), this.getTarget())) {
            return false;
        }
        return MessageConnectionHelper.canExist(MessageSort.ASYNCH_SIGNAL_LITERAL, this.getSource(), null);
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in create link command");
        }
        InteractionFragment sourceContainer = (InteractionFragment)this.getRequest().getParameters().get("Source model container");
        InteractionFragment targetContainer = (InteractionFragment)this.getRequest().getParameters().get("Target model container");
        Message message = CommandHelper.doCreateMessage(this.container, MessageSort.ASYNCH_SIGNAL_LITERAL, this.getSource(), null, sourceContainer, targetContainer);
        if (message != null) {
            this.doConfigure(message, monitor, info);
            ((CreateElementRequest)this.getRequest()).setNewElement((EObject)message);
            return CommandResult.newOKCommandResult((Object)message);
        }
        return CommandResult.newErrorCommandResult((String)"There is now valid container for events");
    }

    protected void doConfigure(Message newElement, IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IElementType elementType = ((CreateElementRequest)this.getRequest()).getElementType();
        ConfigureRequest configureRequest = new ConfigureRequest(this.getEditingDomain(), (EObject)newElement, elementType);
        configureRequest.setClientContext(((CreateElementRequest)this.getRequest()).getClientContext());
        configureRequest.addParameters(this.getRequest().getParameters());
        configureRequest.setParameter("CreateRelationshipRequest.source", (Object)this.getSource());
        configureRequest.setParameter("CreateRelationshipRequest.target", (Object)this.getTarget());
        ICommand configureCommand = elementType.getEditCommand((IEditCommandRequest)configureRequest);
        if (configureCommand != null && configureCommand.canExecute()) {
            configureCommand.execute(monitor, info);
        }
    }

    protected void setElementToEdit(EObject element) {
        throw new UnsupportedOperationException();
    }

    protected Element getSource() {
        return (Element)this.source;
    }

    protected Element getTarget() {
        return (Element)this.target;
    }

    public Interaction getContainer() {
        return this.container;
    }

    protected Interaction deduceContainer(EObject source, EObject target) {
        EObject element = source;
        while (element != null) {
            if (element instanceof Interaction) {
                return (Interaction)element;
            }
            element = element.eContainer();
        }
        return null;
    }
}

