/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.parts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.RelativeLocator;
import org.eclipse.draw2d.TreeSearch;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.handles.HandleBounds;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ResizableShapeEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeConnectionRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeRequest;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.FillStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.datatype.GradientData;
import org.eclipse.papyrus.infra.emf.appearance.helper.ShadowFigureHelper;
import org.eclipse.papyrus.uml.diagram.common.figure.node.PapyrusNodeFigure;
import org.eclipse.papyrus.uml.diagram.sequence.edit.helpers.AnchorHelper;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.ExecutionSpecificationEndEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.Message3EditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.MessageEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.LifelineXYLayoutEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.providers.UMLElementTypes;
import org.eclipse.papyrus.uml.diagram.sequence.util.HighlightUtil;
import org.eclipse.swt.graphics.Color;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.UMLPackage;

public abstract class AbstractExecutionSpecificationEditPart
extends ShapeNodeEditPart {
    private List executionSpecificationEndParts;

    public AbstractExecutionSpecificationEditPart(View view) {
        super(view);
    }

    public List getChildren() {
        if (this.executionSpecificationEndParts == null) {
            this.initExecutionSpecificationEndEditPart();
        }
        return super.getChildren();
    }

    protected void initExecutionSpecificationEndEditPart() {
        this.executionSpecificationEndParts = new ArrayList();
        EObject element = this.resolveSemanticElement();
        if (!(element instanceof ExecutionSpecification)) {
            return;
        }
        ExecutionSpecification execution = (ExecutionSpecification)element;
        ExecutionSpecificationEndEditPart startPart = new ExecutionSpecificationEndEditPart(execution.getStart(), this, new RelativeLocator(this.getFigure(), 1));
        this.executionSpecificationEndParts.add(startPart);
        ExecutionSpecificationEndEditPart finishPart = new ExecutionSpecificationEndEditPart(execution.getFinish(), this, new RelativeLocator(this.getFigure(), 4));
        this.executionSpecificationEndParts.add(finishPart);
        Diagram diagram = ((View)this.getModel()).getDiagram();
        startPart.rebuildLinks(diagram);
        finishPart.rebuildLinks(diagram);
        this.addChild((EditPart)startPart, -1);
        this.addChild((EditPart)finishPart, -1);
    }

    protected NodeFigure createNodePlate() {
        DefaultSizeNodeFigure result = new DefaultSizeNodeFigure(16, 60){

            protected boolean isDefaultAnchorArea(PrecisionPoint p) {
                return false;
            }
        };
        result.setMinimumSize(new Dimension(this.getMapMode().DPtoLP(16), this.getMapMode().DPtoLP(20)));
        return result;
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("PrimaryDrag Policy", (EditPolicy)new ResizableShapeEditPolicy(){

            protected Command getResizeCommand(ChangeBoundsRequest request) {
                EditPart host = this.getHost();
                List<ShapeNodeEditPart> movedChildrenParts = LifelineXYLayoutEditPolicy.getAffixedExecutionSpecificationEditParts((ShapeNodeEditPart)host);
                Rectangle r = this.getInitialFeedbackBounds().getCopy();
                this.getHostFigure().translateToAbsolute((Translatable)r);
                r.translate(0, request.getMoveDelta().y);
                r.resize(0, request.getSizeDelta().height);
                for (ShapeNodeEditPart child : movedChildrenParts) {
                    IFigure figure = child.getFigure();
                    Rectangle rect = figure.getBounds().getCopy();
                    if (figure instanceof HandleBounds) {
                        rect = ((HandleBounds)figure).getBounds().getCopy();
                    }
                    figure.translateToAbsolute((Translatable)rect);
                    if (rect.y >= r.y && r.bottom() >= rect.y) continue;
                    return UnexecutableCommand.INSTANCE;
                }
                return super.getResizeCommand(request);
            }

            protected void showChangeBoundsFeedback(ChangeBoundsRequest request) {
                request.getMoveDelta().x = 0;
                IFigure feedback = this.getDragSourceFeedbackFigure();
                PrecisionRectangle rect = new PrecisionRectangle(this.getInitialFeedbackBounds().getCopy());
                this.getHostFigure().translateToAbsolute((Translatable)rect);
                IFigure f = this.getHostFigure();
                Dimension min = f.getMinimumSize().getCopy();
                Dimension max = f.getMaximumSize().getCopy();
                IMapMode mmode = MapModeUtil.getMapMode((IFigure)f);
                min.height = mmode.LPtoDP(min.height);
                min.width = mmode.LPtoDP(min.width);
                max.height = mmode.LPtoDP(max.height);
                max.width = mmode.LPtoDP(max.width);
                Rectangle originalBounds = rect.getCopy();
                rect.translate(request.getMoveDelta());
                rect.resize(request.getSizeDelta());
                if (min.width > rect.width) {
                    rect.width = min.width;
                } else if (max.width < rect.width) {
                    rect.width = max.width;
                }
                if (min.height > rect.height) {
                    rect.height = min.height;
                } else if (max.height < rect.height) {
                    rect.height = max.height;
                }
                if (rect.height == min.height && request.getSizeDelta().height < 0 && request.getMoveDelta().y > 0) {
                    Point loc = rect.getLocation();
                    loc.y = originalBounds.getBottom().y - min.height;
                    rect.setLocation(loc);
                    request.getSizeDelta().height = min.height - originalBounds.height;
                    request.getMoveDelta().y = loc.y - originalBounds.y;
                }
                if (request.getSizeDelta().height == 0) {
                    ShapeNodeEditPart parentBar = AbstractExecutionSpecificationEditPart.this.moveExecutionSpecificationFeedback(request, AbstractExecutionSpecificationEditPart.this, rect);
                    if (parentBar == null) {
                        parentBar = AbstractExecutionSpecificationEditPart.this.getParent();
                    }
                    HighlightUtil.unhighlight();
                    HighlightUtil.highlight((EditPart)parentBar);
                }
                feedback.translateToRelative((Translatable)rect);
                feedback.setBounds((Rectangle)rect);
            }

            protected void eraseChangeBoundsFeedback(ChangeBoundsRequest request) {
                super.eraseChangeBoundsFeedback(request);
                HighlightUtil.unhighlight();
            }
        });
    }

    protected void setLineWidth(int width) {
        if (this.getPrimaryShape() instanceof NodeFigure) {
            this.getPrimaryShape().setLineWidth(width);
        }
    }

    protected final void refreshShadow() {
        this.getPrimaryShape().setShadow(ShadowFigureHelper.getShadowFigureValue((EModelElement)((View)this.getModel())));
    }

    protected void setTransparency(int transp) {
        this.getPrimaryShape().setTransparency(transp);
    }

    protected void setBackgroundColor(Color color) {
        this.getPrimaryShape().setBackgroundColor(color);
        this.getPrimaryShape().setIsUsingGradient(false);
        this.getPrimaryShape().setGradientData(-1, -1, 0);
    }

    protected void setGradient(GradientData gradient) {
        ExecutionSpecificationRectangleFigure fig = this.getPrimaryShape();
        FillStyle style = (FillStyle)this.getPrimaryView().getStyle(NotationPackage.Literals.FILL_STYLE);
        if (gradient != null) {
            fig.setIsUsingGradient(true);
            fig.setGradientData(style.getFillColor(), gradient.getGradientColor1(), gradient.getGradientStyle());
        } else {
            fig.setIsUsingGradient(false);
        }
    }

    public boolean supportsGradient() {
        return true;
    }

    protected void handleNotificationEvent(Notification event) {
        super.handleNotificationEvent(event);
        Object feature = event.getFeature();
        if (this.getModel() != null && this.getModel() == event.getNotifier()) {
            if (NotationPackage.eINSTANCE.getLineStyle_LineWidth().equals(feature)) {
                this.refreshLineWidth();
            } else if (NotationPackage.eINSTANCE.getLineTypeStyle_LineType().equals(feature)) {
                this.refreshLineType();
            }
        } else if (NotationPackage.eINSTANCE.getLocation_X().equals(feature) || NotationPackage.eINSTANCE.getLocation_Y().equals(feature) || NotationPackage.eINSTANCE.getSize_Height().equals(feature) || NotationPackage.eINSTANCE.getSize_Width().equals(feature)) {
            this.getParent().refresh();
        } else if (UMLPackage.eINSTANCE.getExecutionSpecification_Finish().equals(feature) || UMLPackage.eINSTANCE.getExecutionSpecification_Start().equals(feature)) {
            if (this.executionSpecificationEndParts != null) {
                for (Object child : this.executionSpecificationEndParts) {
                    this.removeChild((EditPart)child);
                }
                this.executionSpecificationEndParts = null;
            }
            this.refreshChildren();
        }
        this.refreshShadow();
    }

    public abstract ExecutionSpecificationRectangleFigure getPrimaryShape();

    /*
     * Unable to fully structure code
     */
    protected ShapeNodeEditPart moveExecutionSpecificationFeedback(ChangeBoundsRequest request, AbstractExecutionSpecificationEditPart movedPart, PrecisionRectangle rect) {
        block3: {
            lifelineEP = (LifelineEditPart)movedPart.getParent();
            copy = rect.getCopy();
            lifelineEP.getPrimaryShape().translateToRelative((Translatable)copy);
            executionSpecificationList = lifelineEP.getChildShapeNodeEditPart();
            movedChildrenParts = LifelineXYLayoutEditPolicy.getAffixedExecutionSpecificationEditParts(this);
            executionSpecificationList.remove((Object)movedPart);
            executionSpecificationList.removeAll(movedChildrenParts);
            parentBar = LifelineXYLayoutEditPolicy.getParent(lifelineEP, copy, executionSpecificationList);
            dotLineBounds = lifelineEP.getPrimaryShape().getFigureLifelineDotLineFigure().getBounds();
            dotLineBarLocationX = dotLineBounds.x + dotLineBounds.width / 2 - 8;
            if (parentBar != null) ** GOTO lbl29
            if (dotLineBarLocationX >= copy.x) break block3;
            dx = dotLineBarLocationX - copy.x;
            request.getMoveDelta().x += dx;
            rect.x += dx;
            break block3;
lbl-1000:
            // 1 sources

            {
                parentBounds = parentBar.getFigure().getBounds();
                width = parentBounds.width > 0 ? parentBounds.width : 16;
                x = parentBounds.x + width / 2 + 1;
                dx = x - copy.x;
                rect.x += dx;
                request.getMoveDelta().x += dx;
                copy.x = x;
                part = LifelineXYLayoutEditPolicy.getParent(lifelineEP, copy, executionSpecificationList);
                if (part == parentBar) break;
                parentBar = part;
lbl29:
                // 2 sources

                ** while (!executionSpecificationList.isEmpty())
            }
        }
        return parentBar;
    }

    public Command getCommand(Request request) {
        if (request instanceof CreateUnspecifiedTypeRequest) {
            return this.getParent().getCommand(request);
        }
        return super.getCommand(request);
    }

    public void showSourceFeedback(Request request) {
        if (request instanceof CreateUnspecifiedTypeRequest) {
            this.getParent().showSourceFeedback(request);
        }
        super.showSourceFeedback(request);
    }

    public void eraseSourceFeedback(Request request) {
        if (request instanceof CreateUnspecifiedTypeRequest) {
            this.getParent().eraseSourceFeedback(request);
        }
        super.eraseSourceFeedback(request);
    }

    public void showTargetFeedback(Request request) {
        if (request instanceof CreateUnspecifiedTypeRequest) {
            this.getParent().showTargetFeedback(request);
        }
        super.showTargetFeedback(request);
    }

    public void eraseTargetFeedback(Request request) {
        if (request instanceof CreateUnspecifiedTypeRequest) {
            this.getParent().eraseTargetFeedback(request);
        }
        super.eraseTargetFeedback(request);
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        ReconnectRequest reconnectRequest;
        ConnectionEditPart connectionEditPart;
        if (request instanceof CreateUnspecifiedTypeConnectionRequest) {
            CreateUnspecifiedTypeConnectionRequest createRequest = (CreateUnspecifiedTypeConnectionRequest)request;
            List relationshipTypes = createRequest.getElementTypes();
            for (Object obj : relationshipTypes) {
                if (!UMLElementTypes.Message_4003.equals(obj) || createRequest.getTargetEditPart().equals(createRequest.getSourceEditPart())) continue;
                return new AnchorHelper.FixedAnchorEx(this.getFigure(), 8);
            }
        } else if (request instanceof ReconnectRequest && (connectionEditPart = (reconnectRequest = (ReconnectRequest)request).getConnectionEditPart()) instanceof MessageEditPart) {
            return new AnchorHelper.FixedAnchorEx(this.getFigure(), 8);
        }
        return super.getTargetConnectionAnchor(request);
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connEditPart) {
        if (connEditPart instanceof MessageEditPart) {
            return new AnchorHelper.FixedAnchorEx(this.getFigure(), 8);
        }
        return super.getTargetConnectionAnchor(connEditPart);
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        ReconnectRequest reconnectRequest;
        ConnectionEditPart connectionEditPart;
        if (request instanceof CreateUnspecifiedTypeConnectionRequest) {
            CreateUnspecifiedTypeConnectionRequest createRequest = (CreateUnspecifiedTypeConnectionRequest)request;
            List relationshipTypes = createRequest.getElementTypes();
            for (Object obj : relationshipTypes) {
                if (!UMLElementTypes.Message_4005.equals(obj)) continue;
                return new AnchorHelper.FixedAnchorEx(this.getFigure(), 32);
            }
        } else if (request instanceof ReconnectRequest && (connectionEditPart = (reconnectRequest = (ReconnectRequest)request).getConnectionEditPart()) instanceof Message3EditPart) {
            return new AnchorHelper.FixedAnchorEx(this.getFigure(), 32);
        }
        return super.getSourceConnectionAnchor(request);
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connEditPart) {
        if (connEditPart instanceof Message3EditPart) {
            return new AnchorHelper.FixedAnchorEx(this.getFigure(), 32);
        }
        return super.getSourceConnectionAnchor(connEditPart);
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshTransparency();
        this.refreshShadow();
    }

    public class ExecutionSpecificationRectangleFigure
    extends PapyrusNodeFigure {
        public ExecutionSpecificationRectangleFigure() {
            this.setPreferredSize(new Dimension(AbstractExecutionSpecificationEditPart.this.getMapMode().DPtoLP(16), AbstractExecutionSpecificationEditPart.this.getMapMode().DPtoLP(60)));
            this.setMinimumSize(new Dimension(AbstractExecutionSpecificationEditPart.this.getMapMode().DPtoLP(16), AbstractExecutionSpecificationEditPart.this.getMapMode().DPtoLP(20)));
        }

        public IFigure findMouseEventTargetAt(int x, int y) {
            IFigure f = this.findMouseEventTargetInDescendantsAt(x, y);
            if (f != null) {
                return f;
            }
            if (!this.containsPoint(x, y)) {
                return null;
            }
            if (this.isMouseEventTarget()) {
                return this;
            }
            return null;
        }

        public IFigure findFigureAt(int x, int y, TreeSearch search) {
            if (search.prune((IFigure)this)) {
                return null;
            }
            IFigure child = this.findDescendantAtExcluding(x, y, search);
            if (child != null) {
                return child;
            }
            if (!this.containsPoint(x, y)) {
                return null;
            }
            if (search.accept((IFigure)this)) {
                return this;
            }
            return null;
        }
    }

    static class FillParentLocator
    implements Locator {
        FillParentLocator() {
        }

        public void relocate(IFigure target) {
            target.setBounds(target.getParent().getBounds());
        }
    }
}

