/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.parts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionLocator;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.INodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.SemanticEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIDebugOptions;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIPlugin;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewAndElementRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeConnectionRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeRequest;
import org.eclipse.gmf.runtime.draw2d.ui.figures.IAnchorableFigure;
import org.eclipse.gmf.runtime.draw2d.ui.figures.IOvalAnchorableFigure;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientReferenceRelationshipRequest;
import org.eclipse.gmf.runtime.gef.ui.figures.SlidableOvalAnchor;
import org.eclipse.gmf.runtime.gef.ui.internal.figures.CircleFigure;
import org.eclipse.gmf.runtime.notation.Anchor;
import org.eclipse.gmf.runtime.notation.DecorationNode;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.impl.ShapeImpl;
import org.eclipse.papyrus.uml.diagram.sequence.edit.commands.CommentAnnotatedElementCreateCommand;
import org.eclipse.papyrus.uml.diagram.sequence.edit.commands.ConstraintConstrainedElementCreateCommand;
import org.eclipse.papyrus.uml.diagram.sequence.edit.commands.GeneralOrderingCreateCommand;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.AbstractMessageEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CommentAnnotatedElementEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.ConstraintConstrainedElementEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.GeneralOrderingEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.HighlightEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.providers.UMLElementTypes;
import org.eclipse.papyrus.uml.diagram.sequence.util.CommandHelper;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;

public class MessageEndEditPart
extends GraphicalEditPart
implements INodeEditPart {
    private static final String DUMMY_TYPE = "999999";
    private static final int DEFAULT_SIZE = 16;
    private ConnectionLocator locator;
    private MessageEnd messageEnd;
    static ViewHelper helper = new ViewHelper();

    public MessageEndEditPart(MessageEnd end, AbstractMessageEditPart parent, ConnectionLocator locator) {
        super((EObject)MessageEndEditPart.createDummyView(parent, (EObject)end));
        this.locator = locator;
        this.setParent((EditPart)parent);
        this.messageEnd = end;
        this.addToResource(parent.getNotationView(), this.getNotationView());
    }

    protected void addNotationalListeners() {
        if (this.hasNotationView()) {
            this.addListenerFilter("View", (NotificationListener)this, (EObject)((View)this.getModel()));
        }
    }

    protected List getModelSourceConnections() {
        return ViewUtil.getSourceConnectionsConnectingVisibleViews((View)((View)this.getModel()));
    }

    protected List getModelTargetConnections() {
        List list = ViewUtil.getTargetConnectionsConnectingVisibleViews((View)((View)this.getModel()));
        return list;
    }

    protected void handleNotificationEvent(Notification notification) {
        Object feature = notification.getFeature();
        if (NotationPackage.eINSTANCE.getView_SourceEdges().equals(feature)) {
            this.refreshSourceConnections();
        } else if (NotationPackage.eINSTANCE.getView_TargetEdges().equals(feature)) {
            this.refreshTargetConnections();
        } else {
            super.handleNotificationEvent(notification);
        }
    }

    private static View createDummyView(AbstractMessageEditPart parent, EObject model) {
        View view = parent.findChildByModel(model);
        if (view != null) {
            return view;
        }
        ShapeImpl node = new ShapeImpl(){

            public boolean eNotificationRequired() {
                return true;
            }
        };
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(DUMMY_TYPE);
        node.setElement(model);
        return node;
    }

    private void addToResource(final View container, final View view) {
        CommandHelper.executeCommandWithoutHistory((EditingDomain)this.getEditingDomain(), (Command)new DummyCommand(){

            public void execute() {
                ViewUtil.insertChildView((View)container, (View)view, (int)-1, (boolean)false);
            }
        }, true);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new MessageEndSemanticEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new MessageEndGraphicalNodeEditPolicy());
        this.installEditPolicy("Highlight Edit Policy", (EditPolicy)new HighlightEditPolicy(){

            protected void highlight(EditPart object) {
                super.highlight(MessageEndEditPart.this.getParent());
                HighlightEditPolicy.Indicator feedback = this.getTargetIndicator();
                Rectangle rect = MessageEndEditPart.this.getFigure().getBounds().getCopy();
                MessageEndEditPart.this.getFigure().translateToAbsolute((Translatable)rect);
                this.setFeedbackLocation((IFigure)feedback, rect.getCenter());
            }
        });
    }

    protected IFigure createFigure() {
        MessageEnd messageEnd = (MessageEnd)this.resolveSemanticElement();
        MessageEndFigure fig = new MessageEndFigure();
        fig.setForegroundColor(ColorConstants.white);
        Label tooltip = new Label();
        if (messageEnd != null) {
            tooltip.setText(messageEnd.getName());
        }
        fig.setToolTip((IFigure)tooltip);
        fig.setOpaque(false);
        return fig;
    }

    public boolean hasNotationView() {
        return true;
    }

    public ConnectionAnchor getSourceConnectionAnchor(org.eclipse.gef.ConnectionEditPart connEditPart) {
        final ConnectionEditPart connection = (ConnectionEditPart)connEditPart;
        String t = "";
        try {
            t = (String)this.getEditingDomain().runExclusive((Runnable)new RunnableWithResult.Impl(){

                public void run() {
                    Anchor a = ((Edge)connection.getModel()).getSourceAnchor();
                    if (a instanceof IdentityAnchor) {
                        this.setResult(((IdentityAnchor)a).getId());
                    } else {
                        this.setResult("");
                    }
                }
            });
        }
        catch (InterruptedException e) {
            Trace.catching((Plugin)DiagramUIPlugin.getInstance(), (String)DiagramUIDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), (String)"getSourceConnectionAnchor", (Throwable)e);
            Log.error((Plugin)DiagramUIPlugin.getInstance(), (int)9, (String)"getSourceConnectionAnchor", (Throwable)e);
        }
        IAnchorableFigure fig = (IAnchorableFigure)this.getFigure();
        return fig.getConnectionAnchor(t);
    }

    public ConnectionAnchor getTargetConnectionAnchor(org.eclipse.gef.ConnectionEditPart connEditPart) {
        final ConnectionNodeEditPart connection = (ConnectionNodeEditPart)connEditPart;
        String t = "";
        try {
            t = (String)this.getEditingDomain().runExclusive((Runnable)new RunnableWithResult.Impl(){

                public void run() {
                    Anchor a = ((Edge)connection.getModel()).getTargetAnchor();
                    if (a instanceof IdentityAnchor) {
                        this.setResult(((IdentityAnchor)a).getId());
                    } else {
                        this.setResult("");
                    }
                }
            });
        }
        catch (InterruptedException e) {
            Trace.catching((Plugin)DiagramUIPlugin.getInstance(), (String)DiagramUIDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), (String)"getTargetConnectionAnchor", (Throwable)e);
            Log.error((Plugin)DiagramUIPlugin.getInstance(), (int)9, (String)"getTargetConnectionAnchor", (Throwable)e);
        }
        IAnchorableFigure fig = (IAnchorableFigure)this.getFigure();
        ConnectionAnchor a = fig.getConnectionAnchor(t);
        return a;
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        Point pt;
        Point center = this.getFigure().getBounds().getCenter();
        this.getFigure().translateToAbsolute((Translatable)center);
        Point point = pt = ((DropRequest)request).getLocation() == null ? center : new Point(((DropRequest)request).getLocation());
        if (request instanceof CreateRequest) {
            this.getFigure().translateToRelative((Translatable)pt);
        }
        ConnectionAnchor a = ((IAnchorableFigure)this.getFigure()).getTargetConnectionAnchorAt(pt);
        return a;
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        IAnchorableFigure fig = (IAnchorableFigure)this.getFigure();
        if (request instanceof ReconnectRequest) {
            if (((DropRequest)request).getLocation() == null) {
                return fig.getSourceConnectionAnchorAt(null);
            }
            Point pt = ((DropRequest)request).getLocation().getCopy();
            return fig.getSourceConnectionAnchorAt(pt);
        }
        if (request instanceof DropRequest) {
            return fig.getSourceConnectionAnchorAt(((DropRequest)request).getLocation());
        }
        return fig.getSourceConnectionAnchorAt(null);
    }

    public boolean canAttachNote() {
        return true;
    }

    public String mapConnectionAnchorToTerminal(ConnectionAnchor c) {
        return ((IAnchorableFigure)this.getFigure()).getConnectionAnchorTerminal(c);
    }

    public ConnectionAnchor mapTerminalToConnectionAnchor(String terminal) {
        return ((IAnchorableFigure)this.getFigure()).getConnectionAnchor(terminal);
    }

    public void rebuildLinks(Diagram diagram) {
        helper.collectViews(diagram);
        if (this.messageEnd == null) {
            return;
        }
        EAnnotation annotation = this.messageEnd.getEAnnotation("Connections");
        if (annotation != null) {
            block0: for (EObject eo : annotation.getReferences()) {
                View view = helper.findView(eo);
                if (view == null) continue;
                EList edges = view.getSourceEdges();
                for (Object o : edges) {
                    if (!(o instanceof Edge) || ((Edge)o).getTarget() != null) continue;
                    this.restoreEdgeTarget((Edge)o);
                    continue block0;
                }
            }
        }
    }

    private void restoreEdgeTarget(final Edge edge) {
        AbstractCommand c = new AbstractCommand(){

            public void execute() {
                edge.setTarget((View)MessageEndEditPart.this.getModel());
            }

            public void redo() {
            }

            public void undo() {
            }

            protected boolean prepare() {
                return true;
            }
        };
        CommandHelper.executeCommandWithoutHistory((EditingDomain)this.getEditingDomain(), (Command)c, true);
    }

    public EditPart getTargetEditPart(Request request) {
        if (request instanceof CreateUnspecifiedTypeConnectionRequest) {
            List types = ((CreateUnspecifiedTypeConnectionRequest)request).getElementTypes();
            if (types.contains(UMLElementTypes.CommentAnnotatedElement_4010) || types.contains(UMLElementTypes.ConstraintConstrainedElement_4011) || types.contains(UMLElementTypes.GeneralOrdering_4012)) {
                return super.getTargetEditPart(request);
            }
        } else if (request instanceof ReconnectRequest) {
            org.eclipse.gef.ConnectionEditPart con = ((ReconnectRequest)request).getConnectionEditPart();
            if (con instanceof CommentAnnotatedElementEditPart || con instanceof ConstraintConstrainedElementEditPart || con instanceof GeneralOrderingEditPart) {
                return super.getTargetEditPart(request);
            }
        } else {
            if ("annotated link end".equals(request.getType()) || "annotated link reorient end".equals(request.getType())) {
                return super.getTargetEditPart(request);
            }
            if (request instanceof CreateUnspecifiedTypeRequest && ((CreateUnspecifiedTypeRequest)request).getElementTypes().contains(UMLElementTypes.TimeConstraint_3019)) {
                return super.getTargetEditPart(request);
            }
        }
        if ("selection" == request.getType() && this.isSelectable()) {
            return this;
        }
        return null;
    }

    static class CommentAnnotatedElementCreateCommandEx
    extends CommentAnnotatedElementCreateCommand {
        public CommentAnnotatedElementCreateCommandEx(CreateRelationshipRequest request, EObject source, EObject target) {
            super(request, source, target);
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            CommandResult res = super.doExecuteWithResult(monitor, info);
            if (this.getTarget() instanceof MessageEnd) {
                MessageEndHelper.addConnectionSourceToMessageEnd((MessageEnd)this.getTarget(), (EObject)this.getSource());
            }
            return res;
        }
    }

    static class ConstraintConstrainedElementCreateCommandEx
    extends ConstraintConstrainedElementCreateCommand {
        public ConstraintConstrainedElementCreateCommandEx(CreateRelationshipRequest request, EObject source, EObject target) {
            super(request, source, target);
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            CommandResult res = super.doExecuteWithResult(monitor, info);
            if (this.getTarget() instanceof MessageEnd) {
                MessageEndHelper.addConnectionSourceToMessageEnd((MessageEnd)this.getTarget(), (EObject)this.getSource());
            }
            return res;
        }
    }

    static class DummyCommand
    extends AbstractCommand {
        DummyCommand() {
        }

        public void execute() {
        }

        public void redo() {
        }

        public void undo() {
        }

        protected boolean prepare() {
            return true;
        }
    }

    static class MessageEndAnchor
    extends SlidableOvalAnchor {
        public MessageEndAnchor(CircleFigure circleFigure, PrecisionPoint p) {
            super((IOvalAnchorableFigure)circleFigure, p);
        }

        public MessageEndAnchor(CircleFigure circleFigure) {
            super((IOvalAnchorableFigure)circleFigure);
        }

        public Point getLocation(Point reference) {
            return this.getBox().getCenter();
        }
    }

    class MessageEndFigure
    extends CircleFigure {
        MessageEndFigure() {
            super(16, 16);
        }

        protected void paintFigure(Graphics g) {
            Rectangle r = Rectangle.SINGLETON;
            r.setBounds(this.getBounds());
            --r.width;
            --r.height;
        }

        protected ConnectionAnchor createAnchor(PrecisionPoint p) {
            if (p == null) {
                return this.createDefaultAnchor();
            }
            return new MessageEndAnchor(this, p);
        }

        protected ConnectionAnchor createDefaultAnchor() {
            return new MessageEndAnchor(this);
        }

        public void validate() {
            MessageEndEditPart.this.locator.relocate((IFigure)this);
            super.validate();
        }

        public ConnectionAnchor getTargetConnectionAnchorAt(Point p) {
            try {
                return super.getTargetConnectionAnchorAt(p);
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    static class MessageEndGraphicalNodeEditPolicy
    extends GraphicalNodeEditPolicy {
        MessageEndGraphicalNodeEditPolicy() {
        }

        protected Connection createDummyConnection(Request req) {
            Connection conn = super.createDummyConnection(req);
            conn.setForegroundColor(ColorConstants.black);
            return conn;
        }

        protected org.eclipse.gef.commands.Command getConnectionAndRelationshipCreateCommand(CreateConnectionViewAndElementRequest request) {
            Map extendedData = request.getExtendedData();
            String requestHint = request.getConnectionViewAndElementDescriptor().getSemanticHint();
            if (((IHintedType)UMLElementTypes.GeneralOrdering_4012).getSemanticHint().equals(requestHint) && this.getHost() instanceof MessageEndEditPart) {
                ArrayList<MessageOccurrenceSpecification> events = new ArrayList<MessageOccurrenceSpecification>(2);
                MessageOccurrenceSpecification messageEnd = (MessageOccurrenceSpecification)((MessageEndEditPart)this.getHost()).resolveSemanticElement();
                events.add(messageEnd);
                extendedData.put("Nearest occurrence specification", events);
                extendedData.put("Nearest occurrence specification location", request.getLocation());
            }
            return super.getConnectionAndRelationshipCreateCommand(request);
        }

        protected org.eclipse.gef.commands.Command getConnectionAndRelationshipCompleteCommand(CreateConnectionViewAndElementRequest request) {
            Map extendedData = request.getExtendedData();
            String requestHint = request.getConnectionViewAndElementDescriptor().getSemanticHint();
            if (((IHintedType)UMLElementTypes.GeneralOrdering_4012).getSemanticHint().equals(requestHint) && this.getHost() instanceof MessageEndEditPart) {
                ArrayList<MessageOccurrenceSpecification> events = new ArrayList<MessageOccurrenceSpecification>(2);
                MessageOccurrenceSpecification messageEnd = (MessageOccurrenceSpecification)((MessageEndEditPart)this.getHost()).resolveSemanticElement();
                events.add(messageEnd);
                extendedData.put("Nearest occurrence specification (end)", events);
                extendedData.put("Nearest occurrence specification location (end)", request.getLocation());
            }
            return super.getConnectionAndRelationshipCompleteCommand(request);
        }
    }

    public static class MessageEndHelper {
        public static void removeConnectionSourceFromMessageEnd(MessageEnd messageEnd, EObject connectionSource) {
            EAnnotation annotation = messageEnd.getEAnnotation("Connections");
            if (annotation != null) {
                annotation.getReferences().remove((Object)connectionSource);
            }
        }

        public static void addConnectionSourceToMessageEnd(MessageEnd messageEnd, EObject connectionSource) {
            EAnnotation annotation = messageEnd.getEAnnotation("Connections");
            if (annotation == null) {
                annotation = EcoreFactory.eINSTANCE.createEAnnotation();
                annotation.setSource("Connections");
                messageEnd.getEAnnotations().add((Object)annotation);
            }
            if (!annotation.getReferences().contains((Object)connectionSource)) {
                annotation.getReferences().add((Object)connectionSource);
            }
        }
    }

    static class MessageEndSemanticEditPolicy
    extends SemanticEditPolicy {
        MessageEndSemanticEditPolicy() {
        }

        protected org.eclipse.gef.commands.Command getSemanticCommand(IEditCommandRequest request) {
            if (request instanceof CreateRelationshipRequest) {
                return this.getCreateRelationshipCommand((CreateRelationshipRequest)request);
            }
            if (request instanceof ReorientReferenceRelationshipRequest) {
                return this.getGEFWrapper((ICommand)new ReorientMessageEndCommand((ReorientReferenceRelationshipRequest)request));
            }
            org.eclipse.gef.commands.Command cmd = super.getSemanticCommand(request);
            return cmd;
        }

        protected org.eclipse.gef.commands.Command getStartCreateRelationshipCommand(CreateRelationshipRequest req) {
            if (UMLElementTypes.ConstraintConstrainedElement_4011 == req.getElementType()) {
                return this.getGEFWrapper((ICommand)new ConstraintConstrainedElementCreateCommandEx(req, req.getSource(), req.getTarget()));
            }
            if (UMLElementTypes.GeneralOrdering_4012 == req.getElementType()) {
                return this.getGEFWrapper((ICommand)new GeneralOrderingCreateCommand(req, req.getSource(), req.getTarget()));
            }
            return null;
        }

        protected org.eclipse.gef.commands.Command getCompleteCreateRelationshipCommand(CreateRelationshipRequest req) {
            if (UMLElementTypes.ConstraintConstrainedElement_4011 == req.getElementType()) {
                return this.getGEFWrapper((ICommand)new ConstraintConstrainedElementCreateCommandEx(req, req.getSource(), req.getTarget()));
            }
            if (UMLElementTypes.CommentAnnotatedElement_4010 == req.getElementType()) {
                return this.getGEFWrapper((ICommand)new CommentAnnotatedElementCreateCommandEx(req, req.getSource(), req.getTarget()));
            }
            if (UMLElementTypes.GeneralOrdering_4012 == req.getElementType()) {
                return this.getGEFWrapper((ICommand)new GeneralOrderingCreateCommand(req, req.getSource(), req.getTarget()));
            }
            return null;
        }

        protected org.eclipse.gef.commands.Command getCreateRelationshipCommand(CreateRelationshipRequest req) {
            org.eclipse.gef.commands.Command command = req.getTarget() == null ? this.getStartCreateRelationshipCommand(req) : this.getCompleteCreateRelationshipCommand(req);
            return command;
        }

        protected final org.eclipse.gef.commands.Command getGEFWrapper(ICommand cmd) {
            return new ICommandProxy(cmd);
        }
    }

    static class ReorientMessageEndCommand
    extends EditElementCommand {
        private ReorientReferenceRelationshipRequest request;

        public ReorientMessageEndCommand(ReorientReferenceRelationshipRequest request) {
            super(request.getLabel(), request.getNewRelationshipEnd(), (IEditCommandRequest)request);
            this.request = request;
        }

        public boolean canExecute() {
            return true;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (this.request.getNewRelationshipEnd() instanceof MessageEnd) {
                MessageEndHelper.addConnectionSourceToMessageEnd((MessageEnd)this.request.getNewRelationshipEnd(), this.request.getReferenceOwner());
                if (this.request.getReferenceOwner() instanceof Constraint) {
                    ((Constraint)this.request.getReferenceOwner()).getConstrainedElements().add((Object)((MessageEnd)this.request.getNewRelationshipEnd()));
                } else if (this.request.getReferenceOwner() instanceof Comment) {
                    ((Comment)this.request.getReferenceOwner()).getAnnotatedElements().add((Object)((MessageEnd)this.request.getNewRelationshipEnd()));
                }
            }
            if (this.request.getOldRelationshipEnd() instanceof MessageEnd) {
                MessageEndHelper.removeConnectionSourceFromMessageEnd((MessageEnd)this.request.getOldRelationshipEnd(), this.request.getReferenceOwner());
                if (this.request.getReferenceOwner() instanceof Constraint) {
                    ((Constraint)this.request.getReferenceOwner()).getConstrainedElements().remove((Object)((MessageEnd)this.request.getOldRelationshipEnd()));
                } else if (this.request.getReferenceOwner() instanceof Comment) {
                    ((Comment)this.request.getReferenceOwner()).getAnnotatedElements().remove((Object)((MessageEnd)this.request.getOldRelationshipEnd()));
                }
            }
            return CommandResult.newOKCommandResult();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ViewHelper {
        Diagram diagram = null;
        Set<View> allViews = new HashSet<View>();
        Map<EObject, View> viewMaps = new HashMap<EObject, View>();

        ViewHelper() {
        }

        View findView(EObject key) {
            return this.viewMaps.get(key);
        }

        void collectViews(Diagram d) {
            if (this.diagram != d) {
                this.diagram = d;
                this.allViews.clear();
                this.viewMaps.clear();
                ViewHelper.getAllNestedViews((View)this.diagram, this.allViews);
                for (View v : this.allViews) {
                    if (v instanceof DecorationNode) continue;
                    this.viewMaps.put(v.getElement(), v);
                }
            }
        }

        private static void getAllNestedViews(View view, Set<View> allViews) {
            for (View childView : view.getChildren()) {
                ViewHelper.getAllNestedViews(childView, allViews);
                allViews.add(childView);
            }
        }
    }
}

