/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.policies;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Connection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.sequence.command.AnnotatedLinkEditCommand;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.AnnotatedLinkEditPart;
import org.eclipse.uml2.uml.TimeObservation;

public class AnnotatedLinkStartEditPolicy
extends GraphicalNodeEditPolicy {
    public static final String ANNOTATED_LINK_START_ROLE = "Annotated Link Start Edit Policy";
    public static final String REQ_ANNOTATED_LINK_START = "annotated link start";
    public static final String REQ_ANNOTATED_LINK_REORIENT_START = "annotated link reorient start";

    public EditPart getTargetEditPart(Request request) {
        if (REQ_ANNOTATED_LINK_START.equals(request.getType()) || REQ_ANNOTATED_LINK_REORIENT_START.equals(request.getType())) {
            return this.getHost();
        }
        return null;
    }

    public Command getCommand(Request request) {
        if (REQ_ANNOTATED_LINK_START.equals(request.getType())) {
            return this.getConnectionCreateCommand((CreateConnectionRequest)request);
        }
        if (REQ_ANNOTATED_LINK_REORIENT_START.equals(request.getType())) {
            return this.getReconnectSourceCommand((ReconnectRequest)request);
        }
        return null;
    }

    public void showSourceFeedback(Request request) {
        if ("annotated link end".equals(request.getType())) {
            this.showCreationFeedback((CreateConnectionRequest)request);
        }
    }

    public void eraseSourceFeedback(Request request) {
        if ("annotated link end".equals(request.getType())) {
            this.eraseCreationFeedback((CreateConnectionRequest)request);
        }
    }

    protected Connection createDummyConnection(Request req) {
        Connection conn = super.createDummyConnection(req);
        conn.setForegroundColor(ColorConstants.black);
        return conn;
    }

    protected Command getReconnectSourceCommand(ReconnectRequest request) {
        View primaryView;
        EObject element;
        EditPart host = this.getHost();
        if (host instanceof GraphicalEditPart && (element = ViewUtil.resolveSemanticElement((View)(primaryView = ((GraphicalEditPart)host).getPrimaryView()))) instanceof TimeObservation && ((TimeObservation)element).getEvent() != null) {
            return UnexecutableCommand.INSTANCE;
        }
        ICommandProxy c = (ICommandProxy)super.getReconnectSourceCommand(request);
        if (c == null) {
            return null;
        }
        if (request.getConnectionEditPart() instanceof AnnotatedLinkEditPart) {
            CompositeCommand cc = (CompositeCommand)c.getICommand();
            AnnotatedLinkEditCommand ac = new AnnotatedLinkEditCommand(this.getEditingDomain());
            ac.setAnnotatedLink((AnnotatedLinkEditPart)request.getConnectionEditPart());
            ac.setSource(this.getHost());
            cc.add((IUndoableOperation)ac);
            return c;
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command getConnectionCreateCommand(CreateConnectionRequest request) {
        View primaryView;
        EObject element;
        EditPart host = this.getHost();
        if (host instanceof GraphicalEditPart && (element = ViewUtil.resolveSemanticElement((View)(primaryView = ((GraphicalEditPart)host).getPrimaryView()))) instanceof TimeObservation && ((TimeObservation)element).getEvent() != null) {
            return UnexecutableCommand.INSTANCE;
        }
        Command command = super.getConnectionCreateCommand(request);
        if (command instanceof ICommandProxy) {
            CompositeCommand cc = (CompositeCommand)((ICommandProxy)command).getICommand();
            AnnotatedLinkEditCommand operation = new AnnotatedLinkEditCommand(this.getEditingDomain());
            operation.setSource(this.getHost());
            cc.add((IUndoableOperation)operation);
        }
        return command;
    }

    private TransactionalEditingDomain getEditingDomain() {
        return ((IGraphicalEditPart)this.getHost()).getEditingDomain();
    }
}

