/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.policies;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CreationEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.providers.UMLElementTypes;
import org.eclipse.papyrus.uml.diagram.sequence.util.SequenceUtil;
import org.eclipse.uml2.uml.OccurrenceSpecification;

public class CreationOnMessageEditPolicy
extends CreationEditPolicy {
    protected Command getCreateElementAndViewCommand(CreateViewAndElementRequest request) {
        EditPart hostPart;
        Map extendedData = request.getExtendedData();
        String requestHint = request.getViewAndElementDescriptor().getSemanticHint();
        if (this.isCreatedOnOccurrenceSpecification(requestHint) && (hostPart = this.getHost()) instanceof ConnectionNodeEditPart) {
            EditPart object;
            LifelineEditPart sourceLifeline = SequenceUtil.getParentLifelinePart(((ConnectionNodeEditPart)hostPart).getSource());
            LifelineEditPart targetLifeline = SequenceUtil.getParentLifelinePart(((ConnectionNodeEditPart)hostPart).getTarget());
            Map.Entry<Point, List<OccurrenceSpecification>> eventAndLocation = null;
            if (sourceLifeline != null) {
                eventAndLocation = SequenceUtil.findNearestEvent(request.getLocation(), sourceLifeline);
            }
            if (targetLifeline != null && eventAndLocation == null) {
                eventAndLocation = SequenceUtil.findNearestEvent(request.getLocation(), targetLifeline);
            }
            List<Object> events = Collections.emptyList();
            Point location = null;
            if (eventAndLocation != null) {
                location = eventAndLocation.getKey();
                events = eventAndLocation.getValue();
            }
            if (extendedData.containsKey("Nearest occurrence specification (end)")) {
                extendedData.put("Nearest occurrence specification (end)", events);
            } else {
                extendedData.put("Nearest occurrence specification", events);
            }
            if (extendedData.containsKey("Nearest occurrence specification location (end)")) {
                extendedData.put("Nearest occurrence specification location (end)", location);
            } else {
                extendedData.put("Nearest occurrence specification location", location);
            }
            if (location != null && (object = this.getHost().getViewer().findObjectAtExcluding(location, Collections.emptyList(), new EditPartViewer.Conditional(){

                public boolean evaluate(EditPart editpart) {
                    return editpart instanceof LifelineEditPart;
                }
            })) instanceof LifelineEditPart) {
                return ((LifelineEditPart)object).getCommand((Request)request);
            }
        }
        return super.getCreateElementAndViewCommand(request);
    }

    private boolean isCreatedOnOccurrenceSpecification(String requestHint) {
        return this.isTimeHint(requestHint) || this.isDurationHint(requestHint);
    }

    private boolean isDurationHint(String requestHint) {
        String durCstOnLifelineHint = ((IHintedType)UMLElementTypes.DurationConstraint_3021).getSemanticHint();
        String durCstOnMessage = ((IHintedType)UMLElementTypes.DurationConstraint_3023).getSemanticHint();
        String durObsOnMessage = ((IHintedType)UMLElementTypes.DurationObservation_3024).getSemanticHint();
        return durCstOnLifelineHint.equals(requestHint) || durCstOnMessage.equals(requestHint) || durObsOnMessage.equals(requestHint);
    }

    private boolean isTimeHint(String requestHint) {
        String timeConstraintHint = ((IHintedType)UMLElementTypes.TimeConstraint_3019).getSemanticHint();
        String timeObservationHint = ((IHintedType)UMLElementTypes.TimeObservation_3020).getSemanticHint();
        return timeConstraintHint.equals(requestHint) || timeObservationHint.equals(requestHint);
    }
}

