/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.policies;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.AbstractPointListShape;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;
import org.eclipse.gef.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.MessageEndEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.figures.EllipseDecoration;
import org.eclipse.papyrus.uml.diagram.sequence.providers.UMLElementTypes;
import org.eclipse.papyrus.uml.diagram.sequence.util.HighlightUtil;
import org.eclipse.papyrus.uml.diagram.sequence.util.SequenceUtil;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.MessageSort;
import org.eclipse.uml2.uml.OccurrenceSpecification;

public class HighlightEditPolicy
extends GraphicalEditPolicy {
    public static final String HIGHLIGHT_ROLE = "Highlight Edit Policy";
    private static final String DURATION_CONSTRAINT_ON_LIFELINE_HINT = ((IHintedType)UMLElementTypes.DurationConstraint_3021).getSemanticHint();
    private static final String TIME_CONSTRAINT_ON_LIFELINE_HINT = ((IHintedType)UMLElementTypes.TimeConstraint_3019).getSemanticHint();
    protected Indicator sourceIndicator;
    protected Indicator targetIndicator;

    public void showSourceFeedback(Request request) {
        EditPolicy editPolicy = null;
        Object type = request.getType();
        if ("connection end".equals(type)) {
            editPolicy = this.getHost().getEditPolicy((Object)"GraphicalNodeEditPolicy");
        } else if ("observation connection end".equals(type)) {
            editPolicy = this.getHost().getEditPolicy((Object)"observationlink");
        }
        if (editPolicy != null) {
            boolean canExecute;
            EditPart targetEditPart = ((CreateConnectionRequest)request).getTargetEditPart();
            boolean bl = canExecute = targetEditPart != null;
            if (targetEditPart != null) {
                Command command = targetEditPart.getCommand(request);
                canExecute = command != null && command.canExecute();
            }
            editPolicy.showSourceFeedback(request);
            PolylineConnection connectionFeedback = (PolylineConnection)this.getConnectionFeedback(editPolicy);
            if (connectionFeedback != null) {
                if (canExecute) {
                    EllipseDecoration dec = new EllipseDecoration();
                    dec.setPreferredSize(10, 10);
                    dec.setSize(10, 10);
                    dec.setLineWidth(2);
                    dec.setAntialias(1);
                    connectionFeedback.setTargetDecoration((RotatableDecoration)dec);
                } else {
                    connectionFeedback.setTargetDecoration(null);
                }
            }
        }
        if ("Reconnection source".equals(type) || "observation reconnect source".equals(type)) {
            boolean highlight;
            editPolicy = this.getHost().getEditPolicy((Object)"Connection Endpoint Policy");
            if (editPolicy != null) {
                editPolicy.showSourceFeedback(request);
            }
            ConnectionEditPart connection = ((ReconnectRequest)request).getConnectionEditPart();
            EditPart target = ((ReconnectRequest)request).getTarget();
            boolean bl = highlight = target != null;
            if (target != null) {
                Command command = target.getCommand(request);
                boolean bl2 = highlight = command != null && command.canExecute();
            }
            if (highlight) {
                Connection conn = (Connection)connection.getFigure();
                PointList line = conn.getPoints().getCopy();
                conn.translateToAbsolute((Translatable)line);
                Indicator sourceFeedback = this.getSourceIndicator();
                this.setFeedbackLocation((IFigure)sourceFeedback, line.getFirstPoint());
            } else {
                this.safeRemoveFeedback((IFigure)this.sourceIndicator);
            }
        } else if ("Reconnection target".equals(type) || "observation reconnect target".equals(type)) {
            boolean highlight;
            editPolicy = this.getHost().getEditPolicy((Object)"Connection Endpoint Policy");
            if (editPolicy != null) {
                editPolicy.showSourceFeedback(request);
            }
            ReconnectRequest reconnectRequest = (ReconnectRequest)request;
            ConnectionEditPart connection = reconnectRequest.getConnectionEditPart();
            EditPart target = reconnectRequest.getTarget();
            boolean bl = highlight = target != null;
            if (target != null) {
                Command command = target.getCommand((Request)reconnectRequest);
                boolean bl3 = highlight = command != null && command.canExecute();
            }
            if (highlight) {
                Connection conn = (Connection)connection.getFigure();
                PointList line = conn.getPoints().getCopy();
                conn.translateToAbsolute((Translatable)line);
                Indicator targetFeedback = this.getTargetIndicator();
                this.setFeedbackLocation((IFigure)targetFeedback, line.getLastPoint());
            } else {
                this.safeRemoveFeedback((IFigure)this.targetIndicator);
            }
        }
    }

    public void showTargetFeedback(Request request) {
        Command command;
        EditPart host = this.getHost();
        if (request instanceof GroupRequest) {
            List editParts = ((GroupRequest)request).getEditParts();
            for (Object object : editParts) {
                this.highlight((EditPart)object);
            }
        } else if (request instanceof CreateConnectionRequest) {
            CreateConnectionRequest req = (CreateConnectionRequest)request;
            EditPart sourceEditPart = req.getSourceEditPart();
            EditPart targetEditPart = req.getTargetEditPart();
            this.highlight(sourceEditPart);
            this.highlight(targetEditPart);
        } else if (request instanceof ReconnectRequest) {
            this.highlight(((ReconnectRequest)request).getTarget());
            this.highlight((EditPart)((ReconnectRequest)request).getConnectionEditPart());
            if (host instanceof MessageEndEditPart) {
                this.highlightMessageEnd(request);
            } else {
                Object type = request.getType();
                if (host instanceof LifelineEditPart && "observation connection end".equals(type)) {
                    this.highlightObservationEvent(request);
                }
            }
        } else {
            this.highlight(host);
        }
        if ((this.isCreating(request, DURATION_CONSTRAINT_ON_LIFELINE_HINT) || this.isCreating(request, TIME_CONSTRAINT_ON_LIFELINE_HINT)) && (command = this.getHost().getCommand(request)) != null && command.canExecute()) {
            this.highlightEventsAboutConstraints(request);
        }
    }

    protected void highlight(EditPart object) {
        HighlightUtil.highlight(object);
    }

    protected void unhighlight(EditPart object) {
        HighlightUtil.unhighlight(object);
    }

    protected void unhighlight() {
        HighlightUtil.unhighlight();
    }

    private Connection getConnectionFeedback(EditPolicy policy) {
        if (policy != null) {
            try {
                Field f = GraphicalNodeEditPolicy.class.getDeclaredField("connectionFeedback");
                f.setAccessible(true);
                return (Connection)f.get(policy);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private void highlightMessageEnd(Request request) {
        Point location = this.getConnectiveLocation(request);
        if (location == null) {
            return;
        }
        MessageEndEditPart host = (MessageEndEditPart)this.getHost();
        ConnectionNodeEditPart parent = (ConnectionNodeEditPart)host.getParent();
        Point p = this.getNearestEndOfConnection(location, parent);
        Indicator feedback = this.getSourceIndicator();
        this.setFeedbackLocation((IFigure)feedback, p);
    }

    private void highlightObservationEvent(Request request) {
        Point location = this.getConnectiveLocation(request);
        Map.Entry<Point, List<OccurrenceSpecification>> eventAndLocation = SequenceUtil.findNearestEvent(location, (LifelineEditPart)this.getHost());
        OccurrenceSpecification event = null;
        if (eventAndLocation != null) {
            List<OccurrenceSpecification> events = eventAndLocation.getValue();
            for (OccurrenceSpecification occurrence : events) {
                Message mess;
                if (occurrence instanceof MessageOccurrenceSpecification && occurrence.equals((mess = ((MessageOccurrenceSpecification)occurrence).getMessage()).getReceiveEvent()) && MessageSort.SYNCH_CALL_LITERAL.equals((Object)mess.getMessageSort())) continue;
                event = occurrence;
                break;
            }
        }
        if (event != null) {
            Point p = this.fixLocationOfEventOnLifeline(this.getHost(), event, location.getCopy());
            Indicator feedback = this.getTargetIndicator();
            this.setFeedbackLocation((IFigure)feedback, p);
        }
    }

    private Point getConnectiveLocation(Request request) {
        Point location = null;
        if (request instanceof CreateConnectionRequest) {
            location = ((CreateConnectionRequest)request).getLocation();
        } else if (request instanceof ReconnectRequest) {
            location = ((ReconnectRequest)request).getLocation();
        }
        return location;
    }

    private void highlightEventsAboutConstraints(Request request) {
        Object locTop = request.getExtendedData().get("Nearest occurrence specification location");
        Object topEvents = request.getExtendedData().get("Nearest occurrence specification");
        if (locTop instanceof Point && topEvents != null && topEvents instanceof Collection && !((Collection)topEvents).isEmpty()) {
            Point referenceTop = ((Point)locTop).getCopy();
            OccurrenceSpecification event = (OccurrenceSpecification)((Collection)topEvents).iterator().next();
            if (event instanceof MessageOccurrenceSpecification) {
                referenceTop = this.fixLocationOfEventOnLifeline(null, event, referenceTop);
            }
            Indicator sourceIndicator = this.getSourceIndicator();
            this.setFeedbackLocation((IFigure)sourceIndicator, referenceTop);
        }
        Object bottomEvents = request.getExtendedData().get("Nearest occurrence specification (end)");
        Object locBottom = request.getExtendedData().get("Nearest occurrence specification location (end)");
        if (locBottom instanceof Point && bottomEvents != null && bottomEvents instanceof Collection && !((Collection)bottomEvents).isEmpty()) {
            Point referenceBottom = ((Point)locBottom).getCopy();
            OccurrenceSpecification event = (OccurrenceSpecification)((Collection)bottomEvents).iterator().next();
            if (event instanceof MessageOccurrenceSpecification) {
                referenceBottom = this.fixLocationOfEventOnLifeline(null, event, referenceBottom);
            }
            Indicator targetIndicator = this.getTargetIndicator();
            this.setFeedbackLocation((IFigure)targetIndicator, referenceBottom);
        }
    }

    private Point fixLocationOfEventOnLifeline(EditPart lifeline, OccurrenceSpecification event, Point location) {
        if (lifeline == null) {
            lifeline = this.findLifelineAt(location);
        }
        if (lifeline == null) {
            return location;
        }
        Point loc = SequenceUtil.findLocationOfEvent((LifelineEditPart)lifeline, (InteractionFragment)event);
        if (loc != null) {
            return loc;
        }
        EditPart linkedEditPart = SequenceUtil.getLinkedEditPart(lifeline, event);
        if (linkedEditPart instanceof ConnectionNodeEditPart) {
            ConnectionNodeEditPart connection = (ConnectionNodeEditPart)linkedEditPart;
            return this.getNearestEndOfConnection(location, connection);
        }
        return location;
    }

    private Point getNearestEndOfConnection(Point location, ConnectionNodeEditPart connection) {
        Connection msgFigure = connection.getConnectionFigure();
        if (msgFigure instanceof AbstractPointListShape) {
            Point start = ((AbstractPointListShape)msgFigure).getStart().getCopy();
            msgFigure.translateToAbsolute((Translatable)start);
            Point end = ((AbstractPointListShape)msgFigure).getEnd().getCopy();
            msgFigure.translateToAbsolute((Translatable)end);
            if (location.getDistance(start) < location.getDistance(end)) {
                return start;
            }
            return end;
        }
        return location;
    }

    private boolean isCreating(Request request, String sementicHint) {
        if (request == null || sementicHint == null) {
            return false;
        }
        String hint = this.getSementicHint(request);
        return sementicHint.equals(hint);
    }

    private String getSementicHint(Request request) {
        Object elementType;
        String hint = null;
        if (request instanceof CreateViewRequest) {
            CreateViewRequest.ViewDescriptor viewDesc = (CreateViewRequest.ViewDescriptor)((CreateViewRequest)request).getViewDescriptors().iterator().next();
            hint = viewDesc.getSemanticHint();
        } else if (request instanceof CreateUnspecifiedTypeRequest && (elementType = ((CreateUnspecifiedTypeRequest)request).getElementTypes().iterator().next()) instanceof IHintedType) {
            hint = ((IHintedType)elementType).getSemanticHint();
        }
        return hint;
    }

    private EditPart findLifelineAt(Point pt) {
        Collection values = this.getHost().getViewer().getEditPartRegistry().values();
        for (Object object : values) {
            if (!(object instanceof LifelineEditPart)) continue;
            LifelineEditPart lifeline = (LifelineEditPart)((Object)object);
            LifelineEditPart.LifelineFigure primaryShape = lifeline.getPrimaryShape();
            Point p = pt.getCopy();
            primaryShape.translateToRelative((Translatable)p);
            if (!primaryShape.containsPoint(p)) continue;
            return lifeline;
        }
        return null;
    }

    protected Indicator getSourceIndicator() {
        if (this.sourceIndicator == null || this.sourceIndicator.getParent() == null) {
            this.sourceIndicator = this.createCircleFeedback();
        }
        return this.sourceIndicator;
    }

    protected Indicator getTargetIndicator() {
        if (this.targetIndicator == null || this.targetIndicator.getParent() == null) {
            this.targetIndicator = this.createCircleFeedback();
        }
        return this.targetIndicator;
    }

    private Indicator createCircleFeedback() {
        Indicator feedback = new Indicator();
        this.getFeedbackLayer().add((IFigure)feedback);
        return feedback;
    }

    protected void setFeedbackLocation(IFigure feedback, Point location) {
        if (feedback == null || location == null) {
            return;
        }
        Point p = location.getCopy();
        Dimension d = feedback.getSize();
        p.x -= d.width / 2;
        p.y -= d.height / 2;
        feedback.translateToRelative((Translatable)p);
        feedback.setLocation(p);
    }

    private void safeRemoveFeedback(IFigure feedback) {
        if (feedback == null || feedback.getParent() == null) {
            return;
        }
        feedback.getParent().remove(feedback);
    }

    public void eraseTargetFeedback(Request request) {
        this.unhighlight();
        this.safeRemoveFeedback((IFigure)this.sourceIndicator);
        this.sourceIndicator = null;
        this.safeRemoveFeedback((IFigure)this.targetIndicator);
        this.targetIndicator = null;
    }

    public void eraseSourceFeedback(Request request) {
        super.eraseSourceFeedback(request);
        this.safeRemoveFeedback((IFigure)this.sourceIndicator);
        this.sourceIndicator = null;
        this.safeRemoveFeedback((IFigure)this.targetIndicator);
        this.targetIndicator = null;
    }

    private static class Indicator
    extends Ellipse {
        public Indicator() {
            this.setLineWidth(2);
            this.setAntialias(1);
            this.setSize(10, 10);
        }
    }
}

