/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.policies;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.BorderItemResizableEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.command.CustomZOrderCommand;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.ActionExecutionSpecificationEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.BehaviorExecutionSpecificationEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CombinedFragment2EditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.DurationConstraintEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.StateInvariantEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.figures.LifelineDotLineCustomFigure;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.sequence.providers.UMLElementTypes;
import org.eclipse.papyrus.uml.diagram.sequence.util.OccurrenceSpecificationMoveHelper;
import org.eclipse.papyrus.uml.diagram.sequence.util.SequenceUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LifelineXYLayoutEditPolicy
extends XYLayoutEditPolicy {
    public static final int EXECUTION_INIT_WIDTH = 16;
    public static final int COREGION_INIT_WIDTH = 30;
    private static final int EXECUTION_INIT_HEIGHT = 50;
    private static final int TIME_BAR_HEIGHT = 1;
    private static final int SPACING_HEIGHT = 5;
    private static final String TIME_CONSTRAINT_HINT = ((IHintedType)UMLElementTypes.TimeConstraint_3019).getSemanticHint();
    private static final String TIME_OBSERVATION_HINT = ((IHintedType)UMLElementTypes.TimeObservation_3020).getSemanticHint();
    private static final String DURATION_CONSTRAINT_ON_LIFELINE_HINT = ((IHintedType)UMLElementTypes.DurationConstraint_3021).getSemanticHint();
    private static final String ACTION_EXECUTION_SPECIFICATION_HINT = ((IHintedType)UMLElementTypes.ActionExecutionSpecification_3006).getSemanticHint();
    private static final String BEHAVIOR_EXECUTION_SPECIFICATION_HINT = ((IHintedType)UMLElementTypes.BehaviorExecutionSpecification_3003).getSemanticHint();
    private static final String CO_REGION_HINT = ((IHintedType)UMLElementTypes.CombinedFragment_3018).getSemanticHint();

    protected Command getOrphanChildrenCommand(Request request) {
        return UnexecutableCommand.INSTANCE;
    }

    protected Command getCreateCommand(CreateRequest request) {
        CreateViewRequest cvr;
        if (request instanceof CreateViewRequest && (cvr = (CreateViewRequest)request).getViewDescriptors().size() > 0) {
            Command cmd;
            CreateViewRequest.ViewDescriptor viewDescriptor = (CreateViewRequest.ViewDescriptor)cvr.getViewDescriptors().iterator().next();
            String semanticHint = viewDescriptor.getSemanticHint();
            if ((TIME_CONSTRAINT_HINT.equals(semanticHint) || TIME_OBSERVATION_HINT.equals(semanticHint)) && (cmd = this.getCommandForTimeObservationOrConstraint(cvr, viewDescriptor)) != null) {
                return cmd;
            }
            if (DURATION_CONSTRAINT_ON_LIFELINE_HINT.equals(semanticHint) && (cmd = this.getCommandForDurationConstraint(cvr, viewDescriptor)) != null) {
                return cmd;
            }
            if ((ACTION_EXECUTION_SPECIFICATION_HINT.equals(semanticHint) || BEHAVIOR_EXECUTION_SPECIFICATION_HINT.equals(semanticHint)) && (cmd = this.getCommandForExecutionSpecificationCreation(cvr, viewDescriptor)) != null) {
                return cmd;
            }
            if (CO_REGION_HINT.equals(semanticHint) && (cmd = this.getCommandForCoRegionCreation(cvr, viewDescriptor)) != null) {
                return cmd;
            }
        }
        return super.getCreateCommand(request);
    }

    protected EditPolicy createChildEditPolicy(EditPart child) {
        View childView = (View)child.getModel();
        switch (UMLVisualIDRegistry.getVisualID(childView)) {
            case 3017: {
                return new StateInvariantEditPart.StateInvariantResizableEditPolicy();
            }
            case 3022: {
                return new BorderItemResizableEditPolicy();
            }
        }
        return super.createChildEditPolicy(child);
    }

    protected Rectangle getCurrentConstraintFor(GraphicalEditPart child) {
        IFigure fig = child.getFigure();
        Object con = fig.getParent().getLayoutManager().getConstraint(fig);
        if (con instanceof Rectangle) {
            return (Rectangle)con;
        }
        return fig.getBounds();
    }

    protected Object getConstraintFor(CreateRequest request) {
        Rectangle constraint = (Rectangle)super.getConstraintFor(request);
        if (request instanceof CreateViewAndElementRequest) {
            String destructionHint;
            CreateViewAndElementRequest req = (CreateViewAndElementRequest)request;
            IHintedType type = (IHintedType)UMLElementTypes.Lifeline_3001;
            if (type.getSemanticHint().equals(req.getViewAndElementDescriptor().getSemanticHint())) {
                constraint.y = 0;
            }
            if ((destructionHint = ((IHintedType)UMLElementTypes.DestructionOccurrenceSpecification_3022).getSemanticHint()).equals(req.getViewAndElementDescriptor().getSemanticHint()) && constraint.width < 0 && constraint.height < 0) {
                constraint.height = 20;
                constraint.width = 20;
            }
        }
        return constraint;
    }

    private static Rectangle getNewBoundsForCoRegion(LifelineEditPart lifelineEP, Rectangle bounds) {
        Rectangle newBounds = bounds.getCopy();
        LifelineDotLineCustomFigure figureLifelineDotLineFigure = lifelineEP.getPrimaryShape().getFigureLifelineDotLineFigure();
        figureLifelineDotLineFigure.translateToRelative((Translatable)newBounds);
        newBounds.translate(figureLifelineDotLineFigure.getBounds().getLocation().getCopy().negate());
        Rectangle dotLineFigureBounds = figureLifelineDotLineFigure.getBounds();
        newBounds.x = dotLineFigureBounds.width / 2 - 15;
        newBounds.width = 30;
        return newBounds;
    }

    private Command getCommandForCoRegionCreation(CreateViewRequest cvr, CreateViewRequest.ViewDescriptor viewDescriptor) {
        Rectangle newBounds = new Rectangle();
        if (cvr.getLocation() != null) {
            newBounds.setLocation(cvr.getLocation());
        }
        if (cvr.getSize() != null) {
            newBounds.setSize(cvr.getSize());
        } else {
            newBounds.width = -1;
            newBounds.height = -1;
        }
        if (newBounds.x < 0 || newBounds.y < 0) {
            newBounds.y = 0;
            newBounds.x = 0;
        }
        newBounds = LifelineXYLayoutEditPolicy.getNewBoundsForCoRegion((LifelineEditPart)this.getHost(), newBounds);
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        return new ICommandProxy((ICommand)new SetBoundsCommand(editingDomain, DiagramUIMessages.SetLocationCommand_Label_Resize, (IAdaptable)viewDescriptor, newBounds));
    }

    private Rectangle getCreateExecuteSpecificationBounds(Point location, Dimension size, String semanticHint) {
        Point newLocation;
        Point point = newLocation = location == null ? new Point() : location.getCopy();
        if (newLocation.x < 0 || newLocation.y < 0) {
            newLocation.y = 0;
            newLocation.x = 0;
        }
        LifelineEditPart editPart = (LifelineEditPart)this.getHost();
        LifelineDotLineCustomFigure figureLifelineDotLineFigure = editPart.getPrimaryShape().getFigureLifelineDotLineFigure();
        List<ShapeNodeEditPart> executionSpecificationList = editPart.getChildShapeNodeEditPart();
        figureLifelineDotLineFigure.translateToRelative((Translatable)newLocation);
        Rectangle dotLineFigureBounds = figureLifelineDotLineFigure.getBounds();
        if (newLocation.y < dotLineFigureBounds.y) {
            int max = dotLineFigureBounds.y;
            for (ShapeNodeEditPart sp : executionSpecificationList) {
                int figureBottom = sp.getFigure().getBounds().y + sp.getFigure().getBounds().height;
                if (figureBottom <= max) continue;
                max = figureBottom;
            }
            newLocation.y = max + 5;
            newLocation.x = dotLineFigureBounds.x + dotLineFigureBounds.width / 2 - 8;
        }
        int newHeight = this.getFigureHeight(semanticHint, size);
        return new Rectangle(newLocation.x, newLocation.y, -1, newHeight);
    }

    private ShapeNodeEditPart getParentWhenCreationExecuteSpecification(Point location, Dimension size, String semanticHint) {
        Rectangle newBounds = this.getCreateExecuteSpecificationBounds(location, size, semanticHint);
        List<ShapeNodeEditPart> executionSpecificationList = ((LifelineEditPart)this.getHost()).getChildShapeNodeEditPart();
        return LifelineXYLayoutEditPolicy.getParent((LifelineEditPart)this.getHost(), newBounds, executionSpecificationList);
    }

    private Command getCommandForExecutionSpecificationCreation(CreateViewRequest cvr, CreateViewRequest.ViewDescriptor viewDescriptor) {
        LifelineEditPart editPart = (LifelineEditPart)this.getHost();
        List<ShapeNodeEditPart> executionSpecificationList = editPart.getChildShapeNodeEditPart();
        Point location = cvr.getLocation();
        Dimension size = cvr.getSize();
        String semanticHint = viewDescriptor.getSemanticHint();
        Rectangle newBounds = this.getCreateExecuteSpecificationBounds(location, size, semanticHint);
        ShapeNodeEditPart parent = this.getParentWhenCreationExecuteSpecification(location, size, semanticHint);
        if ((newBounds = LifelineXYLayoutEditPolicy.getExecutionSpecificationNewBounds(true, editPart, new Rectangle(), newBounds, new ArrayList<ShapeNodeEditPart>(0), false)) == null) {
            return UnexecutableCommand.INSTANCE;
        }
        ICommandProxy p = new ICommandProxy((ICommand)new SetBoundsCommand(editPart.getEditingDomain(), "Creation of an ExecutionSpecification", (IAdaptable)viewDescriptor, newBounds));
        if (parent != null) {
            p = p.chain(LifelineXYLayoutEditPolicy.resizeParentExecutionSpecification((LifelineEditPart)this.getHost(), parent, newBounds.getCopy(), executionSpecificationList));
        }
        return p;
    }

    private static Command resizeParentExecutionSpecification(LifelineEditPart lifelinePart, ShapeNodeEditPart part, Rectangle childBounds, List<ShapeNodeEditPart> list) {
        Rectangle bounds = LifelineXYLayoutEditPolicy.getRelativeBounds(part.getFigure());
        childBounds.x = bounds.x;
        childBounds.width = bounds.width;
        Rectangle rect = bounds.getCopy();
        if (childBounds.y > rect.y) {
            return null;
        }
        rect.height += rect.y - childBounds.y;
        rect.y = childBounds.y;
        Rectangle newBounds = rect.getCopy();
        CompoundCommand command = new CompoundCommand();
        ICommandProxy c = new ICommandProxy((ICommand)new SetBoundsCommand(part.getEditingDomain(), "Resize of Parent Bar", (IAdaptable)part, newBounds.getCopy()));
        command.add((Command)c);
        Point moveDelta = new Point(newBounds.x - bounds.x, newBounds.y - bounds.y);
        if (moveDelta.y != 0) {
            ChangeBoundsRequest request = new ChangeBoundsRequest();
            request.setEditParts((EditPart)part);
            request.setMoveDelta(moveDelta);
            command = OccurrenceSpecificationMoveHelper.completeMoveExecutionSpecificationCommand(command, part, newBounds.getCopy(), request);
        }
        list.remove(part);
        ShapeNodeEditPart parent = LifelineXYLayoutEditPolicy.getParent(lifelinePart, part.getFigure().getBounds(), list);
        if (parent == null) {
            return command.unwrap();
        }
        return command.unwrap().chain(LifelineXYLayoutEditPolicy.resizeParentExecutionSpecification(lifelinePart, parent, newBounds.getCopy(), list));
    }

    private Command getCommandForTimeObservationOrConstraint(CreateViewRequest cvr, CreateViewRequest.ViewDescriptor viewDescriptor) {
        Object loc = cvr.getExtendedData().get("Nearest occurrence specification location");
        if (loc instanceof Point) {
            IFigure parentFigure = ((IGraphicalEditPart)this.getHost()).getFigure();
            Point referencePoint = ((Point)loc).getCopy();
            parentFigure.translateToRelative((Translatable)referencePoint);
            referencePoint.translate(parentFigure.getBounds().getLocation().getCopy().negate());
            int newHeight = this.getFigureHeight(viewDescriptor.getSemanticHint(), cvr.getSize());
            Rectangle newBounds = new Rectangle(referencePoint.x, referencePoint.y - newHeight / 2, -1, newHeight);
            TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
            return new ICommandProxy((ICommand)new SetBoundsCommand(editingDomain, DiagramUIMessages.SetLocationCommand_Label_Resize, (IAdaptable)viewDescriptor, newBounds));
        }
        return null;
    }

    private Command getCommandForDurationConstraint(CreateViewRequest cvr, CreateViewRequest.ViewDescriptor viewDescriptor) {
        Object locTop = cvr.getExtendedData().get("Nearest occurrence specification location");
        Object locBottom = cvr.getExtendedData().get("Nearest occurrence specification location (end)");
        if (locTop instanceof Point && locBottom instanceof Point) {
            IFigure parentFigure = ((IGraphicalEditPart)this.getHost()).getFigure();
            Point referenceTop = ((Point)locTop).getCopy();
            Point referenceBottom = ((Point)locBottom).getCopy();
            int newHeight = referenceBottom.y - referenceTop.y;
            if (newHeight > 0) {
                parentFigure.translateToRelative((Translatable)referenceTop);
                Point parentFigDelta = parentFigure.getBounds().getLocation().getCopy().negate();
                referenceTop.translate(parentFigDelta);
                Rectangle newBounds = new Rectangle(referenceTop.x, referenceTop.y, -1, newHeight);
                newBounds = DurationConstraintEditPart.fixMessageBounds(newBounds, (Request)cvr, (LifelineEditPart)this.getHost());
                TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
                return new ICommandProxy((ICommand)new SetBoundsCommand(editingDomain, DiagramUIMessages.SetLocationCommand_Label_Resize, (IAdaptable)viewDescriptor, newBounds));
            }
            if (newHeight < 0) {
                parentFigure.translateToRelative((Translatable)referenceBottom);
                Point parentFigDelta = parentFigure.getBounds().getLocation().getCopy().negate();
                referenceBottom.translate(parentFigDelta);
                Rectangle newBounds = new Rectangle(referenceBottom.x, referenceBottom.y, -1, -newHeight);
                newBounds = DurationConstraintEditPart.fixMessageBounds(newBounds, (Request)cvr, (LifelineEditPart)this.getHost());
                TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
                return new ICommandProxy((ICommand)new SetBoundsCommand(editingDomain, DiagramUIMessages.SetLocationCommand_Label_Resize, (IAdaptable)viewDescriptor, newBounds));
            }
        }
        return null;
    }

    private int getFigureHeight(String semanticHint, Dimension size) {
        int newHeight = TIME_OBSERVATION_HINT.equals(semanticHint) || TIME_CONSTRAINT_HINT.equals(semanticHint) ? 1 : (size != null ? size.height : 50);
        return newHeight;
    }

    protected static final Rectangle getExecutionSpecificationNewBounds(boolean isMove, LifelineEditPart lifelineEP, Rectangle oldBounds, Rectangle newBounds, List<ShapeNodeEditPart> notToCheckExecutionSpecificationList, boolean useFixedXPos) {
        Rectangle dotLineBounds = lifelineEP.getPrimaryShape().getFigureLifelineDotLineFigure().getBounds();
        if (newBounds.y <= dotLineBounds.y || newBounds.x < dotLineBounds.x || newBounds.x > dotLineBounds.right()) {
            return null;
        }
        List<ShapeNodeEditPart> toCheckExecutionSpecificationList = lifelineEP.getChildShapeNodeEditPart();
        toCheckExecutionSpecificationList.removeAll(notToCheckExecutionSpecificationList);
        if (isMove) {
            ShapeNodeEditPart parent = LifelineXYLayoutEditPolicy.getParent(lifelineEP, newBounds, toCheckExecutionSpecificationList);
            if (useFixedXPos) {
                newBounds.x = oldBounds.x;
            } else if (parent == null) {
                int width = newBounds.width > 0 ? newBounds.width : 16;
                newBounds.x = dotLineBounds.x + dotLineBounds.width / 2 - width / 2;
            } else {
                Rectangle parentBounds = parent.getFigure().getBounds();
                int width = parentBounds.width > 0 ? parentBounds.width : 16;
                newBounds.x = parentBounds.x + width / 2 + 1;
            }
        } else {
            ShapeNodeEditPart oldParent = LifelineXYLayoutEditPolicy.getParent(lifelineEP, oldBounds, toCheckExecutionSpecificationList);
            for (ShapeNodeEditPart esPart : toCheckExecutionSpecificationList) {
                Rectangle esBounds = esPart.getFigure().getBounds();
                int esYBottom = esBounds.y + esBounds.height;
                if (esPart == oldParent || (oldBounds.y + oldBounds.height > esBounds.y || newBounds.y + newBounds.height < esBounds.y) && (oldBounds.y < esYBottom || newBounds.y > esYBottom)) continue;
                return null;
            }
        }
        newBounds.x -= dotLineBounds.x;
        newBounds.y -= dotLineBounds.y;
        return newBounds;
    }

    protected Command getResizeChildrenCommand(ChangeBoundsRequest request) {
        LifelineEditPart lifelineEP = (LifelineEditPart)this.getHost();
        Command command = LifelineXYLayoutEditPolicy.getResizeOrMoveChildrenCommand(lifelineEP, request, false, true, false);
        if (command == null) {
            command = super.getResizeChildrenCommand(request);
        }
        return command;
    }

    protected Command getMoveChildrenCommand(Request request) {
        LifelineEditPart lifelineEP = (LifelineEditPart)this.getHost();
        Command command = LifelineXYLayoutEditPolicy.getResizeOrMoveChildrenCommand(lifelineEP, (ChangeBoundsRequest)request, true, true, false);
        if (command == null) {
            command = super.getMoveChildrenCommand(request);
        }
        return command;
    }

    public static Command getResizeOrMoveChildrenCommand(LifelineEditPart lifelineEP, ChangeBoundsRequest request, boolean isMove, boolean updateEnclosingInteraction, boolean useFixedXPos) {
        List editParts = request.getEditParts();
        if (editParts != null) {
            CompoundCommand compoundCmd = new CompoundCommand();
            compoundCmd.setLabel("Move or resize");
            compoundCmd.setDebugLabel("Debug: Move or resize of an ExecutionSpecification");
            for (EditPart ep : editParts) {
                Point moveDelta;
                if (ep instanceof ActionExecutionSpecificationEditPart || ep instanceof BehaviorExecutionSpecificationEditPart) {
                    ShapeNodeEditPart executionSpecificationEP = (ShapeNodeEditPart)ep;
                    Dimension newSizeDelta = LifelineXYLayoutEditPolicy.adaptSizeDeltaToMaxHeight(executionSpecificationEP.getFigure(), request.getSizeDelta());
                    Rectangle oldBounds = executionSpecificationEP.getFigure().getBounds().getCopy();
                    Rectangle newBounds = oldBounds.getCopy();
                    newBounds.x += request.getMoveDelta().x;
                    newBounds.y += request.getMoveDelta().y;
                    newBounds.height += newSizeDelta.height;
                    BasicEList notToCheckExecutionSpecificationList = new BasicEList();
                    notToCheckExecutionSpecificationList.addAll(LifelineXYLayoutEditPolicy.getAffixedExecutionSpecificationEditParts(executionSpecificationEP));
                    notToCheckExecutionSpecificationList.add(executionSpecificationEP);
                    List<ShapeNodeEditPart> executionSpecificationList = lifelineEP.getChildShapeNodeEditPart();
                    executionSpecificationList.remove(executionSpecificationEP);
                    ShapeNodeEditPart parentBar = LifelineXYLayoutEditPolicy.getParent(lifelineEP, newBounds, executionSpecificationList);
                    newBounds = LifelineXYLayoutEditPolicy.getExecutionSpecificationNewBounds(isMove, lifelineEP, oldBounds, newBounds, (List<ShapeNodeEditPart>)notToCheckExecutionSpecificationList, useFixedXPos);
                    if (newBounds == null) {
                        return UnexecutableCommand.INSTANCE;
                    }
                    if (parentBar != null) {
                        compoundCmd.add(LifelineXYLayoutEditPolicy.resizeParentExecutionSpecification(lifelineEP, parentBar, newBounds.getCopy(), executionSpecificationList));
                    }
                    SetBoundsCommand setBoundsCmd = new SetBoundsCommand(executionSpecificationEP.getEditingDomain(), "Resize of a ExecutionSpecification", (IAdaptable)executionSpecificationEP, newBounds);
                    compoundCmd.add((Command)new ICommandProxy((ICommand)setBoundsCmd));
                    Rectangle realMoveDelta = LifelineXYLayoutEditPolicy.getRealMoveDelta(LifelineXYLayoutEditPolicy.getRelativeBounds(executionSpecificationEP.getFigure()), newBounds);
                    if (isMove) {
                        compoundCmd.add((Command)LifelineXYLayoutEditPolicy.createMovingAffixedExecutionSpecificationCommand(executionSpecificationEP, realMoveDelta, newBounds.getCopy()));
                        compoundCmd.add(LifelineXYLayoutEditPolicy.createZOrderCommand(lifelineEP, executionSpecificationEP, newBounds.getCopy(), (List<ShapeNodeEditPart>)notToCheckExecutionSpecificationList));
                    }
                    compoundCmd = OccurrenceSpecificationMoveHelper.completeMoveExecutionSpecificationCommand(compoundCmd, executionSpecificationEP, newBounds, request);
                    IFigure parentFigure = executionSpecificationEP.getFigure().getParent();
                    parentFigure.translateToAbsolute((Translatable)newBounds);
                    newBounds.translate(parentFigure.getBounds().getLocation());
                    if (updateEnclosingInteraction) {
                        compoundCmd.add(SequenceUtil.createUpdateEnclosingInteractionCommand(executionSpecificationEP, request.getMoveDelta(), newSizeDelta));
                    }
                    compoundCmd.add((Command)new ICommandProxy((ICommand)new LifelineEditPart.PreserveAnchorsPositionCommandEx(executionSpecificationEP, new Dimension(realMoveDelta.width, realMoveDelta.height), 0, executionSpecificationEP.getFigure(), request.getResizeDirection())));
                }
                if (!(ep instanceof CombinedFragment2EditPart)) continue;
                CombinedFragment2EditPart cf2EP = (CombinedFragment2EditPart)ep;
                IFigure cf2Figure = cf2EP.getFigure();
                Rectangle bounds = cf2Figure.getBounds().getCopy();
                cf2Figure.getParent().translateToAbsolute((Translatable)bounds);
                Dimension sizeDelta = request.getSizeDelta();
                if (sizeDelta != null) {
                    if (sizeDelta.width != 0) {
                        return UnexecutableCommand.INSTANCE;
                    }
                    bounds.resize(sizeDelta);
                }
                if ((moveDelta = request.getMoveDelta()) != null) {
                    bounds.translate(moveDelta);
                }
                SetBoundsCommand setBoundsCmd = new SetBoundsCommand(cf2EP.getEditingDomain(), "Resize of a CoRegion", (IAdaptable)cf2EP, LifelineXYLayoutEditPolicy.getNewBoundsForCoRegion(lifelineEP, bounds));
                compoundCmd.add((Command)new ICommandProxy((ICommand)setBoundsCmd));
            }
            if (!compoundCmd.isEmpty()) {
                return compoundCmd;
            }
        }
        return null;
    }

    protected static final Command createZOrderCommand(LifelineEditPart lifelineEP, ShapeNodeEditPart executionSpecificationEP, Rectangle newBounds, List<ShapeNodeEditPart> notToCheckExecutionSpecificationList) {
        List<ShapeNodeEditPart> toCheckExecutionSpecificationList = lifelineEP.getChildShapeNodeEditPart();
        toCheckExecutionSpecificationList.removeAll(notToCheckExecutionSpecificationList);
        CompoundCommand cmd = new CompoundCommand();
        block0: for (ShapeNodeEditPart externalExecutionSpecificationEP : toCheckExecutionSpecificationList) {
            View containerView;
            Rectangle externalExecutionSpecificationBounds = LifelineXYLayoutEditPolicy.getRelativeBounds(externalExecutionSpecificationEP.getFigure());
            if (!externalExecutionSpecificationBounds.touches(newBounds) || (containerView = ViewUtil.getContainerView((View)executionSpecificationEP.getPrimaryView())) == null) continue;
            int i = 0;
            int parentIndex = -1;
            int childIndex = -1;
            for (Object child : containerView.getChildren()) {
                if (child == externalExecutionSpecificationEP.getPrimaryView()) {
                    parentIndex = i;
                } else if (child == executionSpecificationEP.getPrimaryView()) {
                    childIndex = i;
                }
                if (parentIndex != -1 && childIndex != -1) {
                    if (childIndex <= parentIndex) continue block0;
                    cmd.add((Command)new ICommandProxy((ICommand)new CustomZOrderCommand(executionSpecificationEP.getEditingDomain(), executionSpecificationEP.getPrimaryView(), parentIndex)));
                    cmd.add((Command)new ICommandProxy((ICommand)new CustomZOrderCommand(externalExecutionSpecificationEP.getEditingDomain(), externalExecutionSpecificationEP.getPrimaryView(), childIndex)));
                }
                ++i;
            }
        }
        if (!cmd.isEmpty()) {
            return cmd;
        }
        return null;
    }

    public static final ShapeNodeEditPart getParent(LifelineEditPart lifelinePart, Rectangle childBounds, List<ShapeNodeEditPart> toCheckExecutionSpecificationList) {
        ShapeNodeEditPart parent = null;
        Rectangle externalBounds = childBounds.getCopy();
        for (ShapeNodeEditPart externalExecutionSpecificationEP : toCheckExecutionSpecificationList) {
            Rectangle externalExecutionSpecificationBounds = externalExecutionSpecificationEP.getFigure().getBounds();
            externalBounds.x = externalExecutionSpecificationBounds.x;
            externalBounds.width = externalExecutionSpecificationBounds.width;
            if (!externalExecutionSpecificationBounds.touches(externalBounds) || externalExecutionSpecificationBounds.x > childBounds.x || parent != null && externalExecutionSpecificationBounds.x <= parent.getFigure().getBounds().x) continue;
            parent = externalExecutionSpecificationEP;
        }
        return parent;
    }

    protected static final Dimension adaptSizeDeltaToMaxHeight(IFigure figure, Dimension sizeDelta) {
        Dimension newSizeDelta = new Dimension(sizeDelta);
        int figureHeight = figure.getBounds().height;
        int maximunFigureHeight = figure.getMaximumSize().height;
        int minimunFigureHeight = figure.getMinimumSize().height;
        int height = figureHeight + newSizeDelta.height;
        if (height > maximunFigureHeight) {
            newSizeDelta.height = maximunFigureHeight - figureHeight;
        } else if (height < minimunFigureHeight) {
            newSizeDelta.height = minimunFigureHeight - figureHeight;
        }
        return newSizeDelta;
    }

    public static final List<ShapeNodeEditPart> getAffixedExecutionSpecificationEditParts(ShapeNodeEditPart executionSpecificationEP) {
        ArrayList<ShapeNodeEditPart> notToCheckExecutionSpecificationList = new ArrayList<ShapeNodeEditPart>();
        return LifelineXYLayoutEditPolicy.getAffixedExecutionSpecificationEditParts(executionSpecificationEP, notToCheckExecutionSpecificationList);
    }

    protected static final List<ShapeNodeEditPart> getAffixedExecutionSpecificationEditParts(ShapeNodeEditPart executionSpecificationEP, List<ShapeNodeEditPart> notToCheckExecutionSpecificationList) {
        ArrayList<ShapeNodeEditPart> newNotToCheckExecutionSpecificationList = new ArrayList<ShapeNodeEditPart>(notToCheckExecutionSpecificationList);
        newNotToCheckExecutionSpecificationList.add(executionSpecificationEP);
        LifelineEditPart lifelineEP = (LifelineEditPart)executionSpecificationEP.getParent();
        List<ShapeNodeEditPart> executionSpecificationList = lifelineEP.getChildShapeNodeEditPart();
        executionSpecificationList.remove(newNotToCheckExecutionSpecificationList);
        ArrayList<ShapeNodeEditPart> affixedExecutionSpecificationList = new ArrayList<ShapeNodeEditPart>();
        for (ShapeNodeEditPart childExecutionSpecificationEP : executionSpecificationList) {
            if (!LifelineXYLayoutEditPolicy.isAffixedToRight(executionSpecificationEP.getFigure().getBounds(), childExecutionSpecificationEP.getFigure().getBounds())) continue;
            affixedExecutionSpecificationList.add(childExecutionSpecificationEP);
            affixedExecutionSpecificationList.addAll(LifelineXYLayoutEditPolicy.getAffixedExecutionSpecificationEditParts(childExecutionSpecificationEP, newNotToCheckExecutionSpecificationList));
        }
        return affixedExecutionSpecificationList;
    }

    protected static final boolean isAffixedToRight(Rectangle leftFigure, Rectangle rightFigure) {
        return leftFigure.touches(rightFigure) && leftFigure.x < rightFigure.x;
    }

    protected static final CompoundCommand createMovingAffixedExecutionSpecificationCommand(ShapeNodeEditPart executionSpecificationEP, Rectangle moveDelta, Rectangle newBounds) {
        if (moveDelta.y != 0 || moveDelta.height != 0) {
            CompoundCommand compoundCmd = new CompoundCommand();
            for (ShapeNodeEditPart childExecutionSpecificationEP : LifelineXYLayoutEditPolicy.getAffixedExecutionSpecificationEditParts(executionSpecificationEP)) {
                Rectangle childBounds = LifelineXYLayoutEditPolicy.getRelativeBounds(childExecutionSpecificationEP.getFigure());
                childBounds.y += moveDelta.y;
                childBounds.x += moveDelta.x;
                SetBoundsCommand childSetBoundsCmd = new SetBoundsCommand(executionSpecificationEP.getEditingDomain(), "Movement of affixed ExecutionSpecification", (IAdaptable)childExecutionSpecificationEP, childBounds);
                compoundCmd.add((Command)new ICommandProxy((ICommand)childSetBoundsCmd));
                IFigure parentFigure = childExecutionSpecificationEP.getFigure().getParent();
                parentFigure.translateToAbsolute((Translatable)newBounds);
                newBounds.translate(parentFigure.getBounds().getLocation());
                compoundCmd.add(SequenceUtil.createUpdateEnclosingInteractionCommand(childExecutionSpecificationEP, moveDelta.getLocation(), moveDelta.getSize()));
                ChangeBoundsRequest request = new ChangeBoundsRequest();
                request.setMoveDelta(new Point(0, moveDelta.y));
                OccurrenceSpecificationMoveHelper.completeMoveExecutionSpecificationCommand(compoundCmd, childExecutionSpecificationEP, childBounds.getCopy(), request);
                if (LifelineXYLayoutEditPolicy.getAffixedExecutionSpecificationEditParts(childExecutionSpecificationEP).isEmpty()) continue;
                compoundCmd.add((Command)LifelineXYLayoutEditPolicy.createMovingAffixedExecutionSpecificationCommand(childExecutionSpecificationEP, moveDelta, childBounds));
            }
            if (!compoundCmd.isEmpty()) {
                return compoundCmd;
            }
        }
        return null;
    }

    protected static final Rectangle getRealMoveDelta(Rectangle oldRelativeBounds, Rectangle newRelativeBounds) {
        Rectangle realMoveDelta = new Rectangle();
        realMoveDelta.x = newRelativeBounds.x - oldRelativeBounds.x;
        realMoveDelta.y = newRelativeBounds.y - oldRelativeBounds.y;
        realMoveDelta.height = newRelativeBounds.height - oldRelativeBounds.height;
        realMoveDelta.width = newRelativeBounds.width - oldRelativeBounds.width;
        return realMoveDelta;
    }

    protected static final Rectangle getRelativeBounds(IFigure figure) {
        Rectangle relBounds = figure.getBounds().getCopy();
        Rectangle parentRectangle = figure.getParent().getBounds();
        relBounds.x -= parentRectangle.x;
        relBounds.y -= parentRectangle.y;
        return relBounds;
    }
}

