/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.policies;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.BorderItemSelectionEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.figures.IBorderItemLocator;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.papyrus.uml.diagram.sequence.util.OccurrenceSpecificationMoveHelper;

public class TimeRelatedSelectionEditPolicy
extends BorderItemSelectionEditPolicy {
    protected Command getMoveCommand(ChangeBoundsRequest request) {
        Command command;
        this.updateRequest(request);
        if (this.getHost() instanceof IBorderItemEditPart) {
            OccurrenceSpecificationMoveHelper.prepareTimeRelatedElementMoveRequest(request, (IBorderItemEditPart)this.getHost());
        }
        if ((command = super.getMoveCommand(request)) != null) {
            command = OccurrenceSpecificationMoveHelper.completeMoveTimeRelatedElementCommand(command, request, this.getHost(), this.getHostFigure());
        }
        return command;
    }

    private void updateRequest(ChangeBoundsRequest request) {
        IBorderItemEditPart borderItemEP = (IBorderItemEditPart)this.getHost();
        IBorderItemLocator borderItemLocator = borderItemEP.getBorderItemLocator();
        if (borderItemLocator != null) {
            Rectangle initialFeedbackBounds = this.getInitialFeedbackBounds();
            PrecisionRectangle rect = new PrecisionRectangle(initialFeedbackBounds.getCopy());
            this.getHostFigure().translateToAbsolute((Translatable)rect);
            rect.translate(request.getMoveDelta());
            rect.resize(request.getSizeDelta());
            this.getHostFigure().translateToRelative((Translatable)rect);
            Rectangle realLocation = borderItemLocator.getValidLocation(rect.getCopy(), borderItemEP.getFigure());
            Point parentOrigin = borderItemEP.getFigure().getParent().getBounds().getTopLeft();
            Dimension d = realLocation.getTopLeft().getDifference(parentOrigin);
            Point newLocation = new Point(d.width, d.height);
            if (this.getHost().getModel() instanceof Node && ((Node)this.getHost().getModel()).getLayoutConstraint() instanceof Bounds) {
                Bounds bounds = (Bounds)((Node)this.getHost().getModel()).getLayoutConstraint();
                Point moveDelta = request.getMoveDelta();
                moveDelta.x = newLocation.x - bounds.getX();
                moveDelta.y = newLocation.y - bounds.getY();
            }
        }
    }

    protected void showChangeBoundsFeedback(ChangeBoundsRequest request) {
        if (this.getHost() instanceof IBorderItemEditPart) {
            OccurrenceSpecificationMoveHelper.prepareTimeRelatedElementMoveRequest(request, (IBorderItemEditPart)this.getHost());
        }
        super.showChangeBoundsFeedback(request);
    }
}

