/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.preferences;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.infra.gmfdiag.preferences.pages.AbstractPapyrusNodePreferencePage;
import org.eclipse.papyrus.infra.gmfdiag.preferences.utils.PreferenceConstantHelper;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class LifelinePreferencePage
extends AbstractPapyrusNodePreferencePage {
    public static final String LABEL_DISPLAY_PREFERENCE = "PapyrusUMLSequenceDiagram_Lifeline.label.display";
    public static final int SHOW_REPRESENT_NAME = 2;
    public static final int SHOW_REPRESENT_TYPE = 4;
    public static final int SHOW_UNDEFINED_TYPE = 8;
    public static final int SHOW_LIFELINE_NAME = 16;
    public static final int DEFAULT_LABEL_DISPLAY = 6;
    protected Button showRepName;
    protected Button showRepType;
    protected Button showUndefined;
    protected Button showName;
    private int displayValue = this.getPreferenceStore().getInt("PapyrusUMLSequenceDiagram_Lifeline.label.display");

    public LifelinePreferencePage() {
        this.setPreferenceKey("PapyrusUMLSequenceDiagram_Lifeline");
    }

    protected String getBundleId() {
        return "org.eclipse.papyrus.uml.diagram.sequence";
    }

    public static void initDefaults(IPreferenceStore store) {
        String key = "PapyrusUMLSequenceDiagram_Lifeline";
        store.setDefault(PreferenceConstantHelper.getElementConstant((String)key, (int)17), 100);
        store.setDefault(PreferenceConstantHelper.getElementConstant((String)key, (int)16), 250);
        store.setDefault(LABEL_DISPLAY_PREFERENCE, 6);
    }

    protected Button createCheckButton(Composite parent, String label, int mask) {
        Button button = new Button(parent, 32);
        button.setText(label);
        button.addSelectionListener((SelectionListener)new AppearenceSelectionListener(mask));
        return button;
    }

    protected void createLabelPreferencesButtons(Composite parent) {
        Group group = new Group(parent, 32);
        group.setText("Label Display");
        group.setLayout((Layout)new GridLayout(1, true));
        this.showRepName = this.createCheckButton((Composite)group, "Show represent name", 2);
        this.showRepType = this.createCheckButton((Composite)group, "Show represent type", 4);
        this.showUndefined = this.createCheckButton((Composite)group, "Always show undefined type", 8);
        this.showName = this.createCheckButton((Composite)group, "Always show lifeline name", 16);
    }

    protected void createPageContents(Composite parent) {
        super.createPageContents(parent);
        this.createLabelPreferencesButtons(parent);
        this.refreshButtons();
    }

    protected void loadDefaultPreferences() {
        this.displayValue = this.getPreferenceStore().getInt(LABEL_DISPLAY_PREFERENCE);
        this.refreshButtons();
    }

    protected void performDefaults() {
        this.loadDefaultPreferences();
        super.performDefaults();
    }

    public boolean performOk() {
        this.storePreferences();
        return super.performOk();
    }

    protected void refreshButtons() {
        this.showRepName.setSelection(LifelinePreferencePage.isCheck(this.displayValue, 2));
        this.showRepType.setSelection(LifelinePreferencePage.isCheck(this.displayValue, 4));
        this.showUndefined.setSelection(LifelinePreferencePage.isCheck(this.displayValue, 8));
        this.showName.setSelection(LifelinePreferencePage.isCheck(this.displayValue, 16));
    }

    private static boolean isCheck(int value, int mask) {
        return (value & mask) != 0;
    }

    protected void storePreferences() {
        super.storePreferences();
        IPreferenceStore store = this.getPreferenceStore();
        if (this.displayValue != store.getInt(LABEL_DISPLAY_PREFERENCE)) {
            store.setValue(LABEL_DISPLAY_PREFERENCE, this.displayValue);
        }
    }

    private class AppearenceSelectionListener
    implements SelectionListener {
        private final int style;

        public AppearenceSelectionListener(int style) {
            this.style = style;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            LifelinePreferencePage lifelinePreferencePage = LifelinePreferencePage.this;
            lifelinePreferencePage.displayValue = lifelinePreferencePage.displayValue ^ this.style;
            LifelinePreferencePage.this.refreshButtons();
        }
    }
}

