/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.providers;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.service.IProviderChangeListener;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.INodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IPrimaryEditPart;
import org.eclipse.gmf.runtime.diagram.ui.services.editpolicy.CreateEditPoliciesOperation;
import org.eclipse.gmf.runtime.diagram.ui.services.editpolicy.IEditPolicyProvider;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.editparts.NamedElementEditPart;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.AppliedStereotypeCommentCreationEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.AppliedStereotypeCompartmentEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.HyperLinkPopupBarEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.NavigationEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.AbstractExecutionSpecificationEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.TimeObservationEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.TimeObservationLabelEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.AnnotatedLinkEndEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.AnnotatedLinkStartEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.HighlightEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.util.SequenceUtil;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Observation;

public class CustomEditPolicyProvider
implements IEditPolicyProvider {
    public void addProviderChangeListener(IProviderChangeListener listener) {
    }

    public void createEditPolicies(EditPart editPart) {
        Object model;
        editPart.installEditPolicy((Object)"NavigationEditPolicy", (EditPolicy)new NavigationEditPolicy());
        this.installPopupbarPolicy(editPart);
        this.installHighlightPolicy(editPart);
        SequenceUtil.installObservationLinkPolicy(editPart);
        if (editPart instanceof INodeEditPart && (model = editPart.getModel()) instanceof View) {
            EObject element = ViewUtil.resolveSemanticElement((View)((View)model));
            if (element instanceof NamedElement) {
                this.installEditPolicy(editPart, (EditPolicy)new AnnotatedLinkEndEditPolicy(), "Annotated Link End Edit Policy");
            }
            if (element instanceof Constraint || element instanceof Observation || element instanceof Comment) {
                this.installEditPolicy(editPart, (EditPolicy)new AnnotatedLinkStartEditPolicy(), "Annotated Link Start Edit Policy");
            }
        }
    }

    private void installEditPolicy(EditPart editPart, EditPolicy editPolicy, String role) {
        if (editPart == null || editPolicy == null) {
            return;
        }
        EditPolicy myEditPolicy = editPart.getEditPolicy((Object)role);
        if (myEditPolicy == null) {
            editPart.installEditPolicy((Object)role, editPolicy);
        }
    }

    private void installHighlightPolicy(EditPart editPart) {
        this.installEditPolicy(editPart, (EditPolicy)new HighlightEditPolicy(), "Highlight Edit Policy");
    }

    private void installPopupbarPolicy(EditPart editPart) {
        if (!(editPart instanceof ConnectionEditPart)) {
            if (editPart instanceof IPrimaryEditPart && !(editPart instanceof TimeObservationEditPart)) {
                editPart.installEditPolicy((Object)"PopupBarEditPolicy", (EditPolicy)new HyperLinkPopupBarEditPolicy());
            }
            if (editPart instanceof TimeObservationLabelEditPart) {
                editPart.installEditPolicy((Object)"PopupBarEditPolicy", (EditPolicy)new HyperLinkPopupBarEditPolicy());
            }
        }
        if (editPart instanceof IPrimaryEditPart && editPart instanceof AbstractExecutionSpecificationEditPart) {
            editPart.installEditPolicy((Object)"Applied_Stereotype_Comment", (EditPolicy)new AppliedStereotypeCommentCreationEditPolicy());
        }
        if (editPart instanceof NamedElementEditPart) {
            editPart.installEditPolicy((Object)"AppliedStereotypeLabelDisplayEditPolicy", (EditPolicy)new AppliedStereotypeCompartmentEditPolicy());
        }
    }

    public boolean provides(IOperation operation) {
        CreateEditPoliciesOperation epOperation = (CreateEditPoliciesOperation)operation;
        if (!(epOperation.getEditPart() instanceof GraphicalEditPart) && !(epOperation.getEditPart() instanceof ConnectionEditPart)) {
            return false;
        }
        EditPart gep = epOperation.getEditPart();
        String diagramType = ((View)gep.getModel()).getDiagram().getType();
        return "PapyrusUMLSequenceDiagram".equals(diagramType);
    }

    public void removeProviderChangeListener(IProviderChangeListener listener) {
    }
}

