/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.uml.ExecutionSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LifelineModelChildrenHelper {
    public static List<View> getModelChildren(View lifeline) {
        if (lifeline == null) {
            return Collections.emptyList();
        }
        ArrayList<View> children = new ArrayList<View>((Collection<View>)lifeline.getVisibleChildren());
        List<View> result = LifelineModelChildrenHelper.sortChildren(children);
        return result;
    }

    private static List<View> sortChildren(List<View> children) {
        ArrayList<View> result = new ArrayList<View>();
        ArrayList<View> original = new ArrayList<View>(children);
        Iterator iterator = original.iterator();
        while (iterator.hasNext()) {
            View view = (View)iterator.next();
            EObject elt = ViewUtil.resolveSemanticElement((View)view);
            if (elt instanceof ExecutionSpecification) continue;
            result.add(view);
            iterator.remove();
        }
        result.addAll(original);
        Collections.sort(result, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                if (!(o1 instanceof View) || !(o2 instanceof View)) {
                    return 0;
                }
                View v1 = (View)o1;
                View v2 = (View)o2;
                EObject e1 = ViewUtil.resolveSemanticElement((View)v1);
                EObject e2 = ViewUtil.resolveSemanticElement((View)v2);
                if (e1 instanceof ExecutionSpecification && !(e2 instanceof ExecutionSpecification)) {
                    return 1;
                }
                if (!(e1 instanceof ExecutionSpecification) && e2 instanceof ExecutionSpecification) {
                    return -1;
                }
                if (!(e1 instanceof ExecutionSpecification) || !(e2 instanceof ExecutionSpecification)) {
                    return 0;
                }
                Rectangle r1 = LifelineModelChildrenHelper.getViewBounds(v1);
                Rectangle r2 = LifelineModelChildrenHelper.getViewBounds(v2);
                if (r1 == null || r1.x == 0 && r1.y == 0 || r2 == null || r2.x == 0 && r2.y == 0) {
                    return 0;
                }
                if (r1.width <= 0) {
                    r1.width = 16;
                }
                if (r2.width <= 0) {
                    r2.width = 16;
                }
                if (r1.x < r2.x || r1.right() < r2.right()) {
                    return -1;
                }
                return 1;
            }
        });
        return result;
    }

    private static Rectangle getViewBounds(View view) {
        if (view == null) {
            return null;
        }
        Integer x = LifelineModelChildrenHelper.getFeatureValue(view, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X());
        Integer y = LifelineModelChildrenHelper.getFeatureValue(view, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y());
        Integer width = LifelineModelChildrenHelper.getFeatureValue(view, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width());
        Integer height = LifelineModelChildrenHelper.getFeatureValue(view, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height());
        if (x == null && y == null && width == null && height == null) {
            return null;
        }
        return new Rectangle(x == null ? 0 : x, y == null ? 0 : y, width == null ? -1 : width, height == null ? -1 : height);
    }

    private static Integer getFeatureValue(View view, EStructuralFeature feature) {
        if (view == null || feature == null) {
            return null;
        }
        return (Integer)ViewUtil.getPropertyValue((View)view, (EStructuralFeature)feature, (EClass)feature.getEContainingClass());
    }
}

