/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.util;

import java.util.List;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.BaseSlidableAnchor;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.AbstractMessageEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CombinedFragmentEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.util.CommandHelper;

public class MessageAnchorRepairer {
    public static void repair(NodeEditPart editPart, int oldHeight, int newHeight) {
        if (editPart == null || !(editPart instanceof LifelineEditPart) && !(editPart instanceof CombinedFragmentEditPart)) {
            return;
        }
        if (oldHeight == newHeight) {
            return;
        }
        TransactionalEditingDomain editingDomain = ((GraphicalEditPart)editPart).getEditingDomain();
        List sourceConnections = editPart.getSourceConnections();
        for (Object object : sourceConnections) {
            if (!(object instanceof AbstractMessageEditPart)) continue;
            AbstractMessageEditPart conn = (AbstractMessageEditPart)((Object)object);
            Edge edge = (Edge)conn.getModel();
            IdentityAnchor anchor = (IdentityAnchor)edge.getSourceAnchor();
            MessageAnchorRepairer.updateAnchorTerminal((EditingDomain)editingDomain, anchor, oldHeight, newHeight);
        }
        List targetConnections = editPart.getTargetConnections();
        for (Object object : targetConnections) {
            if (!(object instanceof AbstractMessageEditPart)) continue;
            AbstractMessageEditPart conn = (AbstractMessageEditPart)((Object)object);
            Edge edge = (Edge)conn.getModel();
            IdentityAnchor anchor = (IdentityAnchor)edge.getTargetAnchor();
            MessageAnchorRepairer.updateAnchorTerminal((EditingDomain)editingDomain, anchor, oldHeight, newHeight);
        }
    }

    private static void updateAnchorTerminal(EditingDomain editingDomain, final IdentityAnchor anchor, int oldHeight, int newHeight) {
        String oldTerminal = anchor.getId();
        PrecisionPoint pp = BaseSlidableAnchor.parseTerminalString((String)oldTerminal);
        int yPos = (int)Math.round((double)oldHeight * pp.preciseY());
        pp.setPreciseY((double)yPos / (double)newHeight);
        if (pp.preciseY() > 1.0) {
            pp.setPreciseY(1.0);
        } else if (pp.preciseY() < 0.0) {
            pp.setPreciseY(0.0);
        }
        final String newTerminal = new BaseSlidableAnchor(null, pp).getTerminal();
        CommandHelper.executeCommandWithoutHistory(editingDomain, (Command)new AbstractCommand("Update Target Anchors"){

            public void redo() {
                this.execute();
            }

            public boolean canUndo() {
                return false;
            }

            public void execute() {
                anchor.setId(newTerminal);
            }

            public boolean canExecute() {
                return true;
            }
        }, true);
    }
}

