/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.usecase.command;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editparts.AbstractEditPart;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.papyrus.infra.core.utils.EditorUtils;
import org.eclipse.papyrus.uml.diagram.usecase.edit.commands.ExtensionPointCreateCommand;
import org.eclipse.papyrus.uml.diagram.usecase.edit.parts.ExtensionPointEditPart;
import org.eclipse.papyrus.uml.diagram.usecase.edit.parts.UseCasePointsEditPartTN;
import org.eclipse.papyrus.uml.diagram.usecase.edit.parts.UseCasePointsInComponentEditPart;
import org.eclipse.papyrus.uml.diagram.usecase.edit.parts.UseCasePointsInPackageEditPart;
import org.eclipse.papyrus.uml.diagram.usecase.providers.UMLElementTypes;
import org.eclipse.uml2.uml.Extend;
import org.eclipse.uml2.uml.ExtensionPoint;
import org.eclipse.uml2.uml.UseCase;

public class CreateExtensionPointCommand
extends Command {
    private ICommandProxy elementCreationCommand = null;
    private CompoundCommand viewsCreationCommand = null;
    private ICommandProxy setExtensionPropertyCmd;
    private AbstractEditPart compartment = null;
    private EObject containerObject;
    private IHintedType type;
    private IAdaptable adapter;

    public CreateExtensionPointCommand(IHintedType elementType, AbstractEditPart compartmentPart, EObject container, IAdaptable adapter) {
        this.elementCreationCommand = CreateExtensionPointCommand.getElementCreationCommand(container, elementType);
        this.type = elementType;
        this.compartment = compartmentPart;
        this.containerObject = container;
        this.adapter = adapter;
    }

    private static ICommandProxy getElementCreationCommand(EObject container, IHintedType elementType) {
        CreateElementRequest createElementReq = new CreateElementRequest(container, (IElementType)elementType);
        if (UMLElementTypes.ExtensionPoint_3007.equals(elementType)) {
            ExtensionPointCreateCommand cmd = new ExtensionPointCreateCommand(createElementReq);
            return new ICommandProxy((ICommand)cmd);
        }
        return null;
    }

    private ICommandProxy getExtensionPointAddCommand(Extend extend, ExtensionPoint extPoint) {
        SetExtensionPropertyCmd cmd = new SetExtensionPropertyCmd(extend, extPoint);
        return new ICommandProxy((ICommand)cmd);
    }

    public boolean canExecute() {
        return this.elementCreationCommand != null && this.elementCreationCommand.canExecute();
    }

    public void execute() {
        super.execute();
        Object extensionPoint = this.getExtensionPoint();
        if (extensionPoint instanceof ExtensionPoint && this.compartment != null && this.type != null) {
            Object object = this.adapter.getAdapter(Extend.class);
            if (object instanceof Extend) {
                Extend extend = (Extend)object;
                this.setExtensionPropertyCmd = this.getExtensionPointAddCommand(extend, (ExtensionPoint)extensionPoint);
                if (this.setExtensionPropertyCmd.canExecute()) {
                    this.setExtensionPropertyCmd.execute();
                }
            }
            this.createExtensionPointView((ExtensionPoint)extensionPoint);
        }
    }

    private Object getExtensionPoint() {
        UseCase useCase;
        Object extensionPoint = null;
        if (this.containerObject instanceof UseCase && (useCase = (UseCase)this.containerObject).getExtensionPoints() != null && !useCase.getExtensionPoints().isEmpty()) {
            extensionPoint = useCase.getExtensionPoints().get(0);
        }
        if (this.elementCreationCommand != null && extensionPoint == null) {
            this.elementCreationCommand.execute();
            extensionPoint = this.elementCreationCommand.getICommand().getCommandResult().getReturnValue();
        }
        return extensionPoint;
    }

    private void createExtensionPointView(ExtensionPoint extensionPoint) {
        this.viewsCreationCommand = new CompoundCommand();
        IGraphicalEditPart useCasePointEP = null;
        for (Object ep : this.compartment.getChildren()) {
            if (ep instanceof UseCasePointsEditPartTN) {
                useCasePointEP = (IGraphicalEditPart)ep;
                break;
            }
            if (ep instanceof UseCasePointsInComponentEditPart) {
                useCasePointEP = (IGraphicalEditPart)ep;
                break;
            }
            if (!(ep instanceof UseCasePointsInPackageEditPart)) continue;
            useCasePointEP = (IGraphicalEditPart)ep;
            break;
        }
        if (useCasePointEP != null) {
            boolean alreadyDrawn = false;
            for (Object obj : useCasePointEP.getChildren()) {
                if (!(obj instanceof ExtensionPointEditPart) || !extensionPoint.equals(((ExtensionPointEditPart)((Object)obj)).resolveSemanticElement())) continue;
                alreadyDrawn = true;
                break;
            }
            if (!alreadyDrawn) {
                CreateViewRequest.ViewDescriptor descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)new EObjectAdapter((EObject)extensionPoint), Node.class, this.type.getSemanticHint(), useCasePointEP.getDiagramPreferencesHint());
                CreateViewRequest request = new CreateViewRequest(descriptor);
                Command nodeCreationCommand = useCasePointEP.getCommand((Request)request);
                this.viewsCreationCommand.add(nodeCreationCommand);
                this.viewsCreationCommand.execute();
            }
        }
    }

    public void undo() {
        if (this.viewsCreationCommand != null) {
            this.viewsCreationCommand.undo();
        }
        if (this.setExtensionPropertyCmd != null) {
            this.setExtensionPropertyCmd.undo();
        }
        if (this.elementCreationCommand != null) {
            this.elementCreationCommand.undo();
        }
    }

    private class SetExtensionPropertyCmd
    extends AbstractTransactionalCommand {
        private ExtensionPoint extPoint;
        private Extend extend;

        public SetExtensionPropertyCmd(Extend extend, ExtensionPoint extensionPoint) {
            super(EditorUtils.getTransactionalEditingDomain(), "Set extension point property", null);
            this.extend = extend;
            this.extPoint = extensionPoint;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.extend.getExtensionLocations().add((Object)this.extPoint);
            return CommandResult.newOKCommandResult();
        }
    }
}

