/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.papyrus.uml.profile.providers.AppliedProfileContentProvider;
import org.eclipse.papyrus.uml.profile.providers.AppliedProfileLabelProvider;
import org.eclipse.papyrus.uml.tools.utils.ProfileUtil;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RefreshProfileDialog
extends SelectionDialog {
    protected final Map<Package, Collection<Profile>> profilesToReapply;
    protected Runnable callback;
    protected Package rootPackage;

    protected RefreshProfileDialog(Shell parentShell, Package rootPackage) {
        super(parentShell);
        this.setBlockOnOpen(false);
        this.rootPackage = rootPackage;
        this.profilesToReapply = new HashMap<Package, Collection<Profile>>();
        this.setTitle("Some profiles have changed");
    }

    public void setCallback(Runnable callback) {
        this.callback = callback;
    }

    public void create() {
        super.create();
        Label descriptionLabel = new Label(this.getDialogArea(), 64);
        descriptionLabel.setText("Some local profiles have changed. Select the ones you want to re-apply");
        TreeViewer viewer = new TreeViewer(this.getDialogArea());
        viewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        Tree tree = viewer.getTree();
        TableLayout layout = new TableLayout();
        TreeColumn propertyColumn = new TreeColumn(tree, 0x1000000);
        propertyColumn.setText("Package");
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(30, 300, true));
        TreeColumn ownerColumn = new TreeColumn(tree, 0x1000000);
        ownerColumn.setText("Profile");
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(60, 150, true));
        TreeColumn checkColumn = new TreeColumn(tree, 0x1000000);
        checkColumn.setText("Reapply");
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(10, 70, true));
        tree.setLayout((Layout)layout);
        tree.setHeaderVisible(true);
        viewer.setContentProvider((IContentProvider)new AppliedProfileContentProvider(this.rootPackage));
        viewer.setLabelProvider((IBaseLabelProvider)new AppliedProfileLabelProvider());
        viewer.setInput(new Object());
        this.installEditors(viewer);
        this.getDialogArea().layout();
        this.getShell().pack();
    }

    protected void installEditors(TreeViewer viewer) {
        viewer.expandAll();
        TreeItem[] treeItemArray = viewer.getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            this.installEditors(item, this.rootPackage);
            ++n2;
        }
    }

    protected void installEditors(TreeItem treeItem, final Package parentPackage) {
        Profile profile;
        Package currentPackage = (Package)treeItem.getData();
        if (currentPackage instanceof Profile && ProfileUtil.isDirty((Package)parentPackage, (Profile)(profile = (Profile)currentPackage))) {
            Tree tree = treeItem.getParent();
            final Button checkbox = new Button((Composite)tree, 32);
            checkbox.setSelection(true);
            this.getProfilesToReapply(parentPackage).add(profile);
            checkbox.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (checkbox.getSelection()) {
                        RefreshProfileDialog.this.getProfilesToReapply(parentPackage).add(profile);
                    } else {
                        RefreshProfileDialog.this.getProfilesToReapply(parentPackage).remove(profile);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            TreeEditor editor = new TreeEditor(tree);
            editor.horizontalAlignment = 0x1000000;
            editor.grabHorizontal = true;
            editor.setEditor((Control)checkbox, treeItem, 2);
        }
        TreeItem[] treeItemArray = treeItem.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem subitem = treeItemArray[n2];
            this.installEditors(subitem, currentPackage);
            ++n2;
        }
    }

    protected Composite getDialogArea() {
        return (Composite)super.getDialogArea();
    }

    protected Collection<Profile> getProfilesToReapply(Package currentPackage) {
        if (!this.profilesToReapply.containsKey(currentPackage)) {
            this.profilesToReapply.put(currentPackage, new LinkedHashSet());
        }
        return this.profilesToReapply.get(currentPackage);
    }

    protected void okPressed() {
        this.setSelectionResult(this.profilesToReapply.values().toArray());
        if (this.callback != null) {
            this.callback.run();
        }
        super.okPressed();
    }

    public Map<Package, Collection<Profile>> getProfilesToReapply() {
        return this.profilesToReapply;
    }
}

