/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.tree;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.papyrus.uml.profile.ImageManager;
import org.eclipse.papyrus.uml.profile.Message;
import org.eclipse.papyrus.uml.profile.tree.objects.AppliedStereotypePropertyTreeObject;
import org.eclipse.papyrus.uml.profile.tree.objects.AppliedStereotypeTreeObject;
import org.eclipse.papyrus.uml.profile.tree.objects.BooleanValueTreeObject;
import org.eclipse.papyrus.uml.profile.tree.objects.DataTypeValueTreeObject;
import org.eclipse.papyrus.uml.profile.tree.objects.EnumerationValueTreeObject;
import org.eclipse.papyrus.uml.profile.tree.objects.IntegerValueTreeObject;
import org.eclipse.papyrus.uml.profile.tree.objects.MetaclassValueTreeObject;
import org.eclipse.papyrus.uml.profile.tree.objects.PrimitiveTypeValueTreeObject;
import org.eclipse.papyrus.uml.profile.tree.objects.StereotypeValueTreeObject;
import org.eclipse.papyrus.uml.profile.tree.objects.StringValueTreeObject;
import org.eclipse.papyrus.uml.profile.tree.objects.UnlimitedNaturalValueTreeObject;
import org.eclipse.papyrus.uml.profile.tree.objects.UserPrimitiveTypeValueTreeObject;
import org.eclipse.papyrus.uml.profile.tree.objects.ValueTreeObject;
import org.eclipse.papyrus.uml.profile.utils.Util;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.util.UMLUtil;

public class ProfileElementLabelProvider
extends LabelProvider {
    public static final String TAB = "    ";

    public Image getImage(Object object) {
        if (object instanceof AppliedStereotypeTreeObject) {
            return ImageManager.IMG_STEREOTYPE;
        }
        if (object instanceof AppliedStereotypePropertyTreeObject) {
            return ImageManager.IMG_PROPERTY;
        }
        if (object instanceof BooleanValueTreeObject) {
            return ImageManager.IMG_LITERALBOOLEAN;
        }
        if (object instanceof StringValueTreeObject) {
            return ImageManager.IMG_LITERALSTRING;
        }
        if (object instanceof IntegerValueTreeObject) {
            return ImageManager.IMG_LITERALINTEGER;
        }
        if (object instanceof UnlimitedNaturalValueTreeObject) {
            return ImageManager.IMG_LITERALUNLIMITEDNATURAL;
        }
        if (object instanceof UserPrimitiveTypeValueTreeObject) {
            return ImageManager.IMG_PRIMITIVETYPE;
        }
        if (object instanceof EnumerationValueTreeObject) {
            return ImageManager.IMG_ENUMERATION;
        }
        if (object instanceof DataTypeValueTreeObject) {
            return ImageManager.IMG_DATATYPE;
        }
        if (object instanceof StereotypeValueTreeObject) {
            return ImageManager.IMG_STEREOTYPEPROPERTY;
        }
        if (object instanceof MetaclassValueTreeObject) {
            return ImageManager.IMG_METACLASS;
        }
        return ImageManager.IMG_UNKNOWN;
    }

    public String getText(Object object) {
        if (object == null) {
            return "null";
        }
        if (object instanceof AppliedStereotypeTreeObject) {
            Stereotype st = ((AppliedStereotypeTreeObject)object).getStereotype();
            String stName = st.getName();
            String profileName = st.getProfile().getQualifiedName();
            String label = String.valueOf(stName) + TAB + "(from " + profileName + ")";
            return label;
        }
        if (object instanceof AppliedStereotypePropertyTreeObject) {
            AppliedStereotypePropertyTreeObject pTO = (AppliedStereotypePropertyTreeObject)object;
            Property prop = pTO.getProperty();
            Type propType = prop.getType();
            Object propValue = pTO.getValue();
            return this.getPropLabel(prop, propType, propValue);
        }
        if (object instanceof ValueTreeObject) {
            return this.getLabel((ValueTreeObject)object);
        }
        return object.toString();
    }

    private String getPropLabel(Property currentProp, Type currentPropType, Object currentPropValue) {
        String label = this.getPropertyShortLabel(currentProp);
        if (currentPropValue == null) {
            label = String.valueOf(label) + " = null";
            return label;
        }
        label = currentPropType instanceof Enumeration ? this.getPropEnumerationLabel(currentProp, currentPropType, currentPropValue) : (currentPropType instanceof Stereotype ? this.getPropStereotypeLabel(currentProp, currentPropType, currentPropValue) : (currentPropType instanceof Class ? this.getPropClassLabel(currentProp, currentPropType, currentPropValue) : this.getPropDefaultLabel(currentProp, currentPropValue)));
        return label;
    }

    private String getPropEnumerationLabel(Property currentProp, Type currentPropType, Object currentPropValue) {
        String label = this.getPropertyShortLabel(currentProp);
        if (currentProp.getUpper() == 1) {
            if (currentPropValue != null) {
                label = currentPropValue instanceof EnumerationLiteral ? String.valueOf(label) + " = " + ((EnumerationLiteral)currentPropValue).getLabel() : String.valueOf(label) + " = " + currentPropValue;
            }
        } else {
            label = String.valueOf(label) + " = " + currentPropValue;
        }
        return label;
    }

    private String getPropStereotypeLabel(Property currentProp, Type currentPropType, Object currentPropValue) {
        String label = this.getPropertyShortLabel(currentProp);
        if (currentProp.getUpper() == 1) {
            Element baseElement = UMLUtil.getBaseElement((EObject)((EObject)currentPropValue));
            label = String.valueOf(label) + " = " + Util.getLabel(baseElement, true);
        } else {
            List values = (List)currentPropValue;
            ArrayList<String> baseElements = new ArrayList<String>();
            for (Object value : values) {
                Element baseElement = UMLUtil.getBaseElement((EObject)((EObject)value));
                String name = Util.getLabel(baseElement, true);
                if (name == null) continue;
                baseElements.add(name);
            }
            label = String.valueOf(label) + " = " + baseElements;
        }
        return label;
    }

    private String getPropClassLabel(Property currentProp, Type currentPropType, Object currentPropValue) {
        String label = this.getPropertyShortLabel(currentProp);
        if (Util.isMetaclass(currentPropType)) {
            if (currentProp.getUpper() == 1) {
                label = String.valueOf(label) + " = " + Util.getLabel(currentPropValue, true);
            } else {
                List values = (List)currentPropValue;
                ArrayList<String> elementNames = new ArrayList<String>();
                if (values != null) {
                    int i = 0;
                    while (i < values.size()) {
                        elementNames.add(Util.getLabel(values.get(i), true));
                        ++i;
                    }
                }
                label = String.valueOf(label) + " = " + elementNames;
            }
        }
        return label;
    }

    private String getPropDefaultLabel(Property currentProp, Object currentPropValue) {
        String label = this.getPropertyShortLabel(currentProp);
        if (currentPropValue != null) {
            label = String.valueOf(label) + " = " + currentPropValue;
        }
        return label;
    }

    private String getPropertyShortLabel(Property property) {
        String label = "";
        String derived = "";
        if (property.isDerived()) {
            derived = "/";
        }
        int upper = property.getUpper();
        int lower = property.getLower();
        Type type = property.getType();
        String typeName = type.getName();
        String name = property.getName();
        label = upper != -1 ? String.valueOf(derived) + name + ": " + typeName + " " + "[" + lower + ".." + upper + "]" : String.valueOf(derived) + name + ": " + typeName + " " + "[" + lower + "..*]";
        return label;
    }

    private String getLabel(ValueTreeObject object) {
        if (object instanceof PrimitiveTypeValueTreeObject) {
            return this.getLabel((PrimitiveTypeValueTreeObject)object);
        }
        if (object instanceof EnumerationValueTreeObject) {
            return this.getLabel((EnumerationValueTreeObject)object);
        }
        if (object instanceof DataTypeValueTreeObject) {
            return this.getLabel((DataTypeValueTreeObject)object);
        }
        if (object instanceof StereotypeValueTreeObject) {
            return this.getLabel((StereotypeValueTreeObject)object);
        }
        if (object instanceof MetaclassValueTreeObject) {
            return this.getLabel((MetaclassValueTreeObject)object);
        }
        return object.getValue().toString();
    }

    private String getLabel(PrimitiveTypeValueTreeObject object) {
        Object value = object.getValue();
        if (value != null) {
            return value.toString();
        }
        return "undefined";
    }

    private String getLabel(DataTypeValueTreeObject object) {
        Object value = object.getValue();
        if (value != null) {
            return value.toString();
        }
        return "undefined";
    }

    private String getLabel(EnumerationValueTreeObject object) {
        EnumerationValueTreeObject eTO = object;
        Property property = ((AppliedStereotypePropertyTreeObject)eTO.getParent()).getProperty();
        Object value = eTO.getValue();
        EnumerationLiteral eLiteral = null;
        if (value instanceof EnumerationLiteral) {
            eLiteral = (EnumerationLiteral)value;
        } else if (value instanceof EEnumLiteral) {
            EEnumLiteral eEnumLiteral = (EEnumLiteral)value;
            Object tmp = Util.getValueObjectFromString(eEnumLiteral.getName(), property.getType());
            eLiteral = (EnumerationLiteral)tmp;
        } else if (value instanceof String) {
            String literalString = (String)value;
            Object tmp = Util.getValueObjectFromString(literalString, property.getType());
            eLiteral = (EnumerationLiteral)tmp;
        } else if (value instanceof Enumerator) {
            String literalString = ((Enumerator)value).getLiteral();
            Object tmp = Util.getValueObjectFromString(literalString, property.getType());
            eLiteral = (EnumerationLiteral)tmp;
        } else {
            String err = "Value " + value.toString() + " of Property " + property.getName() + " is not an EnumerationLiteral.";
            Message.error(err);
        }
        if (eLiteral != null) {
            return eLiteral.getName();
        }
        return "undefined";
    }

    private String getLabel(StereotypeValueTreeObject object) {
        StereotypeValueTreeObject sTO = object;
        Property property = ((AppliedStereotypePropertyTreeObject)sTO.getParent()).getProperty();
        Object value = sTO.getValue();
        Element baseElement = null;
        if (value instanceof EObject) {
            baseElement = UMLUtil.getBaseElement((EObject)((EObject)value));
        } else {
            String err = "Type " + (value != null ? value.toString() : "null") + " of Property " + property.getName() + " is not an EObject.";
            Message.error(err);
        }
        if (baseElement != null) {
            NamedElement baseNamedElement;
            String label = baseElement.toString();
            if (baseElement instanceof ValueSpecification) {
                return Util.getOriginLabel((ValueSpecification)baseElement);
            }
            if (baseElement instanceof NamedElement && (baseNamedElement = (NamedElement)baseElement).isSetName()) {
                label = baseNamedElement.getQualifiedName();
            }
            return label;
        }
        return "undefined";
    }

    private String getLabel(MetaclassValueTreeObject object) {
        MetaclassValueTreeObject sTO = object;
        Object value = sTO.getValue();
        if (value instanceof ValueSpecification) {
            return Util.getOriginLabel((ValueSpecification)value);
        }
        if (value instanceof Element) {
            return Util.getLabel(value, false);
        }
        return "undefined";
    }
}

