/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.uml.profile.ui.dialogs.ElementImportTreeSelectionDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileTreeSelectionDialog
extends ElementImportTreeSelectionDialog {
    List<String> subProfilesList;

    public ProfileTreeSelectionDialog(Shell parent, Package model) {
        super(parent, model);
        if (!this.isAValidProfile(model)) {
            this.model = null;
        }
        this.subSelection = true;
        this.subProfilesList = new ArrayList<String>();
    }

    public ProfileTreeSelectionDialog(Shell parent, List<Package> model) {
        this(parent, model, new ArrayList<String>());
        this.subSelection = true;
    }

    public ProfileTreeSelectionDialog(Shell parent, List<Package> model, boolean testValidity) {
        this(parent, model, new ArrayList<String>());
        if (testValidity) {
            ArrayList<Package> modelToRemoveList = new ArrayList<Package>();
            for (Package currentPackage : model) {
                if (this.isAValidProfile(currentPackage)) continue;
                modelToRemoveList.add(currentPackage);
            }
            for (Package currentPackage : modelToRemoveList) {
                this.models.remove(currentPackage);
            }
            if (this.models.size() == 0) {
                MessageDialog.openError((Shell)new Shell(), (String)"Profiles not Valid", (String)"Selected profiles cannot be applied because their definition are not valid");
                this.getShell().dispose();
            }
        }
        this.subSelection = true;
    }

    public ProfileTreeSelectionDialog(Shell parent, List<Package> model, List<String> subprofiles) {
        super(parent, model);
        this.subSelection = true;
        this.subProfilesList = subprofiles;
    }

    @Override
    public ArrayList getResult() {
        ArrayList<Profile> profileList = new ArrayList<Profile>();
        for (Element currentElement : this.elementsToImport) {
            if (!(currentElement instanceof Profile)) continue;
            profileList.add((Profile)currentElement);
        }
        return profileList;
    }

    private boolean isAValidProfile(Package profile) {
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)profile);
        AdapterFactory adapterFactory = domain instanceof AdapterFactoryEditingDomain ? ((AdapterFactoryEditingDomain)domain).getAdapterFactory() : null;
        Diagnostician diagnostician = this.createDiagnostician(adapterFactory, (IProgressMonitor)new NullProgressMonitor());
        BasicDiagnostic diagnostic = diagnostician.createDefaultDiagnostic((EObject)profile);
        Map context = diagnostician.createDefaultContext();
        boolean isValid = diagnostician.validate((EObject)profile, (DiagnosticChain)diagnostic, context);
        int severity = diagnostic.getSeverity();
        return severity != 4;
    }

    protected Diagnostician createDiagnostician(final AdapterFactory adapterFactory, final IProgressMonitor progressMonitor) {
        return new Diagnostician(){

            public String getObjectLabel(EObject eObject) {
                IItemLabelProvider itemLabelProvider;
                if (adapterFactory != null && !eObject.eIsProxy() && (itemLabelProvider = (IItemLabelProvider)adapterFactory.adapt((Notifier)eObject, IItemLabelProvider.class)) != null) {
                    return itemLabelProvider.getText((Object)eObject);
                }
                return super.getObjectLabel(eObject);
            }

            public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
                progressMonitor.worked(1);
                return super.validate(eClass, eObject, diagnostics, context);
            }
        };
    }

    @Override
    protected void buildImportTreeList(TreeItem elemTree, Package _package) {
        for (Element elem : _package.getPackagedElements()) {
            TreeItem item;
            if (elem instanceof Profile) {
                item = new TreeItem(elemTree, 0);
                item.setText(((Package)elem).getName());
                item.setData((Object)elem);
                item.setImage(IMG_PROFILE);
                String name = ((Profile)elem).getQualifiedName();
                if (name != null && this.subProfilesList.contains(name)) {
                    item.setChecked(true);
                    this.elementsToImport.add(elem);
                }
                this.buildImportTreeList(item, (Package)elem);
                continue;
            }
            if (!(elem instanceof Package)) continue;
            item = new TreeItem(elemTree, 0);
            item.setText(((Package)elem).getName());
            item.setData((Object)elem);
            item.setImage(IMG_PACKAGE);
            this.buildImportTreeList(item, (Package)elem);
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Choose profile(s) to apply");
    }
}

