/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profilefacet.generation.factory;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.facet.infra.query.ModelQuery;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.emf.facet.queries.parametricquery.EStructuralFeatureArgument;
import org.eclipse.papyrus.infra.emf.facet.queries.parametricquery.ParametricQuery;
import org.eclipse.papyrus.infra.emf.facet.queries.parametricquery.ParametricqueryFactory;
import org.eclipse.papyrus.infra.emf.facet.queries.parametricquery.StringArgument;
import org.eclipse.papyrus.uml.profilefacet.generation.Activator;
import org.eclipse.papyrus.uml.profilefacet.generation.messages.Messages;
import org.eclipse.papyrus.uml.profilefacet.metamodel.profilefacet.ProfileFacetFactory;
import org.eclipse.papyrus.uml.profilefacet.metamodel.profilefacet.ProfileFacetSet;
import org.eclipse.papyrus.uml.profilefacet.metamodel.profilefacet.StereotypeFacet;
import org.eclipse.papyrus.uml.profilefacet.metamodel.profilefacet.StereotypePropertyFacetAttribute;
import org.eclipse.papyrus.uml.profilefacet.metamodel.profilefacet.StereotypePropertyFacetReference;
import org.eclipse.papyrus.uml.profilefacet.queries.registry.QueryRegistry;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;

public class ProfileFacetGenericFactory {
    private static final String BASE_ = "base_";
    private static final String UML_BOOLEAN = "Boolean";
    private static final String UML_INTEGER = "Integer";
    private static final String UML_STRING = "String";
    private static final String UML_REAL = "Real";
    private static final String UML_UNLIMITED_NATURAL = "UnlimitedNatural";
    private final QueryRegistry registry = new QueryRegistry();
    public static final String GET_QUERY_DESCRIPTION = Messages.ProfileFacetGenericFactory_GetterForStereotypeProperty;
    public static final String SET_QUERY_DESCRIPTION = Messages.ProfileFacetGenericFactory_SetterForStereotypeProperty;

    public ProfileFacetSet createProfileFacetSet(Profile profile) {
        ProfileFacetSet set = ProfileFacetFactory.eINSTANCE.createProfileFacetSet();
        set.setName(profile.getName());
        set.setProfileQualifiedName(profile.getQualifiedName());
        set.setNsPrefix(profile.getName());
        set.setNsURI("http://www.eclipse.org/papyrus/profilefacet/" + profile.getQualifiedName());
        set.setExtendedPackage((EPackage)UMLPackage.eINSTANCE);
        XMIResource res = (XMIResource)profile.eResource();
        String XMI_ID = res.getID((EObject)profile);
        set.setRepresentedElement_XMI_ID(XMI_ID);
        for (PackageableElement packagedElement : profile.getPackagedElements()) {
            StereotypeFacet stereotypeFacet;
            if (packagedElement instanceof Profile) {
                ProfileFacetSet subProfile = this.createProfileFacetSet((Profile)packagedElement);
                if (subProfile == null || subProfile.getStereotypeFacets().size() == 0 && subProfile.getSubProfileFacetSet().size() == 0) continue;
                set.getESubpackages().add((Object)subProfile);
                continue;
            }
            if (!(packagedElement instanceof Stereotype) || (stereotypeFacet = this.createFacet((Stereotype)packagedElement)).getStereotypePropertyElements().size() == 0) continue;
            set.getEClassifiers().add((Object)stereotypeFacet);
        }
        if (set.getStereotypeFacets().size() != 0 || set.getSubProfileFacetSet().size() != 0) {
            return set;
        }
        return null;
    }

    public StereotypeFacet createFacet(Stereotype stereotype) {
        StereotypeFacet facet = ProfileFacetFactory.eINSTANCE.createStereotypeFacet();
        String stereotypeQualifiedName = stereotype.getQualifiedName();
        facet.setStereotypeQualifiedName(stereotypeQualifiedName);
        facet.setName(stereotype.getName());
        facet.getESuperTypes().add((Object)UMLPackage.eINSTANCE.getElement());
        XMIResource res = (XMIResource)stereotype.eResource();
        String XMI_ID = res.getID((EObject)stereotype);
        facet.setRepresentedElement_XMI_ID(XMI_ID);
        ArrayList<String> ignoredPropertyName = new ArrayList<String>();
        for (Class extendedMetaclassName : stereotype.getAllExtendedMetaclasses()) {
            ignoredPropertyName.add(BASE_ + extendedMetaclassName.getName());
        }
        for (Property attribute : stereotype.getAttributes()) {
            StereotypePropertyFacetReference ref;
            if (ignoredPropertyName.contains(attribute.getName())) continue;
            if (attribute.getType() instanceof DataType) {
                StereotypePropertyFacetAttribute attr = this.createFacetAttribute(attribute);
                if (attr == null) continue;
                facet.getEStructuralFeatures().add((Object)attr);
                continue;
            }
            if (!(attribute.getType() instanceof EObject) || (ref = this.createFacetReference(attribute)) == null) continue;
            facet.getEStructuralFeatures().add((Object)ref);
        }
        ModelQuery query = this.getQueryForIsAppliedStereotype(stereotypeQualifiedName);
        facet.setConditionQuery(query);
        return facet;
    }

    protected ModelQuery getQueryForIsAppliedStereotype(String stereotypeQualifiedName) {
        ParametricQuery query = ParametricqueryFactory.eINSTANCE.createParametricQuery();
        query.setName("IsApplied_" + stereotypeQualifiedName + "_query");
        query.setLowerBound(0);
        query.setUpperBound(1);
        query.setReturnType((EClassifier)EcorePackage.eINSTANCE.getEBoolean());
        StringArgument arg = ParametricqueryFactory.eINSTANCE.createStringArgument();
        arg.setArgumentName("stereotypeQualifiedName");
        arg.setValue(stereotypeQualifiedName);
        query.getArguments().add((Object)arg);
        ModelQuery testStereotypeCalledQuery = this.registry.getModelQuery("isAppliedRequiredStereotype");
        query.setCalledQuery(testStereotypeCalledQuery);
        query.setDescription(NLS.bind((String)"Test if the stereotype {0} or one of its specialization is applied on the element", (Object)stereotypeQualifiedName));
        return query;
    }

    public StereotypePropertyFacetReference createFacetReference(Property property) {
        StereotypePropertyFacetReference facetReference = ProfileFacetFactory.eINSTANCE.createStereotypePropertyFacetReference();
        facetReference.setIsDerived(property.isDerived());
        facetReference.setChangeable(!property.isReadOnly());
        facetReference.setDerived(true);
        facetReference.setPropertyQualifiedName(property.getQualifiedName());
        XMIResource res = (XMIResource)property.eResource();
        String XMI_ID = res.getID((EObject)property);
        facetReference.setRepresentedElement_XMI_ID(XMI_ID);
        facetReference.setName(property.getName());
        Type type = property.getType();
        EClass eType = EcorePackage.eINSTANCE.getEObject();
        int upperBound = property.upperBound();
        facetReference.setLowerBound(property.getLower());
        facetReference.setUpperBound(property.getUpper());
        ModelQuery getCalledQuery = null;
        ModelQuery setCalledQuery = null;
        if (type instanceof Element) {
            if (upperBound == -1 || upperBound > 1) {
                getCalledQuery = this.registry.getModelQuery("getEObjectMultiReferenceValue");
                setCalledQuery = this.registry.getModelQuery("setEObjectMultiReferenceValue");
            } else {
                getCalledQuery = this.registry.getModelQuery("getEObjectSingleReferenceValue");
                setCalledQuery = this.registry.getModelQuery("setEObjectSingleReferenceValue");
            }
        } else {
            return null;
        }
        ParametricQuery getQuery = ParametricqueryFactory.eINSTANCE.createParametricQuery();
        getQuery.setName("get_" + property.getQualifiedName() + "_value");
        getQuery.setDescription(NLS.bind((String)GET_QUERY_DESCRIPTION, (Object)property.getQualifiedName()));
        getQuery.setLowerBound(facetReference.getLowerBound());
        getQuery.setUpperBound(facetReference.getUpperBound());
        getQuery.setReturnType((EClassifier)eType);
        getQuery.setCalledQuery(getCalledQuery);
        EStructuralFeatureArgument getArgument = ParametricqueryFactory.eINSTANCE.createEStructuralFeatureArgument();
        getArgument.setArgumentName("editedFeature");
        getArgument.setValue((EStructuralFeature)facetReference);
        getQuery.getArguments().add((Object)getArgument);
        ParametricQuery setQuery = ParametricqueryFactory.eINSTANCE.createParametricQuery();
        setQuery.setName("set_" + property.getQualifiedName() + "_value");
        setQuery.setDescription(NLS.bind((String)SET_QUERY_DESCRIPTION, (Object)property.getQualifiedName()));
        setQuery.setLowerBound(0);
        setQuery.setUpperBound(1);
        setQuery.setReturnType((EClassifier)eType);
        setQuery.setCalledQuery(setCalledQuery);
        EStructuralFeatureArgument setArgument = ParametricqueryFactory.eINSTANCE.createEStructuralFeatureArgument();
        setArgument.setArgumentName("editedFeature");
        setArgument.setValue((EStructuralFeature)facetReference);
        setQuery.getArguments().add((Object)setArgument);
        facetReference.setEType((EClassifier)eType);
        facetReference.setValueQuery((ModelQuery)getQuery);
        facetReference.setSetQuery((ModelQuery)setQuery);
        if (facetReference.isChangeable() && upperBound == 1) {
            facetReference.setUnsettable(true);
        }
        return facetReference;
    }

    public StereotypePropertyFacetAttribute createFacetAttribute(Property property) {
        Type type = property.getType();
        EClass eType = null;
        int upperBound = property.upperBound();
        StereotypePropertyFacetAttribute facetAttribute = ProfileFacetFactory.eINSTANCE.createStereotypePropertyFacetAttribute();
        facetAttribute.setIsDerived(property.isDerived());
        facetAttribute.setChangeable(!property.isReadOnly());
        facetAttribute.setDerived(true);
        facetAttribute.setPropertyQualifiedName(property.getQualifiedName());
        XMIResource res = (XMIResource)property.eResource();
        String XMI_ID = res.getID((EObject)property);
        facetAttribute.setRepresentedElement_XMI_ID(XMI_ID);
        facetAttribute.setName(property.getName());
        facetAttribute.setLowerBound(property.getLower());
        facetAttribute.setUpperBound(property.getUpper());
        ModelQuery getCalledQuery = null;
        ModelQuery setCalledQuery = null;
        if (type instanceof PrimitiveType) {
            PrimitiveType pType = (PrimitiveType)type;
            String name = pType.getName();
            if (UML_BOOLEAN.equals(name)) {
                eType = EcorePackage.eINSTANCE.getEBoolean();
                if (upperBound == -1 || upperBound > 1) {
                    getCalledQuery = this.registry.getModelQuery("getBooleanMultiValue");
                    setCalledQuery = this.registry.getModelQuery("setBooleanMultiValue");
                } else {
                    getCalledQuery = this.registry.getModelQuery("getBooleanSingleValue");
                    setCalledQuery = this.registry.getModelQuery("setBooleanSingleValue");
                }
            } else if (UML_INTEGER.equals(name)) {
                eType = EcorePackage.eINSTANCE.getEInt();
                if (upperBound == -1 || upperBound > 1) {
                    getCalledQuery = this.registry.getModelQuery("getIntegerMultiValue");
                    setCalledQuery = this.registry.getModelQuery("setIntegerMultiValue");
                } else {
                    getCalledQuery = this.registry.getModelQuery("getIntegerSingleValue");
                    setCalledQuery = this.registry.getModelQuery("setIntegerSingleValue");
                }
            } else if (UML_REAL.equals(name)) {
                eType = EcorePackage.eINSTANCE.getEDouble();
                if (upperBound == -1 || upperBound > 1) {
                    getCalledQuery = this.registry.getModelQuery("getRealMultiValue");
                    setCalledQuery = this.registry.getModelQuery("setRealMultiValue");
                } else {
                    getCalledQuery = this.registry.getModelQuery("getRealSingleValue");
                    setCalledQuery = this.registry.getModelQuery("setRealSingleValue");
                }
            } else if (UML_STRING.equals(name)) {
                eType = EcorePackage.eINSTANCE.getEString();
                if (upperBound == -1 || upperBound > 1) {
                    getCalledQuery = this.registry.getModelQuery("getStringMultiValue");
                    setCalledQuery = this.registry.getModelQuery("setStringMultiValue");
                } else {
                    getCalledQuery = this.registry.getModelQuery("getStringSingleValue");
                    setCalledQuery = this.registry.getModelQuery("setStringSingleValue");
                }
            } else if (UML_UNLIMITED_NATURAL.equals(name)) {
                eType = EcorePackage.eINSTANCE.getEInt();
                if (upperBound == -1 || upperBound > 1) {
                    getCalledQuery = this.registry.getModelQuery("getUnlimitedNaturalMultiValue");
                    setCalledQuery = this.registry.getModelQuery("setUnlimitedNaturalMultiValue");
                } else {
                    getCalledQuery = this.registry.getModelQuery("getUnlimitedNaturalSingleValue");
                    setCalledQuery = this.registry.getModelQuery("setUnlimitedNaturalSingleValue");
                }
            }
        } else if (type instanceof Enumeration) {
            if (upperBound == -1 || upperBound > 1) {
                eType = UMLPackage.eINSTANCE.getEnumerationLiteral();
                getCalledQuery = this.registry.getModelQuery("getUMLEnumerationMultiValue");
                setCalledQuery = this.registry.getModelQuery("setUMLEnumerationMultiValue");
            } else {
                eType = UMLPackage.eINSTANCE.getEnumerationLiteral();
                getCalledQuery = this.registry.getModelQuery("getUMLEnumerationSingleValue");
                setCalledQuery = this.registry.getModelQuery("setUMLEnumerationSingleValue");
            }
        }
        if (eType == null) {
            if (type instanceof PrimitiveType) {
                eType = EcorePackage.eINSTANCE.getEString();
                if (upperBound == -1 || upperBound > 1) {
                    getCalledQuery = this.registry.getModelQuery("getPrimitiveTypeMultiValue");
                    setCalledQuery = this.registry.getModelQuery("setPrimitiveTypeMultiValue");
                } else {
                    getCalledQuery = this.registry.getModelQuery("getPrimitiveTypeSingleValue");
                    setCalledQuery = this.registry.getModelQuery("setPrimitiveTypeSingleValue");
                }
            } else if (type instanceof DataType) {
                eType = EcorePackage.eINSTANCE.getEString();
                if (upperBound == -1 || upperBound > 1) {
                    getCalledQuery = this.registry.getModelQuery("getDatatypeMultiValue");
                    setCalledQuery = this.registry.getModelQuery("setDatatypeMultiValue");
                } else {
                    getCalledQuery = this.registry.getModelQuery("getDatatypeSingleValue");
                    setCalledQuery = this.registry.getModelQuery("setDatatypeSingleValue");
                }
            } else {
                Activator.log.warn(NLS.bind((String)Messages.ProfileFacetGenericFactory_TheTypeIsNotManaged, (Object)type));
                return null;
            }
        }
        facetAttribute.setEType(eType);
        ParametricQuery getQuery = ParametricqueryFactory.eINSTANCE.createParametricQuery();
        getQuery.setCalledQuery(getCalledQuery);
        getQuery.setName("get_" + property.getQualifiedName() + "_value");
        getQuery.setDescription(NLS.bind((String)GET_QUERY_DESCRIPTION, (Object)property.getQualifiedName()));
        getQuery.setLowerBound(facetAttribute.getLowerBound());
        getQuery.setUpperBound(facetAttribute.getUpperBound());
        getQuery.setReturnType((EClassifier)eType);
        EStructuralFeatureArgument getArgument = ParametricqueryFactory.eINSTANCE.createEStructuralFeatureArgument();
        getArgument.setValue((EStructuralFeature)facetAttribute);
        getArgument.setArgumentName("editedFeature");
        getQuery.getArguments().add((Object)getArgument);
        facetAttribute.setValueQuery((ModelQuery)getQuery);
        ParametricQuery setQuery = ParametricqueryFactory.eINSTANCE.createParametricQuery();
        setQuery.setCalledQuery(setCalledQuery);
        setQuery.setName("set_" + property.getQualifiedName() + "_value");
        setQuery.setDescription(NLS.bind((String)SET_QUERY_DESCRIPTION, (Object)property.getQualifiedName()));
        setQuery.setLowerBound(0);
        setQuery.setUpperBound(1);
        setQuery.setReturnType((EClassifier)eType);
        EStructuralFeatureArgument setArgument = ParametricqueryFactory.eINSTANCE.createEStructuralFeatureArgument();
        setArgument.setValue((EStructuralFeature)facetAttribute);
        setArgument.setArgumentName("editedFeature");
        setQuery.getArguments().add((Object)setArgument);
        facetAttribute.setSetQuery((ModelQuery)setQuery);
        return facetAttribute;
    }
}

