/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profilefacet.queries.getter;

import java.util.List;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.facet.infra.query.core.exception.ModelQueryExecutionException;
import org.eclipse.emf.facet.infra.query.core.java.ParameterValueList;
import org.eclipse.papyrus.uml.profilefacet.metamodel.profilefacet.StereotypeFacet;
import org.eclipse.papyrus.uml.profilefacet.metamodel.profilefacet.StereotypePropertyElement;
import org.eclipse.papyrus.uml.profilefacet.queries.getter.GetGenericSingleValue;
import org.eclipse.papyrus.uml.tools.utils.EnumerationUtil;
import org.eclipse.papyrus.uml.tools.utils.NamedElementUtil;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.TypedElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetUMLEnumerationSingleValue
extends GetGenericSingleValue<EnumerationLiteral> {
    @Override
    public EnumerationLiteral evaluate(Element source, ParameterValueList parameterValues) throws ModelQueryExecutionException {
        StereotypePropertyElement element = (StereotypePropertyElement)parameterValues.getParameterValueByName("editedFeature").getValue();
        if (element != null) {
            EObject container = element.eContainer();
            assert (container instanceof StereotypeFacet);
            StereotypeFacet facet = (StereotypeFacet)container;
            String stereotypeQN = facet.getStereotypeQualifiedName();
            Stereotype appliedStereotype = source.getAppliedStereotype(stereotypeQN);
            String propertyQN = element.getPropertyQualifiedName();
            String propertyName = NamedElementUtil.getNameFromQualifiedName((String)propertyQN);
            if (appliedStereotype != null) {
                Object value = source.getValue(appliedStereotype, propertyName);
                if (value instanceof Enumerator) {
                    Enumeration type = (Enumeration)((TypedElement)appliedStereotype.getOwnedMember(propertyName)).getType();
                    return EnumerationUtil.findEnumerationLiteral((Enumeration)type, (Enumerator)((Enumerator)value));
                }
                return (EnumerationLiteral)value;
            }
            if (appliedStereotype == null) {
                for (Stereotype appliedSte : source.getAppliedStereotypes()) {
                    List superClasses = StereotypeUtil.getAllSuperStereotypes((Stereotype)appliedSte);
                    for (Stereotype current : superClasses) {
                        if (!current.getQualifiedName().equals(stereotypeQN)) continue;
                        Object value = source.getValue(appliedSte, propertyName);
                        if (value instanceof Enumerator) {
                            Enumeration type = (Enumeration)((TypedElement)current.getOwnedMember(propertyName)).getType();
                            return EnumerationUtil.findEnumerationLiteral((Enumeration)type, (Enumerator)((Enumerator)value));
                        }
                        return (EnumerationLiteral)value;
                    }
                }
            }
        }
        return null;
    }
}

