/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profilefacet.queries.setter;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.facet.infra.query.core.exception.ModelQueryExecutionException;
import org.eclipse.emf.facet.infra.query.core.java.IJavaModelQueryWithEditingDomain;
import org.eclipse.emf.facet.infra.query.core.java.ParameterValueList;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.uml.profilefacet.metamodel.profilefacet.StereotypePropertyElement;
import org.eclipse.papyrus.uml.profilefacet.utils.StereotypePropertyUtils;
import org.eclipse.papyrus.uml.tools.utils.NamedElementUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetGenericSingleValue<R>
implements IJavaModelQueryWithEditingDomain<Element, R> {
    public R evaluate(Element source, ParameterValueList parameterValues) throws ModelQueryExecutionException {
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)source);
        return this.evaluate(source, parameterValues, (EditingDomain)domain);
    }

    public R evaluate(final Element source, ParameterValueList parameterValues, EditingDomain editingDomain) throws ModelQueryExecutionException {
        assert (editingDomain != null);
        final Object newValue = parameterValues.getValueByParameterName("newValue");
        StereotypePropertyElement element = (StereotypePropertyElement)parameterValues.getParameterValueByName("editedFeature").getValue();
        if (element != null) {
            Stereotype foundStereotype = StereotypePropertyUtils.getAppliedStereotype(source, element);
            String propertyQN = element.getPropertyQualifiedName();
            final String propertyName = NamedElementUtil.getNameFromQualifiedName((String)propertyQN);
            if (foundStereotype != null) {
                final Stereotype stereotype = foundStereotype;
                AbstractTransactionalCommand setValueCommand = new AbstractTransactionalCommand((TransactionalEditingDomain)editingDomain, "Set Stereotype Value Command", null){

                    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                        source.setValue(stereotype, propertyName, newValue);
                        return CommandResult.newOKCommandResult();
                    }
                };
                editingDomain.getCommandStack().execute((Command)new GMFtoEMFCommandWrapper((ICommand)setValueCommand));
            }
        }
        return null;
    }
}

