/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profilefacet.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.facet.infra.facet.Facet;
import org.eclipse.emf.facet.infra.query.ModelQuerySet;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.Column;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FacetAttributeColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FacetReferenceColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FeatureColumn;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.emf.commands.RemoveFromResourcecommand;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.table.instance.papyrustableinstance.PapyrusTableInstance;
import org.eclipse.papyrus.uml.profilefacet.messages.Messages;
import org.eclipse.papyrus.uml.profilefacet.metamodel.profilefacet.ProfileFacetSet;
import org.eclipse.papyrus.uml.profilefacet.metamodel.profilefacet.StereotypeFacet;
import org.eclipse.papyrus.uml.profilefacet.utils.AdditionalContentsUtils;
import org.eclipse.papyrus.uml.profilefacet.utils.ModelQuerySetUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Profile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileFacetSetDestroyer {
    private final Profile profile;
    private final TransactionalEditingDomain domain;

    public ProfileFacetSetDestroyer(Profile profile) {
        this.profile = profile;
        this.domain = (TransactionalEditingDomain)EMFHelper.resolveEditingDomain((EObject)profile);
    }

    public Command getDestroyFacetSetCommand() {
        CompoundCommand cmd = new CompoundCommand(Messages.ProfileFacetSetDestroyer_DestroyProfileFacetSetCommand);
        if (!AdditionalContentsUtils.areAllFacetSetUniqueByResource(this.profile.eResource().getResourceSet())) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.ProfileFacetSetDestroyer_RemoveProfileFacetSetForReappliedProfile, (String)Messages.ProfileFacetSetDestroyer_ErrorMessageOnDeleteProfileFacetSet);
            return null;
        }
        Collection<ProfileFacetSet> facetSets = AdditionalContentsUtils.getAllFacetSet(this.profile);
        HashSet<StereotypeFacet> facets = new HashSet<StereotypeFacet>();
        for (ProfileFacetSet profileFacetSet : facetSets) {
            facets.addAll(AdditionalContentsUtils.getAllStereotypeFacets(profileFacetSet));
        }
        final Map<PapyrusTableInstance, Collection<StereotypeFacet>> map = this.getAllPapyrusTableInstanceToManaged(this.profile.eResource().getResourceSet(), facets);
        for (final PapyrusTableInstance current : map.keySet()) {
            for (final Column column : current.getTable().getColumns()) {
                EObject featureContainer;
                if (!(column instanceof FacetAttributeColumn) && !(column instanceof FacetReferenceColumn) || !facets.contains(featureContainer = ((FeatureColumn)column).getFeature().eContainer())) continue;
                AbstractTransactionalCommand cc = new AbstractTransactionalCommand(this.domain, Messages.ProfileFacetSetDestroyer_RemoveColumns, null){

                    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                        current.getTable().getColumns().remove((Object)column);
                        return null;
                    }
                };
                cmd.append((Command)new GMFtoEMFCommandWrapper((ICommand)cc));
                cc = null;
            }
            AbstractTransactionalCommand cc = new AbstractTransactionalCommand(this.domain, Messages.ProfileFacetSetDestroyer_RemoveFacetSetAppliedOnTheTable, null){

                protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    current.getTable().getFacets2().removeAll((Collection)map.get(current));
                    return null;
                }
            };
            cmd.append((Command)new GMFtoEMFCommandWrapper((ICommand)cc));
        }
        HashMap ePackage_ProfileFacetSet = new HashMap();
        for (ProfileFacetSet set : facetSets) {
            EPackage pack = (EPackage)set.eContainer();
            if (!ePackage_ProfileFacetSet.containsKey(pack)) {
                ePackage_ProfileFacetSet.put(pack, new ArrayList());
            }
            ((Collection)ePackage_ProfileFacetSet.get(pack)).add(set);
        }
        for (final EPackage pack : ePackage_ProfileFacetSet.keySet()) {
            final Collection value = (Collection)ePackage_ProfileFacetSet.get(pack);
            AbstractTransactionalCommand cc = new AbstractTransactionalCommand(this.domain, null, null){

                protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    pack.getESubpackages().removeAll(value);
                    return CommandResult.newOKCommandResult();
                }
            };
            cmd.append((Command)new GMFtoEMFCommandWrapper((ICommand)cc));
            cc = new AbstractTransactionalCommand(this.domain, null, null){

                protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    if (pack.getESubpackages().size() == 0) {
                        new RemoveFromResourcecommand(ProfileFacetSetDestroyer.this.domain, pack.eResource(), (EObject)pack).execute();
                    }
                    return CommandResult.newOKCommandResult();
                }
            };
            cmd.append((Command)new GMFtoEMFCommandWrapper((ICommand)cc));
            cc = null;
            for (ProfileFacetSet set : value) {
                ModelQuerySet querySet = ModelQuerySetUtil.getModelQuerySet((EObject)set);
                if (querySet == null) continue;
                cmd.append((Command)new RemoveFromResourcecommand(this.domain, querySet.eResource(), (EObject)querySet));
            }
        }
        return cmd;
    }

    public Map<PapyrusTableInstance, Collection<StereotypeFacet>> getAllPapyrusTableInstanceToManaged(ResourceSet resourceSet, Collection<StereotypeFacet> allKnownFacets) {
        HashMap<PapyrusTableInstance, Collection<StereotypeFacet>> map = new HashMap<PapyrusTableInstance, Collection<StereotypeFacet>>();
        for (PapyrusTableInstance pTable : ProfileFacetSetDestroyer.getAllPapyrusTableInstances(resourceSet)) {
            if (this.domain.isReadOnly(pTable.eResource())) continue;
            ArrayList<StereotypeFacet> usedStereotypeFacets = new ArrayList<StereotypeFacet>();
            for (Facet current : pTable.getTable().getFacets2()) {
                if (!(current instanceof StereotypeFacet) || !allKnownFacets.contains(current)) continue;
                usedStereotypeFacets.add((StereotypeFacet)current);
            }
            if (usedStereotypeFacets.isEmpty()) continue;
            map.put(pTable, usedStereotypeFacets);
        }
        return map;
    }

    public static final Collection<PapyrusTableInstance> getAllPapyrusTableInstances(ResourceSet resourceSet) {
        ArrayList<PapyrusTableInstance> allTables = new ArrayList<PapyrusTableInstance>();
        for (Resource resource : resourceSet.getResources()) {
            for (EObject current : resource.getContents()) {
                if (!(current instanceof PapyrusTableInstance)) continue;
                allTables.add((PapyrusTableInstance)current);
            }
        }
        return allTables;
    }
}

