/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.helper.advice;

import java.util.Collection;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.ConfigureElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.papyrus.uml.service.types.helper.advice.AbstractStereotypedElementEditHelperAdvice;
import org.eclipse.papyrus.uml.service.types.utils.NamedElementHelper;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.profile.l2.L2Package;
import org.eclipse.uml2.uml.util.UMLUtil;

public class TraceEditHelperAdvice
extends AbstractStereotypedElementEditHelperAdvice {
    public TraceEditHelperAdvice() {
        this.requiredProfiles.add(L2Package.eINSTANCE);
    }

    protected ICommand getBeforeConfigureCommand(ConfigureRequest request) {
        return new ConfigureElementCommand(request){

            protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                NamedElement element = (NamedElement)request.getElementToConfigure();
                if (element != null) {
                    UMLUtil.StereotypeApplicationHelper.INSTANCE.applyStereotype((Element)element, L2Package.eINSTANCE.getRefine());
                    String initializedName = NamedElementHelper.getDefaultNameWithIncrementFromBase(L2Package.eINSTANCE.getTrace().getName(), (Collection)element.eContainer().eContents());
                    element.setName(initializedName);
                }
                return CommandResult.newOKCommandResult((Object)element);
            }
        };
    }
}

