/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.table.common.provider;

import java.util.List;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.facet.widgets.nattable.INatTableWidget;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.Column;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.TableInstance2;
import org.eclipse.emf.facet.widgets.nattable.internal.NatTableWidget;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForResource;
import org.eclipse.papyrus.infra.table.instance.papyrustableinstance.PapyrusTableInstance;
import org.eclipse.papyrus.uml.table.common.Activator;
import org.eclipse.papyrus.uml.table.common.provider.IPasteInTableCommandProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPasteInTableCommandProvider
implements IPasteInTableCommandProvider {
    protected List<Column> visibleColumns;
    protected String pasteErrorMessage = null;

    @Override
    public final String getPasteErrorMessage() {
        return this.pasteErrorMessage;
    }

    protected TransactionalEditingDomain getEditingDomain(PapyrusTableInstance papyrusTable) {
        TransactionalEditingDomain domain = null;
        ServicesRegistry serviceRegistry = null;
        try {
            serviceRegistry = ServiceUtilsForResource.getInstance().getServiceRegistry(papyrusTable.eResource());
        }
        catch (ServiceException e) {
            Activator.log.error("ServicesRegistry not found", (Throwable)e);
        }
        try {
            domain = ServiceUtils.getInstance().getTransactionalEditingDomain((Object)serviceRegistry);
        }
        catch (ServiceException e) {
            Activator.log.error("EdtingDomain not found", (Throwable)e);
        }
        return domain;
    }

    protected EReference getContainementFeature(PapyrusTableInstance papyrusTable) {
        return papyrusTable.getPastedElementContainmentFeature();
    }

    @Override
    public boolean isPasteEnabled(PapyrusTableInstance papyrusTable, String clipboardContents, INatTableWidget iTableWidget) {
        String[] rows;
        if (clipboardContents != null && !"".equals(clipboardContents) && (rows = this.getRows(clipboardContents)) != null && rows.length != 0) {
            String[] cells = this.getCells(rows[0]);
            if (this.getIElementTypeToCreateElement(papyrusTable) != null && this.getContainementFeature(papyrusTable) != null && cells.length == this.getVisibleColumns(iTableWidget).size()) {
                return true;
            }
        }
        return false;
    }

    protected String[] getRows(String table) {
        String[] rows = table.split("\n");
        return rows;
    }

    protected String[] getCells(String row) {
        return row.split("\t");
    }

    protected IElementType getIElementTypeToCreateElement(PapyrusTableInstance pTable) {
        String id = pTable.getPastedElementId();
        return ElementTypeRegistry.getInstance().getType(id);
    }

    protected List<Column> getVisibleColumns(INatTableWidget widget) {
        return ((NatTableWidget)widget).getVisibleColumnsUsingCustomizationEngine((TableInstance2)widget.getTableInstance());
    }
}

