/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.table.common.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.facet.widgets.nattable.INatTableWidget;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.Column;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FeatureColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance;
import org.eclipse.emf.facet.widgets.nattable.internal.NatTableWidget;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.infra.table.common.exceptions.ErrorInPastePreparationException;
import org.eclipse.papyrus.infra.table.instance.papyrustableinstance.PapyrusTableInstance;
import org.eclipse.papyrus.infra.tools.util.BooleanHelper;
import org.eclipse.papyrus.uml.profilefacet.metamodel.profilefacet.StereotypeFacet;
import org.eclipse.papyrus.uml.profilefacet.metamodel.profilefacet.StereotypePropertyElement;
import org.eclipse.papyrus.uml.profilefacet.utils.StereotypePropertyUtils;
import org.eclipse.papyrus.uml.table.common.factory.PapyrusTableInstanceCommandFactory;
import org.eclipse.papyrus.uml.table.common.messages.Messages;
import org.eclipse.papyrus.uml.table.common.provider.AbstractPasteInTableCommandProvider;
import org.eclipse.papyrus.uml.table.common.status.PasteWarningStatus;
import org.eclipse.papyrus.uml.table.common.status.StereotypeApplicationErrorStatus;
import org.eclipse.papyrus.uml.table.common.status.UnresolvedReferenceErrorInPasteStatus;
import org.eclipse.papyrus.uml.table.common.utils.MultiValueContainer;
import org.eclipse.papyrus.uml.table.common.utils.ValueContainer;
import org.eclipse.papyrus.uml.tools.utils.NameResolutionHelper;
import org.eclipse.papyrus.uml.tools.utils.NamedElementUtil;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PasteInPapyrusTableCommandProvider
extends AbstractPasteInTableCommandProvider {
    private static final String UML_BOOLEAN = "Boolean";
    private static final String UML_INTEGER = "Integer";
    private static final String UML_STRING = "String";
    private static final String UML_REAL = "Real";
    private static final String UML_UNLIMITED_NATURAL = "UnlimitedNatural";
    private static final int MIN_ROWS_FOR_PROGRESS_MONITOR = 5;
    private static final String TYPE_FORMAT_ERROR_MESSAGE = Messages.PasteInPapyrusTableCommandProvider_0;
    protected final Map<EClass, NameResolutionHelper> nameResolutionHelpers = new HashMap<EClass, NameResolutionHelper>();
    protected final Map<String, NameResolutionHelper> stereotypesHelper = new HashMap<String, NameResolutionHelper>();
    protected final Map<StereotypePropertyElement, Property> stereotypePropertiesMap = new HashMap<StereotypePropertyElement, Property>();

    @Override
    public Command getPasteFromFromStringCommand(final PapyrusTableInstance papyrusTable, IProgressMonitor commandCreationCancelProvider, final ProgressMonitorDialog commandExecutionProgressMonitor, String clipboardContents, final INatTableWidget iTableWidget) throws ErrorInPastePreparationException {
        boolean useDialog;
        CompoundCommand cmd = new CompoundCommand(Messages.PasteInPapyrusTableCommandProvider_1);
        TransactionalEditingDomain editingDomain = this.getEditingDomain(papyrusTable);
        Element tableContext = (Element)papyrusTable.getTable().getContext();
        this.pasteErrorMessage = null;
        this.nameResolutionHelpers.clear();
        this.stereotypesHelper.clear();
        this.stereotypePropertiesMap.clear();
        final Collection<Stereotype> stereotypeToApply = this.getStereotypesToApply(papyrusTable, iTableWidget);
        boolean addToTable = true;
        final String[] rows = this.getRows(clipboardContents);
        final ArrayList<ICommand> createCommands = new ArrayList<ICommand>();
        if (commandCreationCancelProvider != null) {
            commandCreationCancelProvider.beginTask(Messages.PasteInPapyrusTableCommandProvider_2, rows.length + 1);
        }
        boolean bl = useDialog = commandExecutionProgressMonitor != null && rows.length > 5;
        if (useDialog) {
            AbstractTransactionalCommand beginMonitor = new AbstractTransactionalCommand(editingDomain, Messages.PasteInPapyrusTableCommandProvider_3, Collections.emptyList()){

                protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    commandExecutionProgressMonitor.open();
                    commandExecutionProgressMonitor.getProgressMonitor().setTaskName(Messages.PasteInPapyrusTableCommandProvider_PastingInTable);
                    commandExecutionProgressMonitor.getProgressMonitor().beginTask(Messages.PasteInPapyrusTableCommandProvider_PastingInTable, rows.length);
                    return CommandResult.newOKCommandResult();
                }
            };
            cmd.append((Command)new GMFtoEMFCommandWrapper((ICommand)beginMonitor));
        }
        String[] stringArray = rows;
        int n = rows.length;
        int n2 = 0;
        while (n2 < n) {
            final String row = stringArray[n2];
            if (useDialog) {
                commandCreationCancelProvider.worked(1);
            }
            if (commandCreationCancelProvider != null && commandCreationCancelProvider.isCanceled()) {
                return null;
            }
            String[] cells = this.getCells(row);
            EReference containementfeature = this.getContainementFeature(papyrusTable);
            if (useDialog) {
                AbstractTransactionalCommand dialogCommand = new AbstractTransactionalCommand(editingDomain, null, null){

                    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                        commandExecutionProgressMonitor.getProgressMonitor().subTask(String.valueOf(Messages.PasteInPapyrusTableCommandProvider_Pasting) + row);
                        return CommandResult.newOKCommandResult();
                    }
                };
                cmd.append((Command)new GMFtoEMFCommandWrapper((ICommand)dialogCommand));
            }
            CreateElementRequest createRequest = new CreateElementRequest(editingDomain, (EObject)tableContext, this.getIElementTypeToCreateElement(papyrusTable), containementfeature);
            IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)tableContext);
            final ICommand commandCreation = provider.getEditCommand((IEditCommandRequest)createRequest);
            createCommands.add(commandCreation);
            cmd.append((Command)new GMFtoEMFCommandWrapper(commandCreation));
            if (stereotypeToApply.size() != 0) {
                AbstractTransactionalCommand applyStereotypesCmd = new AbstractTransactionalCommand(editingDomain, "Apply Required Stereotype", null){

                    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                        Element el = (Element)commandCreation.getCommandResult().getReturnValue();
                        PasteWarningStatus rootStatus = new PasteWarningStatus(Messages.PasteInPapyrusTableCommandProvider_ProblemToApplyStereotype, (EObject)el);
                        for (Stereotype ste : stereotypeToApply) {
                            if (el.getApplicableStereotype(ste.getQualifiedName()) == null) {
                                StereotypeApplicationErrorStatus status = new StereotypeApplicationErrorStatus(NLS.bind((String)Messages.PasteInPapyrusTableCommandProvider_TheStereotypeCantBeApplied, (Object)ste.getQualifiedName(), (Object)el), (EObject)el, ste.getQualifiedName());
                                rootStatus.addChildren(status);
                            }
                            if (el.getAppliedStereotype(ste.getQualifiedName()) != null) continue;
                            el.applyStereotype(ste);
                        }
                        if (rootStatus.isMultiStatus()) {
                            return new CommandResult((IStatus)rootStatus, (Object)rootStatus);
                        }
                        return CommandResult.newOKCommandResult();
                    }
                };
                cmd.append((Command)new GMFtoEMFCommandWrapper((ICommand)applyStereotypesCmd));
            }
            int i = 0;
            while (i < Math.min(cells.length, this.visibleColumns.size())) {
                ValueContainer<?> realValue;
                String valueAsString;
                EStructuralFeature feature;
                Column column = (Column)this.visibleColumns.get(i);
                if (column instanceof FeatureColumn && (feature = ((FeatureColumn)column).getFeature()).isChangeable() && (valueAsString = cells[i]) != null && !"".equals(valueAsString) && !"null".equals(valueAsString) && (realValue = this.deduceValueFromString((Namespace)tableContext, feature, valueAsString)) != null) {
                    if (feature instanceof StereotypePropertyElement) {
                        final String steQN = ((StereotypeFacet)feature.eContainer()).getStereotypeQualifiedName();
                        String propertyQN = ((StereotypePropertyElement)feature).getPropertyQualifiedName();
                        final String propertyName = NamedElementUtil.getNameFromQualifiedName((String)propertyQN);
                        String cmdName = NLS.bind((String)"Set value for the property {0} of the stereotype {1}.", (Object[])new String[]{propertyName, steQN});
                        AbstractTransactionalCommand setStereotypePropertyValue = new AbstractTransactionalCommand(editingDomain, cmdName, null){

                            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                                Element createdElement = (Element)commandCreation.getCommandResult().getReturnValue();
                                Stereotype stereotype = createdElement.getAppliedStereotype(steQN);
                                Object valueToSet = realValue.getValue();
                                if (stereotype == null) {
                                    StereotypeApplicationErrorStatus status = new StereotypeApplicationErrorStatus(NLS.bind((String)"The required stereotype {0} is not applied on the element", (Object)steQN), (EObject)createdElement, steQN);
                                    return CommandResult.newOKCommandResult((Object)status);
                                }
                                createdElement.setValue(stereotype, propertyName, valueToSet);
                                return CommandResult.newOKCommandResult((Object)realValue.getStatus((EObject)createdElement));
                            }
                        };
                        cmd.append((Command)new GMFtoEMFCommandWrapper((ICommand)setStereotypePropertyValue));
                    } else {
                        String label = NLS.bind((String)"Set the value for the feature {0}.", (Object)feature.getName());
                        AbstractTransactionalCommand setValueCommand = new AbstractTransactionalCommand(editingDomain, label, null){

                            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                                EObject createdElement = (EObject)commandCreation.getCommandResult().getReturnValue();
                                IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)createdElement);
                                Object valueToSet = realValue.getValue();
                                SetRequest request = new SetRequest(this.getEditingDomain(), createdElement, feature, valueToSet);
                                ICommand localSetValueCommand = provider.getEditCommand((IEditCommandRequest)request);
                                localSetValueCommand.execute(monitor, info);
                                return CommandResult.newOKCommandResult((Object)realValue.getStatus(createdElement));
                            }
                        };
                        cmd.append((Command)new GMFtoEMFCommandWrapper((ICommand)setValueCommand));
                    }
                }
                ++i;
            }
            if (useDialog) {
                AbstractTransactionalCommand dialogCommand = new AbstractTransactionalCommand(editingDomain, null, null){

                    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                        commandExecutionProgressMonitor.getProgressMonitor().worked(1);
                        return CommandResult.newOKCommandResult();
                    }
                };
                cmd.append((Command)new GMFtoEMFCommandWrapper((ICommand)dialogCommand));
            }
            ++n2;
        }
        AbstractTransactionalCommand addToTableCMD = new AbstractTransactionalCommand(editingDomain, "Launch Progress Monitor Dialog", Collections.emptyList()){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                ArrayList<EObject> toAdd = new ArrayList<EObject>();
                for (ICommand current : createCommands) {
                    EObject createdElement = (EObject)current.getCommandResult().getReturnValue();
                    toAdd.add(createdElement);
                }
                if (!toAdd.isEmpty()) {
                    CompoundCommand cmd2 = new CompoundCommand("Add pasted FlowPort to the table");
                    cmd2.append(PapyrusTableInstanceCommandFactory.getAddRowCommand(toAdd, (TableInstance)papyrusTable.getTable(), (NatTableWidget)iTableWidget));
                    cmd2.execute();
                }
                return CommandResult.newOKCommandResult();
            }
        };
        cmd.append((Command)new GMFtoEMFCommandWrapper((ICommand)addToTableCMD));
        if (useDialog) {
            AbstractTransactionalCommand endMonitor = new AbstractTransactionalCommand(editingDomain, "Close Progress Monitor Dialog", Collections.emptyList()){

                protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    commandExecutionProgressMonitor.getProgressMonitor().done();
                    commandExecutionProgressMonitor.close();
                    return CommandResult.newOKCommandResult();
                }
            };
            cmd.append((Command)new GMFtoEMFCommandWrapper((ICommand)endMonitor));
        }
        if (!cmd.isEmpty() && cmd.canExecute()) {
            return cmd;
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Collection<Stereotype> getStereotypesToApply(PapyrusTableInstance pTable, INatTableWidget iTableWidget) throws ErrorInPastePreparationException {
        ArrayList<String> stereotypeQualifiedName = new ArrayList<String>();
        for (Column col : this.visibleColumns) {
            EStructuralFeature feature;
            if (!(col instanceof FeatureColumn) || !((feature = ((FeatureColumn)col).getFeature()) instanceof StereotypePropertyElement)) continue;
            StereotypeFacet facet = (StereotypeFacet)feature.eContainer();
            stereotypeQualifiedName.add(facet.getStereotypeQualifiedName());
        }
        EList appliedProfiles = ((Element)pTable.getTable().getContext()).getNearestPackage().getAllAppliedProfiles();
        HashSet<Stereotype> toApply = new HashSet<Stereotype>();
        block1: for (String steQN : stereotypeQualifiedName) {
            String stereotypeName = NamedElementUtil.getNameFromQualifiedName((String)steQN);
            String profileQN = NamedElementUtil.getParentQualifiedName((String)steQN);
            NameResolutionHelper helper = this.stereotypesHelper.get(profileQN);
            if (helper != null) continue;
            for (Profile prof : appliedProfiles) {
                if (!prof.getQualifiedName().equals(profileQN)) continue;
                helper = new NameResolutionHelper((Namespace)prof, UMLPackage.eINSTANCE.getStereotype());
                List foundElement = helper.getNamedElements(stereotypeName);
                if (foundElement.size() == 1) {
                    Stereotype ste = (Stereotype)foundElement.get(0);
                    toApply.add(ste);
                    continue block1;
                }
                throw new ErrorInPastePreparationException(NLS.bind((String)Messages.PasteInPapyrusTableCommandProvider_RequiredStereotypeCantBeFound, (Object)stereotypeName));
            }
        }
        return toApply;
    }

    protected ValueContainer<?> deduceBooleanValue(boolean isMany, String valueAsString) throws ErrorInPastePreparationException {
        ValueContainer<Boolean> returnedValue = null;
        if (isMany) {
            ArrayList<Boolean> values = new ArrayList<Boolean>();
            String[] stringArray = valueAsString.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                if (!BooleanHelper.isBoolean((String)str)) {
                    throw new ErrorInPastePreparationException(NLS.bind((String)TYPE_FORMAT_ERROR_MESSAGE, (Object)str, (Object)UML_BOOLEAN));
                }
                values.add(Boolean.valueOf(valueAsString));
                ++n2;
            }
            returnedValue = new MultiValueContainer(values);
        } else if (BooleanHelper.isBoolean((String)valueAsString)) {
            returnedValue = new ValueContainer<Boolean>(Boolean.valueOf(valueAsString));
        } else {
            throw new ErrorInPastePreparationException(NLS.bind((String)TYPE_FORMAT_ERROR_MESSAGE, (Object)valueAsString, (Object)UML_BOOLEAN));
        }
        return returnedValue;
    }

    protected ValueContainer<?> deduceDoubleValue(boolean isMany, String valueAsString) throws ErrorInPastePreparationException {
        ValueContainer<Double> returnedValue = null;
        if (isMany) {
            ArrayList<Double> values = new ArrayList<Double>();
            String[] stringArray = valueAsString.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                Double value = Double.valueOf(str);
                if (value == null) {
                    throw new ErrorInPastePreparationException(NLS.bind((String)TYPE_FORMAT_ERROR_MESSAGE, (Object)str, (Object)"Double"));
                }
                values.add(value);
                ++n2;
            }
            returnedValue = new MultiValueContainer(values);
        } else {
            try {
                returnedValue = new ValueContainer<Double>(Double.valueOf(valueAsString));
            }
            catch (NumberFormatException e) {
                throw new ErrorInPastePreparationException(NLS.bind((String)TYPE_FORMAT_ERROR_MESSAGE, (Object)valueAsString, (Object)"Double"));
            }
        }
        return returnedValue;
    }

    protected ValueContainer<?> deduceEnumerationLiteralValue(boolean isMany, String valueAsString, Enumeration enumeration) throws ErrorInPastePreparationException {
        ValueContainer<EnumerationLiteral> returnedValue = null;
        if (isMany) {
            ArrayList<EnumerationLiteral> values = new ArrayList<EnumerationLiteral>();
            String[] stringArray = valueAsString.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                EnumerationLiteral lit = (EnumerationLiteral)enumeration.getMember(str);
                if (lit == null) {
                    throw new ErrorInPastePreparationException(NLS.bind((String)Messages.PasteInPapyrusTableCommandProvider_TheEnumerationLiteralCantBeFound, (Object)str));
                }
                values.add(lit);
                ++n2;
            }
            returnedValue = new MultiValueContainer(values);
        } else {
            EnumerationLiteral lit = (EnumerationLiteral)enumeration.getMember(valueAsString);
            if (lit == null) {
                throw new ErrorInPastePreparationException(NLS.bind((String)Messages.PasteInPapyrusTableCommandProvider_TheEnumerationLiteralCantBeFound, (Object)valueAsString));
            }
            returnedValue = new ValueContainer<EnumerationLiteral>(lit);
        }
        return returnedValue;
    }

    protected ValueContainer<?> deduceEObjectValue(Namespace namespace, EStructuralFeature feature, EClass eClass, boolean isMany, String valueAsString) {
        ValueContainer<Object> returnedValue = null;
        NameResolutionHelper helper = this.nameResolutionHelpers.get(eClass);
        if (helper == null) {
            helper = new NameResolutionHelper(namespace, eClass);
            this.nameResolutionHelpers.put(eClass, helper);
        }
        if (isMany) {
            PasteWarningStatus root = new PasteWarningStatus("Problem to find some references", null);
            HashSet<EObject> values = new HashSet<EObject>();
            String[] stringArray = valueAsString.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                List elements = helper.getNamedElements(str);
                if (elements.size() == 1) {
                    values.add((EObject)elements.get(0));
                } else {
                    root.addChildren(new UnresolvedReferenceErrorInPasteStatus(NLS.bind((String)Messages.PasteInPapyrusTableCommandProvider_TheTextCantBeMappedOnAnExistingElement, (Object)valueAsString), null, feature, str));
                }
                if (root.isMultiStatus()) {
                    returnedValue = new MultiValueContainer(values, (IStatus)root);
                }
                returnedValue = new MultiValueContainer(values);
                ++n2;
            }
        } else {
            List elements = helper.getNamedElements(valueAsString);
            returnedValue = elements.size() == 1 ? new ValueContainer<EObject>((EObject)elements.get(0)) : new ValueContainer<Object>(null, new UnresolvedReferenceErrorInPasteStatus(NLS.bind((String)Messages.PasteInPapyrusTableCommandProvider_TheTextCantBeMappedOnAnExistingElement, (Object)valueAsString), null, feature, valueAsString));
        }
        return returnedValue;
    }

    protected ValueContainer<?> deduceIntValue(boolean isMany, String valueAsString) throws ErrorInPastePreparationException {
        ValueContainer<Integer> returnedValue = null;
        if (isMany) {
            ArrayList<Integer> values = new ArrayList<Integer>();
            String[] stringArray = valueAsString.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                try {
                    values.add(Integer.valueOf(str));
                }
                catch (NumberFormatException e) {
                    throw new ErrorInPastePreparationException(NLS.bind((String)TYPE_FORMAT_ERROR_MESSAGE, (Object)str, (Object)UML_INTEGER));
                }
                ++n2;
            }
            returnedValue = new MultiValueContainer(values);
        } else {
            try {
                returnedValue = new ValueContainer<Integer>(Integer.valueOf(valueAsString));
            }
            catch (NumberFormatException e) {
                throw new ErrorInPastePreparationException(NLS.bind((String)TYPE_FORMAT_ERROR_MESSAGE, (Object)valueAsString, (Object)UML_INTEGER));
            }
        }
        return returnedValue;
    }

    protected ValueContainer<?> deduceStringValue(boolean isMany, String valueAsString) {
        ValueContainer<String> returnedValue = null;
        if (isMany) {
            ArrayList<String> values = new ArrayList<String>();
            String[] stringArray = valueAsString.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                values.add(str);
                ++n2;
            }
            returnedValue = new MultiValueContainer(values);
        } else {
            returnedValue = new ValueContainer<String>(valueAsString);
        }
        return returnedValue;
    }

    protected ValueContainer<?> deduceValueFromString(Namespace tableContext, EStructuralFeature feature, String valueAsString) throws ErrorInPastePreparationException {
        ValueContainer<?> realValue = null;
        int upperbound = feature.getUpperBound();
        boolean isMany = upperbound > 1 || upperbound == -1;
        Object featureType = null;
        Type type = null;
        if (!feature.isChangeable()) {
            return null;
        }
        if (feature instanceof StereotypePropertyElement) {
            PrimitiveType pType;
            String name;
            Property realFeature = this.stereotypePropertiesMap.get(feature);
            if (realFeature == null && (realFeature = StereotypePropertyUtils.findRealStereotypeProperty((Namespace)tableContext, (StereotypePropertyElement)((StereotypePropertyElement)feature))) != null) {
                this.stereotypePropertiesMap.put((StereotypePropertyElement)feature, realFeature);
            }
            if (realFeature == null) {
                throw new ErrorInPastePreparationException(NLS.bind((String)Messages.PasteInPapyrusTableCommandProvider_StereotypePropertyCantBeResolved, (Object)((StereotypePropertyElement)feature).getPropertyQualifiedName()));
            }
            if (realFeature.isReadOnly()) {
                return null;
            }
            type = realFeature.getType();
            featureType = type instanceof PrimitiveType ? (UML_BOOLEAN.equals(name = (pType = (PrimitiveType)type).getName()) ? EcorePackage.eINSTANCE.getEBoolean() : (UML_INTEGER.equals(name) ? EcorePackage.eINSTANCE.getEInt() : (UML_REAL.equals(name) ? EcorePackage.eINSTANCE.getEDouble() : (UML_STRING.equals(name) ? EcorePackage.eINSTANCE.getEString() : (UML_UNLIMITED_NATURAL.equals(name) ? EcorePackage.eINSTANCE.getEInt() : EcorePackage.eINSTANCE.getEString()))))) : (type instanceof Enumeration ? UMLPackage.eINSTANCE.getEnumeration() : (type instanceof DataType ? EcorePackage.eINSTANCE.getEString() : type.eClass()));
        } else {
            featureType = feature.getEType();
        }
        if (featureType instanceof EDataType) {
            String typeName = featureType.getName();
            if (UML_STRING.equals(typeName) || "EString".equals(typeName)) {
                realValue = this.deduceStringValue(isMany, valueAsString);
            } else if ("EBoolean".equals(typeName) || UML_BOOLEAN.equals(typeName)) {
                realValue = this.deduceBooleanValue(isMany, valueAsString);
            } else if ("EInt".equals(typeName) || UML_INTEGER.equals(typeName)) {
                realValue = this.deduceIntValue(isMany, valueAsString);
            } else if ("EDouble".equals(typeName)) {
                realValue = this.deduceDoubleValue(isMany, valueAsString);
            }
        } else if (featureType instanceof EClass) {
            realValue = "Enumeration".equals(featureType.getName()) ? this.deduceEnumerationLiteralValue(isMany, valueAsString, (Enumeration)type) : this.deduceEObjectValue(tableContext, feature, (EClass)featureType, isMany, valueAsString);
        }
        return realValue;
    }

    @Override
    public boolean isPasteEnabled(PapyrusTableInstance papyrusTable, String clipboardContents, INatTableWidget iTableWidget) {
        this.visibleColumns = this.getVisibleColumns(iTableWidget);
        return super.isPasteEnabled(papyrusTable, clipboardContents, iTableWidget);
    }
}

