/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.resource.UMLResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameResolutionHelper {
    protected Namespace scope;
    protected EClass filter;
    protected Map<String, List<NamedElement>> allNames;

    public NameResolutionHelper(Namespace scope, EClass filter) {
        this.scope = scope;
        this.filter = filter;
    }

    public List<NamedElement> getNamedElements(String name) {
        ArrayList namedElements;
        if (this.allNames == null) {
            this.allNames = new HashMap<String, List<NamedElement>>();
            this.computeAllNames();
        }
        return (namedElements = this.allNames.get(name)) != null ? namedElements : new ArrayList();
    }

    protected void computeAllNames() {
        List<NamedElement> l;
        this.computeNames("", this.scope, true);
        Namespace enclosingNamespace = this.scope.getNamespace();
        String prefix = "";
        while (enclosingNamespace != null) {
            prefix = "";
            this.computeNames(prefix, enclosingNamespace, false);
            enclosingNamespace = enclosingNamespace.getNamespace();
        }
        Model model = this.scope.getModel();
        if (model == null) {
            model = this.scope;
        }
        if (this.filter != null) {
            if (this.filter.isSuperTypeOf(model.eClass()) && (l = this.allNames.get(model.getName())) == null) {
                l = new ArrayList<NamedElement>();
                l.add((NamedElement)model);
                this.allNames.put(model.getName(), l);
            }
        } else {
            l = this.allNames.get(model.getName());
            if (l == null) {
                l = new ArrayList<NamedElement>();
                l.add((NamedElement)model);
                this.allNames.put(model.getName(), l);
            }
        }
        this.computeNames(String.valueOf(model.getName()) + "::", (Namespace)model, false);
        EList resources = this.scope.eResource().getResourceSet().getResources();
        for (Resource resource : resources) {
            List<NamedElement> l2;
            if (resource == this.scope.eResource() || !(resource instanceof UMLResource)) continue;
            UMLResource umlResource = (UMLResource)resource;
            Model root = null;
            TreeIterator i = umlResource.getAllContents();
            while (i.hasNext() && root == null) {
                EObject next = (EObject)i.next();
                if (!(next instanceof Model)) continue;
                root = (Model)next;
            }
            if (root == null) continue;
            if (this.filter != null) {
                if (this.filter.isSuperTypeOf(root.eClass()) && (l2 = this.allNames.get(root.getName())) == null) {
                    l2 = new ArrayList<NamedElement>();
                    l2.add((NamedElement)root);
                    this.allNames.put(root.getName(), l2);
                }
            } else {
                l2 = this.allNames.get(root.getName());
                if (l2 == null) {
                    l2 = new ArrayList<NamedElement>();
                    l2.add((NamedElement)root);
                    this.allNames.put(root.getName(), l2);
                }
            }
            this.computeNames(String.valueOf(root.getName()) + "::", (Namespace)root, false);
        }
    }

    protected void computeNames(String prefix, Namespace scope, boolean ignoreAlreadyFoundNames) {
        Set<Object> preExistingKeys = ignoreAlreadyFoundNames ? new HashSet() : this.allNames.keySet();
        for (NamedElement member : scope.getMembers()) {
            EList memberNames = scope.getNamesOfMember(member);
            for (String memberName : memberNames) {
                if (!preExistingKeys.contains(String.valueOf(prefix) + memberName)) {
                    List<NamedElement> l = this.getNamedElements(String.valueOf(prefix) + memberName);
                    l.add(member);
                    this.allNames.put(String.valueOf(prefix) + memberName, l);
                }
                if (!(member instanceof Namespace)) continue;
                this.computeNames(String.valueOf(prefix) + memberName + "::", (Namespace)member, true);
            }
        }
    }
}

