/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.modelexplorer;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.papyrus.infra.core.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.sasheditor.editor.ISashWindowsContainer;
import org.eclipse.papyrus.infra.core.ui.IRevealSemanticElement;
import org.eclipse.papyrus.infra.core.utils.EditorUtils;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.views.modelexplorer.Activator;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.navigator.ILinkHelper;

public class LinkHelper
implements ILinkHelper {
    public IStructuredSelection findSelection(IEditorInput anInput) {
        return null;
    }

    public void activateEditor(IWorkbenchPage aPage, IStructuredSelection aSelection) {
        if (aSelection == null || aSelection.isEmpty()) {
            return;
        }
        ISelectionService selectService = aPage.getWorkbenchWindow().getSelectionService();
        ISelection selection = selectService.getSelection();
        if (selection instanceof ITreeSelection) {
            IMultiDiagramEditor papyrusEditor = EditorUtils.getMultiDiagramEditor();
            try {
                ISashWindowsContainer windowsContainer = ServiceUtils.getInstance().getISashWindowsContainer((Object)papyrusEditor.getServicesRegistry());
                for (IEditorPart diagramEditor : windowsContainer.getVisibleIEditorParts()) {
                    if (!(diagramEditor instanceof IRevealSemanticElement) || !(aSelection instanceof IStructuredSelection)) continue;
                    Iterator selectionIterator = aSelection.iterator();
                    ArrayList<Object> semanticElementList = new ArrayList<Object>();
                    while (selectionIterator.hasNext()) {
                        Object semanticElement;
                        Object currentSelection = selectionIterator.next();
                        if (!(currentSelection instanceof IAdaptable) || (semanticElement = ((IAdaptable)currentSelection).getAdapter(EObject.class)) == null) continue;
                        semanticElementList.add(semanticElement);
                    }
                    ((IRevealSemanticElement)diagramEditor).revealSemanticElement(semanticElementList);
                }
            }
            catch (Exception e) {
                Activator.log.error("Impossible to acces to windows Container", (Throwable)e);
            }
        }
    }
}

