/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.modelexplorer;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.facet.infra.browser.uicore.CustomizableModelLabelProvider;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.core.editorsfactory.IPageIconsRegistry;
import org.eclipse.papyrus.infra.core.editorsfactory.PageIconsRegistry;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.utils.EditorUtils;
import org.eclipse.papyrus.infra.services.decoration.DecorationService;
import org.eclipse.papyrus.infra.services.decoration.util.Decoration;
import org.eclipse.papyrus.infra.services.decoration.util.IPapyrusDecoration;
import org.eclipse.papyrus.views.modelexplorer.Activator;
import org.eclipse.papyrus.views.modelexplorer.Messages;
import org.eclipse.papyrus.views.modelexplorer.core.ui.pagebookview.ModelExplorerDecorationAdapter;
import org.eclipse.swt.graphics.Image;

public class MoDiscoLabelProvider
extends CustomizableModelLabelProvider {
    private IPageIconsRegistry editorRegistry;
    private DecorationService decorationService;

    public MoDiscoLabelProvider() {
        super(Activator.getDefault().getCustomizationManager());
        try {
            this.decorationService = (DecorationService)EditorUtils.getServiceRegistry().getService(DecorationService.class);
        }
        catch (ServiceException ex) {
            Activator.log.error((Throwable)ex);
        }
    }

    public String getMarkerMessage(Object element) {
        EList decorations = this.decorationService.getDecorations(element, true);
        return Decoration.getMessageFromDecorations((EList)decorations);
    }

    public Image getImage(Object element) {
        EList decorations;
        ModelExplorerDecorationAdapter adapter = new ModelExplorerDecorationAdapter(null);
        if (element instanceof Diagram) {
            adapter.setDecoratorTarget(this.getEditorRegistry().getEditorIcon(element));
        } else {
            Image superImage = super.getImage(element);
            if (superImage == null) {
                return null;
            }
            adapter.setDecoratorTarget(superImage);
        }
        if (element != null && (element instanceof EObject || element instanceof IAdaptable && ((IAdaptable)element).getAdapter(EObject.class) != null) && (decorations = this.decorationService.getDecorations(element, true)) != null) {
            adapter.setDecorations((EList<IPapyrusDecoration>)decorations);
        }
        return adapter.getDecoratedImage();
    }

    protected IPageIconsRegistry getEditorRegistry() {
        if (this.editorRegistry == null) {
            this.editorRegistry = this.createEditorRegistry();
        }
        return this.editorRegistry;
    }

    protected IPageIconsRegistry createEditorRegistry() {
        try {
            return (IPageIconsRegistry)EditorUtils.getServiceRegistry().getService(IPageIconsRegistry.class);
        }
        catch (ServiceException e) {
            return new PageIconsRegistry();
        }
    }

    public String getText(Object element) {
        String text = null;
        if (element instanceof Diagram) {
            Diagram diagram = (Diagram)element;
            text = diagram.getName();
        } else if (element instanceof IAdaptable) {
            EObject obj = (EObject)((IAdaptable)element).getAdapter(EObject.class);
            if (obj instanceof InternalEObject && obj.eIsProxy()) {
                InternalEObject internal = (InternalEObject)obj;
                text = NLS.bind((String)Messages.MoDiscoLabelProvider_ProxyLabel, (Object)obj.getClass().getSimpleName(), (Object)internal.eProxyURI().trimFragment());
            } else {
                text = super.getText(element);
            }
        } else {
            text = super.getText(element);
        }
        return text;
    }
}

