/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.modelexplorer.handler;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageMngr;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.utils.ServiceUtilsForActionHandlers;
import org.eclipse.ui.handlers.HandlerUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractModelExplorerHandler
extends AbstractHandler {
    protected TransactionalEditingDomain getEditingDomain() {
        TransactionalEditingDomain editingDomain = null;
        try {
            editingDomain = ServiceUtilsForActionHandlers.getInstance().getTransactionalEditingDomain();
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        return editingDomain;
    }

    protected IPageMngr getPageManager() {
        IPageMngr pageMngr = null;
        try {
            pageMngr = ServiceUtilsForActionHandlers.getInstance().getIPageMngr();
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        return pageMngr;
    }

    private <T> T adapt(Object object, Class<T> expectedClassType) {
        EObject eobject;
        Object ele;
        if (object instanceof IAdaptable) {
            ele = ((IAdaptable)object).getAdapter(expectedClassType);
            if (ele != null) {
                return (T)ele;
            }
            if (EObject.class.isAssignableFrom(expectedClassType) && (eobject = (EObject)((IAdaptable)object).getAdapter(EObject.class)) != null && expectedClassType.isInstance(eobject)) {
                return (T)eobject;
            }
        }
        if ((ele = Platform.getAdapterManager().getAdapter(object, expectedClassType)) != null) {
            return (T)ele;
        }
        if (EObject.class.isAssignableFrom(expectedClassType) && (eobject = (EObject)Platform.getAdapterManager().getAdapter(object, EObject.class)) != null && expectedClassType.isInstance(eobject)) {
            return (T)eobject;
        }
        return null;
    }

    private <T> List<T> getAllElementAdaptedToType(List<Object> list, Class<T> expectedClassType) {
        ArrayList<T> res = new ArrayList<T>();
        for (Object cur : list) {
            T adapted = this.adapt(cur, expectedClassType);
            if (adapted == null) continue;
            res.add(adapted);
        }
        return res;
    }

    protected <T> List<T> getCurrentSelectionAdaptedToType(ExecutionEvent event, Class<T> expectedType) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            return this.getAllElementAdaptedToType(structuredSelection.toList(), expectedType);
        }
        if (selection instanceof TreeSelection) {
            TreeSelection treeSelection = (TreeSelection)selection;
            return this.getAllElementAdaptedToType(treeSelection.toList(), expectedType);
        }
        return null;
    }
}

