/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.search;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.internal.problems.ApiProblem;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IComponentDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.search.IMetadata;
import org.eclipse.pde.api.tools.internal.search.MissingRefMetadata;
import org.eclipse.pde.api.tools.internal.search.MissingRefParser;
import org.eclipse.pde.api.tools.internal.search.SearchMessages;
import org.eclipse.pde.api.tools.internal.search.UseReportConverter;
import org.osgi.framework.Version;

public class MissingRefReportConverter
extends UseReportConverter {
    private String xmlLocation = null;
    private String htmlLocation = null;
    private File reportsRoot = null;
    private File htmlIndex = null;
    Report currentreport = null;
    static final Comparator compare = new Comparator(){

        public int compare(Object o1, Object o2) {
            if (o1 instanceof String && o2 instanceof String) {
                return ((String)o1).compareTo((String)o2);
            }
            if (o1 instanceof ApiProblem && o2 instanceof ApiProblem) {
                return ((ApiProblem)o1).getMessage().compareTo(((ApiProblem)o2).getMessage());
            }
            return 0;
        }
    };

    public MissingRefReportConverter(String htmlroot, String xmlroot) {
        super(htmlroot, xmlroot, null, null);
        this.xmlLocation = xmlroot;
        this.htmlLocation = htmlroot;
    }

    public void convert(String xslt, IProgressMonitor monitor) throws Exception {
        File reportsRoot;
        File htmlRoot = new File(this.htmlLocation);
        if (!htmlRoot.exists()) {
            if (!htmlRoot.mkdirs()) {
                throw new Exception(NLS.bind((String)SearchMessages.could_not_create_file, (Object)this.htmlLocation));
            }
        } else {
            htmlRoot.mkdirs();
        }
        if (!(reportsRoot = this.getReportsRoot()).exists() || !reportsRoot.isDirectory()) {
            throw new Exception(NLS.bind((String)SearchMessages.invalid_directory_name, (Object)this.xmlLocation));
        }
        long start = 0L;
        if (ApiPlugin.DEBUG_USE_REPORT_CONVERTER) {
            start = System.currentTimeMillis();
        }
        this.writeNotSearchedPage(htmlRoot);
        if (ApiPlugin.DEBUG_USE_REPORT_CONVERTER) {
            System.out.println("done in: " + (System.currentTimeMillis() - start) + " ms");
            System.out.println("Parsing use scan...");
            start = System.currentTimeMillis();
        }
        List result = this.parse();
        if (ApiPlugin.DEBUG_USE_REPORT_CONVERTER) {
            System.out.println("done in: " + (System.currentTimeMillis() - start) + " ms");
            System.out.println("Sorting reports and writing index...");
            start = System.currentTimeMillis();
        }
        this.writeIndexPage(result);
    }

    void writeIndexPage(List result) throws Exception {
        Collections.sort(result, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((Report)o1).name.compareTo(((Report)o2).name);
            }
        });
        PrintWriter writer = null;
        try {
            try {
                File reportIndex = new File(this.getHtmlLocation(), "index.html");
                if (!reportIndex.exists()) {
                    reportIndex.createNewFile();
                }
                StringBuffer buffer = new StringBuffer();
                buffer.append("<!doctype HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n");
                buffer.append("<html>\n").append("<head>\n").append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">\n");
                this.writeMetadataHeaders(buffer);
                buffer.append("<title>").append(this.getIndexTitle()).append("</title>\n");
                buffer.append("</head>\n");
                buffer.append("<body>\n");
                buffer.append("<h3>").append(this.getIndexTitle()).append("</h3>\n");
                this.writeMetadataSummary(buffer);
                buffer.append("<h4>").append(SearchMessages.MissingRefReportConverter_AddlBundleInfo).append("</h4>\n");
                buffer.append("<p>");
                buffer.append(NLS.bind((String)SearchMessages.MissingRefReportConverter_NotSearched, (Object[])new String[]{"<a href=\"./not_searched.html\">", "</a></p>\n"}));
                if (result.size() > 0) {
                    buffer.append(this.getProblemSummaryTable());
                    if (result.size() > 0) {
                        Report report = null;
                        Iterator iter = result.iterator();
                        while (iter.hasNext()) {
                            report = (Report)iter.next();
                            if (report == null) continue;
                            File refereehtml = new File(this.getReportsRoot(), String.valueOf(report.name) + File.separator + "index.html");
                            String link = this.extractLinkFrom(this.getReportsRoot(), refereehtml.getAbsolutePath());
                            buffer.append(this.getReferenceTableEntry(report, link));
                        }
                        buffer.append("</table>\n");
                    }
                } else {
                    buffer.append(this.getNoReportsInformation());
                }
                buffer.append("<p>\n\t<a href=\"http://validator.w3.org/check?uri=referer\">\n<img src=\"http://www.w3.org/Icons/valid-html401-blue\" alt=\"Valid HTML 4.01 Transitional\" height=\"31\" width=\"88\"></a>\n</p>\n");
                buffer.append("</body>\n").append("</html>\n");
                writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(reportIndex), "UTF-8"));
                writer.print(buffer.toString());
                writer.flush();
            }
            catch (IOException iOException) {
                throw new Exception(NLS.bind((String)SearchMessages.ioexception_writing_html_file, (Object)this.getReportIndex().getAbsolutePath()));
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    protected String getNoReportsInformation() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<p>").append("<br>").append(SearchMessages.no_use_scan_ref_problems).append("</p>\n");
        return buffer.toString();
    }

    private Object getReferenceTableEntry(Report report, String link) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<tr>\n");
        buffer.append("<td><b><a href=\"").append(link).append("\">").append(this.getBundleOnlyName(report.name)).append("</a>").append("</b>").append("</td>\n");
        buffer.append("\t<td align=\"left\">").append(this.getVersion(report.name)).append("</td>\n");
        buffer.append("\t<td align=\"center\">").append(report.typeProblems).append("</td>\n");
        buffer.append("\t<td align=\"center\">").append(report.methodProblems).append("</td>\n");
        buffer.append("\t<td align=\"center\">").append(report.fieldProblems).append("</td>\n");
        buffer.append("\t<td align=\"center\">").append(report.getTotal()).append("</td>\n");
        buffer.append("</tr>\n");
        return buffer.toString();
    }

    private StringBuffer getProblemSummaryTable() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<h4>").append(SearchMessages.MissingRefReportConverter_ProblemSummaryTitle).append("</h4>\n");
        buffer.append("<p>").append(SearchMessages.MissingRefReportConverter_ProblemSummary).append("</p>\n");
        buffer.append("<table border=\"1\" width=\"80%\">\n");
        buffer.append("<tr>\n");
        buffer.append("\t<td bgcolor=\"").append("#E0C040").append("\" width=\"25%\" title=\"");
        buffer.append(SearchMessages.MissingRefReportConverter_ProblemTable_ColumnBundleTooltip).append("\"\">");
        buffer.append("<b>").append(SearchMessages.MissingRefReportConverter_ProblemTable_ColumnBundle).append("</b>").append("</td>\n");
        buffer.append("\t<td bgcolor=\"").append("#E0C040").append("\" align=\"center\" width=\"15%\" title=\"");
        buffer.append(SearchMessages.MissingRefReportConverter_ProblemTable_ColumnVersionTooltip).append("\"\">");
        buffer.append("<b>").append(SearchMessages.MissingRefReportConverter_ProblemTable_ColumnVersion).append("</b>").append("</td>\n");
        buffer.append("\t<td bgcolor=\"").append("#E0C040").append("\" align=\"center\" width=\"15%\" title=\"");
        buffer.append(SearchMessages.MissingRefReportConverter_ProblemTable_ColumnMissingTypesTooltip).append("\">");
        buffer.append("<b>").append(SearchMessages.MissingRefReportConverter_ProblemTable_ColumnMissingTypes).append("</b>").append("</td>\n");
        buffer.append("\t<td bgcolor=\"").append("#E0C040").append("\" align=\"center\" width=\"15%\" title=\"");
        buffer.append(SearchMessages.MissingRefReportConverter_ProblemTable_ColumnMissingMethodsTooltip).append("\">");
        buffer.append("<b>").append(SearchMessages.MissingRefReportConverter_ProblemTable_ColumnMissingMethods).append("</b>").append("</td>\n");
        buffer.append("\t<td bgcolor=\"").append("#E0C040").append("\" align=\"center\" width=\"15%\" title=\"");
        buffer.append(SearchMessages.MissingRefReportConverter_ProblemTable_ColumnMissingFieldsTooltip).append("\">");
        buffer.append("<b>").append(SearchMessages.MissingRefReportConverter_ProblemTable_ColumnMissingFields).append("</b>").append("</td>\n");
        buffer.append("\t<td bgcolor=\"").append("#E0C040").append("\" align=\"center\" width=\"15%\" title=\"");
        buffer.append(SearchMessages.MissingRefReportConverter_ProblemTable_ColumnTotalTooltip).append("\">");
        buffer.append("<b>").append(SearchMessages.MissingRefReportConverter_ProblemTable_ColumnTotal).append("</b>").append("</td>\n");
        return buffer;
    }

    void writeMetadataSummary(StringBuffer buffer) throws Exception {
        MissingRefMetadata metadata = (MissingRefMetadata)this.getMetadata();
        buffer.append("<h4>").append(SearchMessages.MissingRefReportConverter_MetadataTitle).append("</h4>\n");
        buffer.append("<table border=\"0px\" title=\"").append(SearchMessages.MissingRefReportConverter_MetadataTableTitle).append("\"width=\"50%\">");
        buffer.append("<tr>\n");
        buffer.append(MissingRefReportConverter.openTD(14)).append(SearchMessages.MissingRefReportConverter_ReportDate).append("</td>\n");
        buffer.append(MissingRefReportConverter.openTD(36)).append(metadata.getRunAtDate()).append("</td>\n");
        buffer.append("</tr>\n");
        buffer.append("<tr>\n");
        buffer.append(MissingRefReportConverter.openTD(14)).append(SearchMessages.MissingRefReportConverter_ProfileLocation).append("</td>\n");
        String value = metadata.getProfile();
        buffer.append(MissingRefReportConverter.openTD(36)).append(value != null ? value : SearchMessages.MissingRefReportConverter_NONE).append("</td>\n");
        buffer.append("</tr>\n");
        buffer.append("<tr>\n");
        buffer.append(MissingRefReportConverter.openTD(14)).append(SearchMessages.MissingRefReportConverter_ReportLocation).append("</td>\n");
        value = metadata.getReportLocation();
        buffer.append(MissingRefReportConverter.openTD(36)).append(value != null ? value : SearchMessages.MissingRefReportConverter_NONE).append("</td>\n");
        buffer.append("</tr>\n");
        buffer.append("<tr>\n");
        buffer.append(MissingRefReportConverter.openTD(14)).append(SearchMessages.MissingRefReportConverter_ApiUseScanLocations).append("</td>\n");
        value = metadata.getApiUseScans();
        buffer.append(MissingRefReportConverter.openTD(36)).append(value != null ? value : SearchMessages.MissingRefReportConverter_NONE).append("</td>\n");
        buffer.append("</tr>\n");
        buffer.append("</td>\n");
        buffer.append("</tr>\n");
        buffer.append("</table>\n");
    }

    IMetadata getMetadata() throws Exception {
        File xmlFile = new File(this.getReportsRoot(), "meta.xml");
        if (!xmlFile.exists()) {
            xmlFile = new File(this.getReportsRoot() + File.separator + "xml", "meta.xml");
        }
        return MissingRefMetadata.getMetadata(xmlFile);
    }

    protected String getIndexTitle() {
        return SearchMessages.MissingRefReportConverter_ReportTitle;
    }

    protected void writeMetadataHeaders(StringBuffer buffer) {
        buffer.append("<meta name=\"").append("description").append("\" content=\"").append(SearchMessages.MissingRefReportConverter_IndexMetaTag).append("\">");
    }

    protected List parse() throws Exception {
        MissingRefParser parser = new MissingRefParser();
        MissingRefVisitor visitor = new MissingRefVisitor();
        parser.parse(this.getXmlLocation(), visitor);
        return visitor.reports;
    }

    protected String getHtmlLocation() {
        return this.htmlLocation;
    }

    protected String getXmlLocation() {
        return this.xmlLocation;
    }

    protected File getReportsRoot() {
        if (this.reportsRoot == null) {
            this.reportsRoot = new File(this.getXmlLocation());
        }
        return this.reportsRoot;
    }

    public File getReportIndex() {
        if (this.htmlIndex == null) {
            return new File(this.htmlLocation);
        }
        return this.htmlIndex;
    }

    class MissingRefVisitor {
        public List reports;

        MissingRefVisitor() {
        }

        public void visitScan() {
            this.reports = new ArrayList();
        }

        public boolean visitComponent(IComponentDescriptor targetComponent) {
            MissingRefReportConverter.this.currentreport = new Report();
            MissingRefReportConverter.this.currentreport.name = this.composeName(targetComponent.getId(), targetComponent.getVersion());
            this.reports.add(MissingRefReportConverter.this.currentreport);
            return true;
        }

        protected String composeName(String id, String version) {
            String versionName = version;
            if (version == null) {
                versionName = Version.emptyVersion.toString();
            }
            StringBuffer buffer = new StringBuffer(3 + id.length() + versionName.length());
            buffer.append(id).append(" (").append(versionName).append(")");
            return buffer.toString();
        }

        public void endVisitComponent() {
            try {
                this.writeIndexFileForComponent(MissingRefReportConverter.this.currentreport);
            }
            catch (Exception e) {
                ApiPlugin.log(e);
            }
        }

        private void writeIndexFileForComponent(Report report) throws Exception {
            PrintWriter writer = null;
            File originhtml = null;
            try {
                try {
                    File htmlroot = new File(MissingRefReportConverter.this.getHtmlLocation(), report.name);
                    if (!htmlroot.exists()) {
                        htmlroot.mkdirs();
                    }
                    if (!(originhtml = new File(htmlroot, "index.html")).exists()) {
                        originhtml.createNewFile();
                    }
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("<!doctype HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n");
                    buffer.append("<html>\n").append("<head>\n").append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">\n");
                    buffer.append(REF_STYLE);
                    buffer.append(REF_SCRIPT);
                    buffer.append("<title>").append(this.getProblemTitle(report.name)).append("</title>\n");
                    buffer.append("</head>\n");
                    buffer.append("<body>\n");
                    buffer.append("<h3>").append(this.getProblemTitle(report.name)).append("</h3>\n");
                    buffer.append(this.getProblemSummary(report));
                    StringBuffer typeProblems = new StringBuffer();
                    StringBuffer methodProblems = new StringBuffer();
                    StringBuffer fieldProblems = new StringBuffer();
                    Map.Entry entry = null;
                    Integer key = null;
                    TreeMap types = null;
                    Iterator iterator = report.apiProblems.entrySet().iterator();
                    while (iterator.hasNext()) {
                        entry = iterator.next();
                        key = (Integer)entry.getKey();
                        types = (TreeMap)entry.getValue();
                        switch (key) {
                            case 1: {
                                typeProblems.append(this.getProblemTable(types));
                                break;
                            }
                            case 2: {
                                methodProblems.append(this.getProblemTable(types));
                                break;
                            }
                            case 3: {
                                fieldProblems.append(this.getProblemTable(types));
                            }
                        }
                    }
                    buffer.append(this.getProblemsTableHeader(SearchMessages.MissingRefReportConverter_ProblemDetails, SearchMessages.MissingRefReportConverter_ProblemTypes));
                    if (typeProblems.length() > 0) {
                        buffer.append(this.getProblemRow(typeProblems, SearchMessages.MissingRefReportConverter_Type));
                    }
                    if (methodProblems.length() > 0) {
                        buffer.append(this.getProblemRow(methodProblems, SearchMessages.MissingRefReportConverter_Method));
                    }
                    if (fieldProblems.length() > 0) {
                        buffer.append(this.getProblemRow(fieldProblems, SearchMessages.MissingRefReportConverter_Field));
                    }
                    buffer.append("</table>\n");
                    buffer.append("<p>").append("<a href=\"../index.html\">").append(SearchMessages.MissingRefReportConverter_BackToIndex).append("</a>\n").append("</p>\n");
                    buffer.append("<p>\n\t<a href=\"http://validator.w3.org/check?uri=referer\">\n<img src=\"http://www.w3.org/Icons/valid-html401-blue\" alt=\"Valid HTML 4.01 Transitional\" height=\"31\" width=\"88\"></a>\n</p>\n");
                    buffer.append("</body>\n");
                    writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(originhtml), "UTF-8"));
                    writer.println(buffer.toString());
                    writer.flush();
                }
                catch (IOException iOException) {
                    throw new Exception(NLS.bind((String)SearchMessages.ioexception_writing_html_file, (Object)originhtml.getAbsolutePath()));
                }
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
        }

        private StringBuffer getProblemRow(StringBuffer type, String header) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("<tr>\n");
            buffer.append("<td align=\"left\">\n");
            buffer.append("<b>");
            buffer.append("<a href=\"javascript:void(0)\" class=\"typeslnk\" onclick=\"expand(this)\" title=\"");
            buffer.append(header).append("\">\n");
            buffer.append("<span>[+] </span>").append(header).append("\n");
            buffer.append("</a>\n").append("</b>");
            buffer.append("<div colspan=\"6\" class=\"types\">\n");
            buffer.append(type).append("\n");
            buffer.append("</div>\n");
            buffer.append("</tr>\n");
            return buffer;
        }

        private StringBuffer getProblemTable(TreeMap types) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("<table width=\"100%\" border=\"0\" cellspacing=\"1\" cellpadding=\"6\">\n");
            Map.Entry entry = null;
            String tname = null;
            ArrayList pbs = null;
            Iterator i = types.entrySet().iterator();
            while (i.hasNext()) {
                entry = i.next();
                tname = (String)entry.getKey();
                pbs = (ArrayList)entry.getValue();
                buffer.append("<tr align=\"left\"> \n");
                buffer.append("<td colspan=\"1\" bgcolor=\"#CCCCCC\">").append("<b>").append(tname).append("</b>").append("</td>\n");
                buffer.append("</tr>\n");
                ApiProblem pb = null;
                Collections.sort(pbs, compare);
                Iterator i2 = pbs.iterator();
                while (i2.hasNext()) {
                    pb = (ApiProblem)i2.next();
                    buffer.append("<tr>\n");
                    buffer.append("<td align=\"left\" width=\"75%\">").append(pb.getMessage()).append("</td>\n");
                    buffer.append("</tr>\n");
                }
            }
            buffer.append("</table>\n");
            return buffer;
        }

        private Object getProblemSummary(Report report) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("<h4>").append(SearchMessages.MissingRefReportConverter_Summary).append("</h4>\n");
            buffer.append("<p>").append(NLS.bind((String)SearchMessages.MissingRefReportConverter_SummaryDesc, (Object[])new String[]{report.name, Integer.toString(report.apiProblems.size())})).append("</p>\n");
            return buffer.toString();
        }

        String getProblemsTableHeader(String sectionname, String type) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("<h4>").append(sectionname).append("</h4>\n");
            buffer.append("<p>").append(SearchMessages.MissingRefReportConverter_ProblemTableHeader).append("</p>\n");
            buffer.append("<div align=\"left\" class=\"main\">");
            buffer.append("<table border=\"1\" width=\"80%\">\n");
            buffer.append("<tr>\n");
            buffer.append("<td bgcolor=\"").append("#E0C040").append("\">").append("<b>").append(type).append("</b></td>\n");
            buffer.append("</tr>\n");
            return buffer.toString();
        }

        protected String getProblemTitle(String bundle) {
            return NLS.bind((String)SearchMessages.MissingRefReportConverter_ProblemTitle, (Object)bundle);
        }

        public void addToCurrentReport(List apiProblems) {
            MissingRefReportConverter.this.currentreport.add(apiProblems);
        }
    }

    static class Report {
        String name = null;
        TreeMap apiProblems = new TreeMap();
        int typeProblems = 0;
        int methodProblems = 0;
        int fieldProblems = 0;

        Report() {
        }

        public void add(List apiProblems) {
            ApiProblem pb = null;
            ArrayList<ApiProblem> list = null;
            TreeMap<String, ArrayList<ApiProblem>> types = null;
            Iterator i = apiProblems.iterator();
            while (i.hasNext()) {
                String tname;
                pb = (ApiProblem)i.next();
                Integer key = new Integer(pb.getKind());
                types = (TreeMap<String, ArrayList<ApiProblem>>)this.apiProblems.get(key);
                if (types == null) {
                    types = new TreeMap<String, ArrayList<ApiProblem>>(compare);
                    this.apiProblems.put(key, types);
                }
                if ((list = (ArrayList<ApiProblem>)types.get(tname = pb.getTypeName())) == null) {
                    list = new ArrayList<ApiProblem>();
                    types.put(tname, list);
                }
                list.add(pb);
                switch (pb.getKind()) {
                    case 1: {
                        ++this.typeProblems;
                        break;
                    }
                    case 2: {
                        ++this.methodProblems;
                        break;
                    }
                    case 3: {
                        ++this.fieldProblems;
                    }
                }
            }
        }

        public int getTotal() {
            return this.typeProblems + this.methodProblems + this.fieldProblems;
        }
    }
}

