/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.record;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.DescriptorEvent;
import org.eclipse.persistence.descriptors.DescriptorEventManager;
import org.eclipse.persistence.descriptors.InheritancePolicy;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.identitymaps.CacheId;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.oxm.ContainerValue;
import org.eclipse.persistence.internal.oxm.MappingNodeValue;
import org.eclipse.persistence.internal.oxm.NodeValue;
import org.eclipse.persistence.internal.oxm.NullCapableValue;
import org.eclipse.persistence.internal.oxm.Reference;
import org.eclipse.persistence.internal.oxm.SAXFragmentBuilder;
import org.eclipse.persistence.internal.oxm.StrBuffer;
import org.eclipse.persistence.internal.oxm.TreeObjectBuilder;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.XPathNode;
import org.eclipse.persistence.internal.oxm.XPathPredicate;
import org.eclipse.persistence.internal.oxm.XPathQName;
import org.eclipse.persistence.internal.oxm.record.ExtendedContentHandler;
import org.eclipse.persistence.internal.oxm.record.ObjectUnmarshalContext;
import org.eclipse.persistence.internal.oxm.record.SequencedUnmarshalContext;
import org.eclipse.persistence.internal.oxm.record.UnmappedContentHandlerWrapper;
import org.eclipse.persistence.internal.oxm.record.UnmarshalContext;
import org.eclipse.persistence.internal.oxm.record.XMLReader;
import org.eclipse.persistence.internal.oxm.record.namespaces.StackUnmarshalNamespaceResolver;
import org.eclipse.persistence.internal.oxm.record.namespaces.UnmarshalNamespaceResolver;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.mappings.foundation.AbstractTransformationMapping;
import org.eclipse.persistence.oxm.MediaType;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLUnmarshalListener;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.mappings.XMLMapping;
import org.eclipse.persistence.oxm.record.DOMRecord;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.oxm.unmapped.DefaultUnmappedContentHandler;
import org.eclipse.persistence.oxm.unmapped.UnmappedContentHandler;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.ext.Locator2;
import org.xml.sax.ext.Locator2Impl;

public class UnmarshalRecord
extends XMLRecord
implements ExtendedContentHandler,
LexicalHandler {
    public static final UnmappedContentHandler DEFAULT_UNMAPPED_CONTENT_HANDLER = new DefaultUnmappedContentHandler();
    protected XMLReader xmlReader;
    private TreeObjectBuilder treeObjectBuilder;
    private XPathFragment xPathFragment = new XPathFragment();
    private XPathNode xPathNode;
    private int levelIndex;
    private UnmarshalRecord childRecord;
    protected UnmarshalRecord parentRecord;
    private DOMRecord transformationRecord;
    private List<UnmarshalRecord> selfRecords;
    private Map<XPathFragment, Integer> indexMap;
    private List<NullCapableValue> nullCapableValues;
    private Object[] containerInstances;
    private List<ContainerValue> defaultEmptyContainerValues;
    private List<ContainerValue> populatedContainerValues;
    private boolean isBufferCDATA;
    private Attributes attributes;
    private QName typeQName;
    protected String rootElementLocalName;
    protected String rootElementName;
    protected String rootElementNamespaceUri;
    private SAXFragmentBuilder fragmentBuilder;
    private Map<String, String> prefixesForFragment;
    private String encoding;
    private String version;
    private String schemaLocation;
    private String noNamespaceSchemaLocation;
    private boolean isSelfRecord;
    private UnmarshalContext unmarshalContext;
    private UnmarshalNamespaceResolver unmarshalNamespaceResolver;
    private boolean isXsiNil;
    private boolean xpathNodeIsMixedContent = false;
    private int unmappedLevel = -1;
    private Locator xmlLocation;
    protected XPathFragment textWrapperFragment;

    public UnmarshalRecord(TreeObjectBuilder treeObjectBuilder) {
        this.xPathFragment.setNamespaceAware(this.isNamespaceAware());
        this.initialize(treeObjectBuilder);
    }

    protected UnmarshalRecord initialize(TreeObjectBuilder treeObjectBuilder) {
        this.isBufferCDATA = false;
        this.treeObjectBuilder = treeObjectBuilder;
        if (treeObjectBuilder != null) {
            this.xPathNode = treeObjectBuilder.getRootXPathNode();
            if (treeObjectBuilder.getNullCapableValues() != null) {
                this.nullCapableValues = new ArrayList<NullCapableValue>(treeObjectBuilder.getNullCapableValues());
            }
            if (treeObjectBuilder.getDefaultEmptyContainerValues() != null) {
                this.defaultEmptyContainerValues = new ArrayList<ContainerValue>(treeObjectBuilder.getDefaultEmptyContainerValues());
            }
        }
        this.isSelfRecord = false;
        return this;
    }

    private void reset() {
        this.xPathNode = null;
        this.childRecord = null;
        this.transformationRecord = null;
        if (this.selfRecords != null) {
            this.selfRecords.clear();
        }
        if (this.indexMap != null) {
            this.indexMap.clear();
        }
        this.nullCapableValues = null;
        this.isBufferCDATA = false;
        this.attributes = null;
        this.typeQName = null;
        this.isSelfRecord = false;
        this.unmarshalContext = null;
        this.isXsiNil = false;
        this.unmappedLevel = -1;
    }

    @Override
    public String getLocalName() {
        return this.rootElementLocalName;
    }

    public void setLocalName(String localName) {
        this.rootElementLocalName = localName;
    }

    @Override
    public String getNamespaceURI() {
        throw XMLMarshalException.operationNotSupported("getNamespaceURI");
    }

    @Override
    public void clear() {
        throw XMLMarshalException.operationNotSupported("clear");
    }

    @Override
    public Document getDocument() {
        throw XMLMarshalException.operationNotSupported("getDocument");
    }

    @Override
    public Element getDOM() {
        throw XMLMarshalException.operationNotSupported("getDOM");
    }

    @Override
    public String transformToXML() {
        throw XMLMarshalException.operationNotSupported("transformToXML");
    }

    public XMLReader getXMLReader() {
        return this.xmlReader;
    }

    public void setXMLReader(XMLReader xmlReader) {
        this.xmlReader = xmlReader;
        this.namespaceAware = xmlReader.isNamespaceAware();
        if (this.xPathFragment != null) {
            this.xPathFragment.setNamespaceAware(this.isNamespaceAware());
        }
    }

    public UnmarshalRecord getChildRecord() {
        return this.childRecord;
    }

    public void setChildRecord(UnmarshalRecord childRecord) {
        this.childRecord = childRecord;
        if (childRecord != null) {
            childRecord.setParentRecord(this);
        }
    }

    public UnmarshalRecord getParentRecord() {
        return this.parentRecord;
    }

    public String getRootElementName() {
        return this.rootElementName;
    }

    public void setRootElementName(String qName) {
        this.rootElementName = qName;
    }

    public String getRootElementNamespaceUri() {
        return this.rootElementNamespaceUri;
    }

    public void setRootElementNamespaceUri(String uri) {
        this.rootElementNamespaceUri = uri;
    }

    public void setParentRecord(UnmarshalRecord parentRecord) {
        this.parentRecord = parentRecord;
    }

    public DOMRecord getTransformationRecord() {
        return this.transformationRecord;
    }

    public void setTransformationRecord(DOMRecord transformationRecord) {
        this.transformationRecord = transformationRecord;
    }

    public UnmarshalNamespaceResolver getUnmarshalNamespaceResolver() {
        if (this.unmarshalNamespaceResolver == null) {
            this.unmarshalNamespaceResolver = new StackUnmarshalNamespaceResolver();
        }
        return this.unmarshalNamespaceResolver;
    }

    public void setUnmarshalNamespaceResolver(UnmarshalNamespaceResolver anUnmarshalNamespaceResolver) {
        this.unmarshalNamespaceResolver = anUnmarshalNamespaceResolver;
    }

    public List getNullCapableValues() {
        if (this.nullCapableValues == null) {
            this.nullCapableValues = new ArrayList<NullCapableValue>();
        }
        return this.nullCapableValues;
    }

    public void removeNullCapableValue(NullCapableValue nullCapableValue) {
        if (this.nullCapableValues != null) {
            this.nullCapableValues.remove(nullCapableValue);
        }
    }

    public Object getContainerInstance(ContainerValue c) {
        return this.getContainerInstance(c, true);
    }

    public Object getContainerInstance(ContainerValue c, boolean createContainerIfNecessary) {
        Object containerInstance = this.containerInstances[c.getIndex()];
        if (containerInstance == null) {
            DatabaseMapping mapping = c.getMapping();
            if (c.getReuseContainer() && !mapping.isReadOnly()) {
                containerInstance = mapping.getAttributeValueFromObject(this.currentObject);
            }
            if (containerInstance == null && createContainerIfNecessary) {
                containerInstance = c.getContainerInstance();
            }
            this.containerInstances[c.getIndex()] = containerInstance;
            this.populatedContainerValues.add(c);
            if (this.defaultEmptyContainerValues != null) {
                this.defaultEmptyContainerValues.remove(c);
            }
        }
        return containerInstance;
    }

    public void setContainerInstance(int index, Object containerInstance) {
        this.containerInstances[index] = containerInstance;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String enc) {
        this.encoding = enc;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public String getNoNamespaceSchemaLocation() {
        return this.noNamespaceSchemaLocation;
    }

    public void setNoNamespaceSchemaLocation(String location) {
        this.noNamespaceSchemaLocation = location;
    }

    protected StrBuffer getStringBuffer() {
        return this.unmarshaller.getStringBuffer();
    }

    public CharSequence getCharacters() {
        return this.unmarshaller.getStringBuffer();
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Attributes attributes) {
        this.attributes = attributes;
    }

    public QName getTypeQName() {
        return this.typeQName;
    }

    public void setTypeQName(QName typeQName) {
        this.typeQName = typeQName;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        if (this.xmlReader != null) {
            this.xmlReader.setLocator(locator);
            if (this.rootElementName == null && this.rootElementLocalName == null && this.parentRecord == null && locator instanceof Locator2) {
                Locator2 loc = (Locator2)locator;
                this.setEncoding(loc.getEncoding());
                this.setVersion(loc.getXMLVersion());
            }
        }
    }

    public Locator getDocumentLocator() {
        if (this.xmlReader != null) {
            return this.xmlReader.getLocator();
        }
        return null;
    }

    @Override
    public Object get(DatabaseField key) {
        XMLField xmlField = this.convertToXMLField(key);
        XPathFragment lastFragment = xmlField.getLastXPathFragment();
        String namespaceURI = lastFragment.getNamespaceURI();
        if (namespaceURI == null) {
            NamespaceResolver namespaceResolver = xmlField.getNamespaceResolver();
            namespaceURI = "";
            if (!(namespaceResolver == null || lastFragment.isAttribute() && lastFragment.getPrefix() == null || (namespaceURI = namespaceResolver.resolveNamespacePrefix(lastFragment.getPrefix())) != null)) {
                namespaceURI = "";
            }
        }
        if (this.isNamespaceAware()) {
            return this.attributes.getValue(namespaceURI, lastFragment.getLocalName());
        }
        return this.attributes.getValue(lastFragment.getLocalName());
    }

    public XPathNode getXPathNode() {
        return this.xPathNode;
    }

    public XMLDescriptor getDescriptor() {
        return (XMLDescriptor)this.treeObjectBuilder.getDescriptor();
    }

    public UnmarshalContext getUnmarshalContext() {
        return this.unmarshalContext;
    }

    public void setUnmarshalContext(UnmarshalContext unmarshalContext) {
        this.unmarshalContext = unmarshalContext;
    }

    public boolean isNil() {
        return this.isXsiNil;
    }

    public void setNil(boolean nil) {
        this.isXsiNil = nil;
    }

    @Override
    public void startDocument() throws SAXException {
        if (this.unmarshaller.getIDResolver() != null && this.parentRecord == null) {
            this.unmarshaller.getIDResolver().startDocument(this.unmarshaller.getErrorHandler());
        }
    }

    private void initializeRecord(Attributes attrs) throws SAXException {
        QName leafElementType;
        this.setAttributes(attrs);
        XMLDescriptor xmlDescriptor = (XMLDescriptor)this.treeObjectBuilder.getDescriptor();
        if (!xmlDescriptor.hasInheritance() || xmlDescriptor.getInheritancePolicy().getClassIndicatorField() == null) {
            this.initialize((TreeObjectBuilder)xmlDescriptor.getObjectBuilder());
            this.initializeRecord((XMLMapping)null);
            return;
        }
        InheritancePolicy inheritancePolicy = xmlDescriptor.getInheritancePolicy();
        Class classValue = inheritancePolicy.classFromRow(this, this.session);
        if (classValue == null && (leafElementType = xmlDescriptor.getDefaultRootElementType()) != null) {
            XPathQName xpathQName = new XPathQName(leafElementType, this.isNamespaceAware());
            Object indicator = inheritancePolicy.getClassIndicatorMapping().get(xpathQName);
            if (indicator != null) {
                classValue = (Class)indicator;
            }
        }
        if (classValue != null) {
            xmlDescriptor = (XMLDescriptor)this.session.getDescriptor(classValue);
        }
        this.initialize((TreeObjectBuilder)xmlDescriptor.getObjectBuilder());
        this.initializeRecord((XMLMapping)null);
    }

    public void initializeRecord(XMLMapping selfRecordMapping) throws SAXException {
        try {
            XMLUnmarshalListener xmlUnmarshalListener;
            XMLDescriptor xmlDescriptor = (XMLDescriptor)this.treeObjectBuilder.getDescriptor();
            this.unmarshalContext = xmlDescriptor.isSequencedObject() ? new SequencedUnmarshalContext() : ObjectUnmarshalContext.getInstance();
            this.currentObject = this.xmlReader.getCurrentObject(this.session, selfRecordMapping);
            if (this.currentObject == null) {
                this.currentObject = this.treeObjectBuilder.buildNewInstance();
            }
            if (xmlDescriptor.getLocationAccessor() != null && this.xmlReader.getLocator() != null) {
                this.xmlLocation = new Locator2Impl(this.xmlReader.getLocator());
            }
            Object parentRecordCurrentObject = null;
            if (this.parentRecord != null) {
                parentRecordCurrentObject = this.parentRecord.currentObject;
            }
            if ((xmlUnmarshalListener = this.unmarshaller.getUnmarshalListener()) != null) {
                if (this.parentRecord == null) {
                    xmlUnmarshalListener.beforeUnmarshal(this.currentObject, null);
                } else {
                    xmlUnmarshalListener.beforeUnmarshal(this.currentObject, parentRecordCurrentObject);
                }
            }
            if (this.parentRecord == null) {
                this.xmlReader.newObjectEvent(this.currentObject, null, selfRecordMapping);
            } else {
                this.xmlReader.newObjectEvent(this.currentObject, parentRecordCurrentObject, selfRecordMapping);
            }
            List containerValues = this.treeObjectBuilder.getContainerValues();
            if (containerValues != null) {
                int containerSize = containerValues.size();
                this.containerInstances = new Object[containerSize];
                this.populatedContainerValues = new ArrayList<ContainerValue>(containerSize);
            }
            if (this.xPathNode.getSelfChildren() != null) {
                int selfChildrenSize = this.xPathNode.getSelfChildren().size();
                this.selfRecords = new ArrayList<UnmarshalRecord>(selfChildrenSize);
                int x = 0;
                while (x < selfChildrenSize) {
                    NodeValue nv = this.xPathNode.getSelfChildren().get(x).getNodeValue();
                    if (nv != null) {
                        this.selfRecords.add(nv.buildSelfRecord(this, this.attributes));
                    }
                    ++x;
                }
            }
        }
        catch (EclipseLinkException e) {
            if (this.xmlReader.getErrorHandler() == null) {
                throw e;
            }
            SAXParseException saxParseException = new SAXParseException(null, null, null, 0, 0, e);
            this.xmlReader.getErrorHandler().error(saxParseException);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        int primaryKeyFieldsSize;
        List<DatabaseField> primaryKeyFields;
        int x;
        if (this.unmarshaller.getIDResolver() != null && this.parentRecord == null) {
            this.unmarshaller.getIDResolver().endDocument();
        }
        if (this.selfRecords != null) {
            int x2 = 0;
            int selfRecordsSize = this.selfRecords.size();
            while (x2 < selfRecordsSize) {
                UnmarshalRecord selfRecord = this.selfRecords.get(x2);
                if (selfRecord != null) {
                    selfRecord.endDocument();
                }
                ++x2;
            }
        }
        if (this.xPathNode.getSelfChildren() != null) {
            int selfChildrenSize = this.xPathNode.getSelfChildren().size();
            x = 0;
            while (x < selfChildrenSize) {
                XPathNode selfNode = this.xPathNode.getSelfChildren().get(x);
                if (selfNode.getNodeValue() != null) {
                    selfNode.getNodeValue().endSelfNodeValue(this, this.selfRecords.get(x), this.attributes);
                }
                ++x;
            }
        }
        ClassDescriptor xmlDescriptor = this.treeObjectBuilder.getDescriptor();
        try {
            DescriptorEventManager eventManager;
            XMLUnmarshalListener listener;
            List transformationMappings;
            ContainerValue cv;
            if (this.populatedContainerValues != null) {
                int populatedCVSize = this.populatedContainerValues.size();
                int i = populatedCVSize - 1;
                while (i >= 0) {
                    cv = this.populatedContainerValues.get(i);
                    cv.setContainerInstance(this.currentObject, this.getContainerInstance(cv, cv.isDefaultEmptyContainer()));
                    --i;
                }
            }
            if (this.defaultEmptyContainerValues != null) {
                int defaultEmptyCVSize = this.defaultEmptyContainerValues.size();
                int i = defaultEmptyCVSize - 1;
                while (i >= 0) {
                    cv = this.defaultEmptyContainerValues.get(i);
                    cv.setContainerInstance(this.currentObject, this.getContainerInstance(cv, cv.isDefaultEmptyContainer()));
                    --i;
                }
            }
            if (this.nullCapableValues != null) {
                x = 0;
                int nullValuesSize = this.nullCapableValues.size();
                while (x < nullValuesSize) {
                    this.nullCapableValues.get(x).setNullValue(this.currentObject, this.session);
                    ++x;
                }
            }
            if ((transformationMappings = this.treeObjectBuilder.getTransformationMappings()) != null) {
                ReadObjectQuery query = new ReadObjectQuery();
                query.setSession(this.session);
                int x3 = 0;
                int transformationMappingsSize = transformationMappings.size();
                while (x3 < transformationMappingsSize) {
                    AbstractTransformationMapping transformationMapping = (AbstractTransformationMapping)transformationMappings.get(x3);
                    transformationMapping.readFromRowIntoObject(this.transformationRecord, null, this.currentObject, null, query, this.session, true);
                    ++x3;
                }
            }
            if ((listener = this.unmarshaller.getUnmarshalListener()) != null) {
                if (this.parentRecord != null) {
                    listener.afterUnmarshal(this.currentObject, this.parentRecord.getCurrentObject());
                } else {
                    listener.afterUnmarshal(this.currentObject, null);
                }
            }
            if (xmlDescriptor.hasEventManager() && (eventManager = xmlDescriptor.getEventManager()) != null && eventManager.hasAnyEventListeners()) {
                DescriptorEvent event = new DescriptorEvent(this.currentObject);
                event.setSession(this.session);
                event.setRecord(this);
                event.setEventCode(8);
                eventManager.executeEvent(event);
            }
        }
        catch (EclipseLinkException e) {
            if (this.xmlReader.getErrorHandler() == null) {
                throw e;
            }
            SAXParseException saxParseException = new SAXParseException(null, null, null, 0, 0, e);
            this.xmlReader.getErrorHandler().error(saxParseException);
        }
        if (this.session.isUnitOfWork() && xmlDescriptor != null && (primaryKeyFields = xmlDescriptor.getPrimaryKeyFields()) != null && (primaryKeyFieldsSize = primaryKeyFields.size()) > 0) {
            CacheId pk = (CacheId)this.treeObjectBuilder.extractPrimaryKeyFromObject(this.currentObject, this.session);
            int x4 = 0;
            while (x4 < primaryKeyFieldsSize) {
                Object value = pk.getPrimaryKey()[x4];
                if (value == null) {
                    XMLField pkField = (XMLField)xmlDescriptor.getPrimaryKeyFields().get(x4);
                    pk.set(x4, this.unmarshaller.getXMLContext().getValueByXPath(this.currentObject, pkField.getXPath(), pkField.getNamespaceResolver(), Object.class));
                }
                ++x4;
            }
            CacheKey key = this.session.getIdentityMapAccessorInstance().acquireDeferredLock(pk, xmlDescriptor.getJavaClass(), xmlDescriptor, false);
            key.setRecord(this);
            key.setObject(this.currentObject);
            key.releaseDeferredLock();
            if (this.unmarshaller.getIDResolver() != null) {
                try {
                    if (primaryKeyFieldsSize > 1) {
                        HashMap<String, Object> idWrapper = new HashMap<String, Object>();
                        int x5 = 0;
                        while (x5 < primaryKeyFieldsSize) {
                            String idName = xmlDescriptor.getPrimaryKeyFieldNames().elementAt(x5);
                            Object idValue = pk.getPrimaryKey()[x5];
                            idWrapper.put(idName, idValue);
                            ++x5;
                        }
                        this.unmarshaller.getIDResolver().bind(idWrapper, this.currentObject);
                    } else {
                        this.unmarshaller.getIDResolver().bind(pk.getPrimaryKey()[0], this.currentObject);
                    }
                }
                catch (SAXException e) {
                    throw XMLMarshalException.unmarshalException(e);
                }
            }
        }
        if (this.parentRecord != null) {
            this.reset();
        }
        if (this.xmlLocation != null && ((XMLDescriptor)xmlDescriptor).getLocationAccessor() != null) {
            ((XMLDescriptor)xmlDescriptor).getLocationAccessor().setAttributeValueInObject(this.getCurrentObject(), this.xmlLocation);
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.getUnmarshalNamespaceResolver().push(prefix, uri);
        this.getPrefixesForFragment().put(prefix, uri);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        this.getUnmarshalNamespaceResolver().pop(prefix);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        XPathFragment xPathNodeXPathFragment;
        if (this.currentObject == null) {
            this.initializeRecord(atts);
        }
        if ((xPathNodeXPathFragment = this.xPathNode.getXPathFragment()) != null && xPathNodeXPathFragment.nameIsText() || this.xpathNodeIsMixedContent) {
            this.xpathNodeIsMixedContent = false;
            NodeValue xPathNodeUnmarshalNodeValue = this.xPathNode.getUnmarshalNodeValue();
            if (xPathNodeUnmarshalNodeValue != null) {
                xPathNodeUnmarshalNodeValue.endElement(this.xPathFragment, this);
                if (this.xPathNode.getParent() != null) {
                    this.xPathNode = this.xPathNode.getParent();
                }
            }
        }
        if (this.rootElementName == null && this.rootElementLocalName == null && this.parentRecord == null) {
            this.rootElementLocalName = localName;
            this.rootElementName = qName;
            this.rootElementNamespaceUri = namespaceURI;
            this.schemaLocation = atts.getValue("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation");
            this.noNamespaceSchemaLocation = atts.getValue("http://www.w3.org/2001/XMLSchema-instance", "noNamespaceSchemaLocation");
        }
        try {
            block38: {
                NodeValue nodeValue;
                XPathFragment textWrapperFragment;
                if (this.selfRecords != null) {
                    int x = 0;
                    int selfRecordsSize = this.selfRecords.size();
                    while (x < selfRecordsSize) {
                        UnmarshalRecord selfRecord = this.selfRecords.get(x);
                        if (selfRecord == null) {
                            this.getFragmentBuilder().startElement(namespaceURI, localName, qName, atts);
                        } else {
                            selfRecord.startElement(namespaceURI, localName, qName, atts);
                        }
                        ++x;
                    }
                }
                if (this.unmappedLevel != -1 && this.unmappedLevel <= this.levelIndex) {
                    ++this.levelIndex;
                    return;
                }
                XPathNode node = this.getNonAttributeXPathNode(namespaceURI, localName, qName, atts);
                if (node == null && this.xPathNode.getTextNode() != null && (textWrapperFragment = this.getTextWrapperFragment()) != null && localName.equals(textWrapperFragment.getLocalName())) {
                    node = this.xPathNode.getTextNode();
                }
                if (node == null) {
                    NodeValue parentNodeValue = this.xPathNode.getUnmarshalNodeValue();
                    if (this.xPathNode.getXPathFragment() == null && parentNodeValue != null) {
                        XPathFragment parentFragment = new XPathFragment();
                        parentFragment.setNamespaceAware(this.isNamespaceAware());
                        if (namespaceURI != null && namespaceURI.length() == 0) {
                            parentFragment.setLocalName(qName);
                            parentFragment.setNamespaceURI(null);
                        } else {
                            parentFragment.setLocalName(localName);
                            parentFragment.setNamespaceURI(namespaceURI);
                        }
                        if (!parentNodeValue.startElement(parentFragment, this, atts)) {
                            this.startUnmappedElement(namespaceURI, localName, qName, atts);
                            return;
                        }
                        ++this.levelIndex;
                        break block38;
                    } else {
                        ++this.levelIndex;
                        this.startUnmappedElement(namespaceURI, localName, qName, atts);
                        return;
                    }
                }
                this.xPathNode = node;
                this.unmarshalContext.startElement(this);
                ++this.levelIndex;
                String xsiNilValue = atts.getValue("http://www.w3.org/2001/XMLSchema-instance", "nil");
                if (xsiNilValue != null) {
                    boolean bl = this.isXsiNil = xsiNilValue.equals("true") || xsiNilValue.equals("1");
                }
                if ((nodeValue = node.getUnmarshalNodeValue()) != null && !nodeValue.startElement(this.xPathFragment, this, atts)) {
                    this.startUnmappedElement(namespaceURI, localName, qName, atts);
                    return;
                }
                if (this.xPathNode.getAttributeChildren() != null || this.xPathNode.getAnyAttributeNodeValue() != null || this.selfRecords != null) {
                    int i = 0;
                    int size = atts.getLength();
                    while (i < size) {
                        block39: {
                            int qnameLength;
                            String qname;
                            String attNamespace = atts.getURI(i);
                            String attLocalName = atts.getLocalName(i);
                            String value = atts.getValue(i);
                            NodeValue attributeNodeValue = null;
                            if ((attLocalName == null || attLocalName.length() == 0) && (qname = atts.getQName(i)) != null && (qnameLength = qname.length()) > 0) {
                                int idx = qname.indexOf(58);
                                if (idx > 0) {
                                    attLocalName = qname.substring(idx + 1, qnameLength);
                                    String attPrefix = qname.substring(0, idx);
                                    if (attPrefix.equals("xmlns")) {
                                        attNamespace = "http://www.w3.org/2000/xmlns/";
                                    }
                                } else {
                                    attLocalName = qname;
                                    if (attLocalName.equals("xmlns")) {
                                        attNamespace = "http://www.w3.org/2000/xmlns/";
                                    }
                                }
                            }
                            if (this.selfRecords != null) {
                                int j = 0;
                                while (j < this.selfRecords.size()) {
                                    UnmarshalRecord nestedRecord = this.selfRecords.get(j);
                                    if (nestedRecord != null && (attributeNodeValue = nestedRecord.getAttributeChildNodeValue(attNamespace, attLocalName)) != null) {
                                        attributeNodeValue.attribute(nestedRecord, attNamespace, attLocalName, value);
                                    }
                                    ++j;
                                }
                            }
                            if (attributeNodeValue == null) {
                                attributeNodeValue = this.getAttributeChildNodeValue(attNamespace, attLocalName);
                                try {
                                    if (attributeNodeValue != null) {
                                        attributeNodeValue.attribute(this, attNamespace, attLocalName, value);
                                        break block39;
                                    }
                                    if (this.xPathNode.getAnyAttributeNodeValue() != null) {
                                        this.xPathNode.getAnyAttributeNodeValue().attribute(this, attNamespace, attLocalName, value);
                                    }
                                }
                                catch (EclipseLinkException e) {
                                    if (this.xmlReader == null) throw e;
                                    if (this.xmlReader.getErrorHandler() == null) {
                                        throw e;
                                    }
                                    SAXParseException saxParseException = new SAXParseException(e.getLocalizedMessage(), this.getDocumentLocator(), e);
                                    this.xmlReader.getErrorHandler().warning(saxParseException);
                                }
                            }
                        }
                        ++i;
                    }
                }
            }
            if (this.prefixesForFragment == null) return;
            this.prefixesForFragment.clear();
            return;
        }
        catch (EclipseLinkException e) {
            if (this.xmlReader == null) throw e;
            if (this.xmlReader.getErrorHandler() == null) {
                throw e;
            }
            SAXParseException saxParseException = new SAXParseException(e.getLocalizedMessage(), this.getDocumentLocator(), e);
            this.xmlReader.getErrorHandler().error(saxParseException);
        }
    }

    public void startUnmappedElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        UnmappedContentHandler unmappedContentHandler;
        ErrorHandler errorHandler;
        if (this.xmlReader.getMediaType() == MediaType.APPLICATION_XML && this.selfRecords == null && !this.isSelfRecord && (errorHandler = this.xmlReader.getErrorHandler()) != null) {
            StringBuilder messageBuilder = new StringBuilder("unexpected element (uri:\"");
            if (namespaceURI != null) {
                messageBuilder.append(namespaceURI);
            }
            messageBuilder.append("\", local:\"");
            messageBuilder.append(localName);
            messageBuilder.append("\"). Expected elements are ");
            List<XPathNode> nonAttributeChildren = this.xPathNode.getNonAttributeChildren();
            if (nonAttributeChildren == null || nonAttributeChildren.size() == 0) {
                messageBuilder.append("(none)");
            } else {
                int x = 0;
                int size = nonAttributeChildren.size();
                while (x < size) {
                    XPathFragment nonAttributeChildXPathFragment = nonAttributeChildren.get(x).getXPathFragment();
                    messageBuilder.append("<{");
                    String nonAttributeChildXPathFragmentNamespaceURI = nonAttributeChildXPathFragment.getNamespaceURI();
                    if (nonAttributeChildXPathFragmentNamespaceURI != null) {
                        messageBuilder.append(nonAttributeChildXPathFragmentNamespaceURI);
                    }
                    messageBuilder.append('}');
                    messageBuilder.append(nonAttributeChildXPathFragment.getLocalName());
                    messageBuilder.append('>');
                    if (x < size - 1) {
                        messageBuilder.append(',');
                    }
                    ++x;
                }
            }
            errorHandler.warning(new SAXParseException(messageBuilder.toString(), this.getDocumentLocator()));
        }
        if (this.selfRecords != null || this.xmlReader == null || this.isSelfRecord()) {
            if (-1 == this.unmappedLevel) {
                this.unmappedLevel = this.levelIndex;
            }
            return;
        }
        Class unmappedContentHandlerClass = this.unmarshaller.getUnmappedContentHandlerClass();
        if (unmappedContentHandlerClass == null) {
            unmappedContentHandler = DEFAULT_UNMAPPED_CONTENT_HANDLER;
        } else {
            try {
                PrivilegedNewInstanceFromClass privilegedNewInstanceFromClass = new PrivilegedNewInstanceFromClass(unmappedContentHandlerClass);
                unmappedContentHandler = (UnmappedContentHandler)privilegedNewInstanceFromClass.run();
            }
            catch (ClassCastException e) {
                throw XMLMarshalException.unmappedContentHandlerDoesntImplement(e, unmappedContentHandlerClass.getName());
            }
            catch (IllegalAccessException e) {
                throw XMLMarshalException.errorInstantiatingUnmappedContentHandler(e, unmappedContentHandlerClass.getName());
            }
            catch (InstantiationException e) {
                throw XMLMarshalException.errorInstantiatingUnmappedContentHandler(e, unmappedContentHandlerClass.getName());
            }
        }
        UnmappedContentHandlerWrapper unmappedContentHandlerWrapper = new UnmappedContentHandlerWrapper(this, unmappedContentHandler);
        unmappedContentHandlerWrapper.startElement(namespaceURI, localName, qName, atts);
        this.xmlReader.setContentHandler(unmappedContentHandlerWrapper);
        this.xmlReader.setLexicalHandler(unmappedContentHandlerWrapper);
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        try {
            XPathFragment xPathFragment;
            if (this.selfRecords != null) {
                int x = 0;
                int selfRecordsSize = this.selfRecords.size();
                while (x < selfRecordsSize) {
                    UnmarshalRecord selfRecord = this.selfRecords.get(x);
                    if (selfRecord != null) {
                        selfRecord.endElement(namespaceURI, localName, qName);
                    } else {
                        this.getFragmentBuilder().endSelfElement(namespaceURI, localName, qName);
                    }
                    ++x;
                }
            }
            if (-1 != this.unmappedLevel && this.unmappedLevel <= this.levelIndex) {
                if (this.levelIndex == this.unmappedLevel) {
                    this.unmappedLevel = -1;
                }
                --this.levelIndex;
                return;
            }
            NodeValue unmarshalNodeValue = this.xPathNode.getUnmarshalNodeValue();
            if (unmarshalNodeValue != null) {
                try {
                    unmarshalNodeValue.endElement(this.xPathFragment, this);
                }
                catch (EclipseLinkException e) {
                    if (this.xmlReader == null || this.xmlReader.getErrorHandler() == null) {
                        throw e;
                    }
                    SAXParseException saxParseException = new SAXParseException(e.getLocalizedMessage(), this.getDocumentLocator(), e);
                    this.xmlReader.getErrorHandler().warning(saxParseException);
                }
            } else {
                XPathNode textNode = this.xPathNode.getTextNode();
                if (textNode != null && textNode.isWhitespaceAware() && this.getStringBuffer().length() == 0) {
                    NodeValue textNodeUnmarshalNodeValue = textNode.getUnmarshalNodeValue();
                    if (!this.isXsiNil) {
                        if (textNodeUnmarshalNodeValue.isMappingNodeValue()) {
                            textNodeUnmarshalNodeValue.endElement(this.xPathFragment, this);
                        }
                    } else if (textNodeUnmarshalNodeValue.isMappingNodeValue()) {
                        Object nullValue;
                        DatabaseMapping mapping = ((MappingNodeValue)textNodeUnmarshalNodeValue).getMapping();
                        if (mapping.isAbstractDirectMapping() && !"".equals(nullValue = ((AbstractDirectMapping)mapping).getNullValue())) {
                            this.setAttributeValue(null, mapping);
                            this.removeNullCapableValue((NullCapableValue)((Object)textNodeUnmarshalNodeValue));
                        }
                        this.isXsiNil = false;
                    }
                }
            }
            if ((xPathFragment = this.xPathNode.getXPathFragment()) != null && xPathFragment.nameIsText() || this.xpathNodeIsMixedContent && this.xPathNode.getParent() != null) {
                this.xPathNode = this.xPathNode.getParent();
            }
            if (this.xPathNode.getParent() != null) {
                this.xPathNode = this.xPathNode.getParent();
            }
            this.xpathNodeIsMixedContent = false;
            this.unmarshalContext.endElement(this);
            this.typeQName = null;
            --this.levelIndex;
            if (this.isNil() && this.levelIndex > 0) {
                this.setNil(false);
            }
            if (this.levelIndex == 0 && this.parentRecord != null && !this.isSelfRecord()) {
                this.endDocument();
                UnmarshalRecord pRec = this.parentRecord;
                while (pRec.isSelfRecord()) {
                    pRec = pRec.parentRecord;
                }
                pRec.endElement(namespaceURI, localName, qName);
                this.xmlReader.setContentHandler(pRec);
                this.xmlReader.setLexicalHandler(pRec);
            }
        }
        catch (EclipseLinkException e) {
            if (this.xmlReader == null || this.xmlReader.getErrorHandler() == null) {
                throw e;
            }
            SAXParseException saxParseException = new SAXParseException(null, null, null, 0, 0, e);
            this.xmlReader.getErrorHandler().warning(saxParseException);
        }
    }

    public void endUnmappedElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.typeQName = null;
        --this.levelIndex;
        if (this.levelIndex == 0 && this.parentRecord != null && !this.isSelfRecord()) {
            this.endDocument();
            UnmarshalRecord pRec = this.parentRecord;
            while (pRec.isSelfRecord()) {
                pRec = pRec.parentRecord;
            }
            pRec.endElement(namespaceURI, localName, qName);
            this.xmlReader.setContentHandler(pRec);
            this.xmlReader.setLexicalHandler(pRec);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.currentObject == null) {
            return;
        }
        try {
            NodeValue unmarshalNodeValue;
            int strBufferInitialLength = -1;
            if (this.selfRecords != null) {
                strBufferInitialLength = this.getStringBuffer().length();
                int x = 0;
                int selfRecordsSize = this.selfRecords.size();
                while (x < selfRecordsSize) {
                    UnmarshalRecord selfRecord = this.selfRecords.get(x);
                    if (selfRecord != null) {
                        selfRecord.characters(ch, start, length);
                    } else {
                        this.getFragmentBuilder().characters(ch, start, length);
                    }
                    ++x;
                }
            }
            if (-1 != this.unmappedLevel && this.unmappedLevel <= this.levelIndex) {
                return;
            }
            XPathNode textNode = this.xPathNode.getTextNode();
            if (textNode == null && (textNode = this.xPathNode.getAnyNode()) != null) {
                this.xpathNodeIsMixedContent = true;
                this.xPathFragment.setLocalName(null);
                this.xPathFragment.setNamespaceURI(null);
                if (length == 0) {
                    return;
                }
            }
            if (textNode != null) {
                if (textNode.getUnmarshalNodeValue().isMixedContentNodeValue()) {
                    String tmpString = new String(ch, start, length);
                    if (!textNode.isWhitespaceAware() && tmpString.trim().length() == 0) {
                        return;
                    }
                }
                this.xPathNode = textNode;
                this.unmarshalContext.characters(this);
            }
            if ((unmarshalNodeValue = this.xPathNode.getUnmarshalNodeValue()) != null && !unmarshalNodeValue.isWrapperNodeValue()) {
                if (strBufferInitialLength == -1) {
                    this.getStringBuffer().append(ch, start, length);
                } else {
                    StrBuffer strBuffer = this.getStringBuffer();
                    if (strBufferInitialLength == strBuffer.length()) {
                        strBuffer.append(ch, start, length);
                    }
                }
            }
        }
        catch (EclipseLinkException e) {
            if (this.xmlReader.getErrorHandler() == null) {
                throw e;
            }
            SAXParseException saxParseException = new SAXParseException(null, null, null, 0, 0, e);
            this.xmlReader.getErrorHandler().error(saxParseException);
        }
    }

    @Override
    public void characters(CharSequence characters) throws SAXException {
        if (characters != null) {
            String string = characters.toString();
            this.characters(string.toCharArray(), 0, string.length());
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    public XPathNode getNonAttributeXPathNode(String namespaceURI, String localName, String qName, Attributes attributes) {
        if (this.levelIndex == 0) {
            return this.xPathNode;
        }
        if (namespaceURI != null && namespaceURI.length() == 0) {
            this.xPathFragment.setLocalName(qName);
            this.xPathFragment.setNamespaceURI(null);
        } else {
            this.xPathFragment.setLocalName(localName);
            this.xPathFragment.setNamespaceURI(namespaceURI);
        }
        XPathNode resultNode = null;
        Map<XPathFragment, XPathNode> nonAttributeChildrenMap = this.xPathNode.getNonAttributeChildrenMap();
        if (nonAttributeChildrenMap != null) {
            resultNode = nonAttributeChildrenMap.get(this.xPathFragment);
            XPathNode nonPredicateNode = null;
            if (resultNode != null && resultNode.hasPredicateSiblings()) {
                nonPredicateNode = resultNode;
                resultNode = null;
            }
            if (resultNode == null) {
                int newIndex;
                if (this.indexMap == null) {
                    this.indexMap = new HashMap<XPathFragment, Integer>();
                    newIndex = 1;
                } else {
                    Integer oldIndex = this.indexMap.get(this.xPathFragment);
                    newIndex = oldIndex == null ? 1 : oldIndex + 1;
                }
                this.indexMap.put(this.xPathFragment, newIndex);
                XPathFragment predicateFragment = new XPathFragment();
                predicateFragment.setNamespaceAware(this.isNamespaceAware());
                predicateFragment.setNamespaceURI(this.xPathFragment.getNamespaceURI());
                predicateFragment.setLocalName(this.xPathFragment.getLocalName());
                predicateFragment.setIndexValue(newIndex);
                resultNode = nonAttributeChildrenMap.get(predicateFragment);
                if (resultNode == null) {
                    predicateFragment.setIndexValue(-1);
                    if (attributes != null) {
                        int x = 0;
                        int length = attributes.getLength();
                        while (x < length) {
                            XPathFragment conditionFragment = new XPathFragment();
                            conditionFragment.setLocalName(attributes.getLocalName(x));
                            conditionFragment.setNamespaceURI(attributes.getURI(x));
                            conditionFragment.setAttribute(true);
                            XPathPredicate condition = new XPathPredicate(conditionFragment, attributes.getValue(x));
                            predicateFragment.setPredicate(condition);
                            resultNode = nonAttributeChildrenMap.get(predicateFragment);
                            if (resultNode != null) break;
                            ++x;
                        }
                    }
                    if (resultNode == null && nonPredicateNode == null) {
                        resultNode = this.xPathNode.getAnyNode();
                    }
                }
            }
            if (resultNode == null && nonPredicateNode != null) {
                return nonPredicateNode;
            }
            return resultNode;
        }
        return null;
    }

    @Override
    public String resolveNamespacePrefix(String prefix) {
        String namespaceURI = this.getUnmarshalNamespaceResolver().getNamespaceURI(prefix);
        if (namespaceURI == null && this.parentRecord != null) {
            namespaceURI = this.parentRecord.resolveNamespacePrefix(prefix);
        }
        return namespaceURI;
    }

    public String resolveNamespaceUri(String uri) {
        String prefix = this.getUnmarshalNamespaceResolver().getPrefix(uri);
        if (prefix == null && this.parentRecord != null) {
            prefix = this.parentRecord.resolveNamespaceUri(uri);
        }
        return prefix;
    }

    @Override
    public String toString() {
        StringWriter writer = new StringWriter();
        writer.write(Helper.getShortClassName(this.getClass()));
        writer.write("()");
        return writer.toString();
    }

    public NodeValue getSelfNodeValueForAttribute(String namespace, String localName) {
        if (this.selfRecords != null) {
            int i = 0;
            int selfRecordsSize = this.selfRecords.size();
            while (i < selfRecordsSize) {
                NodeValue node;
                UnmarshalRecord nestedRecord = this.selfRecords.get(i);
                if (nestedRecord != null && (node = nestedRecord.getAttributeChildNodeValue(namespace, localName)) != null) {
                    return node;
                }
                ++i;
            }
        }
        return null;
    }

    public NodeValue getAttributeChildNodeValue(String namespace, String localName) {
        Map<XPathFragment, XPathNode> attributeChildrenMap = this.xPathNode.getAttributeChildrenMap();
        if (attributeChildrenMap != null) {
            this.xPathFragment.setLocalName(localName);
            this.xPathFragment.setNamespaceURI(namespace);
            XPathNode node = attributeChildrenMap.get(this.xPathFragment);
            if (node != null) {
                return node.getUnmarshalNodeValue();
            }
        }
        return null;
    }

    public SAXFragmentBuilder getFragmentBuilder() {
        if (this.fragmentBuilder == null) {
            this.fragmentBuilder = new SAXFragmentBuilder(this);
        }
        return this.fragmentBuilder;
    }

    public void setFragmentBuilder(SAXFragmentBuilder builder) {
        this.fragmentBuilder = builder;
    }

    public void resetStringBuffer() {
        this.getStringBuffer().reset();
        this.isBufferCDATA = false;
    }

    public boolean isBufferCDATA() {
        return this.isBufferCDATA;
    }

    @Override
    public void comment(char[] data, int start, int length) {
    }

    @Override
    public void startCDATA() {
        if (this.xPathNode != null && this.xPathNode.getUnmarshalNodeValue() != null) {
            this.isBufferCDATA = true;
        }
    }

    @Override
    public void endCDATA() {
    }

    @Override
    public void startEntity(String entity) {
    }

    @Override
    public void endEntity(String entity) {
    }

    @Override
    public void startDTD(String a, String b, String c) {
    }

    @Override
    public void endDTD() {
    }

    public void setSelfRecord(boolean isSelfRecord) {
        this.isSelfRecord = isSelfRecord;
    }

    public boolean isSelfRecord() {
        return this.isSelfRecord;
    }

    public int getLevelIndex() {
        return this.levelIndex;
    }

    public void setAttributeValue(Object value, DatabaseMapping mapping) {
        this.unmarshalContext.setAttributeValue(this, value, mapping);
    }

    public void addAttributeValue(ContainerValue containerValue, Object value) {
        this.unmarshalContext.addAttributeValue(this, containerValue, value);
    }

    public void addAttributeValue(ContainerValue containerValue, Object value, Object collection) {
        this.unmarshalContext.addAttributeValue(this, containerValue, value, collection);
    }

    public void reference(Reference reference) {
        this.unmarshalContext.reference(reference);
    }

    public void unmappedContent() {
        if (this.xPathNode.getParent() != null) {
            this.xPathNode = this.xPathNode.getParent();
        }
        this.unmarshalContext.unmappedContent(this);
    }

    public UnmarshalRecord getChildUnmarshalRecord(TreeObjectBuilder treeObjectBuilder) {
        if (this.childRecord != null && !this.childRecord.isSelfRecord) {
            this.childRecord.initialize(treeObjectBuilder);
            this.childRecord.setParentRecord(this);
            return this.childRecord;
        }
        this.childRecord = (UnmarshalRecord)treeObjectBuilder.createRecord(this.session);
        this.childRecord.setUnmarshaller(this.unmarshaller);
        this.childRecord.setTextWrapperFragment(this.textWrapperFragment);
        this.childRecord.setXMLReader(this.xmlReader);
        this.childRecord.setFragmentBuilder(this.fragmentBuilder);
        this.childRecord.setUnmarshalNamespaceResolver(this.unmarshalNamespaceResolver);
        this.childRecord.setParentRecord(this);
        return this.childRecord;
    }

    @Override
    public void setUnmarshaller(XMLUnmarshaller unmarshaller) {
        super.setUnmarshaller(unmarshaller);
        if (this.xPathFragment != null) {
            this.xPathFragment.setNamespaceAware(this.isNamespaceAware());
        }
    }

    public Map<String, String> getPrefixesForFragment() {
        if (this.prefixesForFragment == null) {
            this.prefixesForFragment = new HashMap<String, String>();
        }
        return this.prefixesForFragment;
    }

    @Override
    public char getNamespaceSeparator() {
        return this.xmlReader.getNamespaceSeparator();
    }

    private void setTextWrapperFragment(XPathFragment newTextWrapperFragment) {
        this.textWrapperFragment = newTextWrapperFragment;
    }

    public XPathFragment getTextWrapperFragment() {
        if (this.xmlReader.getMediaType() == MediaType.APPLICATION_JSON) {
            if (this.textWrapperFragment == null) {
                this.textWrapperFragment = new XPathFragment();
                this.textWrapperFragment.setLocalName(this.unmarshaller.getValueWrapper());
                this.textWrapperFragment.setNamespaceAware(this.isNamespaceAware());
                this.textWrapperFragment.setNamespaceSeparator(this.getNamespaceSeparator());
            }
            return this.textWrapperFragment;
        }
        return null;
    }
}

