/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceReference;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.ast.locator.Locator;
import org.eclipse.php.internal.core.ast.match.ASTMatcher;
import org.eclipse.php.internal.core.ast.nodes.AST;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.ChildListPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.Comment;
import org.eclipse.php.internal.core.ast.nodes.DefaultCommentMapper;
import org.eclipse.php.internal.core.ast.nodes.IBinding;
import org.eclipse.php.internal.core.ast.nodes.Statement;
import org.eclipse.php.internal.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.internal.core.ast.scanner.AstLexer;
import org.eclipse.php.internal.core.ast.visitor.Visitor;
import org.eclipse.text.edits.TextEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Program
extends ASTNode {
    private final ASTNode.NodeList<Statement> statements = new ASTNode.NodeList(this, STATEMENTS_PROPERTY);
    private final ASTNode.NodeList<Comment> comments = new ASTNode.NodeList(this, COMMENTS_PROPERTY);
    public static final ChildListPropertyDescriptor STATEMENTS_PROPERTY = new ChildListPropertyDescriptor(Program.class, "statements", Statement.class, false);
    public static final ChildListPropertyDescriptor COMMENTS_PROPERTY = new ChildListPropertyDescriptor(Program.class, "comments", Comment.class, false);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;
    private DefaultCommentMapper commentMapper = null;
    private ISourceModule sourceModule = null;
    private int[] lineEndTable = new int[0];

    static {
        ArrayList<ChildListPropertyDescriptor> properyList = new ArrayList<ChildListPropertyDescriptor>(1);
        properyList.add(STATEMENTS_PROPERTY);
        properyList.add(COMMENTS_PROPERTY);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(properyList);
    }

    private Program(int start, int end, AST ast, Statement[] statements, List comments) {
        super(start, end, ast);
        if (statements == null || comments == null) {
            throw new IllegalArgumentException();
        }
        Statement[] statementArray = statements;
        int n = statements.length;
        int n2 = 0;
        while (n2 < n) {
            Statement statement = statementArray[n2];
            this.statements.add(statement);
            ++n2;
        }
        for (Object comment : comments) {
            this.comments.add((Comment)comment);
        }
    }

    public Program(int start, int end, AST ast, List statements, List commentList) {
        this(start, end, ast, statements.toArray(new Statement[statements.size()]), commentList);
    }

    public Program(AST ast) {
        super(ast);
    }

    public List<Comment> comments() {
        return this.comments;
    }

    public Collection<Comment> getComments() {
        return Collections.unmodifiableCollection(this.comments);
    }

    public void setSourceModule(ISourceModule typeRoot) {
        this.sourceModule = typeRoot;
    }

    public ISourceModule getSourceModule() {
        return this.sourceModule;
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public void childrenAccept(Visitor visitor) {
        for (ASTNode aSTNode : this.statements) {
            aSTNode.accept(visitor);
        }
        for (ASTNode aSTNode : this.comments) {
            aSTNode.accept(visitor);
        }
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        for (ASTNode aSTNode : this.statements) {
            aSTNode.traverseTopDown(visitor);
        }
        for (ASTNode aSTNode : this.comments) {
            aSTNode.traverseTopDown(visitor);
        }
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
        for (ASTNode aSTNode : this.statements) {
            aSTNode.traverseBottomUp(visitor);
        }
        for (ASTNode aSTNode : this.comments) {
            aSTNode.traverseBottomUp(visitor);
        }
        this.accept(visitor);
    }

    @Override
    public void toString(StringBuffer buffer, String tab) {
        buffer.append("<Program");
        this.appendInterval(buffer);
        buffer.append(">\n").append("\t").append("<Statements>\n");
        for (ASTNode aSTNode : this.statements) {
            aSTNode.toString(buffer, "\t\t" + tab);
            buffer.append("\n");
        }
        buffer.append("\t").append("</Statements>\n").append("\t").append("<Comments>\n");
        for (ASTNode aSTNode : this.comments) {
            aSTNode.toString(buffer, "\t\t" + tab);
            buffer.append("\n");
        }
        buffer.append("\t").append("</Comments>\n").append("</Program>");
    }

    @Override
    public int getType() {
        return 46;
    }

    public Statement[] getStatements() {
        return this.statements.toArray((Statement[])new Statement[this.statements.size()]);
    }

    public List<Statement> statements() {
        return this.statements;
    }

    public ASTNode getElementAt(int offset) {
        return Locator.locateNode(this, offset);
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    public void initCommentMapper(IDocument document, AstLexer scanner) {
        this.commentMapper = new DefaultCommentMapper(this.getComments().toArray(new Comment[this.getComments().size()]));
        this.commentMapper.initialize(this, scanner, document);
    }

    DefaultCommentMapper getCommentMapper() {
        return this.commentMapper;
    }

    public void setLineEndTable(int[] lineEndTable) {
        if (lineEndTable == null) {
            throw new NullPointerException();
        }
        this.lineEndTable = lineEndTable;
    }

    public int getColumnNumber(int position) {
        int currentLineEnd;
        if (this.lineEndTable == null) {
            return -2;
        }
        int line = this.getLineNumber(position);
        if (line == -1) {
            return -1;
        }
        if (line == 1) {
            if (position >= this.getStart() + this.getLength()) {
                return -1;
            }
            return position;
        }
        int length = this.lineEndTable.length;
        int previousLineOffset = this.lineEndTable[line - 2];
        int offsetForLine = previousLineOffset + 1;
        int n = currentLineEnd = line == length + 1 ? this.getStart() + this.getLength() - 1 : this.lineEndTable[line - 1];
        if (offsetForLine > currentLineEnd) {
            return -1;
        }
        return position - offsetForLine;
    }

    public int getLineNumber(int position) {
        if (this.lineEndTable == null) {
            return -2;
        }
        int length = this.lineEndTable.length;
        if (length == 0) {
            if (position >= this.getStart() + this.getLength()) {
                return -1;
            }
            return 1;
        }
        int low = 0;
        if (position < 0) {
            return -1;
        }
        if (position <= this.lineEndTable[low]) {
            return 1;
        }
        int hi = length - 1;
        if (position > this.lineEndTable[hi]) {
            if (position >= this.getStart() + this.getLength()) {
                return -1;
            }
            return length + 1;
        }
        while (low + 1 != hi) {
            int mid = low + (hi - low) / 2;
            if (position <= this.lineEndTable[mid]) {
                hi = mid;
                continue;
            }
            low = mid;
        }
        return low + 2;
    }

    public int getPosition(int line, int column) {
        int currentLineEnd;
        if (this.lineEndTable == null) {
            return -2;
        }
        if (line < 1 || column < 0) {
            return -1;
        }
        int length = this.lineEndTable.length;
        if (length == 0) {
            if (line != 1) {
                return -1;
            }
            return column >= this.getStart() + this.getLength() ? -1 : column;
        }
        if (line == 1) {
            int endOfLine = this.lineEndTable[0];
            return column > endOfLine ? -1 : column;
        }
        if (line > length + 1) {
            return -1;
        }
        int previousLineOffset = this.lineEndTable[line - 2];
        int offsetForLine = previousLineOffset + 1;
        int n = currentLineEnd = line == length + 1 ? this.getStart() + this.getLength() - 1 : this.lineEndTable[line - 1];
        if (offsetForLine + column > currentLineEnd) {
            return -1;
        }
        return offsetForLine + column;
    }

    public int getExtendedLength(ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException();
        }
        if (this.commentMapper == null || node.getAST() != this.getAST()) {
            return node.getLength();
        }
        return this.commentMapper.getExtendedLength(node);
    }

    public int getExtendedStartPosition(ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException();
        }
        if (this.commentMapper == null || node.getAST() != this.getAST()) {
            return node.getStart();
        }
        return this.commentMapper.getExtendedStartPosition(node);
    }

    public int firstLeadingCommentIndex(ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException();
        }
        if (this.commentMapper == null || node.getAST() != this.getAST()) {
            return -1;
        }
        return this.commentMapper.firstLeadingCommentIndex(node);
    }

    public int lastTrailingCommentIndex(ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException();
        }
        if (this.commentMapper == null || node.getAST() != this.getAST()) {
            return -1;
        }
        return this.commentMapper.lastTrailingCommentIndex(node);
    }

    public void recordModifications() {
        this.getAST().recordModifications(this);
    }

    public TextEdit rewrite(IDocument document, Map options) {
        return this.getAST().rewrite(document, options);
    }

    @Override
    ASTNode clone0(AST target) {
        List statements = ASTNode.copySubtrees(target, this.statements());
        List comments = ASTNode.copySubtrees(target, this.comments());
        Program result = new Program(this.getStart(), this.getEnd(), target, statements, comments);
        return result;
    }

    @Override
    List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    final List internalGetChildListProperty(ChildListPropertyDescriptor property) {
        if (property == STATEMENTS_PROPERTY) {
            return this.statements();
        }
        if (property == COMMENTS_PROPERTY) {
            return this.comments();
        }
        return super.internalGetChildListProperty(property);
    }

    public ASTNode findDeclaringNode(IBinding binding) {
        ISourceReference phpElement = (ISourceReference)binding.getPHPElement();
        try {
            return this.getElementAt(phpElement.getSourceRange().getOffset());
        }
        catch (ModelException e) {
            PHPCorePlugin.log(e);
            return null;
        }
    }
}

