/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.etfw.tau.perfdmf.views;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.ptp.etfw.IBuildLaunchUtils;
import org.eclipse.ptp.etfw.internal.BuildLaunchUtils;
import org.eclipse.ptp.etfw.tau.perfdmf.PerfDMFUIPlugin;
import org.eclipse.ptp.etfw.tau.perfdmf.messages.Messages;
import org.eclipse.ptp.etfw.tau.perfdmf.views.ParaProfController;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.part.DrillDownAdapter;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.AbstractTextEditor;

public class PerfDMFView
extends ViewPart {
    private TreeViewer viewer;
    private DrillDownAdapter drillDownAdapter;
    private Action refreshAction;
    private Action doubleClickAction;
    private Action paraprofAction;
    private Action launchparaprofAction;
    private Action switchDatabaseAction;
    ParaProfController ppc = new ParaProfController((IBuildLaunchUtils)new BuildLaunchUtils());
    List<ParaProfController.TreeTuple> databases = null;
    private ParaProfController.TreeTuple database = null;
    private static final String DATABASE_SELECTION = "DATABASE.SELECTION";
    private IMemento memento;

    IFile getFile(String filename, IResource[] resources) {
        try {
            int j = 0;
            while (j < resources.length) {
                IFile f;
                if (resources[j] instanceof IFile ? (f = (IFile)resources[j]).getName().equals(filename) : (resources[j] instanceof IFolder ? (f = this.getFile(filename, ((IFolder)resources[j]).members())) != null : resources[j] instanceof IProject && (f = this.getFile(filename, ((IProject)resources[j]).members())) != null)) {
                    return f;
                }
                ++j;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return null;
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            return window.getActivePage();
        }
        return null;
    }

    public String[] getDatabaseNames() {
        int nameSize = 0;
        if (this.databases != null) {
            nameSize = this.databases.size();
        }
        String[] names = new String[nameSize];
        int i = 0;
        while (i < names.length) {
            names[i] = this.databases.get((int)i).name;
            ++i;
        }
        return names;
    }

    public static String extractDatabaseName(String name) {
        return name;
    }

    public ParaProfController.TreeTuple getDatabase(String name) {
        if (this.databases == null || this.databases.size() < 1) {
            this.database = null;
            return null;
        }
        if (name == null) {
            name = Messages.PerfDMFView_Default;
        }
        Iterator<ParaProfController.TreeTuple> dit = this.databases.iterator();
        int defdex = 0;
        int i = 0;
        while (dit.hasNext()) {
            ParaProfController.TreeTuple dtest = dit.next();
            if (dtest.name.equals(name)) {
                this.database = dtest;
                if (this.switchDatabaseAction != null) {
                    this.switchDatabaseAction.setText(String.valueOf(Messages.PerfDMFView_UsingDatabase) + this.database.name);
                }
                return dtest;
            }
            if (dtest.name.equals(Messages.PerfDMFView_Default)) {
                defdex = i;
            }
            ++i;
        }
        this.database = this.databases.get(defdex);
        if (this.switchDatabaseAction != null) {
            this.switchDatabaseAction.setText(String.valueOf(Messages.PerfDMFView_UsingDatabase) + this.database.name);
        }
        return this.database;
    }

    private void openSource(String projectName, String filename, int startLine, int endLine) {
        try {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRoot root = workspace.getRoot();
            IFile file = this.getFile(filename, root.members());
            if (file == null) {
                return;
            }
            FileEditorInput iEditorInput = new FileEditorInput(file);
            IWorkbenchPage p = PerfDMFView.getActivePage();
            String editorid = "org.eclipse.cdt.ui.editor.CEditor";
            if (file.getContentDescription().toString().indexOf("org.eclipse.photran.core.freeFormFortranSource") >= 0 || file.getContentDescription().toString().indexOf("org.eclipse.photran.core.fortranSource") >= 0) {
                editorid = "org.eclipse.photran.ui.FreeFormFortranEditor";
            } else if (file.getContentDescription().toString().indexOf("org.eclipse.photran.core.fixedFormFortranSource") >= 0) {
                editorid = "org.eclipse.photran.ui.FixedFormFortranEditor";
            }
            IEditorPart part = null;
            if (p != null) {
                part = p.openEditor((IEditorInput)iEditorInput, editorid, true);
            }
            TextEditor textEditor = (TextEditor)part;
            int start = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput()).getLineOffset(startLine - 1);
            int end = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput()).getLineOffset(endLine);
            textEditor.setHighlightRange(start, end - start, true);
            TextEditor abstractTextEditor = textEditor;
            ISourceViewer viewer = null;
            Field[] fields = AbstractTextEditor.class.getDeclaredFields();
            int i = 0;
            while (i < fields.length) {
                if ("fSourceViewer".equals(fields[i].getName())) {
                    Field f = fields[i];
                    f.setAccessible(true);
                    viewer = (ISourceViewer)f.get(abstractTextEditor);
                    break;
                }
                ++i;
            }
            if (viewer != null) {
                viewer.revealRange(start, end - start);
                viewer.setSelectedRange(start, end - start);
            }
        }
        catch (Throwable throwable) {}
    }

    public PerfDMFView() {
        PerfDMFUIPlugin.registerPerfDMFView(this);
        this.databases = this.ppc.getDatabases();
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        String db = null;
        if (this.database != null) {
            db = this.database.name;
        }
        memento.putString(DATABASE_SELECTION, db);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.memento = memento;
    }

    public String recallSelectedDB() {
        if (this.memento == null) {
            return null;
        }
        String value = this.memento.getString(DATABASE_SELECTION);
        return value;
    }

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 770);
        this.drillDownAdapter = new DrillDownAdapter(this.viewer);
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.viewer.setSorter((ViewerSorter)new NameSorter());
        this.viewer.setInput((Object)this.getViewSite());
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                PerfDMFView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.refreshAction);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.paraprofAction);
        manager.add((IAction)this.refreshAction);
        manager.add((IContributionItem)new Separator());
        this.drillDownAdapter.addNavigationActions(manager);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.switchDatabaseAction);
        manager.add((IAction)this.launchparaprofAction);
        manager.add((IContributionItem)new Separator());
        this.drillDownAdapter.addNavigationActions(manager);
    }

    private boolean openInParaProf(ParaProfController.TreeTuple trial) {
        if (trial.level == ParaProfController.Level.TRIAL) {
            this.ppc.openTrial(trial.dbid, trial.id);
        }
        return true;
    }

    private void makeActions() {
        this.refreshAction = new Action(){

            public void run() {
                ((ViewContentProvider)PerfDMFView.this.viewer.getContentProvider()).refresh((Viewer)PerfDMFView.this.viewer);
            }
        };
        this.refreshAction.setText(Messages.PerfDMFView_Refresh);
        this.refreshAction.setToolTipText(Messages.PerfDMFView_RefreshData);
        this.refreshAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"PDMA", (String)"icons/refresh.gif"));
        this.doubleClickAction = new Action(){

            public void run() {
                ISelection selection = PerfDMFView.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                TreeNode to = (TreeNode)obj;
                if (to.tt != null) {
                    PerfDMFView.this.openInParaProf(to.tt);
                }
            }
        };
        this.switchDatabaseAction = new Action(){

            public void run() {
                ListDialog dblist = new ListDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell());
                ArrayContentProvider dbs = new ArrayContentProvider();
                LabelProvider dl = new LabelProvider();
                String[] names = PerfDMFView.this.getDatabaseNames();
                dblist.setHelpAvailable(false);
                dblist.setContentProvider((IStructuredContentProvider)dbs);
                dblist.setLabelProvider((ILabelProvider)dl);
                dblist.setTitle(Messages.PerfDMFView_SelectDatabase);
                dblist.setInput((Object)names);
                dblist.open();
                Object[] result = dblist.getResult();
                if (result != null && result.length >= 1) {
                    PerfDMFView.this.database = PerfDMFView.this.getDatabase(result[0].toString());
                    ((ViewContentProvider)PerfDMFView.this.viewer.getContentProvider()).refresh((Viewer)PerfDMFView.this.viewer);
                }
            }
        };
        this.switchDatabaseAction.setText(String.valueOf(Messages.PerfDMFView_UsingDatabase) + this.database.name);
        this.switchDatabaseAction.setToolTipText(Messages.PerfDMFView_SelectOtherDatabase);
        this.launchparaprofAction = new Action(){

            public void run() {
                PerfDMFView.this.ppc.openManager();
            }
        };
        this.launchparaprofAction.setText(Messages.PerfDMFView_LaunchParaProf);
        this.launchparaprofAction.setToolTipText(Messages.PerfDMFView_LaunchParaProf);
        this.launchparaprofAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"PDMA", (String)"icons/pp.gif"));
        this.paraprofAction = new Action(){

            public void run() {
                ISelection selection = PerfDMFView.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                TreeNode node = (TreeNode)obj;
                PerfDMFView.this.openInParaProf(node.tt);
            }
        };
        this.paraprofAction.setText(Messages.PerfDMFView_OpenInParaProf);
        this.paraprofAction.setToolTipText(Messages.PerfDMFView_OpenInParaProf);
        this.paraprofAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"PDMA", (String)"icons/pp.gif"));
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                PerfDMFView.this.doubleClickAction.run();
            }
        });
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public boolean showProfile(String project, String projectType, String trialName) {
        ViewContentProvider vcp = (ViewContentProvider)this.viewer.getContentProvider();
        vcp.refresh((Viewer)this.viewer);
        Object[] objs = vcp.getChildren(vcp.getRoot());
        int i = 0;
        while (i < objs.length) {
            TreeNode node = (TreeNode)objs[i];
            if (((TreeNode)node).tt.name.equals(project) || objs.length == 1 && ((TreeNode)node).tt.name.equals("default")) {
                this.viewer.setExpandedState((Object)node, true);
                TreeNode[] expObjs = node.getChildren();
                int j = 0;
                while (j < expObjs.length) {
                    TreeNode expNode = expObjs[j];
                    if (expNode.getName().equals(projectType) || expObjs.length == 1 && expNode.getName().equals("default")) {
                        this.viewer.setExpandedState((Object)expNode, true);
                        TreeNode[] trialObjs = expNode.getChildren();
                        int k = 0;
                        while (k < trialObjs.length) {
                            TreeNode trialNode = trialObjs[k];
                            if (trialNode.getName().equals(trialName)) {
                                StructuredSelection selection = new StructuredSelection((Object)trialNode);
                                this.viewer.setSelection((ISelection)selection);
                                return true;
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return true;
    }

    public boolean addProfile(String project, String projectType, String trialName, IFileStore directory, String dbname) {
        ParaProfController.TreeTuple database = this.getDatabase(dbname);
        if (database == null) {
            return false;
        }
        try {
            this.ppc.uploadTrial(directory, database.id, project, projectType, trialName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        this.showProfile(project, projectType, trialName);
        return true;
    }

    class NameSorter
    extends ViewerSorter {
        NameSorter() {
        }
    }

    class TreeNode
    implements IAdaptable {
        private final ParaProfController.TreeTuple tt;
        private TreeNode parent;
        private final ArrayList<TreeNode> children = new ArrayList();

        public TreeNode(ParaProfController.TreeTuple tt) {
            this.tt = tt;
        }

        public Object getAdapter(Class adapter) {
            return null;
        }

        public int getID() {
            return this.tt.id;
        }

        public String getName() {
            if (this.tt == null) {
                return "";
            }
            return this.tt.name;
        }

        public void setParent(TreeNode parent) {
            this.parent = parent;
        }

        public TreeNode getParent() {
            return this.parent;
        }

        public String toString() {
            return this.getName();
        }

        public void addChild(TreeNode child) {
            this.children.add(child);
            child.setParent(this);
        }

        public void removeChild(TreeNode child) {
            this.children.remove(child);
            child.setParent(null);
        }

        public TreeNode[] getChildren() {
            return this.children.toArray(new TreeNode[this.children.size()]);
        }

        public boolean hasChildren() {
            return this.children.size() > 0;
        }
    }

    class ViewContentProvider
    implements IStructuredContentProvider,
    ITreeContentProvider {
        private TreeNode invisibleRoot;

        ViewContentProvider() {
        }

        public void refresh(Viewer v) {
            this.invisibleRoot = null;
            v.refresh();
        }

        public Object getRoot() {
            return this.invisibleRoot;
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            if (parent.equals(PerfDMFView.this.getViewSite())) {
                if (this.invisibleRoot == null && !this.initialize()) {
                    return null;
                }
                return this.getChildren(this.invisibleRoot);
            }
            return this.getChildren(parent);
        }

        public Object getParent(Object child) {
            return ((TreeNode)child).getParent();
        }

        public Object[] getChildren(Object parent) {
            return ((TreeNode)parent).getChildren();
        }

        public boolean hasChildren(Object parent) {
            return ((TreeNode)parent).hasChildren();
        }

        private boolean initialize() {
            class SourceWatcher
            implements Runnable {
                SourceWatcher() {
                }

                public void run() {
                    BlockingQueue<String> q = ((ViewContentProvider)ViewContentProvider.this).PerfDMFView.this.ppc.getPullQueue();
                    if (q != null) {
                        while (true) {
                            String s = null;
                            try {
                                s = q.take();
                                if (s == null || s.equals("DONE")) break;
                                if (s.equals("RESTART")) {
                                    while (!((ViewContentProvider)ViewContentProvider.this).PerfDMFView.this.ppc.pullReady) {
                                    }
                                    q = ((ViewContentProvider)ViewContentProvider.this).PerfDMFView.this.ppc.getPullQueue();
                                    continue;
                                }
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            String[] split = s.split(" ");
                            final String source = split[2];
                            final int start = Integer.parseInt(split[3]);
                            final int finish = Integer.parseInt(split[5]);
                            Display.getDefault().asyncExec(new Runnable(){

                                public void run() {
                                    PerfDMFView.this.openSource(null, source, start, finish);
                                }
                            });
                        }
                    }
                    System.out.println("Leaving Listener");
                }
            }
            new Thread(new SourceWatcher()).start();
            this.invisibleRoot = new TreeNode(null);
            if (PerfDMFView.this.databases == null) {
                this.invisibleRoot.addChild(new TreeNode(null));
                return true;
            }
            if (PerfDMFView.this.database == null) {
                String recall = PerfDMFView.this.recallSelectedDB();
                if (recall == null) {
                    recall = Messages.PerfDMFView_Default;
                }
                PerfDMFView.this.getDatabase(recall);
                if (PerfDMFView.this.database == null) {
                    PerfDMFView.this.database = ParaProfController.EMPTY;
                    return true;
                }
            }
            for (ParaProfController.TreeTuple app : PerfDMFView.this.ppc.getApplications(((PerfDMFView)PerfDMFView.this).database.id)) {
                TreeNode root = new TreeNode(app);
                for (ParaProfController.TreeTuple exp : PerfDMFView.this.ppc.getExperiments(((PerfDMFView)PerfDMFView.this).database.id, app.id)) {
                    TreeNode tp = new TreeNode(exp);
                    for (ParaProfController.TreeTuple trial : PerfDMFView.this.ppc.getTrials(((PerfDMFView)PerfDMFView.this).database.id, exp.id)) {
                        TreeNode to = new TreeNode(trial);
                        tp.addChild(to);
                    }
                    root.addChild(tp);
                }
                this.invisibleRoot.addChild(root);
            }
            return true;
        }
    }

    class ViewLabelProvider
    extends LabelProvider {
        ViewLabelProvider() {
        }

        public String getText(Object obj) {
            return obj.toString();
        }

        public Image getImage(Object obj) {
            String imageKey = "IMG_OBJ_FOLDER";
            if (((TreeNode)((TreeNode)obj)).tt.level == ParaProfController.Level.TRIAL) {
                imageKey = "IMG_OBJ_ELEMENTS";
            }
            return PlatformUI.getWorkbench().getSharedImages().getImage(imageKey);
        }
    }
}

