/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.gem.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ptp.gem.messages.Messages;
import org.eclipse.ptp.gem.util.GemUtilities;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class GemHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        String extension;
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchWindow window = wb.getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        Command cmd = event.getCommand();
        String cmdString = cmd.getId();
        if (cmdString.equals("org.eclipse.ptp.gem.commands.numprocsCommand")) {
            GemUtilities.setNumProcesses();
            return null;
        }
        IEditorPart editor = page.getActiveEditor();
        IFile inputFile = null;
        boolean isSourceFileExtension = false;
        if (editor == null) {
            return null;
        }
        IFileEditorInput editorInput = (IFileEditorInput)editor.getEditorInput();
        inputFile = editorInput.getFile();
        try {
            if (inputFile.getProject().hasNature("org.eclipse.ptp.rdt.core.remoteMakeNature") || inputFile.getProject().hasNature("org.eclipse.ptp.rdt.sync.core.remoteSyncNature")) {
                return null;
            }
        }
        catch (CoreException ce) {
            GemUtilities.logExceptionDetail((Exception)((Object)ce));
        }
        if ((extension = inputFile.getFileExtension()) != null) {
            boolean bl = isSourceFileExtension = extension.equals("c") || extension.equals("cpp") || extension.equals("c++") || extension.equals("cc") || extension.equals("cp");
        }
        if (isSourceFileExtension) {
            GemUtilities.saveMostRecentURI(inputFile.getLocationURI());
            GemUtilities.setCommandLineArgs();
            try {
                IViewReference[] activeViews = page.getViewReferences();
                boolean foundBrowser = false;
                boolean foundAnalyzer = false;
                IViewReference[] iViewReferenceArray = activeViews;
                int n = activeViews.length;
                int n2 = 0;
                while (n2 < n) {
                    IViewReference ref = iViewReferenceArray[n2];
                    if (ref.getId().equals("org.eclipse.ptp.gem.views.GemBrowser")) {
                        foundBrowser = true;
                    }
                    if (ref.getId().equals("org.eclipse.ptp.gem.views.GemAnalyzer")) {
                        foundAnalyzer = true;
                    }
                    ++n2;
                }
                if (!foundBrowser) {
                    page.showView("org.eclipse.ptp.gem.views.GemBrowser");
                }
                if (!foundAnalyzer) {
                    page.showView("org.eclipse.ptp.gem.views.GemAnalyzer");
                }
                page.showView("org.eclipse.ptp.gem.views.GemConsole");
                GemUtilities.initGemViews((IResource)inputFile, true, true);
            }
            catch (PartInitException e) {
                GemUtilities.logExceptionDetail((Exception)((Object)e));
            }
        } else {
            GemUtilities.showErrorDialog(Messages.GemHandler_1);
        }
        return null;
    }
}

