/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.sync.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsEditableProvider;
import org.eclipse.cdt.core.settings.model.CIncludePathEntry;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.managedbuilder.language.settings.providers.GCCBuildCommandParser;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ptp.rdt.sync.core.BuildConfigurationManager;
import org.eclipse.ptp.rdt.sync.core.BuildScenario;
import org.eclipse.ptp.rdt.sync.core.MissingConnectionException;
import org.eclipse.ptp.remote.core.IRemoteConnection;

public class SyncGCCBuildCommandParser
extends GCCBuildCommandParser
implements ILanguageSettingsEditableProvider {
    protected void setSettingEntries(List<ICLanguageSettingEntry> entries) {
        if (entries == null) {
            super.setSettingEntries(entries);
            return;
        }
        BuildConfigurationManager bcm = BuildConfigurationManager.getInstance();
        BuildScenario bs = bcm.getBuildScenarioForProject(this.currentProject);
        if (bs.getSyncProvider() == null) {
            super.setSettingEntries(entries);
            return;
        }
        IRemoteConnection conn = null;
        try {
            conn = bs.getRemoteConnection();
        }
        catch (MissingConnectionException missingConnectionException) {
            super.setSettingEntries(entries);
            return;
        }
        ArrayList<ICLanguageSettingEntry> newEntries = new ArrayList<ICLanguageSettingEntry>();
        for (ICLanguageSettingEntry entry : entries) {
            String remotePath;
            String workspacePath;
            Object newEntry = !(entry instanceof CIncludePathEntry) || (entry.getFlags() & 8) == 1 ? entry : ((workspacePath = this.getWorkspacePath(remotePath = ((CIncludePathEntry)entry).getValue(), bs.getLocation(this.currentProject))) == null ? new CIncludePathEntry("//" + conn.getName() + remotePath, entry.getFlags()) : new CIncludePathEntry(workspacePath, entry.getFlags()));
            newEntries.add((ICLanguageSettingEntry)newEntry);
        }
        super.setSettingEntries(newEntries);
    }

    public String parseResourceName(String line) {
        String compilerPath = super.parseResourceName(line);
        if (compilerPath == null) {
            return compilerPath;
        }
        BuildConfigurationManager bcm = BuildConfigurationManager.getInstance();
        BuildScenario bs = bcm.getBuildScenarioForProject(this.currentProject);
        if (bs.getSyncProvider() == null) {
            return compilerPath;
        }
        String workspacePath = this.getWorkspacePath(compilerPath, bs.getLocation(this.currentProject));
        if (workspacePath == null) {
            return compilerPath;
        }
        return workspacePath;
    }

    private String getWorkspacePath(String remotePathString, String remoteRootString) {
        Path remoteRoot = new Path(remoteRootString);
        Path remotePath = new Path(remotePathString);
        if (!remoteRoot.isPrefixOf((IPath)remotePath)) {
            return null;
        }
        IPath localRoot = this.currentProject.getLocation();
        return remotePath.toOSString().replaceFirst(remoteRoot.toOSString(), localRoot.toOSString());
    }
}

